/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplatesScheme;
import com.intellij.ide.fileTemplates.InternalTemplateBean;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.ExportableFileTemplateSettings;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.FileTemplateSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.project.ProjectKt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="FileTemplateManagerImpl", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FileTemplateManagerImpl
extends FileTemplateManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl");
    private final State myState;
    private final FileTypeManagerEx myTypeManager;
    private final FileTemplateSettings myProjectSettings;
    private final ExportableFileTemplateSettings myDefaultSettings;
    private final Project myProject;
    private final FileTemplatesScheme myProjectScheme;
    private FileTemplatesScheme myScheme;
    private boolean myInitialized;
    private Date myTestDate;

    public static FileTemplateManagerImpl getInstanceImpl(@NotNull Project project) {
        if (project == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(0);
        }
        return (FileTemplateManagerImpl)FileTemplateManagerImpl.getInstance(project);
    }

    FileTemplateManagerImpl(@NotNull FileTypeManagerEx typeManager, FileTemplateSettings projectSettings, ExportableFileTemplateSettings defaultSettings, final Project project) {
        if (typeManager == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(1);
        }
        this.myState = new State();
        this.myScheme = FileTemplatesScheme.DEFAULT;
        this.myTypeManager = typeManager;
        this.myProjectSettings = projectSettings;
        this.myDefaultSettings = defaultSettings;
        this.myProject = project;
        this.myProjectScheme = project.isDefault() ? null : new FileTemplatesScheme("Project"){

            @Override
            @NotNull
            public String getTemplatesDir() {
                String string = FileUtilRt.toSystemDependentName((String)(ProjectKt.getStateStore(project).getDirectoryStorePath(false) + "/" + "fileTemplates"));
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public Project getProject() {
                Project project2 = project;
                if (project2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return project2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTemplatesDir";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProject";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private FileTemplateSettings getSettings() {
        return this.myScheme == FileTemplatesScheme.DEFAULT ? this.myDefaultSettings : this.myProjectSettings;
    }

    @Override
    @NotNull
    public FileTemplatesScheme getCurrentScheme() {
        FileTemplatesScheme fileTemplatesScheme = this.myScheme;
        if (fileTemplatesScheme == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(2);
        }
        return fileTemplatesScheme;
    }

    @Override
    public void setCurrentScheme(@NotNull FileTemplatesScheme scheme2) {
        if (scheme2 == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(3);
        }
        for (FTManager child : this.getAllManagers()) {
            child.saveTemplates();
        }
        this.setScheme(scheme2);
    }

    private void setScheme(@NotNull FileTemplatesScheme scheme2) {
        if (scheme2 == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(4);
        }
        this.myScheme = scheme2;
        this.myInitialized = true;
    }

    @Override
    protected FileTemplateManager checkInitialized() {
        if (!this.myInitialized) {
            this.setScheme(this.myScheme);
        }
        return this;
    }

    @Override
    @Nullable
    public FileTemplatesScheme getProjectScheme() {
        return this.myProjectScheme;
    }

    @Override
    public FileTemplate[] getTemplates(String category) {
        if ("Default".equals(category)) {
            return (FileTemplate[])ArrayUtil.mergeArrays((Object[])this.getInternalTemplates(), (Object[])this.getAllTemplates());
        }
        if ("Includes".equals(category)) {
            return this.getAllPatterns();
        }
        if ("Code".equals(category)) {
            return this.getAllCodeTemplates();
        }
        if ("J2EE".equals(category)) {
            return this.getAllJ2eeTemplates();
        }
        throw new IllegalArgumentException("Unknown category: " + category);
    }

    @Override
    @NotNull
    public FileTemplate[] getAllTemplates() {
        Collection<FileTemplateBase> templates = this.getSettings().getDefaultTemplatesManager().getAllTemplates(false);
        FileTemplate[] fileTemplateArray = templates.toArray(FileTemplate.EMPTY_ARRAY);
        if (fileTemplateArray == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(5);
        }
        return fileTemplateArray;
    }

    @Override
    public FileTemplate getTemplate(@NotNull String templateName) {
        if (templateName == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(6);
        }
        return this.getSettings().getDefaultTemplatesManager().findTemplateByName(templateName);
    }

    @Override
    @NotNull
    public FileTemplate addTemplate(@NotNull String name, @NotNull String extension) {
        if (name == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(7);
        }
        if (extension == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(8);
        }
        FileTemplateBase fileTemplateBase = this.getSettings().getDefaultTemplatesManager().addTemplate(name, extension);
        if (fileTemplateBase == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(9);
        }
        return fileTemplateBase;
    }

    @Override
    public void removeTemplate(@NotNull FileTemplate template) {
        if (template == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(10);
        }
        String qName = ((FileTemplateBase)template).getQualifiedName();
        for (FTManager manager : this.getAllManagers()) {
            manager.removeTemplate(qName);
        }
    }

    @Override
    @NotNull
    public Properties getDefaultProperties() {
        Properties props = new Properties();
        Calendar calendar = Calendar.getInstance();
        Date date = this.myTestDate == null ? calendar.getTime() : this.myTestDate;
        SimpleDateFormat sdfMonthNameShort = new SimpleDateFormat("MMM");
        SimpleDateFormat sdfMonthNameFull = new SimpleDateFormat("MMMM");
        SimpleDateFormat sdfDayNameShort = new SimpleDateFormat("EEE");
        SimpleDateFormat sdfDayNameFull = new SimpleDateFormat("EEEE");
        SimpleDateFormat sdfYearFull = new SimpleDateFormat("yyyy");
        props.setProperty("DATE", DateFormatUtil.formatDate((Date)date));
        props.setProperty("TIME", DateFormatUtil.formatTime((Date)date));
        props.setProperty("YEAR", sdfYearFull.format(date));
        props.setProperty("MONTH", FileTemplateManagerImpl.getCalendarValue(calendar, 2));
        props.setProperty("MONTH_NAME_SHORT", sdfMonthNameShort.format(date));
        props.setProperty("MONTH_NAME_FULL", sdfMonthNameFull.format(date));
        props.setProperty("DAY", FileTemplateManagerImpl.getCalendarValue(calendar, 5));
        props.setProperty("DAY_NAME_SHORT", sdfDayNameShort.format(date));
        props.setProperty("DAY_NAME_FULL", sdfDayNameFull.format(date));
        props.setProperty("HOUR", FileTemplateManagerImpl.getCalendarValue(calendar, 11));
        props.setProperty("MINUTE", FileTemplateManagerImpl.getCalendarValue(calendar, 12));
        props.setProperty("SECOND", FileTemplateManagerImpl.getCalendarValue(calendar, 13));
        props.setProperty("USER", SystemProperties.getUserName());
        props.setProperty("PRODUCT_NAME", ApplicationNamesInfo.getInstance().getFullProductName());
        props.setProperty("DS", "$");
        props.setProperty("PROJECT_NAME", this.myProject.getName());
        Properties properties = props;
        if (properties == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(11);
        }
        return properties;
    }

    @NotNull
    private static String getCalendarValue(Calendar calendar, int field) {
        String result2;
        int val = calendar.get(field);
        if (field == 2) {
            ++val;
        }
        if ((result2 = Integer.toString(val)).length() == 1) {
            String string = "0" + result2;
            if (string == null) {
                FileTemplateManagerImpl.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = result2;
        if (string == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @NotNull
    public Collection<String> getRecentNames() {
        this.validateRecentNames();
        Collection<String> collection = this.myState.getRecentNames(25);
        if (collection == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @Override
    public void addRecentName(@NotNull @NonNls String name) {
        if (name == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(15);
        }
        this.myState.addName(name);
    }

    private void validateRecentNames() {
        Collection<FileTemplateBase> allTemplates = this.getSettings().getDefaultTemplatesManager().getAllTemplates(false);
        ArrayList<String> allNames = new ArrayList<String>(allTemplates.size());
        for (FileTemplate fileTemplate : allTemplates) {
            allNames.add(fileTemplate.getName());
        }
        this.myState.validateNames(allNames);
    }

    @Override
    @NotNull
    public FileTemplate[] getInternalTemplates() {
        InternalTemplateBean[] internalTemplateBeans = (InternalTemplateBean[])Extensions.getExtensions(InternalTemplateBean.EP_NAME);
        FileTemplate[] result2 = new FileTemplate[internalTemplateBeans.length];
        for (int i = 0; i < internalTemplateBeans.length; ++i) {
            result2[i] = this.getInternalTemplate(internalTemplateBeans[i].name);
        }
        if (result2 == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(16);
        }
        return result2;
    }

    @Override
    public FileTemplate getInternalTemplate(@NotNull @NonNls String templateName) {
        FileTemplateBase template;
        if (templateName == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(17);
        }
        if ((template = (FileTemplateBase)this.findInternalTemplate(templateName)) == null) {
            template = (FileTemplateBase)this.getJ2eeTemplate(templateName);
            if (template != null) {
                template.setReformatCode(true);
            } else {
                String text = FileTemplateManagerImpl.normalizeText(this.getDefaultClassTemplateText(templateName));
                template = this.getSettings().getInternalTemplatesManager().addTemplate(templateName, "java");
                template.setText(text);
            }
        }
        return template;
    }

    @Override
    public FileTemplate findInternalTemplate(@NotNull @NonNls String templateName) {
        FileTemplateBase template;
        if (templateName == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(18);
        }
        if ((template = this.getSettings().getInternalTemplatesManager().findTemplateByName(templateName)) == null) {
            template = this.getSettings().getDefaultTemplatesManager().findTemplateByName(templateName);
        }
        return template;
    }

    @NotNull
    public static String normalizeText(@NotNull String text) {
        if (text == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(19);
        }
        text = StringUtil.convertLineSeparators((String)text);
        text = StringUtil.replace((String)text, (String)"$NAME$", (String)"${NAME}");
        text = StringUtil.replace((String)text, (String)"$PACKAGE_NAME$", (String)"${PACKAGE_NAME}");
        text = StringUtil.replace((String)text, (String)"$DATE$", (String)"${DATE}");
        text = StringUtil.replace((String)text, (String)"$TIME$", (String)"${TIME}");
        String string = text = StringUtil.replace((String)text, (String)"$USER$", (String)"${USER}");
        if (string == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Override
    @NotNull
    public String internalTemplateToSubject(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(21);
        }
        for (InternalTemplateBean bean : (InternalTemplateBean[])Extensions.getExtensions(InternalTemplateBean.EP_NAME)) {
            if (!bean.name.equals(templateName) || bean.subject == null) continue;
            String string = bean.subject;
            if (string == null) {
                FileTemplateManagerImpl.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = templateName.toLowerCase();
        if (string == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Override
    @NotNull
    public String localizeInternalTemplateName(@NotNull FileTemplate template) {
        if (template == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(24);
        }
        String string = template.getName();
        if (string == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NonNls
    @NotNull
    private String getDefaultClassTemplateText(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(26);
        }
        String string = IdeBundle.message((String)"template.default.class.comment", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}) + "package $PACKAGE_NAME$;\npublic " + this.internalTemplateToSubject(templateName) + " $NAME$ { }";
        if (string == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(27);
        }
        return string;
    }

    @Override
    public FileTemplate getCodeTemplate(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(28);
        }
        return FileTemplateManagerImpl.getTemplateFromManager(templateName, this.getSettings().getCodeTemplatesManager());
    }

    @Override
    public FileTemplate getJ2eeTemplate(@NotNull @NonNls String templateName) {
        if (templateName == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(29);
        }
        return FileTemplateManagerImpl.getTemplateFromManager(templateName, this.getSettings().getJ2eeTemplatesManager());
    }

    @Nullable
    private static FileTemplate getTemplateFromManager(@NotNull String templateName, @NotNull FTManager ftManager) {
        FileTemplateBase template;
        if (templateName == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(30);
        }
        if (ftManager == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(31);
        }
        if ((template = ftManager.getTemplate(templateName)) != null) {
            return template;
        }
        template = ftManager.findTemplateByName(templateName);
        if (template != null) {
            return template;
        }
        if (templateName.endsWith("ForTest") && ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        String message = "Template not found: " + templateName;
        LOG.error(message);
        return null;
    }

    @Override
    @NotNull
    public FileTemplate getDefaultTemplate(@NotNull String name) {
        if (name == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(32);
        }
        String templateQName = this.getQualifiedName(name);
        for (FTManager manager : this.getAllManagers()) {
            FileTemplateBase template = manager.getTemplate(templateQName);
            if (template == null) continue;
            if (template instanceof BundledFileTemplate) {
                template = ((BundledFileTemplate)template).clone();
                ((BundledFileTemplate)template).revertToDefaults();
            }
            FileTemplateBase fileTemplateBase = template;
            if (fileTemplateBase == null) {
                FileTemplateManagerImpl.$$$reportNull$$$0(33);
            }
            return fileTemplateBase;
        }
        String message = "Default template not found: " + name;
        LOG.error(message);
        throw new RuntimeException(message);
    }

    @NotNull
    private String getQualifiedName(@NotNull String name) {
        if (name == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(34);
        }
        String string = this.myTypeManager.getExtension(name).isEmpty() ? FileTemplateBase.getQualifiedName(name, "java") : name;
        if (string == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(35);
        }
        return string;
    }

    @Override
    @NotNull
    public FileTemplate[] getAllPatterns() {
        Collection<FileTemplateBase> allTemplates = this.getSettings().getPatternsManager().getAllTemplates(false);
        FileTemplate[] fileTemplateArray = allTemplates.toArray(FileTemplate.EMPTY_ARRAY);
        if (fileTemplateArray == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(36);
        }
        return fileTemplateArray;
    }

    @Override
    public FileTemplate getPattern(@NotNull String name) {
        if (name == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(37);
        }
        return this.getSettings().getPatternsManager().findTemplateByName(name);
    }

    @Override
    @NotNull
    public FileTemplate[] getAllCodeTemplates() {
        Collection<FileTemplateBase> templates = this.getSettings().getCodeTemplatesManager().getAllTemplates(false);
        FileTemplate[] fileTemplateArray = templates.toArray(FileTemplate.EMPTY_ARRAY);
        if (fileTemplateArray == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(38);
        }
        return fileTemplateArray;
    }

    @Override
    @NotNull
    public FileTemplate[] getAllJ2eeTemplates() {
        Collection<FileTemplateBase> templates = this.getSettings().getJ2eeTemplatesManager().getAllTemplates(false);
        FileTemplate[] fileTemplateArray = templates.toArray(FileTemplate.EMPTY_ARRAY);
        if (fileTemplateArray == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(39);
        }
        return fileTemplateArray;
    }

    @Override
    public void setTemplates(@NotNull String templatesCategory, @NotNull Collection<FileTemplate> templates) {
        if (templatesCategory == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(40);
        }
        if (templates == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(41);
        }
        for (FTManager manager : this.getAllManagers()) {
            if (!templatesCategory.equals(manager.getName())) continue;
            manager.updateTemplates(templates);
            break;
        }
    }

    @Override
    public void saveAllTemplates() {
        for (FTManager manager : this.getAllManagers()) {
            manager.saveTemplates();
        }
    }

    public URL getDefaultTemplateDescription() {
        return this.myDefaultSettings.getDefaultTemplateDescription();
    }

    URL getDefaultIncludeDescription() {
        return this.myDefaultSettings.getDefaultIncludeDescription();
    }

    public void setTestDate(Date testDate) {
        this.myTestDate = testDate;
    }

    @Nullable
    public State getState() {
        this.myState.SCHEME = this.myScheme.getName();
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(42);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
        FileTemplatesScheme scheme2 = this.myProjectScheme != null && this.myProjectScheme.getName().equals(state.SCHEME) ? this.myProjectScheme : FileTemplatesScheme.DEFAULT;
        this.setScheme(scheme2);
    }

    private FTManager[] getAllManagers() {
        return this.getSettings().getAllManagers();
    }

    public void setDefaultFileIncludeTemplateTextTemporarilyForTest(final String simpleName, final String text, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            FileTemplateManagerImpl.$$$reportNull$$$0(43);
        }
        FTManager defaultTemplatesManager = this.getSettings().getPatternsManager();
        final String qName = this.getQualifiedName(simpleName);
        FileTemplateBase oldTemplate = defaultTemplatesManager.getTemplate(qName);
        Map<String, FileTemplateBase> templates = defaultTemplatesManager.getTemplates();
        templates.put(qName, new FileTemplateBase(){

            @Override
            @NotNull
            public String getName() {
                String string = simpleName;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public void setName(@NotNull String name) {
                if (name == null) {
                    2.$$$reportNull$$$0(1);
                }
                throw new AbstractMethodError();
            }

            @Override
            public boolean isDefault() {
                return true;
            }

            @Override
            @NotNull
            public String getDescription() {
                throw new AbstractMethodError();
            }

            @Override
            @NotNull
            public String getExtension() {
                String string = qName.substring(simpleName.length());
                if (string == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Override
            public void setExtension(@NotNull String extension) {
                if (extension == null) {
                    2.$$$reportNull$$$0(3);
                }
                throw new AbstractMethodError();
            }

            @Override
            @NotNull
            protected String getDefaultText() {
                String string = text;
                if (string == null) {
                    2.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getExtension";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "setExtension";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        Disposer.register((Disposable)parentDisposable, () -> templates.put(qName, oldTemplate));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeManager";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 6: 
            case 17: 
            case 18: 
            case 21: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 7: 
            case 15: 
            case 32: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ftManager";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatesCategory";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentScheme";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTemplates";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addTemplate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCalendarValue";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalTemplates";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeText";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "internalTemplateToSubject";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "localizeInternalTemplateName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultClassTemplateText";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTemplate";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPatterns";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCodeTemplates";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllJ2eeTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentScheme";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setScheme";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTemplate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addTemplate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeTemplate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addRecentName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInternalTemplate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findInternalTemplate";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "normalizeText";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "internalTemplateToSubject";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "localizeInternalTemplateName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultClassTemplateText";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCodeTemplate";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getJ2eeTemplate";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateFromManager";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTemplate";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getPattern";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setTemplates";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultFileIncludeTemplateTextTemporarilyForTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        public List<String> RECENT_TEMPLATES = new ArrayList<String>();
        public String SCHEME = FileTemplatesScheme.DEFAULT.getName();

        public void addName(@NotNull @NonNls String name) {
            if (name == null) {
                State.$$$reportNull$$$0(0);
            }
            this.RECENT_TEMPLATES.remove(name);
            this.RECENT_TEMPLATES.add(name);
        }

        @NotNull
        public Collection<String> getRecentNames(int max) {
            int size = this.RECENT_TEMPLATES.size();
            int resultSize = Math.min(max, size);
            List<String> list2 = this.RECENT_TEMPLATES.subList(size - resultSize, size);
            if (list2 == null) {
                State.$$$reportNull$$$0(1);
            }
            return list2;
        }

        public void validateNames(List<String> validNames) {
            this.RECENT_TEMPLATES.retainAll(validNames);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$State";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplateManagerImpl$State";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecentNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

