/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.AbstractProjectNode;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewUnloadedModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectViewProjectNode
extends AbstractProjectNode {
    public ProjectViewProjectNode(Project project, ViewSettings viewSettings) {
        super(project, project, viewSettings);
    }

    public boolean canRepresent(Object element) {
        Project project = (Project)this.getValue();
        return project == element || project != null && element instanceof VirtualFile && element.equals(project.getBaseDir());
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        VirtualFile[] files2;
        if (this.myProject.isDisposed()) {
            List<AbstractTreeNode> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectViewProjectNode.$$$reportNull$$$0(0);
            }
            return list2;
        }
        List<VirtualFile> topLevelContentRoots = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelRoots();
        LinkedHashSet<ModuleDescription> modules = new LinkedHashSet<ModuleDescription>(topLevelContentRoots.size());
        for (VirtualFile root : topLevelContentRoots) {
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)root, (Project)this.myProject);
            if (module != null) {
                modules.add((ModuleDescription)new LoadedModuleDescriptionImpl(module));
                continue;
            }
            String unloadedModuleName = ProjectRootsUtil.findUnloadedModuleByContentRoot(root, this.myProject);
            if (unloadedModuleName == null) continue;
            ContainerUtil.addIfNotNull(modules, (Object)ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescription(unloadedModuleName));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        ArrayList<AbstractTreeNode> nodes = new ArrayList<AbstractTreeNode>(this.modulesAndGroups(modules));
        VirtualFile baseDir = this.getProject().getBaseDir();
        if (baseDir == null) {
            ArrayList<AbstractTreeNode> arrayList = nodes;
            if (arrayList == null) {
                ProjectViewProjectNode.$$$reportNull$$$0(1);
            }
            return arrayList;
        }
        for (VirtualFile file2 : files2 = baseDir.getChildren()) {
            if (file2.isDirectory() || ProjectFileIndex.SERVICE.getInstance((Project)this.getProject()).getModuleForFile(file2, false) != null) continue;
            nodes.add((AbstractTreeNode)new PsiFileNode(this.getProject(), psiManager.findFile(file2), this.getSettings()));
        }
        if (this.getSettings().isShowLibraryContents()) {
            nodes.add((AbstractTreeNode)new ExternalLibrariesNode(this.getProject(), this.getSettings()));
        }
        ArrayList<AbstractTreeNode> arrayList = nodes;
        if (arrayList == null) {
            ProjectViewProjectNode.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    protected AbstractTreeNode createModuleGroup(Module module) {
        PsiDirectory psi;
        List<VirtualFile> roots = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelModuleRoots(module, this.getSettings());
        if (roots.size() == 1 && (psi = PsiManager.getInstance((Project)this.myProject).findDirectory(roots.get(0))) != null) {
            return new PsiDirectoryNode(this.myProject, psi, this.getSettings());
        }
        return new ProjectViewModuleNode(this.getProject(), module, this.getSettings());
    }

    @Override
    protected AbstractTreeNode createUnloadedModuleNode(UnloadedModuleDescription moduleDescription) {
        PsiDirectory psi;
        List<VirtualFile> roots = ProjectViewDirectoryHelper.getInstance(this.myProject).getTopLevelUnloadedModuleRoots(moduleDescription, this.getSettings());
        if (roots.size() == 1 && (psi = PsiManager.getInstance((Project)this.myProject).findDirectory(roots.get(0))) != null) {
            return new PsiDirectoryNode(this.myProject, psi, this.getSettings());
        }
        return new ProjectViewUnloadedModuleNode(this.getProject(), moduleDescription, this.getSettings());
    }

    @Override
    protected AbstractTreeNode createModuleGroupNode(ModuleGroup moduleGroup) {
        return new ProjectViewModuleGroupNode(this.getProject(), moduleGroup, this.getSettings());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/ProjectViewProjectNode", "getChildren"));
    }
}

