/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.FileIconProvider;
import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.PerFileMappings;
import com.intellij.lang.PerFileMappingsBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighterProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.stubs.StubElementTypeHolderEP;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.indexing.LightDirectoryIndex;
import com.intellij.util.messages.MessageBus;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ScratchFileService", storages={@Storage(value="scratches.xml", roamingType=RoamingType.DISABLED)})
public class ScratchFileServiceImpl
extends ScratchFileService
implements PersistentStateComponent<Element>,
Disposable {
    private static final RootType NULL_TYPE = new RootType("", null){};
    private final LightDirectoryIndex<RootType> myIndex;
    private final MyLanguages myScratchMapping = new MyLanguages();

    protected ScratchFileServiceImpl(Application application) {
        Disposer.register((Disposable)this, (Disposable)this.myScratchMapping);
        this.myIndex = new LightDirectoryIndex<RootType>((Disposable)application, NULL_TYPE, index -> {
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (RootType r : RootType.getAllRootIds()) {
                index.putInfo(fileSystem.findFileByPath(this.getRootPath(r)), r);
            }
        });
        this.initFileOpenedListener(application.getMessageBus());
        for (StubElementTypeHolderEP holderEP : (StubElementTypeHolderEP[])Extensions.getExtensions((ExtensionPointName)StubElementTypeHolderEP.EP_NAME)) {
            holderEP.initialize();
        }
    }

    @NotNull
    public String getRootPath(@NotNull RootType rootId) {
        if (rootId == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(0);
        }
        String string = this.getRootPath() + "/" + rootId.getId();
        if (string == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public RootType getRootType(@Nullable VirtualFile file2) {
        if (file2 == null || !file2.isInLocalFileSystem()) {
            return null;
        }
        VirtualFile directory = file2.isDirectory() ? file2 : file2.getParent();
        RootType result2 = this.myIndex.getInfoForFile(directory);
        return result2 == NULL_TYPE ? null : result2;
    }

    private void initFileOpenedListener(MessageBus messageBus) {
        FileEditorManagerListener editorListener = new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!this.isEditable(file2)) {
                    return;
                }
                RootType rootType = ScratchFileServiceImpl.this.getRootType(file2);
                if (rootType == null) {
                    return;
                }
                rootType.fileOpened(file2, source);
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (Boolean.TRUE.equals(file2.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN))) {
                    return;
                }
                if (!this.isEditable(file2)) {
                    return;
                }
                RootType rootType = ScratchFileServiceImpl.this.getRootType(file2);
                if (rootType == null) {
                    return;
                }
                rootType.fileClosed(file2, source);
            }

            boolean isEditable(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(4);
                }
                return FileDocumentManager.getInstance().getDocument(file2) != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/scratch/ScratchFileServiceImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileOpened";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileClosed";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isEditable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
            for (VirtualFile virtualFile : editorManager.getOpenFiles()) {
                editorListener.fileOpened(editorManager, virtualFile);
            }
        }
        messageBus.connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)editorListener);
    }

    @NotNull
    protected String getRootPath() {
        String string = FileUtil.toSystemIndependentName((String)PathManager.getScratchPath());
        if (string == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public PerFileMappings<Language> getScratchesMapping() {
        MyLanguages myLanguages = this.myScratchMapping;
        if (myLanguages == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(3);
        }
        return myLanguages;
    }

    @Nullable
    public Element getState() {
        return this.myScratchMapping.getState();
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(4);
        }
        this.myScratchMapping.loadState(state);
    }

    public void dispose() {
    }

    public VirtualFile findFile(@NotNull RootType rootType, @NotNull String pathName, @NotNull ScratchFileService.Option option) throws IOException {
        if (rootType == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(5);
        }
        if (pathName == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(6);
        }
        if (option == null) {
            ScratchFileServiceImpl.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String fullPath = this.getRootPath(rootType) + "/" + pathName;
        if (option != ScratchFileService.Option.create_new_always) {
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(fullPath);
            if (file2 != null && !file2.isDirectory()) {
                return file2;
            }
            if (option == ScratchFileService.Option.existing_only) {
                return null;
            }
        }
        String ext = PathUtil.getFileExtension((String)pathName);
        String fileNameExt = PathUtil.getFileName((String)pathName);
        String fileName = StringUtil.trimEnd((String)fileNameExt, (String)(ext == null ? "" : "." + ext));
        return (VirtualFile)WriteAction.compute(() -> {
            if (option == null) {
                ScratchFileServiceImpl.$$$reportNull$$$0(8);
            }
            VirtualFile dir = VfsUtil.createDirectories((String)PathUtil.getParentPath((String)fullPath));
            if (option == ScratchFileService.Option.create_new_always) {
                return VfsUtil.createChildSequent((Object)LocalFileSystem.getInstance(), (VirtualFile)dir, (String)fileName, (String)StringUtil.notNullize((String)ext));
            }
            return dir.findOrCreateChildData((Object)LocalFileSystem.getInstance(), fileNameExt);
        });
    }

    @Nullable
    private static Language getLanguageByFileName(@Nullable VirtualFile file2) {
        return file2 == null ? null : LanguageUtil.getFileTypeLanguage((FileType)FileTypeManager.getInstance().getFileTypeByFileName(file2.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootId";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scratch/ScratchFileServiceImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scratch/ScratchFileServiceImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchesMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findFile$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IndexSetContributor
    extends IndexableSetContributor {
        @NotNull
        public Set<VirtualFile> getAdditionalRootsToIndex() {
            ScratchFileService instance = ScratchFileService.getInstance();
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            HashSet result2 = ContainerUtil.newHashSet();
            for (RootType rootType : RootType.getAllRootIds()) {
                if (rootType.isHidden()) continue;
                ContainerUtil.addIfNotNull((Collection)result2, (Object)fileSystem.findFileByPath(instance.getRootPath(rootType)));
            }
            HashSet hashSet = result2;
            if (hashSet == null) {
                IndexSetContributor.$$$reportNull$$$0(0);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileServiceImpl$IndexSetContributor", "getAdditionalRootsToIndex"));
        }
    }

    public static class UsageTypeExtension
    implements UsageTypeProvider {
        private static final ConcurrentMap<RootType, UsageType> ourUsageTypes = ConcurrentFactoryMap.createMap(key -> new UsageType("Usage in " + key.getDisplayName()));

        @Nullable
        public UsageType getUsageType(PsiElement element) {
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
            RootType rootType = file2 != null && file2.getFileType() == ScratchFileType.INSTANCE ? ScratchFileService.getInstance().getRootType(file2) : null;
            return rootType == null ? null : (UsageType)ourUsageTypes.get(rootType);
        }
    }

    public static class UseScopeExtension
    extends UseScopeEnlarger {
        @Override
        @Nullable
        public SearchScope getAdditionalUseScope(@NotNull PsiElement element) {
            SearchScope useScope;
            if (element == null) {
                UseScopeExtension.$$$reportNull$$$0(0);
            }
            if ((useScope = element.getUseScope()) instanceof LocalSearchScope) {
                return null;
            }
            return ScratchesSearchScope.getScratchesScope(element.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/scratch/ScratchFileServiceImpl$UseScopeExtension", "getAdditionalUseScope"));
        }
    }

    public static class NavBarExtension
    extends AbstractNavBarModelExtension {
        @Override
        @Nullable
        public Icon getIcon(Object object) {
            VirtualFile file2;
            VirtualFile virtualFile = file2 = object instanceof PsiFileSystemItem ? ((PsiFileSystemItem)object).getVirtualFile() : null;
            if (file2 == null) {
                return null;
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(file2);
            if (rootType == null) {
                return null;
            }
            Icon icon = rootType.substituteIcon(((PsiFileSystemItem)object).getProject(), file2);
            return icon == null && file2.isDirectory() ? AllIcons.Nodes.Folder : icon;
        }

        @Override
        @Nullable
        public String getPresentableText(Object object) {
            if (!(object instanceof PsiElement)) {
                return null;
            }
            Project project = ((PsiElement)object).getProject();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)object));
            if (virtualFile == null || !virtualFile.isValid()) {
                return null;
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(virtualFile);
            if (rootType == null) {
                return null;
            }
            if (virtualFile.isDirectory() && this.additionalRoots(project).contains(virtualFile)) {
                return rootType.getDisplayName();
            }
            return rootType.substituteName(project, virtualFile);
        }

        @Override
        @NotNull
        public Collection<VirtualFile> additionalRoots(Project project) {
            LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            ScratchFileService app = ScratchFileService.getInstance();
            for (RootType r : RootType.getAllRootIds()) {
                ContainerUtil.addIfNotNull((Collection)result2, (Object)fileSystem.findFileByPath(app.getRootPath(r)));
            }
            LinkedHashSet linkedHashSet = result2;
            if (linkedHashSet == null) {
                NavBarExtension.$$$reportNull$$$0(0);
            }
            return linkedHashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchFileServiceImpl$NavBarExtension", "additionalRoots"));
        }
    }

    public static class AccessExtension
    implements NonProjectFileWritingAccessExtension {
        @Override
        public boolean isWritable(@NotNull VirtualFile file2) {
            if (file2 == null) {
                AccessExtension.$$$reportNull$$$0(0);
            }
            return file2.getFileType() == ScratchFileType.INSTANCE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/ScratchFileServiceImpl$AccessExtension", "isWritable"));
        }
    }

    public static class FilePresentation
    implements FileIconProvider,
    EditorTabTitleProvider,
    DumbAware {
        @Nullable
        public Icon getIcon(@NotNull VirtualFile file2, @Iconable.IconFlags int flags, @Nullable Project project) {
            if (file2 == null) {
                FilePresentation.$$$reportNull$$$0(0);
            }
            if (project == null || file2.isDirectory()) {
                return null;
            }
            RootType rootType = ScratchFileService.getInstance().getRootType(file2);
            if (rootType == null) {
                return null;
            }
            return rootType.substituteIcon(project, file2);
        }

        @Override
        @Nullable
        public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file2) {
            RootType rootType;
            if (project == null) {
                FilePresentation.$$$reportNull$$$0(1);
            }
            if (file2 == null) {
                FilePresentation.$$$reportNull$$$0(2);
            }
            if ((rootType = ScratchFileService.getInstance().getRootType(file2)) == null) {
                return null;
            }
            return rootType.substituteName(project, file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/scratch/ScratchFileServiceImpl$FilePresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getIcon";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEditorTabTitle";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Highlighter
    implements SyntaxHighlighterProvider {
        @Nullable
        public SyntaxHighlighter create(@NotNull FileType fileType, @Nullable Project project, @Nullable VirtualFile file2) {
            if (fileType == null) {
                Highlighter.$$$reportNull$$$0(0);
            }
            if (project == null || file2 == null || !(fileType instanceof ScratchFileType)) {
                return null;
            }
            Language language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file2);
            return language == null ? null : SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project, (VirtualFile)file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/ide/scratch/ScratchFileServiceImpl$Highlighter", "create"));
        }
    }

    public static class Substitutor
    extends LanguageSubstitutor {
        @Nullable
        public Language getLanguage(@NotNull VirtualFile file2, @NotNull Project project) {
            if (file2 == null) {
                Substitutor.$$$reportNull$$$0(0);
            }
            if (project == null) {
                Substitutor.$$$reportNull$$$0(1);
            }
            return Substitutor.substituteLanguage(project, file2);
        }

        @Nullable
        public static Language substituteLanguage(@NotNull Project project, @NotNull VirtualFile file2) {
            RootType rootType;
            if (project == null) {
                Substitutor.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                Substitutor.$$$reportNull$$$0(3);
            }
            if ((rootType = ScratchFileService.getInstance().getRootType(file2)) == null) {
                return null;
            }
            Language language = rootType.substituteLanguage(project, file2);
            Language adjusted = language != null ? language : ScratchFileServiceImpl.getLanguageByFileName(file2);
            return adjusted != null && adjusted != ScratchFileType.INSTANCE.getLanguage() ? LanguageSubstitutors.INSTANCE.substituteLanguage(adjusted, file2, project) : adjusted;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/scratch/ScratchFileServiceImpl$Substitutor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLanguage";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "substituteLanguage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TypeFactory
    extends FileTypeFactory {
        public void createFileTypes(@NotNull FileTypeConsumer consumer) {
            if (consumer == null) {
                TypeFactory.$$$reportNull$$$0(0);
            }
            consumer.consume((FileType)ScratchFileType.INSTANCE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/ide/scratch/ScratchFileServiceImpl$TypeFactory", "createFileTypes"));
        }
    }

    private static class MyLanguages
    extends PerFileMappingsBase<Language> {
        private MyLanguages() {
        }

        public List<Language> getAvailableValues() {
            return LanguageUtil.getFileLanguages();
        }

        @Nullable
        protected String serialize(Language language) {
            return language.getID();
        }

        @Nullable
        protected Language handleUnknownMapping(VirtualFile file2, String value) {
            return PlainTextLanguage.INSTANCE;
        }
    }
}

