/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DarculaTableHeaderUI
extends BasicTableHeaderUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaTableHeaderUI();
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        Graphics2D g = (Graphics2D)g2;
        GraphicsConfig config = new GraphicsConfig((Graphics)g);
        Color bg = c.getBackground();
        g.setPaint(new GradientPaint(0.0f, 0.0f, ColorUtil.shift((Color)bg, (double)1.4), 0.0f, c.getHeight(), ColorUtil.shift((Color)bg, (double)0.9)));
        TableColumnModel model = ((JTableHeader)c).getColumnModel();
        int h = c.getHeight();
        int w = model.getTotalColumnWidth();
        g.fillRect(0, 0, w, h);
        g.setPaint(ColorUtil.shift((Color)bg, (double)0.75));
        UIUtil.drawLine((Graphics)g, (int)0, (int)(h - 1), (int)w, (int)(h - 1));
        UIUtil.drawLine((Graphics)g, (int)(w - 1), (int)0, (int)(w - 1), (int)(h - 1));
        Enumeration<TableColumn> columns = model.getColumns();
        Color lineColor = ColorUtil.shift((Color)bg, (double)0.7);
        Color shadow = Gray._255.withAlpha(30);
        int offset = 0;
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            if (!columns.hasMoreElements() || column.getWidth() <= 0) continue;
            g.setColor(lineColor);
            UIUtil.drawLine((Graphics)g, (int)((offset += column.getWidth()) - 1), (int)1, (int)(offset - 1), (int)(h - 3));
            g.setColor(shadow);
            UIUtil.drawLine((Graphics)g, (int)offset, (int)1, (int)offset, (int)(h - 3));
        }
        config.restore();
        super.paint(g, c);
    }
}

