/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.DefaultLookup;

public class DarculaComboBoxUI
extends BasicComboBoxUI
implements Border,
ErrorBorderCapable {
    private KeyListener editorKeyListener;
    private FocusListener editorFocusListener;
    private PropertyChangeListener propertyListener;

    public DarculaComboBoxUI() {
    }

    @Deprecated
    public DarculaComboBoxUI(JComboBox unused) {
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarculaComboBoxUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.comboBox.setBorder(this);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyListener = this.createPropertyListener();
        this.comboBox.addPropertyChangeListener(this.propertyListener);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this.propertyListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyListener);
            this.propertyListener = null;
        }
    }

    protected PropertyChangeListener createPropertyListener() {
        return e -> {
            EditorTextField etf;
            if ("enabled".equals(e.getPropertyName()) && (etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class))) != null) {
                Color color = e.getNewValue() == Boolean.FALSE ? UIManager.getColor("ComboBox.disabledBackground") : null;
                etf.setBackground(color);
            }
        };
    }

    @Override
    protected JButton createArrowButton() {
        Color bg = this.comboBox.getBackground();
        Color fg = this.comboBox.getForeground();
        BasicArrowButton button = new BasicArrowButton(5, bg, fg, fg, fg){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g.create();
                Rectangle r = new Rectangle(this.getSize());
                JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1, (int)0, (int)1, (int)1));
                try {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                    g2.translate(r.x, r.y);
                    float bw = DarculaUIUtil.bw();
                    float lw = DarculaUIUtil.lw(g2);
                    float arc = DarculaUIUtil.arc() - bw - lw;
                    Path2D.Float innerShape = new Path2D.Float();
                    ((Path2D)innerShape).moveTo(lw, bw + lw);
                    ((Path2D)innerShape).lineTo((float)r.width - bw - lw - arc, bw + lw);
                    ((Path2D)innerShape).quadTo((float)r.width - bw - lw, bw + lw, (float)r.width - bw - lw, bw + lw + arc);
                    ((Path2D)innerShape).lineTo((float)r.width - bw - lw, (float)r.height - bw - lw - arc);
                    ((Path2D)innerShape).quadTo((float)r.width - bw - lw, (float)r.height - bw - lw, (float)r.width - bw - lw - arc, (float)r.height - bw - lw);
                    ((Path2D)innerShape).lineTo(lw, (float)r.height - bw - lw);
                    innerShape.closePath();
                    g2.setColor(DarculaComboBoxUI.this.getArrowButtonFillColor(DarculaComboBoxUI.this.comboBox.getBackground()));
                    g2.fill(innerShape);
                    g2.setColor(DarculaComboBoxUI.this.getArrowButtonFillColor(DarculaUIUtil.getOutlineColor(DarculaComboBoxUI.this.comboBox.isEnabled())));
                    g2.fill(new Rectangle2D.Float(0.0f, bw + lw, DarculaUIUtil.lw(g2), (float)r.height - (bw + lw) * 2.0f));
                    g2.setColor((Color)new JBColor((Color)Gray._255, DarculaComboBoxUI.this.comboBox.isEnabled() ? this.getForeground() : DarculaUIUtil.getOutlineColor(DarculaComboBoxUI.this.comboBox.isEnabled())));
                    g2.fill(DarculaComboBoxUI.getArrowShape(this));
                }
                finally {
                    g2.dispose();
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return DarculaComboBoxUI.getArrowButtonPreferredSize(DarculaComboBoxUI.this.comboBox);
            }
        };
        button.setBorder((Border)JBUI.Borders.empty());
        button.setOpaque(false);
        return button;
    }

    protected Color getArrowButtonFillColor(Color defaultColor) {
        return DarculaUIUtil.getArrowButtonFillColor(this.comboBox.hasFocus(), this.comboBox.isEnabled(), defaultColor);
    }

    @NotNull
    static Dimension getArrowButtonPreferredSize(@Nullable JComboBox comboBox) {
        Object i = comboBox != null ? comboBox.getInsets() : DarculaComboBoxUI.getDefaultComboBoxInsets();
        Dimension dimension = new Dimension(JBUI.scale((int)16) + i.left, JBUI.scale((int)22) + i.top + i.bottom);
        if (dimension == null) {
            DarculaComboBoxUI.$$$reportNull$$$0(0);
        }
        return dimension;
    }

    static Shape getArrowShape(Component button) {
        Rectangle r = new Rectangle(button.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1, (int)0, (int)1, (int)1));
        int tW = JBUI.scale((int)8);
        int tH = JBUI.scale((int)6);
        int xU = (r.width - tW) / 2 - JBUI.scale((int)1);
        int yU = (r.height - tH) / 2 + JBUI.scale((int)1);
        Path2D.Float path = new Path2D.Float();
        ((Path2D)path).moveTo(xU, yU);
        ((Path2D)path).lineTo(xU + tW, yU);
        ((Path2D)path).lineTo(xU + tW / 2, yU + tH);
        ((Path2D)path).lineTo(xU, yU);
        path.closePath();
        return path;
    }

    @NotNull
    private static JBInsets getDefaultComboBoxInsets() {
        JBInsets jBInsets = JBUI.insets((int)4, (int)8, (int)4, (int)4);
        if (jBInsets == null) {
            DarculaComboBoxUI.$$$reportNull$$$0(1);
        }
        return jBInsets;
    }

    @Override
    protected Insets getInsets() {
        return DarculaComboBoxUI.getDefaultComboBoxInsets().asUIResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        Container parent = c.getParent();
        if (parent != null) {
            g.setColor(DarculaComboBoxUI.isTableCellEditor(c) && this.editor != null ? this.editor.getBackground() : parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle r = new Rectangle(c.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            float bw = DarculaUIUtil.bw();
            float arc = DarculaUIUtil.arc();
            boolean editable = this.editor != null && this.comboBox.isEditable();
            Color background = editable && this.comboBox.isEnabled() ? this.editor.getBackground() : UIUtil.getPanelBackground();
            g2.setColor(background);
            RoundRectangle2D.Float innerShape = new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc);
            g2.fill(innerShape);
        }
        finally {
            g2.dispose();
        }
        if (!this.comboBox.isEditable()) {
            this.checkFocus();
            this.paintCurrentValue(g, this.rectangleForCurrentValue(), this.hasFocus);
        }
    }

    protected static boolean isTableCellEditor(JComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty("JComboBox.isTableCellEditor")) || c.getParent() instanceof JTable;
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        SimpleColoredComponent scc;
        boolean changeOpaque;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        if (c == null) {
            return;
        }
        if (!hasFocus || this.isPopupVisible(this.comboBox)) {
            c.setBackground(UIManager.getColor("ComboBox.background"));
        }
        c.setFont(this.comboBox.getFont());
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            c.setForeground(this.listBox.getForeground());
            c.setBackground(this.listBox.getBackground());
        } else if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        } else {
            c.setForeground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledForeground", null));
            c.setBackground(DefaultLookup.getColor(this.comboBox, this, "ComboBox.disabledBackground", null));
        }
        boolean bl = changeOpaque = c instanceof JComponent && DarculaComboBoxUI.isTableCellEditor(this.comboBox) && c.isOpaque();
        if (changeOpaque) {
            ((JComponent)c).setOpaque(false);
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        Rectangle r = new Rectangle(bounds);
        Insets iPad = null;
        if (c instanceof SimpleColoredComponent) {
            scc = (SimpleColoredComponent)c;
            iPad = scc.getIpad();
            scc.setIpad((Insets)JBUI.emptyInsets());
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, r.x, r.y, r.width, r.height, shouldValidate);
        if (changeOpaque) {
            ((JComponent)c).setOpaque(true);
        }
        if (c instanceof SimpleColoredComponent) {
            scc = (SimpleColoredComponent)c;
            scc.setIpad(iPad);
        }
    }

    @Override
    protected ComboBoxEditor createEditor() {
        ComboBoxEditor comboBoxEditor = super.createEditor();
        this.installEditorKeyListener(comboBoxEditor);
        return comboBoxEditor;
    }

    protected void installEditorKeyListener(@NotNull ComboBoxEditor cbe) {
        Component ec;
        if (cbe == null) {
            DarculaComboBoxUI.$$$reportNull$$$0(2);
        }
        if ((ec = cbe.getEditorComponent()) != null) {
            this.editorKeyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    this.process(e);
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    this.process(e);
                }

                private void process(KeyEvent e) {
                    int code2 = e.getKeyCode();
                    if ((code2 == 38 || code2 == 40) && e.getModifiers() == 0) {
                        DarculaComboBoxUI.this.comboBox.dispatchEvent(e);
                    }
                }
            };
            ec.addKeyListener(this.editorKeyListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.comboBox == null || this.arrowButton == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            this.checkFocus();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Rectangle r = new Rectangle(x, y, width, height);
            JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
            g2.translate(r.x, r.y);
            float lw = DarculaUIUtil.lw(g2);
            float bw = DarculaUIUtil.bw();
            float arc = DarculaUIUtil.arc();
            Path2D.Float border = new Path2D.Float(0);
            border.append(new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc), false);
            border.append(new RoundRectangle2D.Float(bw + lw, bw + lw, (float)r.width - (bw + lw) * 2.0f, (float)r.height - (bw + lw) * 2.0f, arc - lw, arc - lw), false);
            g2.setColor(DarculaUIUtil.getOutlineColor(c.isEnabled()));
            g2.fill(border);
            Object op = this.comboBox.getClientProperty("JComponent.outline");
            if (op != null) {
                DarculaUIUtil.paintOutlineBorder(g2, r.width, r.height, arc, true, this.hasFocus, DarculaUIUtil.Outline.valueOf(op.toString()));
            } else if (this.hasFocus) {
                DarculaUIUtil.paintFocusBorder(g2, r.width, r.height, arc, true);
            }
        }
        finally {
            g2.dispose();
        }
    }

    protected void checkFocus() {
        this.hasFocus = false;
        if (!this.comboBox.isEnabled()) {
            this.hasFocus = false;
            return;
        }
        this.hasFocus = DarculaComboBoxUI.hasFocus(this.comboBox);
        if (this.hasFocus) {
            return;
        }
        ComboBoxEditor ed = this.comboBox.getEditor();
        if (ed != null) {
            this.hasFocus = DarculaComboBoxUI.hasFocus(ed.getEditorComponent());
        }
    }

    protected static boolean hasFocus(Component c) {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return owner != null && SwingUtilities.isDescendingFrom(owner, c);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getInsets();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    protected Dimension getSizeWithButton(Dimension d) {
        Insets i = this.getInsets();
        Dimension abSize = this.arrowButton.getPreferredSize();
        int editorHeight = this.editor != null ? this.editor.getPreferredSize().height + i.top + i.bottom : 0;
        int height = Math.max(Math.max(editorHeight, Math.max(abSize.height, d.height)), JBUI.scale((int)22) + i.top + i.bottom);
        int width = Math.max(d.width, abSize.width + JBUI.scale((int)10));
        return new Dimension(width, height);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getSizeWithButton(super.getPreferredSize(c));
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getSizeWithButton(super.getMinimumSize(c));
    }

    @Override
    protected void configureEditor() {
        super.configureEditor();
        if (this.editor instanceof JComponent) {
            JComponent jEditor = (JComponent)this.editor;
            jEditor.setOpaque(false);
            jEditor.setBorder((Border)JBUI.Borders.empty());
            this.editorFocusListener = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    this.update();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.update();
                }

                private void update() {
                    if (DarculaComboBoxUI.this.comboBox != null) {
                        DarculaComboBoxUI.this.comboBox.repaint();
                    }
                }
            };
            if (this.editor instanceof JTextComponent) {
                this.editor.addFocusListener(this.editorFocusListener);
            } else {
                EditorTextField etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class));
                if (etf != null) {
                    etf.addFocusListener(this.editorFocusListener);
                }
            }
        }
        if (Registry.is((String)"ide.ui.composite.editor.for.combobox") && this.editor instanceof JPanel) {
            this.editor.setFocusable(false);
        }
    }

    @Override
    protected void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.editorKeyListener != null) {
            this.editor.removeKeyListener(this.editorKeyListener);
        }
        if (this.editor instanceof JTextComponent) {
            if (this.editorFocusListener != null) {
                this.editor.removeFocusListener(this.editorFocusListener);
            }
        } else {
            EditorTextField etf = (EditorTextField)((Object)UIUtil.findComponentOfType((JComponent)((JComponent)this.editor), EditorTextField.class));
            if (etf != null && this.editorFocusListener != null) {
                etf.removeFocusListener(this.editorFocusListener);
            }
        }
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new BasicComboBoxUI.ComboBoxLayoutManager(){

            @Override
            public void layoutContainer(Container parent) {
                JComboBox cb = (JComboBox)parent;
                if (DarculaComboBoxUI.this.arrowButton != null) {
                    Dimension aps = DarculaComboBoxUI.this.arrowButton.getPreferredSize();
                    if (cb.getComponentOrientation().isLeftToRight()) {
                        DarculaComboBoxUI.this.arrowButton.setBounds(cb.getWidth() - aps.width, 0, aps.width, cb.getHeight());
                    } else {
                        DarculaComboBoxUI.this.arrowButton.setBounds(0, 0, aps.width, cb.getHeight());
                    }
                }
                DarculaComboBoxUI.this.layoutEditor();
            }
        };
    }

    protected void layoutEditor() {
        if (this.comboBox.isEditable() && this.editor != null) {
            Rectangle er = this.rectangleForCurrentValue();
            Dimension eps = this.editor.getPreferredSize();
            if (eps.height < er.height) {
                int delta = (er.height - eps.height) / 2;
                er.y += delta;
                er.height = eps.height;
            }
            this.editor.setBounds(er);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/darcula/ui/DarculaComboBoxUI";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cbe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrowButtonPreferredSize";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultComboBoxInsets";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/darcula/ui/DarculaComboBoxUI";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installEditorKeyListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

