/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.legacy.ideSettings;

import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.collectors.legacy.ideSettings.IdeInitialConfigButtonUsages;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class IdeInitialConfigUsageCollectors {

    private static abstract class Base
    extends UsagesCollector {
        private Base() {
        }

        protected abstract Set<UsageDescriptor> doGetUsages() throws CollectUsagesException;

        private static boolean shouldCount() {
            return IdeInitialConfigButtonUsages.getConfigImport() != IdeInitialConfigButtonUsages.ConfigImport.NO_INIT;
        }

        @Override
        @NotNull
        public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
            if (!Base.shouldCount()) {
                Set<UsageDescriptor> set2 = Collections.emptySet();
                if (set2 == null) {
                    Base.$$$reportNull$$$0(0);
                }
                return set2;
            }
            Set<UsageDescriptor> set3 = this.doGetUsages();
            if (set3 == null) {
                Base.$$$reportNull$$$0(1);
            }
            return set3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/collectors/legacy/ideSettings/IdeInitialConfigUsageCollectors$Base", "getUsages"));
        }
    }

    public static class SelectedLAF
    extends Base {
        @Override
        protected Set<UsageDescriptor> doGetUsages() {
            String laf = WelcomeWizardUtil.getWizardLAF();
            if (StringUtil.isEmpty((String)laf)) {
                return Collections.emptySet();
            }
            return Collections.singleton(new UsageDescriptor(laf, 1));
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GroupDescriptor.create("Wizard_Selected LAF");
            if (groupDescriptor == null) {
                SelectedLAF.$$$reportNull$$$0(0);
            }
            return groupDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/collectors/legacy/ideSettings/IdeInitialConfigUsageCollectors$SelectedLAF", "getGroupId"));
        }
    }

    public static class SelectedKeymap
    extends Base {
        @Override
        protected Set<UsageDescriptor> doGetUsages() {
            String keymapName = WelcomeWizardUtil.getWizardMacKeymap();
            if (StringUtil.isEmpty((String)keymapName)) {
                return Collections.emptySet();
            }
            return Collections.singleton(new UsageDescriptor(keymapName, 1));
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GroupDescriptor.create("Wizard_Selected keymap");
            if (groupDescriptor == null) {
                SelectedKeymap.$$$reportNull$$$0(0);
            }
            return groupDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/collectors/legacy/ideSettings/IdeInitialConfigUsageCollectors$SelectedKeymap", "getGroupId"));
        }
    }

    public static class DownloadedPlugins
    extends Base {
        @Override
        @NotNull
        public Set<UsageDescriptor> doGetUsages() {
            Set<UsageDescriptor> set2 = IdeInitialConfigButtonUsages.getDownloadedPlugins().stream().map(pluginId -> new UsageDescriptor((String)pluginId, 1)).collect(Collectors.toSet());
            if (set2 == null) {
                DownloadedPlugins.$$$reportNull$$$0(0);
            }
            return set2;
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GroupDescriptor.create("Wizard_Downloaded plugins");
            if (groupDescriptor == null) {
                DownloadedPlugins.$$$reportNull$$$0(1);
            }
            return groupDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/internal/statistic/collectors/legacy/ideSettings/IdeInitialConfigUsageCollectors$DownloadedPlugins";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class DisabledPlugins
    extends Base {
        @Override
        @NotNull
        public Set<UsageDescriptor> doGetUsages() {
            Set<UsageDescriptor> set2 = IdeInitialConfigButtonUsages.getPredefinedDisabledPlugins().stream().map(pluginDescriptor -> new UsageDescriptor((String)pluginDescriptor, 1)).collect(Collectors.toSet());
            if (set2 == null) {
                DisabledPlugins.$$$reportNull$$$0(0);
            }
            return set2;
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GroupDescriptor.create("Wizard_Disabled plugins");
            if (groupDescriptor == null) {
                DisabledPlugins.$$$reportNull$$$0(1);
            }
            return groupDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/internal/statistic/collectors/legacy/ideSettings/IdeInitialConfigUsageCollectors$DisabledPlugins";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class SkipSteps
    extends Base {
        @Override
        @NotNull
        public Set<UsageDescriptor> doGetUsages() {
            Set<UsageDescriptor> set2 = Collections.singleton(new UsageDescriptor(IdeInitialConfigButtonUsages.getSkipRemainingPressedScreen(), 1));
            if (set2 == null) {
                SkipSteps.$$$reportNull$$$0(0);
            }
            return set2;
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GroupDescriptor.create("Wizard_Skip remaining pressed");
            if (groupDescriptor == null) {
                SkipSteps.$$$reportNull$$$0(1);
            }
            return groupDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/internal/statistic/collectors/legacy/ideSettings/IdeInitialConfigUsageCollectors$SkipSteps";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class ConfigImport
    extends Base {
        @Override
        @NotNull
        public Set<UsageDescriptor> doGetUsages() {
            Set<UsageDescriptor> set2 = Collections.singleton(StatisticsUtilKt.getEnumUsage("import", IdeInitialConfigButtonUsages.getConfigImport()));
            if (set2 == null) {
                ConfigImport.$$$reportNull$$$0(0);
            }
            return set2;
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            GroupDescriptor groupDescriptor = GroupDescriptor.create("Import settings");
            if (groupDescriptor == null) {
                ConfigImport.$$$reportNull$$$0(1);
            }
            return groupDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/internal/statistic/collectors/legacy/ideSettings/IdeInitialConfigUsageCollectors$ConfigImport";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doGetUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupId";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

