/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.concurrency.JobScheduler;
import com.intellij.internal.statistic.collectors.fus.os.OsVersionUsageCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.lang.JavaVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/internal/statistic/eventLog/SystemStateMonitor;", "Lcom/intellij/openapi/startup/StartupActivity;", "()V", "INITIAL_DELAY", "", "PERIOD_DELAY", "getOSName", "", "getOSVersion", "logSystemEvent", "", "runActivity", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
public final class SystemStateMonitor
implements StartupActivity {
    private final int INITIAL_DELAY = 5;
    private final int PERIOD_DELAY = 1440;

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (!FeatureUsageLogger.INSTANCE.isEnabled()) {
            return;
        }
        JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(this){
            final /* synthetic */ SystemStateMonitor this$0;

            public final void run() {
                SystemStateMonitor.access$logSystemEvent(this.this$0);
            }
            {
                this.this$0 = systemStateMonitor;
            }
        }, this.INITIAL_DELAY, this.PERIOD_DELAY, TimeUnit.MINUTES);
    }

    private final void logSystemEvent() {
        HashMap os = new HashMap();
        Map map = os;
        Object object = "name";
        Object object2 = this.getOSName();
        map.put(object, object2);
        map = os;
        object = "version";
        object2 = this.getOSVersion();
        map.put(object, object2);
        HashMap jvm = new HashMap();
        object = jvm;
        object2 = "vendor";
        String string = System.getProperty("java.vendor", "Unknown");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"System.getProperty(\"java.vendor\", \"Unknown\")");
        String string2 = string;
        object.put(object2, string2);
        object = jvm;
        object2 = "version";
        string2 = "1." + JavaVersion.current().feature;
        object.put(object2, string2);
        HashMap info = new HashMap();
        object2 = info;
        string2 = "os";
        HashMap hashMap = os;
        object2.put(string2, hashMap);
        object2 = info;
        string2 = "jvm";
        hashMap = jvm;
        object2.put(string2, hashMap);
        FeatureUsageLogger.INSTANCE.log("state-monitoring", "system", (Map)info);
    }

    private final String getOSName() {
        String string;
        if (SystemInfo.isLinux) {
            string = "Linux";
        } else if (SystemInfo.isMac) {
            string = "Mac.OS.X";
        } else if (SystemInfo.isWindows) {
            string = "Windows";
        } else {
            String string2 = SystemInfo.OS_NAME;
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SystemInfo.OS_NAME");
        }
        return string;
    }

    private final String getOSVersion() {
        if (SystemInfo.isLinux) {
            String string = OsVersionUsageCollector.getLinuxOSVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"OsVersionUsageCollector.getLinuxOSVersion()");
            return string;
        }
        String string = SystemInfo.OS_VERSION;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SystemInfo.OS_VERSION");
        return string;
    }

    public static final /* synthetic */ void access$logSystemEvent(SystemStateMonitor $this) {
        $this.logSystemEvent();
    }
}

