/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.panel.ComponentPanel;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.ProgressPanel;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;

public class ComponentPanelTestAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project != null) {
            new ComponentPanelTest(project).show();
        }
    }

    private static class ComponentPanelTest
    extends DialogWrapper {
        private final Project myProject;
        private final Alarm myAlarm = new Alarm(this.getDisposable());
        private ProgressTimerRequest progressTimerRequest;

        private ComponentPanelTest(Project project) {
            super(project);
            this.myProject = project;
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JBEditorTabs tabs = new JBEditorTabs(this.myProject, ActionManager.getInstance(), IdeFocusManager.getInstance((Project)this.myProject), this.getDisposable()){

                public boolean isAlphabeticalMode() {
                    return false;
                }
            };
            tabs.addTab(new TabInfo(this.createComponentPanel()).setText("Component"));
            tabs.addTab(new TabInfo(this.createComponentGridPanel()).setText("Component Grid"));
            final TabInfo progressTab = new TabInfo(this.createProgressGridPanel()).setText("Progress Grid");
            tabs.addTab(progressTab);
            tabs.addListener((TabsListener)new TabsListener.Adapter(){

                public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                    if (newSelection == progressTab) {
                        myAlarm.addRequest((Runnable)progressTimerRequest, 200, ModalityState.any());
                    } else {
                        myAlarm.cancelRequest((Runnable)progressTimerRequest);
                    }
                }
            });
            return tabs;
        }

        private JComponent createComponentPanel() {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            panel2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            final JTextField text1 = new JTextField();
            Dimension d = text1.getPreferredSize();
            text1.setPreferredSize(new Dimension(JBUI.scale((int)100), d.height));
            panel2.add(UI.PanelFactory.panel((JComponent)text1).withLabel("&Textfield:").withComment("Textfield description").moveCommentRight().createPanel());
            JTextField text2 = new JTextField();
            panel2.add(UI.PanelFactory.panel((JComponent)text2).withLabel("&Path:").createPanel());
            final ComponentPanel cp = ComponentPanel.getComponentPanel((JComponent)text2);
            text1.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    if (cp != null) {
                        cp.setCommentText(text1.getText());
                    }
                }
            });
            panel2.add(UI.PanelFactory.panel((JComponent)new JCheckBox("This is a checkbox 1")).withComment("My long long long long long long long long long long comment").createPanel());
            panel2.add(UI.PanelFactory.panel((JComponent)new JCheckBox("This is a checkbox 2")).withTooltip("Help tooltip description").createPanel());
            panel2.add(UI.PanelFactory.panel((JComponent)new JButton("Abracadabra")).withComment("Abradabra comment").createPanel());
            String[] items = new String[]{"One", "Two", "Three", "Four", "Five", "Six"};
            panel2.add(UI.PanelFactory.panel(new JComboBox<String>(items)).withComment("Combobox comment").createPanel());
            final String[] columns = new String[]{"First column", "Second column"};
            final String[][] data = new String[][]{{"one", "1"}, {"two", "2"}, {"three", "3"}, {"four", "4"}, {"five", "5"}, {"six", "6"}, {"seven", "7"}, {"eight", "8"}, {"nine", "9"}, {"ten", "10"}, {"eleven", "11"}, {"twelve", "12"}, {"thirteen", "13"}, {"fourteen", "14"}, {"fifteen", "15"}, {"sixteen", "16"}};
            JBTable table = new JBTable((TableModel)new AbstractTableModel(){

                @Override
                public String getColumnName(int column) {
                    return columns[column];
                }

                @Override
                public int getRowCount() {
                    return data.length;
                }

                @Override
                public int getColumnCount() {
                    return columns.length;
                }

                @Override
                public Object getValueAt(int row, int col) {
                    return data[row][col];
                }

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }

                @Override
                public void setValueAt(Object value, int row, int col) {
                }
            });
            JBScrollPane pane = new JBScrollPane((Component)table);
            pane.setPreferredSize((Dimension)JBUI.size((int)200, (int)100));
            pane.putClientProperty((Object)UIUtil.KEEP_BORDER_SIDES, (Object)15);
            panel2.add(UI.PanelFactory.panel((JComponent)pane).withLabel("Table label:").moveLabelOnTop().withComment("Table comment").createPanel());
            panel2.add(new Box.Filler((Dimension)JBUI.size((int)100, (int)20), (Dimension)JBUI.size((int)200, (int)30), (Dimension)JBUI.size((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE)));
            return panel2;
        }

        private JComponent createComponentGridPanel() {
            ComboboxWithBrowseButton cbb = new ComboboxWithBrowseButton(new JComboBox<String>(new String[]{"One", "Two", "Three", "Four"}));
            cbb.addActionListener(e -> System.out.println("Browse for combobox"));
            JBScrollPane pane = new JBScrollPane((Component)new JTextArea(3, 40));
            pane.putClientProperty((Object)UIUtil.KEEP_BORDER_SIDES, (Object)15);
            JPanel p1 = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JTextField()).withLabel("&Port:").withComment("Port comment")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JTextField()).withLabel("&Host:").withComment("Host comment")).add((PanelBuilder)UI.PanelFactory.panel(new JComboBox<String>(new String[]{"HTTP", "HTTPS", "FTP", "SSL"})).withLabel("P&rotocol:").withComment("Protocol comment").withTooltip("Protocol selection").withTooltipLink("Check here for more info", () -> System.out.println("More info"))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)new ComponentWithBrowseButton((JComponent)new JTextField(), e -> System.out.println("Browse for text"))).withLabel("&Text field:").withComment("Text field comment")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)cbb).withLabel("&Combobox selection:")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JCheckBox("Checkbox")).withComment("Checkbox comment text")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)pane).withLabel("Text area:").withComment("Text area comment").moveLabelOnTop()).createPanel();
            ButtonGroup bg = new ButtonGroup();
            JRadioButton rb1 = new JRadioButton("RadioButton 1");
            JRadioButton rb2 = new JRadioButton("RadioButton 2");
            JRadioButton rb3 = new JRadioButton("RadioButton 3");
            bg.add(rb1);
            bg.add(rb2);
            bg.add(rb3);
            rb1.setSelected(true);
            JPanel p2 = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JCheckBox("Checkbox 1")).withComment("Comment 1").moveCommentRight()).add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JCheckBox("Checkbox 2")).withComment("Comment 2")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JCheckBox("Checkbox 3")).withTooltip("Checkbox tooltip")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)rb1).withComment("Comment 1").moveCommentRight()).add((PanelBuilder)UI.PanelFactory.panel((JComponent)rb2).withComment("Comment 2")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)rb3).withTooltip("RadioButton tooltip")).createPanel();
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            panel2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            panel2.add(p1);
            panel2.add(Box.createVerticalStrut(JBUI.scale((int)5)));
            panel2.add(p2);
            panel2.add(new Box.Filler((Dimension)JBUI.size((int)100, (int)20), (Dimension)JBUI.size((int)200, (int)30), (Dimension)JBUI.size((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE)));
            return panel2;
        }

        private JComponent createProgressGridPanel() {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new BoxLayout(panel2, 1));
            JProgressBar pb1 = new JProgressBar(0, 100);
            JProgressBar pb2 = new JProgressBar(0, 100);
            this.progressTimerRequest = new ProgressTimerRequest(pb1);
            this.myAlarm.addRequest((Runnable)this.progressTimerRequest, 200, ModalityState.any());
            ProgressPanel progressPanel = ProgressPanel.getProgressPanel((JComponent)pb1);
            if (progressPanel != null) {
                progressPanel.setCommentText(Integer.toString(0));
            }
            panel2.add(UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)pb1).withLabel("Label 1.1").withCancel(() -> this.myAlarm.cancelRequest((Runnable)this.progressTimerRequest)).andCancelText("Stop")).add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)pb2).withLabel("Label 1.2").withPause(() -> System.out.println("Pause action #2")).withResume(() -> System.out.println("Resume action #2"))).createPanel());
            ((ProgressPanel)ObjectUtils.assertNotNull((Object)ProgressPanel.getProgressPanel((JComponent)pb1))).setCommentText("Long long long long long long long text");
            ((ProgressPanel)ObjectUtils.assertNotNull((Object)ProgressPanel.getProgressPanel((JComponent)pb2))).setCommentText("Short text");
            JProgressBar pb3 = new JProgressBar(0, 100);
            JProgressBar pb4 = new JProgressBar(0, 100);
            panel2.add(UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)pb3).withLabel("Label 2.1").moveLabelLeft().withCancel(() -> System.out.println("Cancel action #3"))).add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)pb4).withTopSeparator().withLabel("Label 2.2").moveLabelLeft().withPause(() -> System.out.println("Pause action #4")).withResume(() -> System.out.println("Resume action #4"))).createPanel());
            ((ProgressPanel)ObjectUtils.assertNotNull((Object)ProgressPanel.getProgressPanel((JComponent)pb3))).setCommentText("Long long long long long long text");
            ((ProgressPanel)ObjectUtils.assertNotNull((Object)ProgressPanel.getProgressPanel((JComponent)pb4))).setCommentText("Short text");
            panel2.add(UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JProgressBar)new JProgressBar(0, 100)).withTopSeparator().withoutComment().andCancelAsButton().withCancel(() -> System.out.println("Cancel action #11"))).createPanel());
            return JBUI.Panels.simplePanel().addToTop((Component)panel2);
        }

        private class ProgressTimerRequest
        implements Runnable {
            private final JProgressBar myProgressBar;

            private ProgressTimerRequest(JProgressBar progressBar) {
                this.myProgressBar = progressBar;
            }

            @Override
            public void run() {
                if (this.canPlay()) {
                    int v = this.myProgressBar.getValue() + 1;
                    if (v > this.myProgressBar.getMaximum()) {
                        v = this.myProgressBar.getMinimum();
                    }
                    this.myProgressBar.setValue(v);
                    ProgressPanel progressPanel = ProgressPanel.getProgressPanel((JComponent)this.myProgressBar);
                    if (progressPanel != null) {
                        progressPanel.setCommentText(Integer.toString(v));
                    }
                    ComponentPanelTest.this.myAlarm.addRequest((Runnable)this, 200, ModalityState.any());
                }
            }

            private boolean canPlay() {
                ProgressPanel progressPanel = ProgressPanel.getProgressPanel((JComponent)this.myProgressBar);
                return progressPanel != null && progressPanel.getState() == ProgressPanel.State.PLAYING;
            }
        }
    }
}

