/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.customFolding;

import com.intellij.lang.customFolding.CustomFoldingConfiguration;
import com.intellij.lang.customFolding.CustomFoldingSettingsPanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CustomFoldingConfigurable
implements SearchableConfigurable {
    private final CustomFoldingConfiguration myConfiguration;
    private final CustomFoldingSettingsPanel mySettingsPanel;

    public CustomFoldingConfigurable(Project project) {
        this.myConfiguration = CustomFoldingConfiguration.getInstance(project);
        this.mySettingsPanel = new CustomFoldingSettingsPanel();
    }

    @NotNull
    public String getId() {
        String string = this.getDisplayName();
        if (string == null) {
            CustomFoldingConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    public String getDisplayName() {
        return "Custom Folding";
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this.mySettingsPanel.getComponent();
    }

    public boolean isModified() {
        return this.myConfiguration.getState().isEnabled() != this.mySettingsPanel.isEnabled() || !this.myConfiguration.getState().getStartFoldingPattern().equals(this.mySettingsPanel.getStartPattern()) || !this.myConfiguration.getState().getEndFoldingPattern().equals(this.mySettingsPanel.getEndPattern()) || !this.myConfiguration.getState().getDefaultCollapsedStatePattern().equals(this.mySettingsPanel.getCollapsedStatePattern());
    }

    public void apply() throws ConfigurationException {
        this.myConfiguration.getState().setStartFoldingPattern(this.mySettingsPanel.getStartPattern());
        this.myConfiguration.getState().setEndFoldingPattern(this.mySettingsPanel.getEndPattern());
        this.myConfiguration.getState().setEnabled(this.mySettingsPanel.isEnabled());
        this.myConfiguration.getState().setDefaultCollapsedStatePattern(this.mySettingsPanel.getCollapsedStatePattern());
    }

    public void reset() {
        this.mySettingsPanel.setStartPattern(this.myConfiguration.getState().getStartFoldingPattern());
        this.mySettingsPanel.setEndPattern(this.myConfiguration.getState().getEndFoldingPattern());
        this.mySettingsPanel.setEnabled(this.myConfiguration.getState().isEnabled());
        this.mySettingsPanel.setCollapsedStatePattern(this.myConfiguration.getState().getDefaultCollapsedStatePattern());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/customFolding/CustomFoldingConfigurable", "getId"));
    }
}

