/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionPopupMenuImpl
implements ActionPopupMenu,
ApplicationActivationListener {
    private final Application myApp;
    private final MyMenu myMenu;
    private final ActionManagerImpl myManager;
    private Getter<DataContext> myDataContextProvider;
    private MessageBusConnection myConnection;
    private IdeFrame myFrame;
    private boolean myIsToolWindowContextMenu;

    public ActionPopupMenuImpl(String place, @NotNull ActionGroup group, ActionManagerImpl actionManager, @Nullable PresentationFactory factory) {
        if (group == null) {
            ActionPopupMenuImpl.$$$reportNull$$$0(0);
        }
        this.myIsToolWindowContextMenu = false;
        this.myManager = actionManager;
        this.myMenu = new MyMenu(place, group, factory);
        this.myApp = ApplicationManager.getApplication();
    }

    public JPopupMenu getComponent() {
        return this.myMenu;
    }

    public String getPlace() {
        return this.myMenu.myPlace;
    }

    public ActionGroup getActionGroup() {
        return this.myMenu.myGroup;
    }

    public void setDataContextProvider(@Nullable Getter<DataContext> dataContextProvider) {
        this.myDataContextProvider = dataContextProvider;
    }

    public void setTargetComponent(@Nullable JComponent component) {
        this.myDataContextProvider = component == null ? null : () -> DataManager.getInstance().getDataContext((Component)component);
        this.myIsToolWindowContextMenu = component != null && UIUtil.getParentOfType(InternalDecorator.class, (Component)component) != null;
    }

    public boolean isToolWindowContextMenu() {
        return this.myIsToolWindowContextMenu;
    }

    public void applicationDeactivated(IdeFrame ideFrame) {
        if (this.myFrame == ideFrame) {
            this.myMenu.setVisible(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/ActionPopupMenuImpl", "<init>"));
    }

    private class MyMenu
    extends JBPopupMenu {
        private final String myPlace;
        private final ActionGroup myGroup;
        private DataContext myContext;
        private final PresentationFactory myPresentationFactory;

        public MyMenu(@NotNull String place, @Nullable ActionGroup group, PresentationFactory factory) {
            if (group == null) {
                MyMenu.$$$reportNull$$$0(0);
            }
            this.myPlace = place;
            this.myGroup = group;
            this.myPresentationFactory = factory != null ? factory : new MenuItemPresentationFactory();
            this.addPopupMenuListener(new MyPopupMenuListener());
        }

        public void show(Component component, int x, int y) {
            if (!component.isShowing()) {
                throw new IllegalArgumentException("component must be shown on the screen");
            }
            this.removeAll();
            int x2 = Math.max(0, Math.min(x, component.getWidth() - 1));
            int y2 = Math.max(0, Math.min(y, component.getHeight() - 1));
            this.myContext = ActionPopupMenuImpl.this.myDataContextProvider != null ? (DataContext)ActionPopupMenuImpl.this.myDataContextProvider.get() : DataManager.getInstance().getDataContext(component, x2, y2);
            Utils.fillMenu(this.myGroup, (JComponent)((Object)this), true, this.myPresentationFactory, this.myContext, this.myPlace, false, false, LaterInvocator.isInModalContext());
            if (this.getComponentCount() == 0) {
                return;
            }
            if (ActionPopupMenuImpl.this.myApp != null && ActionPopupMenuImpl.this.myApp.isActive()) {
                Component frame = UIUtil.findUltimateParent((Component)component);
                if (frame instanceof IdeFrame) {
                    ActionPopupMenuImpl.this.myFrame = (IdeFrame)frame;
                }
                ActionPopupMenuImpl.this.myConnection = ActionPopupMenuImpl.this.myApp.getMessageBus().connect();
                ActionPopupMenuImpl.this.myConnection.subscribe(ApplicationActivationListener.TOPIC, (Object)ActionPopupMenuImpl.this);
            }
            super.show(component, x, y);
        }

        public void setVisible(boolean b) {
            super.setVisible(b);
            if (!b) {
                ReflectionUtil.resetField((Object)((Object)this), (String)"invoker");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/impl/ActionPopupMenuImpl$MyMenu", "<init>"));
        }

        private class MyPopupMenuListener
        implements PopupMenuListener {
            private MyPopupMenuListener() {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this.disposeMenu();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.disposeMenu();
            }

            private void disposeMenu() {
                ActionPopupMenuImpl.this.myManager.removeActionPopup(ActionPopupMenuImpl.this);
                MyMenu.this.removeAll();
                if (ActionPopupMenuImpl.this.myConnection != null) {
                    ActionPopupMenuImpl.this.myConnection.disconnect();
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                MyMenu.this.removeAll();
                Utils.fillMenu(MyMenu.this.myGroup, (JComponent)((Object)MyMenu.this), !UISettings.getInstance().getDisableMnemonics(), MyMenu.this.myPresentationFactory, MyMenu.this.myContext, MyMenu.this.myPlace, false, false, LaterInvocator.isInModalContext());
                ActionPopupMenuImpl.this.myManager.addActionPopup(ActionPopupMenuImpl.this);
            }
        }
    }
}

