/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.Main;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ConfigImportSettings;
import com.intellij.openapi.application.ImportOldConfigsPanel;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Function;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import java.awt.Dialog;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PropertyResourceBundle;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigImportHelper {
    private static final boolean SKIP_UPDATE_CHANNEL_IMPORT = true;
    private static final String FIRST_SESSION_KEY = "intellij.first.ide.session";
    private static final String CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY = "intellij.config.imported.in.current.session";
    private static final String BUILD_NUMBER_FILE = SystemInfo.isMac ? "/Resources/build.txt" : "build.txt";
    private static final String PLUGINS_PATH = "plugins";
    private static final String BIN_FOLDER = "bin";
    private static final String CONFIG_RELATED_PATH = SystemInfo.isMac ? "" : "config/";
    private static final String OPTIONS_XML = "options/options.xml";

    private ConfigImportHelper() {
    }

    public static void importConfigsTo(@NotNull String newConfigPath) {
        block6: {
            ImportOldConfigsPanel dialog2;
            File installationHome;
            if (newConfigPath == null) {
                ConfigImportHelper.$$$reportNull$$$0(0);
            }
            System.setProperty(FIRST_SESSION_KEY, Boolean.TRUE.toString());
            ConfigImportSettings settings = ConfigImportHelper.getConfigImportSettings();
            File newConfigDir = new File(newConfigPath);
            File oldConfigDir = ConfigImportHelper.findOldConfigDir(newConfigDir, settings.getCustomPathsSelector());
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            do {
                dialog2 = new ImportOldConfigsPanel(oldConfigDir, settings);
                dialog2.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
                AppUIUtil.updateWindowIcon(dialog2);
                dialog2.setVisible(true);
                if (!dialog2.isImportEnabled()) break block6;
            } while (!ConfigImportHelper.validateOldConfigDir(installationHome = dialog2.getSelectedFile(), oldConfigDir = ConfigImportHelper.getOldConfigDir(installationHome, settings), settings));
            assert (oldConfigDir != null);
            ConfigImportHelper.doImport(newConfigDir, oldConfigDir, settings, installationHome);
            settings.importFinished(newConfigPath);
            System.setProperty(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY, Boolean.TRUE.toString());
            CloudConfigProvider provider = CloudConfigProvider.getProvider();
            if (provider != null) {
                provider.importFinished(newConfigDir);
            }
        }
    }

    public static boolean isFirstSession() {
        return Boolean.getBoolean(FIRST_SESSION_KEY);
    }

    public static boolean isConfigImported() {
        return Boolean.getBoolean(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY);
    }

    @NotNull
    private static ConfigImportSettings getConfigImportSettings() {
        block4: {
            ConfigImportSettings configImportSettings;
            try {
                Class<?> customProviderClass = Class.forName("com.intellij.openapi.application." + PlatformUtils.getPlatformPrefix() + "ConfigImportSettings");
                if (!ConfigImportSettings.class.isAssignableFrom(customProviderClass)) break block4;
                configImportSettings = (ConfigImportSettings)ReflectionUtil.newInstance(customProviderClass);
            }
            catch (ClassNotFoundException | RuntimeException exception) {
                // empty catch block
            }
            if (configImportSettings == null) {
                ConfigImportHelper.$$$reportNull$$$0(1);
            }
            return configImportSettings;
        }
        ConfigImportSettings configImportSettings = new ConfigImportSettings();
        if (configImportSettings == null) {
            ConfigImportHelper.$$$reportNull$$$0(2);
        }
        return configImportSettings;
    }

    @Nullable
    private static File findOldConfigDir(@NotNull File configDir, @Nullable String customPathSelector) {
        File selectorDir;
        File parent;
        if (configDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(3);
        }
        if ((parent = (selectorDir = CONFIG_RELATED_PATH.isEmpty() ? configDir : configDir.getParentFile()).getParentFile()) == null || !parent.exists()) {
            return null;
        }
        File maxFile = null;
        long lastModified = 0L;
        String selector = PathManager.getPathsSelector() != null ? PathManager.getPathsSelector() : selectorDir.getName();
        String prefix = ConfigImportHelper.getPrefixFromSelector(selector);
        String customPrefix = customPathSelector != null ? ConfigImportHelper.getPrefixFromSelector(customPathSelector) : null;
        for (File file2 : parent.listFiles((file1, name) -> StringUtil.startsWithIgnoreCase((String)name, (String)prefix) || customPrefix != null && StringUtil.startsWithIgnoreCase((String)name, (String)customPrefix))) {
            long modified;
            File options = new File(file2, CONFIG_RELATED_PATH + OPTIONS_XML);
            if (!options.exists() || (modified = options.lastModified()) <= lastModified) continue;
            lastModified = modified;
            maxFile = file2;
        }
        if (maxFile == null) {
            File v1_1 = new File(PathManager.getDefaultConfigPathFor((String)"AndroidStudio"));
            File v1_2 = new File(PathManager.getDefaultConfigPathFor((String)"AndroidStudio1.2"));
            File v1_3 = new File(PathManager.getDefaultConfigPathFor((String)"AndroidStudio1.3"));
            File v1_4 = new File(PathManager.getDefaultConfigPathFor((String)"AndroidStudio1.4"));
            File v1_5 = new File(PathManager.getDefaultConfigPathFor((String)"AndroidStudio1.5"));
            File v2_0 = new File(PathManager.getDefaultConfigPathFor((String)"AndroidStudio2.0"));
            File v2_1 = new File(PathManager.getDefaultConfigPathFor((String)"AndroidStudio2.1"));
            File v2_2 = new File(PathManager.getDefaultConfigPathFor((String)"AndroidStudio2.2"));
            File v2_3 = new File(PathManager.getDefaultConfigPathFor((String)"AndroidStudio2.3"));
            File v30preview = new File(PathManager.getDefaultConfigPathFor((String)"AndroidStudioPreview3.0"));
            File v30 = new File(PathManager.getDefaultConfigPathFor((String)"AndroidStudio3.0"));
            File v31preview = new File(PathManager.getDefaultConfigPathFor((String)"AndroidStudioPreview3.1"));
            File v31 = new File(PathManager.getDefaultConfigPathFor((String)"AndroidStudio3.1"));
            for (File file3 : new File[]{v1_1, v1_2, v1_3, v1_4, v1_5, v2_0, v2_1, v2_2, v2_3, v30preview, v30, v31preview, v31}) {
                long modified;
                File options;
                if (!file3.isDirectory() || !(options = new File(file3, OPTIONS_XML)).exists() || (modified = file3.lastModified()) < lastModified) continue;
                lastModified = modified;
                maxFile = file3;
            }
            if (maxFile != null) {
                return maxFile;
            }
        }
        return maxFile != null ? new File(maxFile, CONFIG_RELATED_PATH) : null;
    }

    private static String getPrefixFromSelector(String selector) {
        return (SystemInfo.isMac ? "" : ".") + selector.replaceAll("\\d(\\.\\d)?", "");
    }

    private static void doImport(@NotNull File newConfigDir, @NotNull File oldConfigDir, ConfigImportSettings settings, File installationHome) {
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(4);
        }
        if (oldConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(5);
        }
        try {
            ConfigImportHelper.copy(oldConfigDir, newConfigDir, settings, installationHome);
            if (!SystemInfo.isMac) {
                File[] files2;
                File oldParent = oldConfigDir.getParentFile();
                File newParent = newConfigDir.getParentFile();
                if (oldParent != null && newParent != null && (files2 = oldParent.listFiles()) != null) {
                    for (File file2 : files2) {
                        String path = file2.getPath();
                        if (!path.endsWith(".properties") && !path.endsWith(".vmoptions")) continue;
                        File dest = new File(newParent, file2.getName());
                        Files.copy((File)file2, (File)dest);
                    }
                }
            }
        }
        catch (IOException e) {
            String message = ApplicationBundle.message((String)"error.unable.to.import.settings", (Object[])new Object[]{e.getMessage()});
            Main.showMessage((String)ApplicationBundle.message((String)"title.settings.import.failed", (Object[])new Object[0]), (String)message, (boolean)false);
        }
    }

    private static boolean validateOldConfigDir(@Nullable File installationHome, @Nullable File oldConfigDir, @NotNull ConfigImportSettings settings) {
        if (settings == null) {
            ConfigImportHelper.$$$reportNull$$$0(6);
        }
        if (oldConfigDir == null) {
            if (installationHome != null) {
                String message = ApplicationBundle.message((String)"error.invalid.installation.home", (Object[])new Object[]{installationHome.getAbsolutePath(), settings.getProductName(ThreeState.YES)});
                Main.showMessage((String)ApplicationBundle.message((String)"title.settings.import.failed", (Object[])new Object[0]), (String)message, (boolean)false);
            }
            return false;
        }
        if (!oldConfigDir.exists()) {
            String message = ApplicationBundle.message((String)"error.no.settings.path", (Object[])new Object[]{oldConfigDir.getAbsolutePath()});
            Main.showMessage((String)ApplicationBundle.message((String)"title.settings.import.failed", (Object[])new Object[0]), (String)message, (boolean)false);
            return false;
        }
        return true;
    }

    private static void copy(@NotNull File src, @NotNull File dest, ConfigImportSettings settings, File oldInstallationHome) throws IOException {
        int end;
        String xml;
        int index;
        if (src == null) {
            ConfigImportHelper.$$$reportNull$$$0(7);
        }
        if (dest == null) {
            ConfigImportHelper.$$$reportNull$$$0(8);
        }
        src = src.getCanonicalFile();
        dest = dest.getCanonicalFile();
        if (!src.isDirectory()) {
            throw new IOException(ApplicationBundle.message((String)"config.import.invalid.directory.error", (Object[])new Object[]{src.getAbsolutePath()}));
        }
        if (!dest.isDirectory()) {
            throw new IOException(ApplicationBundle.message((String)"config.import.invalid.directory.error", (Object[])new Object[]{dest.getAbsolutePath()}));
        }
        if (FileUtil.filesEqual((File)src, (File)dest)) {
            return;
        }
        FileUtil.ensureExists((File)dest);
        FileUtil.copyDir((File)src, (File)dest);
        FileUtil.delete((File)new File(dest, "user.token"));
        FileUtil.delete((File)new File(dest, "user.web.token"));
        File oldPluginsDir = new File(src, PLUGINS_PATH);
        if (!oldPluginsDir.isDirectory() && SystemInfo.isMac) {
            oldPluginsDir = ConfigImportHelper.getSettingsPath(oldInstallationHome, settings, "idea.plugins.path", (Function<String, String>)((Function)pathSelector -> PathManager.getDefaultPluginPathFor((String)pathSelector)));
            if (oldPluginsDir == null) {
                oldPluginsDir = new File(PathManager.getDefaultPluginPathFor((String)src.getName()));
            }
            File newPluginsDir = new File(PathManager.getPluginsPath());
            FileUtil.copyDir((File)oldPluginsDir, (File)newPluginsDir);
        }
        ConfigImportHelper.loadOldPlugins(oldPluginsDir, dest);
        File updates = new File(dest, "options" + File.separator + "updates.xml");
        if (updates.exists() && (index = (xml = Files.toString((File)updates, (Charset)Charsets.UTF_8)).indexOf("<option name=\"UPDATE_CHANNEL_TYPE\"")) != -1 && (end = xml.indexOf(62, index)) != -1) {
            xml = xml.substring(0, index) + xml.substring(end + 1);
            Files.write((CharSequence)xml, (File)updates, (Charset)Charsets.UTF_8);
        }
    }

    private static boolean loadOldPlugins(File plugins2, File dest) throws IOException {
        if (plugins2.exists()) {
            SmartList descriptors = new SmartList();
            PluginManagerCore.loadDescriptors(plugins2, (List<IdeaPluginDescriptorImpl>)descriptors, null, 0);
            SmartList oldPlugins = new SmartList();
            for (IdeaPluginDescriptorImpl descriptor : descriptors) {
                if (!descriptor.isEnabled() || descriptor.isBundled()) continue;
                oldPlugins.add(descriptor.getPluginId().getIdString());
            }
            if (!oldPlugins.isEmpty()) {
                PluginManagerCore.savePluginsList((Collection<String>)oldPlugins, false, new File(dest, "installed.txt"));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static File getOldConfigDir(@Nullable File oldInstallHome, ConfigImportSettings settings) {
        if (oldInstallHome == null) {
            return null;
        }
        if (new File(oldInstallHome, OPTIONS_XML).exists()) {
            return oldInstallHome;
        }
        if (new File(oldInstallHome, CONFIG_RELATED_PATH + OPTIONS_XML).exists()) {
            return new File(oldInstallHome, CONFIG_RELATED_PATH);
        }
        int oldBuildNumber = ConfigImportHelper.getBuildNumber(oldInstallHome);
        if (oldBuildNumber != -1 && oldBuildNumber <= 600) {
            return new File(oldInstallHome, "config");
        }
        return ConfigImportHelper.getSettingsPath(oldInstallHome, settings, "idea.config.path", (Function<String, String>)((Function)pathsSelector -> PathManager.getDefaultConfigPathFor((String)pathsSelector)));
    }

    private static File getSettingsPath(File installHome, ConfigImportSettings settings, String propertyName, Function<String, String> fromPathSelector) {
        List<File> launchFileCandidates = ConfigImportHelper.getLaunchFilesCandidates(installHome, settings);
        for (File candidate : launchFileCandidates) {
            File probableConfig;
            String configDir;
            if (!candidate.exists() || (configDir = PathManager.substituteVars((String)ConfigImportHelper.getPropertyFromLaxFile(candidate, propertyName), (String)installHome.getPath())) == null || !(probableConfig = new File(configDir)).exists()) continue;
            return probableConfig;
        }
        for (File candidate : launchFileCandidates) {
            File candidateDir;
            String pathsSelector;
            if (!candidate.exists() || (pathsSelector = ConfigImportHelper.getPropertyFromLaxFile(candidate, "idea.paths.selector")) == null || !(candidateDir = new File((String)fromPathSelector.fun((Object)pathsSelector))).exists()) continue;
            return candidateDir;
        }
        return null;
    }

    private static List<File> getLaunchFilesCandidates(@NotNull File instHome, @NotNull ConfigImportSettings settings) {
        if (instHome == null) {
            ConfigImportHelper.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            ConfigImportHelper.$$$reportNull$$$0(10);
        }
        File bin = new File(instHome, BIN_FOLDER);
        ArrayList<File> files2 = new ArrayList<File>();
        if (SystemInfo.isMac) {
            files2.add(new File(new File(instHome, "Contents"), "Info.plist"));
            files2.add(new File(new File(new File(bin, "idea.app"), "Contents"), "Info.plist"));
            files2.add(new File(new File(new File(instHome, "idea.app"), "Contents"), "Info.plist"));
        }
        files2.add(new File(bin, "idea.properties"));
        String executableName = StringUtil.toLowerCase((String)settings.getExecutableName());
        ConfigImportHelper.addLaunchExecutableScriptsCandidates(files2, executableName, bin);
        files2.addAll(settings.getCustomLaunchFilesCandidates(instHome, bin));
        if (!"idea".equals(executableName)) {
            ConfigImportHelper.addLaunchExecutableScriptsCandidates(files2, "idea", bin);
        }
        return files2;
    }

    private static void addLaunchExecutableScriptsCandidates(List<File> files2, String executableName, File binFolder) {
        files2.add(new File(binFolder, executableName + ".lax"));
        files2.add(new File(binFolder, executableName + ".bat"));
        files2.add(new File(binFolder, executableName + ".sh"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getPropertyFromLaxFile(@NotNull File file2, @NotNull String propertyName) {
        if (file2 == null) {
            ConfigImportHelper.$$$reportNull$$$0(11);
        }
        if (propertyName == null) {
            ConfigImportHelper.$$$reportNull$$$0(12);
        }
        if (file2.getName().endsWith(".properties")) {
            try {
                PropertyResourceBundle bundle;
                try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file2));){
                    bundle = new PropertyResourceBundle(fis);
                }
                if (bundle.containsKey(propertyName)) {
                    return bundle.getString(propertyName);
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        String fileContent = ConfigImportHelper.getContent(file2);
        String propertyValue = ConfigImportHelper.findProperty(propertyName, fileContent);
        if (!StringUtil.isEmpty((String)propertyValue)) {
            return propertyValue;
        }
        return null;
    }

    @Nullable
    private static String findProperty(String propertyName, String fileContent) {
        String param = propertyName + "=";
        int idx = fileContent.indexOf(param);
        if (idx == -1) {
            param = "<key>" + propertyName + "</key>";
            idx = fileContent.indexOf(param);
            if (idx == -1) {
                return null;
            }
            if ((idx = fileContent.indexOf("<string>", idx)) == -1) {
                return null;
            }
            return ConfigImportHelper.fixDirName(fileContent.substring(idx += "<string>".length(), fileContent.indexOf("</string>", idx)), true);
        }
        String configDir = "";
        if (fileContent.length() > (idx += param.length())) {
            if (fileContent.charAt(idx) == '\"') {
                ++idx;
                while (fileContent.length() > idx && fileContent.charAt(idx) != '\"' && fileContent.charAt(idx) != '\n' && fileContent.charAt(idx) != '\r') {
                    configDir = configDir + fileContent.charAt(idx);
                    ++idx;
                }
            } else {
                while (fileContent.length() > idx && !Character.isSpaceChar(fileContent.charAt(idx)) && fileContent.charAt(idx) != '\n' && fileContent.charAt(idx) != '\r') {
                    configDir = configDir + fileContent.charAt(idx);
                    ++idx;
                }
            }
        }
        if ((configDir = ConfigImportHelper.fixDirName(configDir, true)).length() > 0) {
            configDir = new File(configDir).getPath();
        }
        return configDir;
    }

    @Nullable
    private static String getContent(File file2) {
        try {
            return FileUtil.loadFile((File)file2);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String fixDirName(String dir, boolean replaceUserHome) {
        if (StringUtil.startsWithChar((CharSequence)dir, (char)'\"') && StringUtil.endsWithChar((CharSequence)dir, (char)'\"')) {
            dir = dir.substring(1, dir.length() - 1);
        }
        if (replaceUserHome) {
            dir = FileUtil.expandUserHome((String)dir);
        }
        return dir;
    }

    public static boolean isInstallationHomeOrConfig(@NotNull String installationHome, @NotNull ConfigImportSettings settings) {
        String[] mainJarNames;
        if (installationHome == null) {
            ConfigImportHelper.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            ConfigImportHelper.$$$reportNull$$$0(14);
        }
        if (new File(installationHome, OPTIONS_XML).exists()) {
            return true;
        }
        if (new File(installationHome, CONFIG_RELATED_PATH + OPTIONS_XML).exists()) {
            return true;
        }
        if (!new File(installationHome, BIN_FOLDER).exists()) {
            return false;
        }
        File libFolder = new File(installationHome, "lib");
        boolean quickTest = false;
        for (String name : mainJarNames = settings.getMainJarNames()) {
            String mainJarName = StringUtil.toLowerCase((String)name) + ".jar";
            if (!new File(libFolder, mainJarName).exists()) continue;
            quickTest = true;
            break;
        }
        if (!quickTest) {
            return false;
        }
        List<File> files2 = ConfigImportHelper.getLaunchFilesCandidates(new File(installationHome), settings);
        for (File file2 : files2) {
            if (!file2.exists()) continue;
            return true;
        }
        return false;
    }

    private static int getBuildNumber(File installDirectory) {
        File buildTxt = new File(installDirectory = installDirectory.getAbsoluteFile(), BUILD_NUMBER_FILE);
        if (!buildTxt.exists() || buildTxt.isDirectory()) {
            buildTxt = new File(new File(installDirectory, BIN_FOLDER), BUILD_NUMBER_FILE);
        }
        if (buildTxt.exists() && !buildTxt.isDirectory()) {
            int buildNumber = -1;
            String buildNumberText = ConfigImportHelper.getContent(buildTxt);
            if (buildNumberText != null) {
                try {
                    if (buildNumberText.length() > 1) {
                        buildNumberText = buildNumberText.trim();
                        buildNumber = Integer.parseInt(buildNumberText);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return buildNumber;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfigPath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/ConfigImportHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfigDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldConfigDir";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instHome";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installationHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/ConfigImportHelper";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigImportSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importConfigsTo";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findOldConfigDir";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doImport";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateOldConfigDir";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLaunchFilesCandidates";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyFromLaxFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInstallationHomeOrConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

