/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.CommonBundle;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CannotUndoReportDialog
extends DialogWrapper {
    private static final int FILE_TEXT_PREVIEW_CHARS_LIMIT = 40;
    private JList myProblemFilesList;
    private JPanel myPanel;
    private JLabel myProblemMessageLabel;

    public CannotUndoReportDialog(Project project, @Nls String problemText, Collection<DocumentReference> files2) {
        super(project, false);
        this.$$$setupUI$$$();
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (DocumentReference file2 : files2) {
            CharSequence content;
            VirtualFile vFile = file2.getFile();
            if (vFile != null) {
                model.add(0, vFile.getPresentableUrl());
                continue;
            }
            Document document = file2.getDocument();
            CharSequence charSequence = content = document == null ? null : document.getImmutableCharSequence();
            if (content != null && content.length() > 40) {
                content = content.subSequence(0, 40) + "...";
            }
            model.add(0, "<temporary file>" + (content == null ? "" : " [" + content + "]"));
        }
        this.myProblemFilesList.setModel(model);
        this.setTitle(CommonBundle.message((String)"cannot.undo.dialog.title", (Object[])new Object[0]));
        this.myProblemMessageLabel.setText(problemText);
        this.myProblemMessageLabel.setIcon(Messages.getErrorIcon());
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            CannotUndoReportDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/impl/CannotUndoReportDialog", "createActions"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myProblemMessageLabel = jLabel = new JLabel();
        jLabel.setText("%%Cannot undo reason%");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndentWithoutInsets.createTitledBorder(null, (String)"Problem files", (int)0, (int)0, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myProblemFilesList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

