/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.CommandLog;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreCommandProcessor
extends CommandProcessorEx {
    protected CommandDescriptor myCurrentCommand;
    private final Stack<CommandDescriptor> myInterruptedCommands = new Stack();
    private final List<CommandListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private int myUndoTransparentCount;

    public void executeCommand(@NotNull Runnable runnable2, String name, Object groupId) {
        if (runnable2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(0);
        }
        this.executeCommand(null, runnable2, name, groupId);
    }

    public void executeCommand(Project project, @NotNull Runnable runnable2, String name, Object groupId) {
        if (runnable2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(1);
        }
        this.executeCommand(project, runnable2, name, groupId, UndoConfirmationPolicy.DEFAULT);
    }

    public void executeCommand(Project project, @NotNull Runnable runnable2, String name, Object groupId, Document document) {
        if (runnable2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(2);
        }
        this.executeCommand(project, runnable2, name, groupId, UndoConfirmationPolicy.DEFAULT, document);
    }

    public void executeCommand(Project project, @NotNull Runnable command, String name, Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(3);
        }
        if (confirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(4);
        }
        this.executeCommand(project, command, name, groupId, confirmationPolicy, null);
    }

    public void executeCommand(Project project, @NotNull Runnable command, String name, Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy, Document document) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(5);
        }
        if (confirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(6);
        }
        this.executeCommand(project, command, name, groupId, confirmationPolicy, true, document);
    }

    public void executeCommand(@Nullable Project project, @NotNull Runnable command, @Nullable String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean shouldRecordCommandForActiveDocument) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(7);
        }
        if (confirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(8);
        }
        this.executeCommand(project, command, name, groupId, confirmationPolicy, shouldRecordCommandForActiveDocument, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(@Nullable Project project, @NotNull Runnable command, @Nullable String name, @Nullable Object groupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean shouldRecordCommandForActiveDocument, @Nullable Document document) {
        if (command == null) {
            CoreCommandProcessor.$$$reportNull$$$0(9);
        }
        if (confirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(10);
        }
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (project != null && project.isDisposed()) {
            CommandLog.LOG.error("Project " + project + " already disposed");
            return;
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("executeCommand: " + command + ", name = " + name + ", groupId = " + groupId + ", in command = " + (this.myCurrentCommand != null) + ", in transparent action = " + this.isUndoTransparentActionInProgress());
        }
        if (this.myCurrentCommand != null) {
            command.run();
            return;
        }
        Throwable throwable = null;
        try {
            this.myCurrentCommand = new CommandDescriptor(command, project, name, groupId, confirmationPolicy, shouldRecordCommandForActiveDocument, document);
            this.fireCommandStarted();
            command.run();
        }
        catch (Throwable th) {
            throwable = th;
        }
        finally {
            this.finishCommand(project, this.myCurrentCommand, throwable);
        }
    }

    @Override
    @Nullable
    public Object startCommand(@NotNull Project project, @Nls String name, Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy) {
        if (project == null) {
            CoreCommandProcessor.$$$reportNull$$$0(11);
        }
        if (undoConfirmationPolicy == null) {
            CoreCommandProcessor.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project.isDisposed()) {
            return null;
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("startCommand: name = " + name + ", groupId = " + groupId);
        }
        if (this.myCurrentCommand != null) {
            return null;
        }
        Document document = groupId instanceof Ref && ((Ref)groupId).get() instanceof Document ? (Document)((Ref)groupId).get() : null;
        this.myCurrentCommand = new CommandDescriptor(EmptyRunnable.INSTANCE, project, name, groupId, undoConfirmationPolicy, true, document);
        this.fireCommandStarted();
        return this.myCurrentCommand;
    }

    @Override
    public void finishCommand(Project project, Object command, Throwable throwable) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandLog.LOG.assertTrue(this.myCurrentCommand != null, (Object)"no current command in progress");
        this.fireCommandFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCommandFinished() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent((CommandProcessor)this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myShouldRecordActionForActiveDocument, currentCommand.myDocument);
        try {
            for (CommandListener listener2 : this.myListeners) {
                try {
                    listener2.beforeCommandFinished(event);
                }
                catch (Throwable e) {
                    CommandLog.LOG.error(e);
                }
            }
        }
        finally {
            this.myCurrentCommand = null;
            for (CommandListener listener2 : this.myListeners) {
                try {
                    listener2.commandFinished(event);
                }
                catch (Throwable e) {
                    CommandLog.LOG.error(e);
                }
            }
        }
    }

    @Override
    public void enterModal() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        this.myInterruptedCommands.push(currentCommand);
        if (currentCommand != null) {
            this.fireCommandFinished();
        }
    }

    @Override
    public void leaveModal() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandLog.LOG.assertTrue(this.myCurrentCommand == null, (Object)("Command must not run: " + this.myCurrentCommand));
        this.myCurrentCommand = this.myInterruptedCommands.pop();
        if (this.myCurrentCommand != null) {
            this.fireCommandStarted();
        }
    }

    public void setCurrentCommandName(String name) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandLog.LOG.assertTrue(currentCommand != null);
        currentCommand.myName = name;
    }

    public void setCurrentCommandGroupId(Object groupId) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandLog.LOG.assertTrue(currentCommand != null);
        currentCommand.myGroupId = groupId;
    }

    @Nullable
    public Runnable getCurrentCommand() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        return currentCommand != null ? currentCommand.myCommand : null;
    }

    @Nullable
    public String getCurrentCommandName() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        if (currentCommand != null) {
            return currentCommand.myName;
        }
        if (!this.myInterruptedCommands.isEmpty()) {
            CommandDescriptor command = this.myInterruptedCommands.peek();
            return command != null ? command.myName : null;
        }
        return null;
    }

    @Nullable
    public Object getCurrentCommandGroupId() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        if (currentCommand != null) {
            return currentCommand.myGroupId;
        }
        if (!this.myInterruptedCommands.isEmpty()) {
            CommandDescriptor command = this.myInterruptedCommands.peek();
            return command != null ? command.myGroupId : null;
        }
        return null;
    }

    @Nullable
    public Project getCurrentCommandProject() {
        CommandDescriptor currentCommand = this.myCurrentCommand;
        return currentCommand != null ? currentCommand.myProject : null;
    }

    public void addCommandListener(@NotNull CommandListener listener2) {
        if (listener2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(13);
        }
        this.myListeners.add(listener2);
    }

    public void addCommandListener(final @NotNull CommandListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(14);
        }
        if (parentDisposable == null) {
            CoreCommandProcessor.$$$reportNull$$$0(15);
        }
        this.addCommandListener(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                CoreCommandProcessor.this.removeCommandListener(listener2);
            }
        });
    }

    public void removeCommandListener(@NotNull CommandListener listener2) {
        if (listener2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(16);
        }
        this.myListeners.remove(listener2);
    }

    public void runUndoTransparentAction(@NotNull Runnable action) {
        if (action == null) {
            CoreCommandProcessor.$$$reportNull$$$0(17);
        }
        if (CommandLog.LOG.isDebugEnabled()) {
            CommandLog.LOG.debug("runUndoTransparentAction: " + action + ", in command = " + (this.myCurrentCommand != null) + ", in transparent action = " + this.isUndoTransparentActionInProgress());
        }
        if (this.myUndoTransparentCount++ == 0) {
            this.fireUndoTransparentStarted();
        }
        try {
            action.run();
        }
        finally {
            if (--this.myUndoTransparentCount == 0) {
                this.fireUndoTransparentFinished();
            }
        }
    }

    public boolean isUndoTransparentActionInProgress() {
        return this.myUndoTransparentCount > 0;
    }

    public void markCurrentCommandAsGlobal(Project project) {
    }

    public void addAffectedDocuments(Project project, Document ... docs) {
        if (docs == null) {
            CoreCommandProcessor.$$$reportNull$$$0(18);
        }
    }

    public void addAffectedFiles(Project project, VirtualFile ... files2) {
        if (files2 == null) {
            CoreCommandProcessor.$$$reportNull$$$0(19);
        }
    }

    private void fireCommandStarted() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CommandDescriptor currentCommand = this.myCurrentCommand;
        CommandEvent event = new CommandEvent((CommandProcessor)this, currentCommand.myCommand, currentCommand.myName, currentCommand.myGroupId, currentCommand.myProject, currentCommand.myUndoConfirmationPolicy, currentCommand.myShouldRecordActionForActiveDocument, currentCommand.myDocument);
        for (CommandListener listener2 : this.myListeners) {
            try {
                listener2.commandStarted(event);
            }
            catch (Throwable e) {
                CommandLog.LOG.error(e);
            }
        }
    }

    private void fireUndoTransparentStarted() {
        for (CommandListener listener2 : this.myListeners) {
            try {
                listener2.undoTransparentActionStarted();
            }
            catch (Throwable e) {
                CommandLog.LOG.error(e);
            }
        }
    }

    private void fireUndoTransparentFinished() {
        for (CommandListener listener2 : this.myListeners) {
            try {
                listener2.undoTransparentActionFinished();
            }
            catch (Throwable e) {
                CommandLog.LOG.error(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmationPolicy";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoConfirmationPolicy";
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docs";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/impl/CoreCommandProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeCommand";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "startCommand";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "addCommandListener";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "removeCommandListener";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "runUndoTransparentAction";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "addAffectedDocuments";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "addAffectedFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CommandDescriptor {
        @NotNull
        public final Runnable myCommand;
        public final Project myProject;
        public String myName;
        public Object myGroupId;
        public final Document myDocument;
        @NotNull
        public final UndoConfirmationPolicy myUndoConfirmationPolicy;
        public final boolean myShouldRecordActionForActiveDocument;

        CommandDescriptor(@NotNull Runnable command, Project project, String name, Object groupId, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean shouldRecordActionForActiveDocument, Document document) {
            if (command == null) {
                CommandDescriptor.$$$reportNull$$$0(0);
            }
            if (undoConfirmationPolicy == null) {
                CommandDescriptor.$$$reportNull$$$0(1);
            }
            this.myCommand = command;
            this.myProject = project;
            this.myName = name;
            this.myGroupId = groupId;
            this.myUndoConfirmationPolicy = undoConfirmationPolicy;
            this.myShouldRecordActionForActiveDocument = shouldRecordActionForActiveDocument;
            this.myDocument = document;
        }

        public String toString() {
            return "'" + this.myName + "', group: '" + this.myGroupId + "'";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "command";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "undoConfirmationPolicy";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/command/impl/CoreCommandProcessor$CommandDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

