/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.openapi.diff.impl.DiffSplitterI;
import com.intellij.openapi.diff.impl.highlighting.DiffPanelState;
import com.intellij.openapi.diff.impl.splitter.DiffDividerPaint;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import java.awt.Graphics;
import javax.swing.JComponent;

class DiffSplitter
extends Splitter
implements DiffSplitterI {
    private final DiffDividerPaint myPaint;
    private final DiffPanelState myData;
    private final VisibleAreaListener myVisibleAreaListener = new VisibleAreaListener(){

        public void visibleAreaChanged(VisibleAreaEvent e) {
            DiffSplitter.this.redrawDiffs();
        }
    };

    public DiffSplitter(JComponent component1, JComponent component2, DiffDividerPaint dividerPaint, DiffPanelState data) {
        this.myPaint = dividerPaint;
        this.myData = data;
        this.setDividerWidth(30);
        this.setFirstComponent(component1);
        this.setSecondComponent(component2);
        this.setHonorComponentsMinimumSize(false);
    }

    protected Divider createDivider() {
        return new Splitter.DividerImpl(){

            public void paint(Graphics g) {
                super.paint(g);
                DiffSplitter.this.myPaint.paint(g, (JComponent)((Object)this));
                DiffSplitter.this.myData.drawOnDivider(g, (JComponent)((Object)this));
            }
        };
    }

    @Override
    public void redrawDiffs() {
        this.getDivider().repaint();
    }

    @Override
    public VisibleAreaListener getVisibleAreaListener() {
        return this.myVisibleAreaListener;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }
}

