/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.execution.CommandLineUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.AbstractUpdateDialog;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.ButtonInfo;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.LicensingFacade;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UpdateInfoDialog
extends AbstractUpdateDialog {
    private final UpdateChannel myUpdatedChannel;
    private final boolean myForceHttps;
    private final Collection<PluginDownloader> myUpdatedPlugins;
    private final BuildInfo myNewBuild;
    private final PatchInfo myPatch;
    private final boolean myWriteProtected;
    private final Pair<String, Color> myLicenseInfo;
    private final File myTestPatch;

    UpdateInfoDialog(@NotNull UpdateChannel channel, @NotNull BuildInfo newBuild, @Nullable PatchInfo patch, boolean enableLink, boolean forceHttps, @Nullable Collection<PluginDownloader> updatedPlugins, @Nullable Collection<IdeaPluginDescriptor> incompatiblePlugins) {
        if (channel == null) {
            UpdateInfoDialog.$$$reportNull$$$0(0);
        }
        if (newBuild == null) {
            UpdateInfoDialog.$$$reportNull$$$0(1);
        }
        super(enableLink);
        this.myUpdatedChannel = channel;
        this.myForceHttps = forceHttps;
        this.myUpdatedPlugins = updatedPlugins;
        this.myNewBuild = newBuild;
        this.myPatch = patch;
        this.myWriteProtected = this.myPatch != null && !SystemInfo.isWindows && !Files.isWritable(Paths.get(PathManager.getHomePath(), new String[0]));
        this.getCancelAction().putValue("DefaultAction", Boolean.TRUE);
        this.myLicenseInfo = UpdateInfoDialog.initLicensingInfo(this.myUpdatedChannel, this.myNewBuild);
        this.myTestPatch = null;
        this.init();
        if (!ContainerUtil.isEmpty(incompatiblePlugins)) {
            String list2 = StringUtil.join(incompatiblePlugins, IdeaPluginDescriptor::getName, (String)"<br/>");
            this.setErrorText(IdeBundle.message((String)"updates.incompatible.plugins.found", (Object[])new Object[]{incompatiblePlugins.size(), list2}));
        }
    }

    UpdateInfoDialog(UpdateChannel channel, BuildInfo newBuild, PatchInfo patch, @Nullable File patchFile) {
        super(true);
        this.myUpdatedChannel = channel;
        this.myForceHttps = true;
        this.myUpdatedPlugins = null;
        this.myNewBuild = newBuild;
        this.myPatch = patch;
        this.myWriteProtected = false;
        this.myLicenseInfo = null;
        this.myTestPatch = patchFile;
        this.init();
        this.setTitle("[TEST] " + this.getTitle());
    }

    private static Pair<String, Color> initLicensingInfo(UpdateChannel channel, BuildInfo build) {
        Boolean applicable;
        LicensingFacade facade = LicensingFacade.getInstance();
        if (facade == null) {
            return null;
        }
        if (channel.getLicensing().equals("eap")) {
            return Pair.pair((Object)IdeBundle.message((String)"updates.channel.bundled.key", (Object[])new Object[0]), null);
        }
        Date releaseDate = build.getReleaseDate();
        Boolean bl = applicable = releaseDate == null ? null : facade.isApplicableForProduct(releaseDate);
        if (applicable == null) {
            return null;
        }
        if (applicable == Boolean.FALSE) {
            return Pair.pair((Object)IdeBundle.message((String)"updates.paid.upgrade", (Object[])new Object[]{channel.getEvalDays()}), (Object)JBColor.RED);
        }
        if (facade.isPerpetualForProduct(releaseDate) == Boolean.TRUE) {
            return Pair.pair((Object)IdeBundle.message((String)"updates.fallback.build", (Object[])new Object[0]), null);
        }
        Date expiration = facade.getLicenseExpirationDate();
        if (expiration != null) {
            return Pair.pair((Object)IdeBundle.message((String)"updates.interim.build", (Object[])new Object[]{DateFormatUtil.formatAboutDialogDate((Date)expiration)}), null);
        }
        return null;
    }

    protected JComponent createCenterPanel() {
        return new UpdateInfoPanel().myPanel;
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList actions = ContainerUtil.newArrayList();
        if (this.myPatch != null) {
            boolean canRestart = ApplicationManager.getApplication().isRestartCapable();
            actions.add(new AbstractAction(IdeBundle.message((String)(canRestart ? "updates.download.and.restart.button" : "updates.apply.manually.button"), (Object[])new Object[0])){
                {
                    this.setEnabled(!UpdateInfoDialog.this.myWriteProtected);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdateInfoDialog.this.close(0);
                    UpdateInfoDialog.this.downloadPatchAndRestart();
                }
            });
        }
        List<ButtonInfo> buttons = this.myNewBuild.getButtons();
        for (ButtonInfo info : buttons) {
            if (info.isDownload() && this.myPatch != null) continue;
            actions.add(new ButtonAction(info));
        }
        actions.add(new AbstractAction(IdeBundle.message((String)"updates.ignore.update.button", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                String build = UpdateInfoDialog.this.myNewBuild.getNumber().asStringWithoutProductCode();
                UpdateSettings.getInstance().getIgnoredBuildNumbers().add(build);
                UpdateInfoDialog.this.doCancelAction();
            }
        });
        actions.add(this.getCancelAction());
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            UpdateInfoDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    @Override
    protected String getCancelButtonText() {
        return IdeBundle.message((String)"updates.remind.later.button", (Object[])new Object[0]);
    }

    private void downloadPatchAndRestart() {
        boolean updatePlugins;
        boolean bl = updatePlugins = !ContainerUtil.isEmpty(this.myUpdatedPlugins);
        if (updatePlugins && !new PluginUpdateInfoDialog(this.myUpdatedPlugins).showAndGet()) {
            return;
        }
        new Task.Backgroundable(null, IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                Application app;
                String[] command;
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                try {
                    File file2 = UpdateInfoDialog.this.myTestPatch != null ? UpdateInfoDialog.this.myTestPatch : UpdateInstaller.downloadPatchFile(UpdateInfoDialog.this.myPatch, UpdateInfoDialog.this.myNewBuild.getNumber(), UpdateInfoDialog.this.myForceHttps, indicator);
                    indicator.setText(IdeBundle.message((String)"update.preparing.patch.progress", (Object[])new Object[0]));
                    command = UpdateInstaller.preparePatchCommand(file2);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    Logger.getInstance(UpdateInstaller.class).warn((Throwable)e);
                    String title = IdeBundle.message((String)"updates.error.connection.title", (Object[])new Object[0]);
                    String message = IdeBundle.message((String)"update.downloading.patch.error", (Object[])new Object[]{e.getMessage()});
                    UpdateChecker.NOTIFICATIONS.createNotification(title, message, NotificationType.ERROR, (NotificationListener)new NotificationListener.Adapter(){

                        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                            if (notification == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (e == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            UpdateInfoDialog.this.openDownloadPage();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "notification";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "e";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/openapi/updateSettings/impl/UpdateInfoDialog$3$1";
                            objectArray[2] = "hyperlinkActivated";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }).notify(null);
                    return;
                }
                if (updatePlugins) {
                    UpdateInstaller.installPluginUpdates(UpdateInfoDialog.this.myUpdatedPlugins, indicator);
                }
                if ((app = ApplicationManager.getApplication()).isRestartCapable()) {
                    if (indicator.isShowing()) {
                        app.invokeLater(() -> ((ApplicationImpl)app).exit(true, true, true, command));
                    } else {
                        String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
                        String message = IdeBundle.message((String)"update.ready.message", (Object[])new Object[0]);
                        UpdateChecker.NOTIFICATIONS.createNotification(title, message, NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

                            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                                if (notification == null) {
                                    2.$$$reportNull$$$0(0);
                                }
                                if (e == null) {
                                    2.$$$reportNull$$$0(1);
                                }
                                app.invokeLater(() -> ((ApplicationImpl)app).exit(true, true, true, command));
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "notification";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "e";
                                        break;
                                    }
                                }
                                objectArray[1] = "com/intellij/openapi/updateSettings/impl/UpdateInfoDialog$3$2";
                                objectArray[2] = "hyperlinkActivated";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        }).notify(null);
                    }
                } else {
                    UpdateInfoDialog.showPatchInstructions(command);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/updateSettings/impl/UpdateInfoDialog$3", "run"));
            }
        }.queue();
    }

    private void openDownloadPage() {
        String url = this.myNewBuild.getDownloadUrl();
        assert (!StringUtil.isEmptyOrSpaces((String)url)) : "channel:" + this.myUpdatedChannel.getId() + " build:" + this.myNewBuild.getNumber();
        BrowserUtil.browse((String)UpdateInfoDialog.augmentUrl(url));
    }

    private static void showPatchInstructions(String[] command) {
        String product = ApplicationNamesInfo.getInstance().getFullProductName().replace(' ', '-').toLowerCase(Locale.US);
        String version = ApplicationInfo.getInstance().getFullVersion();
        File file2 = new File(SystemProperties.getUserHome(), product + "-" + version + "-patch." + (SystemInfo.isWindows ? "cmd" : "sh"));
        try {
            String text = (SystemInfo.isWindows ? "@echo off\n\n" : "#!/bin/sh\n\n") + StringUtil.join((Collection)CommandLineUtil.toCommandLine(Arrays.asList(command)), (String)" ");
            FileUtil.writeToFile((File)file2, (String)text);
            FileUtil.setExecutableAttribute((String)file2.getPath(), (boolean)true);
        }
        catch (Exception e) {
            Logger.getInstance(UpdateInstaller.class).error((Throwable)e);
            return;
        }
        String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
        String message = IdeBundle.message((String)"update.apply.manually.message", (Object[])new Object[]{file2});
        ApplicationManager.getApplication().invokeLater(() -> Messages.showInfoMessage((String)message, (String)title));
    }

    private static String formatVersion(String versionString, BuildNumber build) {
        return IdeBundle.message((String)"updates.version.info", (Object[])new Object[]{versionString, build.asStringWithoutProductCode()});
    }

    private static String augmentUrl(String url) {
        return IdeUrlTrackingParametersProvider.getInstance().augmentUrl(url);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBuild";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/UpdateInfoDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateInfoDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class UpdateInfoPanel {
        private JPanel myPanel;
        private JEditorPane myUpdateMessage;
        private JBLabel myCurrentVersion;
        private JBLabel myNewVersion;
        private JBLabel myPatchLabel;
        private JBLabel myPatchInfo;
        private JEditorPane myMessageArea;
        private JEditorPane myLicenseArea;
        private JBScrollPane myScrollPane;

        public UpdateInfoPanel() {
            int idx;
            String url;
            this.$$$setupUI$$$();
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            ApplicationNamesInfo appNames = ApplicationNamesInfo.getInstance();
            String message = UpdateInfoDialog.this.myNewBuild.getMessage();
            String fullProductName = appNames.getFullProductName();
            if (StringUtil.isEmpty((String)message)) {
                message = IdeBundle.message((String)"updates.new.version.available", (Object[])new Object[]{fullProductName});
            }
            if (!StringUtil.isEmptyOrSpaces((String)(url = UpdateInfoDialog.this.myNewBuild.getDownloadUrl())) && (idx = message.indexOf(fullProductName)) >= 0) {
                message = message.substring(0, idx) + "<a href='" + UpdateInfoDialog.augmentUrl(url) + "'>" + fullProductName + "</a>" + message.substring(idx + fullProductName.length());
            }
            UpdateInfoDialog.this.configureMessageArea(this.myUpdateMessage, message, null, (HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
            this.myCurrentVersion.setText(UpdateInfoDialog.formatVersion(appInfo.getFullVersion(), appInfo.getBuild()));
            this.myNewVersion.setText(UpdateInfoDialog.formatVersion(UpdateInfoDialog.this.myNewBuild.getVersion(), UpdateInfoDialog.this.myNewBuild.getNumber()));
            if (UpdateInfoDialog.this.myPatch != null && !StringUtil.isEmptyOrSpaces((String)UpdateInfoDialog.this.myPatch.getSize())) {
                this.myPatchInfo.setText(UpdateInfoDialog.this.myPatch.getSize() + " MB");
            } else {
                this.myPatchLabel.setVisible(false);
                this.myPatchInfo.setVisible(false);
            }
            if (UpdateInfoDialog.this.myWriteProtected) {
                message = IdeBundle.message((String)"updates.write.protected", (Object[])new Object[]{appNames.getProductName(), PathManager.getHomePath()});
                UpdateInfoDialog.this.configureMessageArea(this.myMessageArea, message, (Color)JBColor.RED, null);
            } else {
                UpdateInfoDialog.this.configureMessageArea(this.myMessageArea);
            }
            if (UpdateInfoDialog.this.myLicenseInfo != null) {
                UpdateInfoDialog.this.configureMessageArea(this.myLicenseArea, (String)((UpdateInfoDialog)UpdateInfoDialog.this).myLicenseInfo.first, (Color)((UpdateInfoDialog)UpdateInfoDialog.this).myLicenseInfo.second, null);
            }
        }

        private void createUIComponents() {
            this.myUpdateMessage = new JEditorPane("text/html", ""){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension size = super.getPreferredScrollableViewportSize();
                    size.height = Math.min(size.height, JBUI.scale((int)400));
                    return size;
                }
            };
            this.myScrollPane = new JBScrollPane((Component)this.myUpdateMessage, 20, 31);
            this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JEditorPane jEditorPane;
            JEditorPane jEditorPane2;
            JBLabel jBLabel;
            JBLabel jBLabel2;
            JBLabel jBLabel3;
            JBLabel jBLabel4;
            JPanel jPanel;
            this.createUIComponents();
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), null, 0, 0, null, null));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(10, 0, 10, 0), -1, -1, false, false));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            jPanel.add((Component)jPanel2, gridBagConstraints);
            JBLabel jBLabel5 = new JBLabel();
            this.$$$loadLabelText$$$((JLabel)jBLabel5, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.current.version"));
            jPanel2.add((Component)jBLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myCurrentVersion = jBLabel4 = new JBLabel();
            jBLabel4.setText("X.Y (build XXX.YYY)");
            jPanel2.add((Component)jBLabel4, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            JBLabel jBLabel6 = new JBLabel();
            this.$$$loadLabelText$$$((JLabel)jBLabel6, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.available.version"));
            jPanel2.add((Component)jBLabel6, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myNewVersion = jBLabel3 = new JBLabel();
            jBLabel3.setText("X.Y (build XXX.YYY)");
            jPanel2.add((Component)jBLabel3, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myPatchLabel = jBLabel2 = new JBLabel();
            this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.patch.label"));
            jPanel2.add((Component)jBLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myPatchInfo = jBLabel = new JBLabel();
            jBLabel.setText("XX MB");
            jPanel2.add((Component)jBLabel, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            JBScrollPane jBScrollPane = this.myScrollPane;
            jBScrollPane.setHorizontalScrollBarPolicy(31);
            jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 3, 0, 3, 2, 0, null, null, null));
            this.myMessageArea = jEditorPane2 = new JEditorPane();
            jEditorPane2.setContentType("text/html");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.fill = 1;
            jPanel.add((Component)jEditorPane2, gridBagConstraints2);
            JPanel jPanel3 = new JPanel();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 5;
            gridBagConstraints3.fill = 3;
            jPanel.add((Component)jPanel3, gridBagConstraints3);
            JPanel jPanel4 = new JPanel();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 3;
            gridBagConstraints4.fill = 3;
            gridBagConstraints4.insets = new Insets(5, 0, 0, 0);
            jPanel.add((Component)jPanel4, gridBagConstraints4);
            this.myLicenseArea = jEditorPane = new JEditorPane();
            jEditorPane.setContentType("text/html");
            jEditorPane.setEditable(false);
            jEditorPane.setOpaque(false);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 4;
            gridBagConstraints5.fill = 1;
            jPanel.add((Component)jEditorPane, gridBagConstraints5);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static class ButtonAction
    extends AbstractAction {
        private final String myUrl;

        private ButtonAction(ButtonInfo info) {
            super(info.getName());
            this.myUrl = info.getUrl();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BrowserUtil.browse((String)UpdateInfoDialog.augmentUrl(this.myUrl));
        }
    }
}

