/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedShowHistoryForRevisionAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        boolean visible = TabbedShowHistoryForRevisionAction.isVisible(e);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(visible && TabbedShowHistoryForRevisionAction.isEnabled(e));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        AbstractVcs vcs = (AbstractVcs)ObjectUtils.assertNotNull((Object)TabbedShowHistoryForRevisionAction.getVcs(project, (VcsKey)event.getData(VcsDataKeys.VCS)));
        Change change = ((Change[])event.getRequiredData(VcsDataKeys.SELECTED_CHANGES))[0];
        ContentRevision revision = (ContentRevision)ObjectUtils.assertNotNull((Object)TabbedShowHistoryForRevisionAction.getContentRevision(change));
        if (TabbedShowHistoryForRevisionAction.canShowNewFileHistory(project, revision.getFile())) {
            TabbedShowHistoryForRevisionAction.showNewFileHistory(project, revision.getFile(), revision.getRevisionNumber().asString());
        } else {
            VcsHistoryProviderEx vcsHistoryProvider = (VcsHistoryProviderEx)ObjectUtils.assertNotNull((Object)((VcsHistoryProviderEx)vcs.getVcsHistoryProvider()));
            AbstractVcsHelperImpl helper = (AbstractVcsHelperImpl)((Object)ObjectUtils.assertNotNull((Object)((Object)TabbedShowHistoryForRevisionAction.getVcsHelper(project))));
            helper.showFileHistory(vcsHistoryProvider, revision.getFile(), vcs, revision.getRevisionNumber());
        }
    }

    private static void showNewFileHistory(@NotNull Project project, @NotNull FilePath path, @NotNull String revisionNumber) {
        if (project == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(2);
        }
        if (path == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(3);
        }
        if (revisionNumber == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(4);
        }
        VcsLogFileHistoryProvider historyProvider = (VcsLogFileHistoryProvider)ServiceManager.getService(VcsLogFileHistoryProvider.class);
        historyProvider.showFileHistory(project, path, revisionNumber);
    }

    private static boolean canShowNewFileHistory(@NotNull Project project, @NotNull FilePath path) {
        VcsLogFileHistoryProvider historyProvider;
        if (project == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(5);
        }
        if (path == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(6);
        }
        return (historyProvider = (VcsLogFileHistoryProvider)ServiceManager.getService(VcsLogFileHistoryProvider.class)) != null && historyProvider.canShowFileHistory(project, path);
    }

    private static boolean isVisible(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(7);
        }
        if ((project = event.getProject()) == null) {
            return false;
        }
        if (TabbedShowHistoryForRevisionAction.getVcsHelper(project) == null) {
            return false;
        }
        AbstractVcs vcs = TabbedShowHistoryForRevisionAction.getVcs(project, (VcsKey)event.getData(VcsDataKeys.VCS));
        if (vcs == null) {
            return false;
        }
        VcsHistoryProvider vcsHistoryProvider = vcs.getVcsHistoryProvider();
        return vcsHistoryProvider instanceof VcsHistoryProviderEx;
    }

    private static boolean isEnabled(@NotNull AnActionEvent event) {
        Change[] changes;
        if (event == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(8);
        }
        if ((changes = (Change[])event.getData(VcsDataKeys.SELECTED_CHANGES)) == null || changes.length != 1) {
            return false;
        }
        return TabbedShowHistoryForRevisionAction.getContentRevision(changes[0]) != null;
    }

    @Nullable
    private static ContentRevision getContentRevision(@NotNull Change change) {
        if (change == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(9);
        }
        return change.getType() == Change.Type.DELETED ? change.getBeforeRevision() : change.getAfterRevision();
    }

    @Nullable
    private static AbstractVcs getVcs(@NotNull Project project, @Nullable VcsKey vcsKey) {
        if (project == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(10);
        }
        return vcsKey == null ? null : ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(vcsKey.getName());
    }

    @Nullable
    private static AbstractVcsHelperImpl getVcsHelper(@NotNull Project project) {
        if (project == null) {
            TabbedShowHistoryForRevisionAction.$$$reportNull$$$0(11);
        }
        AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)project);
        return (AbstractVcsHelperImpl)((Object)ObjectUtils.tryCast((Object)helper, AbstractVcsHelperImpl.class));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/TabbedShowHistoryForRevisionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showNewFileHistory";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "canShowNewFileHistory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisible";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getContentRevision";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getVcs";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getVcsHelper";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

