/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.ex.ThreeStateCheckboxAction;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.UnversionedViewDialog;
import com.intellij.openapi.vcs.changes.actions.MoveChangesToAnotherListAction;
import com.intellij.openapi.vcs.changes.actions.RollbackDialogAction;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedFilesNode;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.CommitDialogChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.EditSourceForDialogAction;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultipleLocalChangeListsBrowser
extends CommitDialogChangesBrowser
implements Disposable {
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    private final boolean myEnableUnversioned;
    @Nullable
    private JComponent myBottomDiffComponent;
    @NotNull
    private final ChangeListChooser myChangeListChooser;
    @NotNull
    private final DeleteProvider myDeleteProvider;
    private final List<Change> myChanges;
    private final List<VirtualFile> myUnversioned;
    private boolean myHasHiddenUnversioned;
    @NotNull
    private LocalChangeList myChangeList;
    @Nullable
    private Runnable mySelectedListChangeListener;

    public MultipleLocalChangeListsBrowser(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems, boolean enableUnversioned) {
        if (project == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(0);
        }
        super(project, showCheckboxes, highlightProblems);
        this.myUpdateQueue = new MergingUpdateQueue("MultipleLocalChangeListsBrowser", 300, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this);
        this.myDeleteProvider = new VirtualFileDeleteProvider();
        this.myChanges = new ArrayList<Change>();
        this.myUnversioned = new ArrayList<VirtualFile>();
        this.myEnableUnversioned = enableUnversioned;
        this.myChangeList = ChangeListManager.getInstance((Project)project).getDefaultChangeList();
        this.myChangeListChooser = new ChangeListChooser();
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)new MyChangeListListener(), (Disposable)this);
        this.init();
        this.updateDisplayedChangeLists();
        this.updateSelectedChangeList(this.myChangeList);
    }

    @Override
    @NotNull
    protected ChangesBrowserBase.ChangesBrowserTreeList createTreeList(@NotNull Project project, boolean showCheckboxes, boolean highlightProblems) {
        if (project == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(1);
        }
        MyChangesBrowserTreeList myChangesBrowserTreeList = new MyChangesBrowserTreeList(project, showCheckboxes, highlightProblems);
        if (myChangesBrowserTreeList == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(2);
        }
        return myChangesBrowserTreeList;
    }

    @Override
    @Nullable
    protected JComponent createHeaderPanel() {
        return this.myChangeListChooser;
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>(super.createToolbarActions());
        result2.add(ActionManager.getInstance().getAction("ChangesView.Refresh"));
        if (this.myEnableUnversioned) {
            result2.add((AnAction)new ShowHideUnversionedFilesAction());
            result2.add((AnAction)UnversionedViewDialog.getUnversionedActionGroup());
            UnversionedViewDialog.registerUnversionedActionsShortcuts((JComponent)((Object)this.myViewer));
        } else {
            result2.add(ActionManager.getInstance().getAction("ChangesView.Move"));
        }
        EmptyAction.registerWithShortcutSet((String)"ChangesView.Move", (ShortcutSet)CommonShortcuts.getMove(), (JComponent)((Object)this.myViewer));
        RollbackDialogAction rollbackAction = new RollbackDialogAction();
        rollbackAction.registerCustomShortcutSet(this, null);
        result2.add(rollbackAction);
        EditSourceForDialogAction editSourceAction = new EditSourceForDialogAction(this);
        editSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this);
        result2.add(editSourceAction);
        result2.add(ActionManager.getInstance().getAction("Vcs.CheckinProjectToolbar"));
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<AnAction> createDiffActions() {
        List list2 = ContainerUtil.append(super.createDiffActions(), (Object[])new AnAction[]{new ToggleChangeDiffAction(), new MoveChangeDiffAction()});
        if (list2 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    protected void updateDiffContext(@NotNull DiffRequestChain chain) {
        if (chain == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(5);
        }
        super.updateDiffContext(chain);
        chain.putUserData(DiffUserDataKeysEx.BOTTOM_PANEL, (Object)this.myBottomDiffComponent);
        chain.putUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, (Object)true);
    }

    public void setBottomDiffComponent(@NotNull JComponent value) {
        if (value == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(6);
        }
        this.myBottomDiffComponent = value;
    }

    public void setSelectedListChangeListener(@Nullable Runnable runnable2) {
        this.mySelectedListChangeListener = runnable2;
    }

    private boolean isShowUnversioned() {
        return this.myEnableUnversioned && VcsConfiguration.getInstance((Project)this.myProject).SHOW_UNVERSIONED_FILES_WHILE_COMMIT;
    }

    private void setShowUnversioned(boolean value) {
        VcsConfiguration.getInstance((Project)this.myProject).SHOW_UNVERSIONED_FILES_WHILE_COMMIT = value;
        this.updateDisplayedChanges();
    }

    @Override
    @NotNull
    public LocalChangeList getSelectedChangeList() {
        LocalChangeList localChangeList = this.myChangeList;
        if (localChangeList == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(7);
        }
        return localChangeList;
    }

    public void setSelectedChangeList(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(8);
        }
        this.myChangeListChooser.setSelectedChangeList(list2);
    }

    private void updateSelectedChangeList(@NotNull LocalChangeList list2) {
        boolean isListChanged;
        if (list2 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(9);
        }
        boolean bl = isListChanged = !this.myChangeList.getId().equals(list2.getId());
        if (isListChanged) {
            LineStatusTrackerManager.getInstanceImpl(this.myProject).resetExcludedFromCommitMarkers();
        }
        this.myChangeList = list2;
        this.myChangeListChooser.setToolTipText(list2.getName());
        this.updateDisplayedChanges();
        if (isListChanged && this.mySelectedListChangeListener != null) {
            this.mySelectedListChangeListener.run();
        }
        ((MyChangesBrowserTreeList)this.myViewer).updateExclusionStates();
    }

    @Override
    public void updateDisplayedChangeLists() {
        List changeLists = ChangeListManager.getInstance((Project)this.myProject).getChangeLists();
        this.myChangeListChooser.setAvailableLists(changeLists);
    }

    public void updateDisplayedChanges() {
        this.myChanges.clear();
        this.myUnversioned.clear();
        this.myHasHiddenUnversioned = false;
        this.myChanges.addAll(this.myChangeList.getChanges());
        if (this.myEnableUnversioned) {
            List<VirtualFile> unversioned = ChangeListManagerImpl.getInstanceImpl(this.myProject).getUnversionedFiles();
            if (this.isShowUnversioned()) {
                this.myUnversioned.addAll(unversioned);
            }
            if (!this.isShowUnversioned() && !unversioned.isEmpty()) {
                this.myHasHiddenUnversioned = true;
            }
        }
        this.myViewer.rebuildTree();
    }

    @Override
    @NotNull
    protected DefaultTreeModel buildTreeModel() {
        MyChangeNodeDecorator decorator = new MyChangeNodeDecorator();
        TreeModelBuilder builder = new TreeModelBuilder(this.myProject, this.getGrouping());
        builder.setChanges(this.myChanges, decorator);
        builder.setUnversioned(this.myUnversioned);
        if (this.myHasHiddenUnversioned) {
            this.myViewer.getEmptyText().setText("Unversioned files available. ").appendText("Show", SimpleTextAttributes.LINK_ATTRIBUTES, e -> this.setShowUnversioned(true));
        } else {
            this.myViewer.getEmptyText().setText(DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{0}));
        }
        DefaultTreeModel defaultTreeModel = builder.build();
        if (defaultTreeModel == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(10);
        }
        return defaultTreeModel;
    }

    @Override
    @Nullable
    protected ChangeDiffRequestChain.Producer getDiffRequestProducer(@NotNull Object entry) {
        if (entry == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(11);
        }
        if (entry instanceof VirtualFile) {
            return UnversionedDiffRequestProducer.create(this.myProject, (VirtualFile)entry);
        }
        return super.getDiffRequestProducer(entry);
    }

    @Override
    @Nullable
    public Object getData(String dataId) {
        if (ChangesListView.UNVERSIONED_FILES_DATA_KEY.is(dataId)) {
            return VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjectsStream(VirtualFile.class);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myDeleteProvider;
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            return new ChangeList[]{this.myChangeList};
        }
        return super.getData(dataId);
    }

    @Override
    @NotNull
    public List<Change> getDisplayedChanges() {
        List<Change> list2 = VcsTreeModelData.all((JTree)((Object)this.myViewer)).userObjects(Change.class);
        if (list2 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Change> getSelectedChanges() {
        List<Change> list2 = VcsTreeModelData.selected((JTree)((Object)this.myViewer)).userObjects(Change.class);
        if (list2 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Change> getIncludedChanges() {
        List<Change> list2 = VcsTreeModelData.included(this.myViewer).userObjects(Change.class);
        if (list2 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<VirtualFile> getDisplayedUnversionedFiles() {
        if (!this.isShowUnversioned()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(15);
            }
            return list2;
        }
        VcsTreeModelData treeModelData = VcsTreeModelData.allUnderTag((JTree)((Object)this.myViewer), ChangesBrowserNode.UNVERSIONED_FILES_TAG);
        if (MultipleLocalChangeListsBrowser.containsCollapsedUnversionedNode(treeModelData)) {
            List<VirtualFile> list3 = this.myUnversioned;
            if (list3 == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(16);
            }
            return list3;
        }
        List<VirtualFile> list4 = treeModelData.userObjects(VirtualFile.class);
        if (list4 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(17);
        }
        return list4;
    }

    @Override
    @NotNull
    public List<VirtualFile> getSelectedUnversionedFiles() {
        if (!this.isShowUnversioned()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(18);
            }
            return list2;
        }
        VcsTreeModelData treeModelData = VcsTreeModelData.selectedUnderTag((JTree)((Object)this.myViewer), ChangesBrowserNode.UNVERSIONED_FILES_TAG);
        if (MultipleLocalChangeListsBrowser.containsCollapsedUnversionedNode(treeModelData)) {
            List<VirtualFile> list3 = this.myUnversioned;
            if (list3 == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(19);
            }
            return list3;
        }
        List<VirtualFile> list4 = treeModelData.userObjects(VirtualFile.class);
        if (list4 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(20);
        }
        return list4;
    }

    @Override
    @NotNull
    public List<VirtualFile> getIncludedUnversionedFiles() {
        if (!this.isShowUnversioned()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(21);
            }
            return list2;
        }
        VcsTreeModelData treeModelData = VcsTreeModelData.includedUnderTag(this.myViewer, ChangesBrowserNode.UNVERSIONED_FILES_TAG);
        if (MultipleLocalChangeListsBrowser.containsCollapsedUnversionedNode(treeModelData)) {
            List<VirtualFile> list3 = this.myUnversioned;
            if (list3 == null) {
                MultipleLocalChangeListsBrowser.$$$reportNull$$$0(22);
            }
            return list3;
        }
        List<VirtualFile> list4 = treeModelData.userObjects(VirtualFile.class);
        if (list4 == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(23);
        }
        return list4;
    }

    private static boolean containsCollapsedUnversionedNode(@NotNull VcsTreeModelData treeModelData) {
        Optional<ChangesBrowserNode> node;
        if (treeModelData == null) {
            MultipleLocalChangeListsBrowser.$$$reportNull$$$0(24);
        }
        if (!(node = treeModelData.nodesStream().filter(it -> it instanceof ChangesBrowserUnversionedFilesNode).findAny()).isPresent()) {
            return false;
        }
        ChangesBrowserUnversionedFilesNode unversionedFilesNode = (ChangesBrowserUnversionedFilesNode)node.get();
        return unversionedFilesNode.isManyFiles();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chain";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModelData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChangeList";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTreeModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayedChanges";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedChanges";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayedUnversionedFiles";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUnversionedFiles";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedUnversionedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTreeList";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateDiffContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setBottomDiffComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedChangeList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedChangeList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDiffRequestProducer";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "containsCollapsedUnversionedNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyChangesBrowserTreeList
    extends ChangesBrowserBase.ChangesBrowserTreeList {
        private final Set<Object> myIncludedChanges;
        private final Map<Change, PartialLocalLineStatusTracker.ExclusionState> myTrackerExclusionStates;

        public MyChangesBrowserTreeList(Project project, boolean showCheckboxes, boolean highlightProblems) {
            if (project == null) {
                MyChangesBrowserTreeList.$$$reportNull$$$0(0);
            }
            super(MultipleLocalChangeListsBrowser.this, project, showCheckboxes, highlightProblems);
            this.myIncludedChanges = new THashSet();
            this.myTrackerExclusionStates = new HashMap<Change, PartialLocalLineStatusTracker.ExclusionState>();
            final PartialLocalLineStatusTracker.ListenerAdapter trackerListener = new PartialLocalLineStatusTracker.ListenerAdapter(){

                @Override
                public void onExcludedFromCommitChange(@NotNull PartialLocalLineStatusTracker tracker) {
                    if (tracker == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MyChangesBrowserTreeList.this.scheduleExclusionStatesUpdate();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$MyChangesBrowserTreeList$1", "onExcludedFromCommitChange"));
                }
            };
            LineStatusTrackerManager.ListenerAdapter trackerManagerListener = new LineStatusTrackerManager.ListenerAdapter(){

                @Override
                public void onTrackerAdded(@NotNull LineStatusTracker<?> tracker) {
                    if (tracker == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (tracker instanceof PartialLocalLineStatusTracker) {
                        PartialLocalLineStatusTracker partialTracker = (PartialLocalLineStatusTracker)tracker;
                        Change change = MyChangesBrowserTreeList.this.findChangeFor(tracker);
                        if (change != null) {
                            partialTracker.setExcludedFromCommit(!MyChangesBrowserTreeList.this.myIncludedChanges.contains(change));
                        }
                        partialTracker.addListener(trackerListener, MultipleLocalChangeListsBrowser.this);
                    }
                }

                @Override
                public void onTrackerRemoved(@NotNull LineStatusTracker<?> tracker) {
                    Change change;
                    if (tracker == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (tracker instanceof PartialLocalLineStatusTracker && (change = MyChangesBrowserTreeList.this.findChangeFor(tracker)) != null) {
                        MyChangesBrowserTreeList.this.myTrackerExclusionStates.remove(change);
                        PartialLocalLineStatusTracker.ExclusionState exclusionState = ((PartialLocalLineStatusTracker)tracker).getExcludedFromCommitState(MultipleLocalChangeListsBrowser.this.myChangeList.getId());
                        if (exclusionState != PartialLocalLineStatusTracker.ExclusionState.NO_CHANGES) {
                            if (exclusionState != PartialLocalLineStatusTracker.ExclusionState.ALL_EXCLUDED) {
                                MyChangesBrowserTreeList.this.myIncludedChanges.add(change);
                            } else {
                                MyChangesBrowserTreeList.this.myIncludedChanges.remove(change);
                            }
                        }
                        MyChangesBrowserTreeList.this.scheduleExclusionStatesUpdate();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "tracker";
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$MyChangesBrowserTreeList$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTrackerAdded";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTrackerRemoved";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            LineStatusTrackerManager.getInstanceImpl(project).addTrackerListener(trackerManagerListener, MultipleLocalChangeListsBrowser.this);
            for (LineStatusTracker<?> tracker : LineStatusTrackerManager.getInstanceImpl(project).getTrackers()) {
                if (!(tracker instanceof PartialLocalLineStatusTracker)) continue;
                ((PartialLocalLineStatusTracker)tracker).addListener(trackerListener, MultipleLocalChangeListsBrowser.this);
            }
        }

        @NotNull
        private ThreeStateCheckBox.State getUserObjectState(@NotNull Object change) {
            PartialLocalLineStatusTracker.ExclusionState exclusionState;
            if (change == null) {
                MyChangesBrowserTreeList.$$$reportNull$$$0(1);
            }
            if ((exclusionState = this.getExclusionState(change)) == PartialLocalLineStatusTracker.ExclusionState.ALL_INCLUDED) {
                ThreeStateCheckBox.State state = ThreeStateCheckBox.State.SELECTED;
                if (state == null) {
                    MyChangesBrowserTreeList.$$$reportNull$$$0(2);
                }
                return state;
            }
            if (exclusionState == PartialLocalLineStatusTracker.ExclusionState.ALL_EXCLUDED) {
                ThreeStateCheckBox.State state = ThreeStateCheckBox.State.NOT_SELECTED;
                if (state == null) {
                    MyChangesBrowserTreeList.$$$reportNull$$$0(3);
                }
                return state;
            }
            ThreeStateCheckBox.State state = ThreeStateCheckBox.State.DONT_CARE;
            if (state == null) {
                MyChangesBrowserTreeList.$$$reportNull$$$0(4);
            }
            return state;
        }

        @Override
        @NotNull
        protected ThreeStateCheckBox.State getNodeStatus(@NotNull ChangesBrowserNode<?> node) {
            if (node == null) {
                MyChangesBrowserTreeList.$$$reportNull$$$0(5);
            }
            boolean hasIncluded = false;
            boolean hasExcluded = false;
            for (Object change : VcsTreeModelData.children(node).userObjects()) {
                PartialLocalLineStatusTracker.ExclusionState exclusionState = this.getExclusionState(change);
                if (exclusionState == PartialLocalLineStatusTracker.ExclusionState.ALL_INCLUDED) {
                    hasIncluded = true;
                    continue;
                }
                if (exclusionState == PartialLocalLineStatusTracker.ExclusionState.ALL_EXCLUDED) {
                    hasExcluded = true;
                    continue;
                }
                hasIncluded = true;
                hasExcluded = true;
            }
            if (hasIncluded && hasExcluded) {
                ThreeStateCheckBox.State state = ThreeStateCheckBox.State.DONT_CARE;
                if (state == null) {
                    MyChangesBrowserTreeList.$$$reportNull$$$0(6);
                }
                return state;
            }
            if (hasIncluded) {
                ThreeStateCheckBox.State state = ThreeStateCheckBox.State.SELECTED;
                if (state == null) {
                    MyChangesBrowserTreeList.$$$reportNull$$$0(7);
                }
                return state;
            }
            ThreeStateCheckBox.State state = ThreeStateCheckBox.State.NOT_SELECTED;
            if (state == null) {
                MyChangesBrowserTreeList.$$$reportNull$$$0(8);
            }
            return state;
        }

        @Override
        public boolean isIncluded(Object change) {
            PartialLocalLineStatusTracker.ExclusionState trackerState = this.getExclusionState(change);
            return trackerState != PartialLocalLineStatusTracker.ExclusionState.ALL_EXCLUDED;
        }

        @Override
        @NotNull
        public Set<Object> getIncludedSet() {
            HashSet<Object> set2 = new HashSet<Object>(this.myIncludedChanges);
            for (Map.Entry<Change, PartialLocalLineStatusTracker.ExclusionState> entry : this.myTrackerExclusionStates.entrySet()) {
                Change change = entry.getKey();
                PartialLocalLineStatusTracker.ExclusionState trackerState = entry.getValue();
                if (trackerState == PartialLocalLineStatusTracker.ExclusionState.ALL_EXCLUDED) {
                    set2.remove(change);
                    continue;
                }
                set2.add(change);
            }
            HashSet<Object> hashSet = set2;
            if (hashSet == null) {
                MyChangesBrowserTreeList.$$$reportNull$$$0(9);
            }
            return hashSet;
        }

        @Override
        public void setIncludedChanges(@NotNull Collection<?> changes) {
            if (changes == null) {
                MyChangesBrowserTreeList.$$$reportNull$$$0(10);
            }
            HashSet set2 = new HashSet(changes);
            this.getTrackersStream().forEach(pair -> {
                Change change = (Change)pair.first;
                PartialLocalLineStatusTracker tracker = (PartialLocalLineStatusTracker)pair.second;
                tracker.setExcludedFromCommit(!set2.contains(change));
            });
            this.myIncludedChanges.clear();
            this.myIncludedChanges.addAll(changes);
            this.updateExclusionStates();
        }

        @Override
        public void includeChanges(Collection<?> changes) {
            for (Object change : changes) {
                PartialLocalLineStatusTracker tracker;
                if (!(change instanceof Change) || (tracker = PartialChangesUtil.getPartialTracker(this.myProject, (Change)change)) == null) continue;
                tracker.setExcludedFromCommit(false);
            }
            this.myIncludedChanges.addAll(changes);
            this.updateExclusionStates();
        }

        @Override
        public void excludeChanges(Collection<?> changes) {
            for (Object change : changes) {
                PartialLocalLineStatusTracker tracker;
                if (!(change instanceof Change) || (tracker = PartialChangesUtil.getPartialTracker(this.myProject, (Change)change)) == null) continue;
                tracker.setExcludedFromCommit(true);
            }
            this.myIncludedChanges.removeAll(changes);
            this.updateExclusionStates();
        }

        @Override
        protected void toggleChanges(Collection<?> changes) {
            boolean hasExcluded = false;
            for (Object value : changes) {
                PartialLocalLineStatusTracker.ExclusionState exclusionState = this.getExclusionState(value);
                if (exclusionState == PartialLocalLineStatusTracker.ExclusionState.ALL_INCLUDED) continue;
                hasExcluded = true;
                break;
            }
            if (hasExcluded) {
                this.includeChanges(changes);
            } else {
                this.excludeChanges(changes);
            }
        }

        @NotNull
        private PartialLocalLineStatusTracker.ExclusionState getExclusionState(@NotNull Object change) {
            PartialLocalLineStatusTracker.ExclusionState exclusionState;
            if (change == null) {
                MyChangesBrowserTreeList.$$$reportNull$$$0(11);
            }
            if ((exclusionState = this.myTrackerExclusionStates.get(change)) != null) {
                PartialLocalLineStatusTracker.ExclusionState exclusionState2 = exclusionState;
                if (exclusionState2 == null) {
                    MyChangesBrowserTreeList.$$$reportNull$$$0(12);
                }
                return exclusionState2;
            }
            PartialLocalLineStatusTracker.ExclusionState exclusionState3 = this.myIncludedChanges.contains(change) ? PartialLocalLineStatusTracker.ExclusionState.ALL_INCLUDED : PartialLocalLineStatusTracker.ExclusionState.ALL_EXCLUDED;
            if (exclusionState3 == null) {
                MyChangesBrowserTreeList.$$$reportNull$$$0(13);
            }
            return exclusionState3;
        }

        private void updateExclusionStates() {
            this.myTrackerExclusionStates.clear();
            this.getTrackersStream().forEach(pair -> {
                Change change = (Change)pair.first;
                PartialLocalLineStatusTracker tracker = (PartialLocalLineStatusTracker)pair.second;
                PartialLocalLineStatusTracker.ExclusionState state = tracker.getExcludedFromCommitState(MultipleLocalChangeListsBrowser.this.myChangeList.getId());
                if (state != PartialLocalLineStatusTracker.ExclusionState.NO_CHANGES) {
                    this.myTrackerExclusionStates.put(change, state);
                }
            });
            this.notifyInclusionListener();
            this.invalidateNodeSizes();
            this.repaint();
        }

        @Nullable
        private Change findChangeFor(@NotNull LineStatusTracker<?> tracker) {
            if (tracker == null) {
                MyChangesBrowserTreeList.$$$reportNull$$$0(14);
            }
            return VcsTreeModelData.all((JTree)((Object)this)).userObjectsStream(Change.class).filter(change -> {
                if (tracker == null) {
                    MyChangesBrowserTreeList.$$$reportNull$$$0(16);
                }
                return tracker.getVirtualFile().equals(PartialChangesUtil.getVirtualFile(change));
            }).findFirst().orElse(null);
        }

        @NotNull
        private Stream<Pair<Change, PartialLocalLineStatusTracker>> getTrackersStream() {
            Stream<Pair<Change, PartialLocalLineStatusTracker>> stream = VcsTreeModelData.all((JTree)((Object)this)).userObjectsStream(Change.class).map(change -> {
                PartialLocalLineStatusTracker tracker = PartialChangesUtil.getPartialTracker(this.myProject, change);
                if (tracker != null) {
                    return Pair.create((Object)change, (Object)tracker);
                }
                return null;
            }).filter(Objects::nonNull);
            if (stream == null) {
                MyChangesBrowserTreeList.$$$reportNull$$$0(15);
            }
            return stream;
        }

        private void scheduleExclusionStatesUpdate() {
            MultipleLocalChangeListsBrowser.this.myUpdateQueue.queue(new Update("updateExcludedFromCommit"){

                public void run() {
                    MyChangesBrowserTreeList.this.updateExclusionStates();
                }
            });
        }

        private void invalidateNodeSizes() {
            TreeUI ui = this.getUI();
            if (ui instanceof WideSelectionTreeUI) {
                ((WideSelectionTreeUI)ui).invalidateNodeSizes();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$MyChangesBrowserTreeList";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tracker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$MyChangesBrowserTreeList";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUserObjectState";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeStatus";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIncludedSet";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExclusionState";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTrackersStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserObjectState";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 15: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getNodeStatus";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setIncludedChanges";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getExclusionState";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "findChangeFor";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$findChangeFor$2";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        private MyChangeListListener() {
        }

        public void changeListsChanged() {
            MultipleLocalChangeListsBrowser.this.myUpdateQueue.queue(new Update("updateChangeLists"){

                public void run() {
                    MultipleLocalChangeListsBrowser.this.updateDisplayedChangeLists();
                }
            });
        }
    }

    private class ToggleChangeDiffAction
    extends ThreeStateCheckboxAction
    implements CustomComponentAction {
        public ToggleChangeDiffAction() {
            super(VcsBundle.message((String)"commit.dialog.include.action.name", (Object[])new Object[0]));
        }

        @NotNull
        public ThreeStateCheckBox.State isSelected(AnActionEvent e) {
            Object object = this.getUserObject(e);
            if (object == null) {
                ThreeStateCheckBox.State state = ThreeStateCheckBox.State.NOT_SELECTED;
                if (state == null) {
                    ToggleChangeDiffAction.$$$reportNull$$$0(0);
                }
                return state;
            }
            ThreeStateCheckBox.State state = ((MyChangesBrowserTreeList)MultipleLocalChangeListsBrowser.this.myViewer).getUserObjectState(object);
            if (state == null) {
                ToggleChangeDiffAction.$$$reportNull$$$0(1);
            }
            return state;
        }

        public void setSelected(AnActionEvent e, @NotNull ThreeStateCheckBox.State state) {
            Object object;
            if (state == null) {
                ToggleChangeDiffAction.$$$reportNull$$$0(2);
            }
            if ((object = this.getUserObject(e)) == null) {
                return;
            }
            if (state != ThreeStateCheckBox.State.NOT_SELECTED) {
                MultipleLocalChangeListsBrowser.this.myViewer.includeChange(object);
            } else {
                MultipleLocalChangeListsBrowser.this.myViewer.excludeChange(object);
            }
        }

        @Nullable
        private Object getUserObject(AnActionEvent e) {
            Object object = e.getData(VcsDataKeys.CURRENT_CHANGE);
            if (object == null) {
                object = e.getData(VcsDataKeys.CURRENT_UNVERSIONED);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$ToggleChangeDiffAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$ToggleChangeDiffAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MoveChangeDiffAction
    extends MoveChangesToAnotherListAction {
        private MoveChangeDiffAction() {
        }

        @Override
        protected boolean isEnabled(@NotNull AnActionEvent e) {
            if (e == null) {
                MoveChangeDiffAction.$$$reportNull$$$0(0);
            }
            return e.getData(VcsDataKeys.CURRENT_CHANGE) != null || e.getData(VcsDataKeys.CURRENT_UNVERSIONED) != null;
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MoveChangeDiffAction.$$$reportNull$$$0(1);
            }
            Change change = (Change)e.getData(VcsDataKeys.CURRENT_CHANGE);
            VirtualFile file2 = (VirtualFile)e.getData(VcsDataKeys.CURRENT_UNVERSIONED);
            List<Change> changes = change == null ? Collections.emptyList() : Collections.singletonList(change);
            List<VirtualFile> unversionedFiles = file2 == null ? Collections.emptyList() : Collections.singletonList(file2);
            MoveChangeDiffAction.askAndMove(MultipleLocalChangeListsBrowser.this.myProject, changes, unversionedFiles);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$MoveChangeDiffAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowHideUnversionedFilesAction
    extends ToggleAction
    implements DumbAware {
        private ShowHideUnversionedFilesAction() {
            super("Show Unversioned Files", null, AllIcons.Vcs.ShowUnversionedFiles);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowHideUnversionedFilesAction.$$$reportNull$$$0(0);
            }
            return MultipleLocalChangeListsBrowser.this.isShowUnversioned();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ShowHideUnversionedFilesAction.$$$reportNull$$$0(1);
            }
            MultipleLocalChangeListsBrowser.this.setShowUnversioned(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$ShowHideUnversionedFilesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ChangeListChooser
    extends JPanel {
        private static final int MAX_NAME_LEN = 35;
        @NotNull
        private final ComboBox<LocalChangeList> myChooser = new ComboBox();

        public ChangeListChooser() {
            this.myChooser.setEditable(false);
            this.myChooser.setRenderer((ListCellRenderer)new ColoredListCellRenderer<LocalChangeList>(){

                protected void customizeCellRenderer(@NotNull JList<? extends LocalChangeList> list2, LocalChangeList value, int index, boolean selected, boolean hasFocus) {
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String name = StringUtil.shortenTextWithEllipsis((String)value.getName().trim(), (int)35, (int)0);
                    this.append(name, value.isDefault() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$ChangeListChooser$1", "customizeCellRenderer"));
                }
            });
            this.myChooser.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    LocalChangeList changeList;
                    if (e.getStateChange() == 1 && (changeList = (LocalChangeList)ChangeListChooser.this.myChooser.getSelectedItem()) != null) {
                        MultipleLocalChangeListsBrowser.this.updateSelectedChangeList(changeList);
                    }
                }
            });
            this.setLayout(new BorderLayout(4, 2));
            JLabel label = new JLabel(VcsBundle.message((String)"commit.dialog.changelist.label", (Object[])new Object[0]));
            label.setLabelFor((Component)this.myChooser);
            this.add((Component)label, "West");
            this.add((Component)this.myChooser, "Center");
        }

        public void setAvailableLists(@NotNull List<LocalChangeList> lists) {
            LocalChangeList currentList;
            if (lists == null) {
                ChangeListChooser.$$$reportNull$$$0(0);
            }
            if ((currentList = (LocalChangeList)ContainerUtil.find(lists, (Object)MultipleLocalChangeListsBrowser.this.getSelectedChangeList())) == null) {
                currentList = lists.get(0);
            }
            this.myChooser.setModel((ComboBoxModel)new CollectionComboBoxModel(lists, (Object)currentList));
            this.myChooser.setEnabled(lists.size() > 1);
            MultipleLocalChangeListsBrowser.this.updateSelectedChangeList(currentList);
        }

        public void setSelectedChangeList(@NotNull LocalChangeList list2) {
            if (list2 == null) {
                ChangeListChooser.$$$reportNull$$$0(1);
            }
            ComboBoxModel model = this.myChooser.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                LocalChangeList element = (LocalChangeList)model.getElementAt(i);
                if (!element.getName().equals(list2.getName())) continue;
                this.myChooser.setSelectedIndex(i);
                MultipleLocalChangeListsBrowser.this.updateSelectedChangeList(element);
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lists";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/MultipleLocalChangeListsBrowser$ChangeListChooser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setAvailableLists";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelectedChangeList";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyChangeNodeDecorator
    implements ChangeNodeDecorator {
        private final ChangeNodeDecorator myRemoteRevisionsDecorator;

        private MyChangeNodeDecorator() {
            this.myRemoteRevisionsDecorator = RemoteRevisionsCache.getInstance(MultipleLocalChangeListsBrowser.this.myProject).getChangesNodeDecorator();
        }

        @Override
        public void decorate(Change change, SimpleColoredComponent renderer, boolean isShowFlatten) {
            int rangesToCommit;
            List ranges;
            PartialLocalLineStatusTracker tracker = PartialChangesUtil.getPartialTracker(MultipleLocalChangeListsBrowser.this.myProject, change);
            if (tracker != null && (ranges = tracker.getRanges()) != null && (rangesToCommit = ContainerUtil.count(ranges, it -> it.getChangelistId().equals(MultipleLocalChangeListsBrowser.this.myChangeList.getId()) && !it.isExcludedFromCommit())) != 0 && rangesToCommit != ranges.size()) {
                renderer.append(String.format(FontUtil.spaceAndThinSpace() + "%s of %s changes", rangesToCommit, ranges.size()), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            }
            this.myRemoteRevisionsDecorator.decorate(change, renderer, isShowFlatten);
        }

        @Override
        public void preDecorate(Change change, ChangesBrowserNodeRenderer renderer, boolean isShowFlatten) {
            this.myRemoteRevisionsDecorator.preDecorate(change, renderer, isShowFlatten);
        }
    }
}

