/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ContentRevisionVirtualFile
extends AbstractVcsVirtualFile {
    @NotNull
    private final ContentRevision myContentRevision;
    private byte[] myContent;
    private boolean myContentLoadFailed;
    private static final Map<ContentRevision, ContentRevisionVirtualFile> ourMap = ContainerUtil.createWeakMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentRevisionVirtualFile create(@NotNull ContentRevision contentRevision) {
        if (contentRevision == null) {
            ContentRevisionVirtualFile.$$$reportNull$$$0(0);
        }
        Map<ContentRevision, ContentRevisionVirtualFile> map = ourMap;
        synchronized (map) {
            ContentRevisionVirtualFile revisionVirtualFile = ourMap.get(contentRevision);
            if (revisionVirtualFile == null) {
                revisionVirtualFile = new ContentRevisionVirtualFile(contentRevision);
                ourMap.put(contentRevision, revisionVirtualFile);
            }
            return revisionVirtualFile;
        }
    }

    private ContentRevisionVirtualFile(@NotNull ContentRevision contentRevision) {
        if (contentRevision == null) {
            ContentRevisionVirtualFile.$$$reportNull$$$0(1);
        }
        super(contentRevision.getFile().getPath(), (VirtualFileSystem)VcsFileSystem.getInstance());
        this.myContentRevision = contentRevision;
        this.setCharset(CharsetToolkit.UTF8_CHARSET);
    }

    public boolean isDirectory() {
        return false;
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() {
        if (this.myContentLoadFailed || this.myProcessingBeforeContentsChange) {
            if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
                ContentRevisionVirtualFile.$$$reportNull$$$0(2);
            }
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        if (this.myContent == null) {
            this.loadContent();
        }
        if (this.myContent == null) {
            ContentRevisionVirtualFile.$$$reportNull$$$0(3);
        }
        return this.myContent;
    }

    private void loadContent() {
        final VcsFileSystem vcsFileSystem = (VcsFileSystem)this.getFileSystem();
        try {
            byte[] bytes = null;
            if (this.myContentRevision instanceof ByteBackedContentRevision) {
                bytes = ((ByteBackedContentRevision)this.myContentRevision).getContentAsBytes();
            } else {
                String content = this.myContentRevision.getContent();
                byte[] byArray = bytes = content != null ? content.getBytes(this.getCharset()) : null;
            }
            if (bytes == null) {
                throw new VcsException("Could not load content");
            }
            this.fireBeforeContentsChange();
            this.myContent = bytes;
            ++this.myModificationStamp;
            this.setRevision(this.myContentRevision.getRevisionNumber().asString());
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    vcsFileSystem.fireContentsChanged(this, ContentRevisionVirtualFile.this, 0L);
                }
            });
        }
        catch (VcsException e) {
            this.myContentLoadFailed = true;
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    vcsFileSystem.fireBeforeFileDeletion(this, ContentRevisionVirtualFile.this);
                }
            });
            this.myContent = ArrayUtil.EMPTY_BYTE_ARRAY;
            this.setRevision("0");
            Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.could.not.load.virtual.file.content", (Object[])new Object[]{this.getPresentableUrl(), e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.could.not.load.content", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    vcsFileSystem.fireFileDeleted(this, ContentRevisionVirtualFile.this, ContentRevisionVirtualFile.this.getName(), ContentRevisionVirtualFile.this.getParent());
                }
            });
        }
        catch (ProcessCanceledException ex) {
            this.myContent = ArrayUtil.EMPTY_BYTE_ARRAY;
        }
    }

    @NotNull
    public ContentRevision getContentRevision() {
        ContentRevision contentRevision = this.myContentRevision;
        if (contentRevision == null) {
            ContentRevisionVirtualFile.$$$reportNull$$$0(4);
        }
        return contentRevision;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRevision";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/vfs/ContentRevisionVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/vfs/ContentRevisionVirtualFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

