/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.win32.Win32LocalFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FileLoadingTracker;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.UserDataInterner;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.impl.PsiCachedValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualDirectoryImpl
extends VirtualFileSystemEntry {
    private static final Logger LOG = Logger.getInstance(VirtualDirectoryImpl.class);
    private static final boolean CHECK = ApplicationManager.getApplication().isUnitTestMode();
    private static final VirtualDirectoryImpl NULL_VIRTUAL_FILE = new VirtualDirectoryImpl(-42, new VfsData.Segment(), new VfsData.DirectoryData(), null, (NewVirtualFileSystem)LocalFileSystem.getInstance()){

        @Override
        public String toString() {
            return "NULL";
        }
    };
    private final VfsData.DirectoryData myData;
    private final NewVirtualFileSystem myFs;

    public VirtualDirectoryImpl(int id, @NotNull VfsData.Segment segment, @NotNull VfsData.DirectoryData data, @Nullable VirtualDirectoryImpl parent, @NotNull NewVirtualFileSystem fs) {
        if (segment == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(0);
        }
        if (data == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(1);
        }
        if (fs == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(2);
        }
        super(id, segment, parent);
        this.myData = data;
        this.myFs = fs;
    }

    @NotNull
    public NewVirtualFileSystem getFileSystem() {
        NewVirtualFileSystem newVirtualFileSystem = this.myFs;
        if (newVirtualFileSystem == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(3);
        }
        return newVirtualFileSystem;
    }

    @Nullable
    private VirtualFileSystemEntry findChild(@NotNull String name, boolean doRefresh, boolean ensureCanonicalName, @NotNull NewVirtualFileSystem delegate) {
        boolean caseSensitive;
        VirtualFileSystemEntry result2;
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(4);
        }
        if (delegate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(5);
        }
        if ((result2 = this.doFindChild(name, ensureCanonicalName, delegate, caseSensitive = delegate.isCaseSensitive())) == NULL_VIRTUAL_FILE) {
            result2 = doRefresh ? this.createAndFindChildWithEventFire(name, delegate) : null;
        } else if (result2 != null && doRefresh && delegate.isDirectory((VirtualFile)result2) != result2.isDirectory()) {
            RefreshQueue.getInstance().refresh(false, false, null, new VirtualFile[]{result2});
            result2 = this.findChild(name, false, ensureCanonicalName, delegate);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VirtualFileSystemEntry doFindChildInArray(@NotNull String name, boolean caseSensitive) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(6);
        }
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            if (this.myData.isAdoptedName(name)) {
                return NULL_VIRTUAL_FILE;
            }
            int[] array = this.myData.myChildrenIds;
            int indexInReal = VirtualDirectoryImpl.findIndex(array, name, caseSensitive);
            if (indexInReal >= 0) {
                return VfsData.getFileById(array[indexInReal], this);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private VirtualFileSystemEntry doFindChild(@NotNull String name, boolean ensureCanonicalName, @NotNull NewVirtualFileSystem delegate, boolean caseSensitive) {
        VirtualFileSystemEntry child;
        FakeVirtualFile fake;
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(7);
        }
        if (delegate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(8);
        }
        if (name.isEmpty()) {
            return null;
        }
        if (!this.isValid()) {
            throw new InvalidVirtualFileAccessException((VirtualFile)this);
        }
        VirtualFileSystemEntry found = this.doFindChildInArray(name, caseSensitive);
        if (found != null) {
            return found;
        }
        if (ensureCanonicalName) {
            String trimmedName = VirtualDirectoryImpl.deSlash(name);
            if (trimmedName == null) {
                return null;
            }
            if (!trimmedName.equals(name)) {
                found = this.doFindChildInArray(trimmedName, caseSensitive);
                if (found != null) {
                    return found;
                }
                name = trimmedName;
            }
        }
        if (this.allChildrenLoaded()) {
            return NULL_VIRTUAL_FILE;
        }
        if (ensureCanonicalName && (name = delegate.getCanonicallyCasedName((VirtualFile)(fake = new FakeVirtualFile((VirtualFile)this, name)))).isEmpty()) {
            return null;
        }
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            if (this.myData.isAdoptedName(name)) {
                return NULL_VIRTUAL_FILE;
            }
            int[] array = this.myData.myChildrenIds;
            int index = VirtualDirectoryImpl.findIndex(array, name, caseSensitive);
            if (index >= 0) {
                return VfsData.getFileById(array[index], this);
            }
            if (this.allChildrenLoaded()) {
                return null;
            }
            int id = ourPersistence.getId((VirtualFile)this, name, delegate);
            if (id <= 0) {
                this.myData.addAdoptedName(name, caseSensitive);
                return null;
            }
            child = this.createChild(FileNameCache.storeName(name), id, delegate);
            this.insertChildAt(child, index);
            ((PersistentFSImpl)ourPersistence).incStructuralModificationCount();
            this.assertConsistency(caseSensitive, name);
        }
        if (!child.isDirectory()) {
            VfsRootAccess.assertAccessInTests(child, this.getFileSystem());
        }
        return child;
    }

    private static String deSlash(@NotNull String name) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(9);
        }
        int startTrimmed = -1;
        int endTrimmed = -1;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (startTrimmed == -1) {
                if (VirtualDirectoryImpl.isFileSeparator(c)) continue;
                startTrimmed = i;
                continue;
            }
            if (endTrimmed == -1) {
                if (!VirtualDirectoryImpl.isFileSeparator(c)) continue;
                endTrimmed = i;
                continue;
            }
            if (VirtualDirectoryImpl.isFileSeparator(c)) continue;
            return null;
        }
        if (startTrimmed == -1) {
            return null;
        }
        if (endTrimmed == -1) {
            return name.substring(startTrimmed);
        }
        if (startTrimmed == endTrimmed) {
            return null;
        }
        return name.substring(startTrimmed, endTrimmed);
    }

    private static boolean isFileSeparator(char c) {
        return c == '/' || c == '\\';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private VirtualFileSystemEntry[] getArraySafely() {
        VfsData.DirectoryData directoryData = this.myData;
        // MONITORENTER : directoryData
        VirtualFileSystemEntry[] virtualFileSystemEntryArray = this.myData.getFileChildren(this.myId, this);
        // MONITOREXIT : directoryData
        if (virtualFileSystemEntryArray != null) return virtualFileSystemEntryArray;
        VirtualDirectoryImpl.$$$reportNull$$$0(10);
        return virtualFileSystemEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public VirtualFileSystemEntry createChild(@NotNull String name, int id, @NotNull NewVirtualFileSystem delegate) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(11);
        }
        if (delegate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(12);
        }
        VfsData.DirectoryData directoryData = this.myData;
        // MONITORENTER : directoryData
        VirtualFileSystemEntry virtualFileSystemEntry = this.createChild(FileNameCache.storeName(name), id, delegate);
        // MONITOREXIT : directoryData
        if (virtualFileSystemEntry != null) return virtualFileSystemEntry;
        VirtualDirectoryImpl.$$$reportNull$$$0(13);
        return virtualFileSystemEntry;
    }

    @NotNull
    private VirtualFileSystemEntry createChild(int nameId, int id, @NotNull NewVirtualFileSystem delegate) {
        if (delegate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(14);
        }
        FileLoadingTracker.fileLoaded(this, nameId);
        int attributes = ourPersistence.getFileAttributes(id);
        VfsData.Segment segment = VfsData.getSegment(id, true);
        try {
            VfsData.initFile(id, segment, nameId, PersistentFS.isDirectory(attributes) ? new VfsData.DirectoryData() : KeyFMap.EMPTY_MAP);
        }
        catch (VfsData.FileAlreadyCreatedException e) {
            throw new RuntimeException("dir=" + this.myId + "; dir.children=" + Arrays.toString(FSRecords.listAll(this.myId)), e);
        }
        LOG.assertTrue(!(this.getFileSystem() instanceof Win32LocalFileSystem));
        VirtualFileSystemEntry child = VfsData.getFileById(id, this);
        assert (child != null);
        segment.setFlag(id, 0x20000000, PersistentFS.isSymLink(attributes));
        segment.setFlag(id, Integer.MIN_VALUE, PersistentFS.isSpecialFile(attributes));
        segment.setFlag(id, 0x1000000, PersistentFS.isWritable(attributes));
        segment.setFlag(id, 0x2000000, PersistentFS.isHidden(attributes));
        child.updateLinkStatus();
        if (delegate.markNewFilesAsDirty()) {
            child.markDirty();
        }
        VirtualFileSystemEntry virtualFileSystemEntry = child;
        if (virtualFileSystemEntry == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(15);
        }
        return virtualFileSystemEntry;
    }

    @Nullable
    private VirtualFileSystemEntry createAndFindChildWithEventFire(@NotNull String name, @NotNull NewVirtualFileSystem delegate) {
        FakeVirtualFile fake;
        FileAttributes attributes;
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(16);
        }
        if (delegate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(17);
        }
        if ((attributes = delegate.getAttributes((VirtualFile)(fake = new FakeVirtualFile((VirtualFile)this, name)))) == null) {
            return null;
        }
        String realName = delegate.getCanonicallyCasedName((VirtualFile)fake);
        VFileCreateEvent event = new VFileCreateEvent(null, (VirtualFile)this, realName, attributes.isDirectory(), true);
        RefreshQueue.getInstance().processSingleEvent((VFileEvent)event);
        return this.findChild(realName);
    }

    @Nullable
    public NewVirtualFile refreshAndFindChild(@NotNull String name) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(18);
        }
        return this.findChild(name, true, true, this.getFileSystem());
    }

    @Nullable
    public NewVirtualFile findChildIfCached(@NotNull String name) {
        boolean caseSensitive;
        VirtualFileSystemEntry found;
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(19);
        }
        return (found = this.doFindChildInArray(name, caseSensitive = this.getFileSystem().isCaseSensitive())) == NULL_VIRTUAL_FILE ? null : found;
    }

    @NotNull
    public Iterable<VirtualFile> iterInDbChildren() {
        if (!ourPersistence.wereChildrenAccessed((VirtualFile)this)) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(20);
            }
            return list2;
        }
        if (ourPersistence.areChildrenLoaded((VirtualFile)this)) {
            List<VirtualFile> list3 = Arrays.asList(this.getChildren());
            if (list3 == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(21);
            }
            return list3;
        }
        String[] names = ourPersistence.listPersisted((VirtualFile)this);
        NewVirtualFileSystem delegate = PersistentFS.replaceWithNativeFS(this.getFileSystem());
        for (String name : names) {
            this.findChild(name, false, false, delegate);
        }
        Collection collection = this.getCachedChildren();
        if (collection == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(22);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public VirtualFile[] getChildren() {
        int[] result2;
        if (!this.isValid()) {
            throw new InvalidVirtualFileAccessException((VirtualFile)this);
        }
        NewVirtualFileSystem delegate = this.getFileSystem();
        boolean caseSensitive = delegate.isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        // MONITORENTER : directoryData
        if (this.allChildrenLoaded()) {
            this.assertConsistency(caseSensitive, "");
            VirtualFileSystemEntry[] virtualFileSystemEntryArray = this.getArraySafely();
            // MONITOREXIT : directoryData
            if (virtualFileSystemEntryArray != null) return virtualFileSystemEntryArray;
            VirtualDirectoryImpl.$$$reportNull$$$0(23);
            return virtualFileSystemEntryArray;
        }
        boolean wasChildrenLoaded = ourPersistence.areChildrenLoaded((VirtualFile)this);
        FSRecords.NameId[] childrenIds = ourPersistence.listAll((VirtualFile)this);
        if (childrenIds.length == 0) {
            result2 = ArrayUtil.EMPTY_INT_ARRAY;
        } else {
            Arrays.sort(childrenIds, (o1, o2) -> {
                CharSequence name1 = o1.name;
                CharSequence name2 = o2.name;
                int cmp = VirtualDirectoryImpl.compareNames(name1, name2, caseSensitive);
                if (cmp == 0 && name1 != name2) {
                    LOG.error((Object)((Object)ourPersistence) + " returned duplicate file names(" + name1 + "," + name2 + ") caseSensitive: " + caseSensitive + " SystemInfo.isFileSystemCaseSensitive: " + SystemInfo.isFileSystemCaseSensitive + " SystemInfo.OS: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + " wasChildrenLoaded: " + wasChildrenLoaded + " in the dir: " + (Object)((Object)this) + "; children: " + Arrays.toString(childrenIds));
                }
                return cmp;
            });
            TIntHashSet prevChildren = new TIntHashSet(this.myData.myChildrenIds);
            result2 = new int[childrenIds.length];
            for (int i = 0; i < childrenIds.length; ++i) {
                FSRecords.NameId child = childrenIds[i];
                result2[i] = child.id;
                assert (child.id > 0) : child;
                prevChildren.remove(child.id);
                if (VfsData.getFileById(child.id, this) != null) continue;
                this.createChild(child.nameId, child.id, delegate);
            }
            if (!prevChildren.isEmpty()) {
                LOG.error("Loaded child disappeared: parent=" + VirtualDirectoryImpl.verboseToString(this) + "; child=" + VirtualDirectoryImpl.verboseToString(VfsData.getFileById(prevChildren.toArray()[0], this)));
            }
        }
        if (this.getId() > 0) {
            this.myData.myChildrenIds = result2;
            this.setChildrenLoaded();
            if (CHECK) {
                this.assertConsistency(caseSensitive, Arrays.asList(childrenIds));
            }
        }
        VirtualFileSystemEntry[] virtualFileSystemEntryArray = this.getArraySafely();
        // MONITOREXIT : directoryData
        if (virtualFileSystemEntryArray != null) return virtualFileSystemEntryArray;
        VirtualDirectoryImpl.$$$reportNull$$$0(24);
        return virtualFileSystemEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertConsistency(boolean caseSensitive, @NotNull Object details) {
        if (details == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(25);
        }
        if (!CHECK || ApplicationInfoImpl.isInStressTest()) {
            return;
        }
        int[] childrenIds = this.myData.myChildrenIds;
        for (int i = 1; i < childrenIds.length; ++i) {
            CharSequence prevName;
            int id = childrenIds[i];
            int prev2 = childrenIds[i - 1];
            CharSequence name = VfsData.getNameByFileId(id);
            int cmp = VirtualDirectoryImpl.compareNames(name, prevName = VfsData.getNameByFileId(prev2), caseSensitive);
            if (cmp <= 0) {
                VirtualDirectoryImpl.error(VirtualDirectoryImpl.verboseToString(VfsData.getFileById(prev2, this)) + " is wrongly placed before " + VirtualDirectoryImpl.verboseToString(VfsData.getFileById(id, this)), this.getArraySafely(), details);
            }
            if (!this.myData.isAdoptedName(name)) continue;
            try {
                VirtualDirectoryImpl.error("In " + VirtualDirectoryImpl.verboseToString(this) + " file '" + name + "' is both child and adopted", this.getArraySafely(), "Adopted: " + this.myData.getAdoptedNames() + ";\n " + details);
                continue;
            }
            finally {
                this.myData.removeAdoptedName(name);
            }
        }
    }

    @NotNull
    private static String verboseToString(VirtualFileSystemEntry file2) {
        if (file2 == null) {
            if ("null" == null) {
                VirtualDirectoryImpl.$$$reportNull$$$0(26);
            }
            return "null";
        }
        String string = (Object)((Object)file2) + " (name: '" + file2.getName() + "', " + ((Object)((Object)file2)).getClass() + ", parent: " + (Object)((Object)file2.getParent()) + "; id: " + file2.getId() + "; FS: " + file2.getFileSystem() + "; delegate.attrs: " + file2.getFileSystem().getAttributes((VirtualFile)file2) + "; caseSensitive: " + file2.getFileSystem().isCaseSensitive() + "; canonical: " + file2.getFileSystem().getCanonicallyCasedName((VirtualFile)file2) + ") ";
        if (string == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(27);
        }
        return string;
    }

    private static void error(String message, VirtualFileSystemEntry[] array, Object ... details) {
        String children2 = StringUtil.join((Object[])array, VirtualDirectoryImpl::verboseToString, (String)"\n");
        String detailsStr = StringUtil.join((Iterable)ContainerUtil.map((Object[])details, o -> o instanceof Object[] ? Arrays.toString((Object[])o) : o), (String)"\n");
        throw new AssertionError((Object)(message + "; children: " + children2 + "\nDetails: " + detailsStr));
    }

    @Nullable
    public VirtualFileSystemEntry findChild(@NotNull String name) {
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(28);
        }
        return this.findChild(name, false, true, this.getFileSystem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualFileSystemEntry findChildById(int id, boolean cachedOnly) {
        int i;
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            i = ArrayUtil.indexOf((int[])this.myData.myChildrenIds, (int)id);
        }
        if (i >= 0) {
            return VfsData.getFileById(id, this);
        }
        if (cachedOnly) {
            return null;
        }
        String name = ourPersistence.getName(id);
        return this.findChild(name, false, false, this.getFileSystem());
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        throw new IOException("Cannot get content of directory: " + (Object)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAndAddChildren(@NotNull List<FSRecords.NameId> added) {
        if (added == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(29);
        }
        if (added.size() <= 1) {
            for (FSRecords.NameId pair2 : added) {
                VirtualFileSystemEntry file2 = this.createChild(pair2.name.toString(), pair2.id, this.getFileSystem());
                this.addChild(file2);
            }
            return;
        }
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        Comparator pairComparator = (p1, p2) -> VirtualDirectoryImpl.compareNames(p1.name, p2.name, caseSensitive);
        added.sort(pairComparator);
        TIntArrayList mergedIds = new TIntArrayList(this.myData.myChildrenIds.length + added.size());
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            for (FSRecords.NameId pair3 : added) {
                this.myData.removeAdoptedName(pair3.name);
                this.createChild(pair3.name.toString(), pair3.id, this.getFileSystem());
            }
            ContainerUtil.processSortedListsInOrder(added, (List)new AbstractList<FSRecords.NameId>(){

                @Override
                public FSRecords.NameId get(int index) {
                    int id = ((VirtualDirectoryImpl)VirtualDirectoryImpl.this).myData.myChildrenIds[index];
                    CharSequence name = (CharSequence)ObjectUtils.assertNotNull((Object)VfsData.getNameByFileId(id));
                    return new FSRecords.NameId(id, -1, name);
                }

                @Override
                public int size() {
                    return ((VirtualDirectoryImpl)VirtualDirectoryImpl.this).myData.myChildrenIds.length;
                }
            }, (Comparator)pairComparator, (boolean)true, pair -> mergedIds.add(pair.id));
            this.myData.myChildrenIds = mergedIds.toNativeArray();
            this.assertConsistency(caseSensitive, added);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(@NotNull VirtualFileSystemEntry child) {
        if (child == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(30);
        }
        String childName = child.getName();
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            this.myData.removeAdoptedName(childName);
            int indexInReal = VirtualDirectoryImpl.findIndex(this.myData.myChildrenIds, childName, caseSensitive);
            if (indexInReal < 0) {
                this.insertChildAt(child, indexInReal);
            }
            this.assertConsistency(caseSensitive, (Object)child);
        }
    }

    private void insertChildAt(@NotNull VirtualFileSystemEntry file2, int negativeIndex) {
        if (file2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(31);
        }
        int[] array = this.myData.myChildrenIds;
        int[] appended = new int[array.length + 1];
        int i = -negativeIndex - 1;
        System.arraycopy(array, 0, appended, 0, i);
        appended[i] = file2.getId();
        assert (appended[i] > 0) : file2;
        System.arraycopy(array, i, appended, i + 1, array.length - i);
        this.myData.myChildrenIds = appended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(32);
        }
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        String name = file2.getName();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            int indexInReal = VirtualDirectoryImpl.findIndex(this.myData.myChildrenIds, name, caseSensitive);
            if (indexInReal >= 0) {
                this.myData.myChildrenIds = ArrayUtil.remove((int[])this.myData.myChildrenIds, (int)indexInReal);
            }
            if (!this.allChildrenLoaded()) {
                this.myData.addAdoptedName(name, caseSensitive);
            }
            this.assertConsistency(caseSensitive, file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildren(@NotNull TIntHashSet idsToRemove, @NotNull List<CharSequence> namesToRemove) {
        if (idsToRemove == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(33);
        }
        if (namesToRemove == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(34);
        }
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            int[] newIds = new int[this.myData.myChildrenIds.length];
            int[] oldIds = this.myData.myChildrenIds;
            int o = 0;
            for (int oldId : oldIds) {
                if (idsToRemove.contains(oldId)) continue;
                newIds[o++] = oldId;
            }
            if (o != newIds.length) {
                newIds = o == 0 ? ArrayUtil.EMPTY_INT_ARRAY : Arrays.copyOf(newIds, o);
            }
            this.myData.myChildrenIds = newIds;
            if (!this.allChildrenLoaded()) {
                this.myData.addAdoptedNames(namesToRemove, caseSensitive);
            }
            this.assertConsistency(caseSensitive, namesToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateChildrenToCreate(@NotNull List<VFileCreateEvent> childrenToCreate) {
        if (childrenToCreate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(35);
        }
        if (childrenToCreate.size() <= 1) {
            for (int i = childrenToCreate.size() - 1; i >= 0; --i) {
                VFileCreateEvent event = childrenToCreate.get(i);
                if (event.isValid()) continue;
                childrenToCreate.remove(i);
            }
            return;
        }
        boolean caseSensitive = this.getFileSystem().isCaseSensitive();
        VfsData.DirectoryData directoryData = this.myData;
        synchronized (directoryData) {
            THashSet existingNames = new THashSet(this.myData.myChildrenIds.length, (TObjectHashingStrategy)(caseSensitive ? CharSequenceHashingStrategy.CASE_SENSITIVE : CharSequenceHashingStrategy.CASE_INSENSITIVE));
            for (int id : this.myData.myChildrenIds) {
                existingNames.add(VfsData.getNameByFileId(id));
            }
            int id = this.getId();
            if (id >= 0) {
                FSRecords.NameId[] persistentIds;
                for (FSRecords.NameId nameId : persistentIds = FSRecords.listAll(id)) {
                    existingNames.add(nameId.name);
                }
            }
            this.validateAgainst(childrenToCreate, (Set<CharSequence>)existingNames);
            if (!childrenToCreate.isEmpty() && !this.allChildrenLoaded()) {
                int beforeSize = existingNames.size();
                String[] names = this.getFileSystem().list((VirtualFile)this);
                existingNames.addAll(Arrays.asList(names));
                if (beforeSize != existingNames.size()) {
                    this.validateAgainst(childrenToCreate, (Set<CharSequence>)existingNames);
                }
            }
        }
    }

    private void validateAgainst(@NotNull List<VFileCreateEvent> childrenToCreate, @NotNull Set<CharSequence> existingNames) {
        if (childrenToCreate == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(36);
        }
        if (existingNames == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(37);
        }
        for (int i = childrenToCreate.size() - 1; i >= 0; --i) {
            boolean childExists;
            VFileCreateEvent event = childrenToCreate.get(i);
            String childName = event.getChildName();
            boolean bl = childExists = !this.myData.isAdoptedName(childName) && existingNames.contains(childName);
            if (!childExists) continue;
            childrenToCreate.remove(i);
        }
    }

    public boolean allChildrenLoaded() {
        return this.getFlagInt(0x8000000);
    }

    private void setChildrenLoaded() {
        this.setFlagInt(0x8000000, true);
        this.myData.clearAdoptedNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<String> getSuspiciousNames() {
        VfsData.DirectoryData directoryData = this.myData;
        // MONITORENTER : directoryData
        Collection<CharSequence> names = this.myData.getAdoptedNames();
        List list2 = ContainerUtil.map(names, (Function)Function.TO_STRING);
        // MONITOREXIT : directoryData
        if (list2 != null) return list2;
        VirtualDirectoryImpl.$$$reportNull$$$0(38);
        return list2;
    }

    private static int findIndex(@NotNull int[] ids, @NotNull CharSequence name, boolean caseSensitive) {
        if (ids == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(39);
        }
        if (name == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(40);
        }
        int low = 0;
        int high = ids.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = VirtualDirectoryImpl.compareNames(name, VfsData.getNameByFileId(ids[mid]), caseSensitive);
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int compareNames(@NotNull CharSequence name1, @NotNull CharSequence name2, boolean caseSensitive) {
        int d;
        if (name1 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(41);
        }
        if (name2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(42);
        }
        if ((d = name1.length() - name2.length()) != 0) {
            return d;
        }
        for (int i = 0; i < name1.length(); ++i) {
            d = StringUtil.compare((char)name1.charAt(i), (char)name2.charAt(i), (!caseSensitive ? 1 : 0) != 0);
            if (d == 0) continue;
            return d;
        }
        return 0;
    }

    public boolean isDirectory() {
        return true;
    }

    @NotNull
    public List<VirtualFile> getCachedChildren() {
        List<VirtualFileSystemEntry> list2 = Arrays.asList(this.getArraySafely());
        if (list2 == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(43);
        }
        return list2;
    }

    public InputStream getInputStream() throws IOException {
        throw new IOException("getInputStream() must not be called against a directory: " + this.getUrl());
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new IOException("getOutputStream() must not be called against a directory: " + this.getUrl());
    }

    @Override
    public void markDirtyRecursively() {
        this.markDirty();
        this.markDirtyRecursivelyInternal();
    }

    private void markDirtyRecursivelyInternal() {
        for (VirtualFileSystemEntry child : this.getArraySafely()) {
            child.markDirtyInternal();
            if (!(child instanceof VirtualDirectoryImpl)) continue;
            ((VirtualDirectoryImpl)child).markDirtyRecursivelyInternal();
        }
    }

    protected void setUserMap(@NotNull KeyFMap map) {
        if (map == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(44);
        }
        this.myData.myUserMap = map;
    }

    @NotNull
    protected KeyFMap getUserMap() {
        KeyFMap keyFMap = this.myData.myUserMap;
        if (keyFMap == null) {
            VirtualDirectoryImpl.$$$reportNull$$$0(45);
        }
        return keyFMap;
    }

    protected boolean changeUserMap(KeyFMap oldMap, KeyFMap newMap) {
        VirtualDirectoryImpl.checkLeaks(newMap);
        return this.myData.changeUserMap(oldMap, UserDataInterner.internUserData(newMap));
    }

    static void checkLeaks(KeyFMap newMap) {
        for (Key key : newMap.getKeys()) {
            if (key != null && newMap.get(key) instanceof PsiCachedValue) {
                throw new AssertionError((Object)"Don't store CachedValue in VFS user data, since it leads to memory leaks");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 38: 
            case 43: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 38: 
            case 43: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 38: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 28: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idsToRemove";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesToRemove";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenToCreate";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VirtualDirectoryImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getArraySafely";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createChild";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "iterInDbChildren";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "verboseToString";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspiciousNames";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedChildren";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 38: 
            case 43: 
            case 45: {
                break;
            }
            case 4: 
            case 5: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doFindChildInArray";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doFindChild";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deSlash";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createChild";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAndFindChildWithEventFire";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindChild";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findChildIfCached";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "assertConsistency";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddChildren";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "insertChildAt";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "removeChildren";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "validateChildrenToCreate";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "validateAgainst";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findIndex";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "compareNames";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setUserMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 38: 
            case 43: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class OptionHolder {
        static final boolean loadAllChildren = Registry.is((String)"vfs.load.all.persistent.children");

        private OptionHolder() {
        }
    }
}

