/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.diagnostic.IdeMessagePanel;
import com.intellij.diagnostic.MessagePool;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.IdeNotificationArea;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.AbstractActionWithPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.NewRecentProjectPanel;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeBalloonLayoutImpl;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomePopupAction;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.Gray;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBSlidingPanel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextAccessor;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlatWelcomeFrame
extends JFrame
implements IdeFrame,
Disposable,
AccessibleContextAccessor {
    public static final String BOTTOM_PANEL = "BOTTOM_PANEL";
    private static final String ACTION_GROUP_KEY = "ACTION_GROUP_KEY";
    public static final int DEFAULT_HEIGHT = 460;
    public static final int MAX_DEFAULT_WIDTH = 777;
    private BalloonLayout myBalloonLayout;
    private final FlatWelcomeScreen myScreen;
    private boolean myDisposed;

    public FlatWelcomeFrame() {
        JRootPane rootPane = this.getRootPane();
        this.myScreen = new FlatWelcomeScreen();
        IdeGlassPaneImpl glassPane = new IdeGlassPaneImpl(rootPane){

            @Override
            public void addNotify() {
                super.addNotify();
                TransactionGuard.submitTransaction((Disposable)FlatWelcomeFrame.this, () -> JBProtocolCommand.handleCurrentCommand());
            }
        };
        this.setGlassPane(glassPane);
        glassPane.setVisible(false);
        this.setContentPane(this.myScreen.getWelcomePanel());
        this.setTitle(this.getWelcomeFrameTitle());
        AppUIUtil.updateWindowIcon(this);
        int width = RecentProjectsManager.getInstance().getRecentProjectsActions(false).length == 0 ? 666 : 777;
        this.getRootPane().setPreferredSize(new Dimension(JBUI.scale((int)width), Math.max(JBUI.scale((int)460), this.getMinimumSize().height)));
        this.setResizable(false);
        Dimension size = this.getPreferredSize();
        Point location = DimensionService.getInstance().getLocation("WELCOME_SCREEN", null);
        Rectangle screenBounds = ScreenUtil.getScreenRectangle((Point)(location != null ? location : new Point(0, 0)));
        this.setBounds(screenBounds.x + (screenBounds.width - size.width) / 2, screenBounds.y + (screenBounds.height - size.height) / 3, size.width, size.height);
        if (Registry.is((String)"suppress.focus.stealing")) {
            this.setAutoRequestFocus(false);
        }
        UiNotifyConnector.doWhenFirstShown((Component)this, this::pack);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(Project project) {
                Disposer.dispose((Disposable)FlatWelcomeFrame.this);
            }
        });
        this.myBalloonLayout = PlatformUtils.isAndroidStudio() ? new WelcomeBalloonLayoutImpl(rootPane, (Insets)JBUI.insets((int)8), this.myScreen.myEventListener, this.myScreen.myEventLocation) : new BalloonLayoutImpl(rootPane, (Insets)JBUI.insets((int)8));
        WelcomeFrame.setupCloseAction(this);
        MnemonicHelper.init((Component)this);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this);
    }

    @Override
    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        FlatWelcomeFrame.saveLocation(this.getBounds());
        super.dispose();
        if (this.myBalloonLayout != null) {
            ((BalloonLayoutImpl)this.myBalloonLayout).dispose();
            this.myBalloonLayout = null;
        }
        Disposer.dispose((Disposable)this.myScreen);
        WelcomeFrame.resetInstance();
    }

    private static void saveLocation(Rectangle location) {
        Point middle = new Point(location.x + location.width / 2, location.y + location.height / 2);
        DimensionService.getInstance().setLocation("WELCOME_SCREEN", middle, null);
    }

    public StatusBar getStatusBar() {
        return null;
    }

    public static Color getMainBackground() {
        return new JBColor(0xF7F7F7, 4540234);
    }

    public static Color getProjectsBackground() {
        return new JBColor((Color)Gray.xFF, (Color)Gray.x39);
    }

    public static Color getLinkNormalColor() {
        return new JBColor((Color)Gray._0, (Color)Gray.xBB);
    }

    public static Color getListSelectionColor(boolean hasFocus) {
        return hasFocus ? new JBColor(3700182, 4943535) : new JBColor((Color)Gray.xDD, (Color)Gray.x45);
    }

    public static Color getActionLinkSelectionColor() {
        return new JBColor(14411253, 4741237);
    }

    public static JBColor getSeparatorColor() {
        return new JBColor((Color)Gray.xEC, new Color(72, 75, 78));
    }

    public AccessibleContext getCurrentAccessibleContext() {
        return this.accessibleContext;
    }

    protected String getWelcomeFrameTitle() {
        String title = "Welcome to " + ApplicationNamesInfo.getInstance().getFullProductName();
        if (Boolean.getBoolean("ide.ui.version.in.title")) {
            title = title + ' ' + ApplicationInfo.getInstance().getFullVersion();
        }
        return title;
    }

    @NotNull
    public static JComponent getPreferredFocusedComponent(@NotNull Pair<JPanel, JBList<AnAction>> pair) {
        JBTextField textField2;
        if (pair == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(0);
        }
        if (((JBList)pair.second).getModel().getSize() == 1 && (textField2 = (JBTextField)UIUtil.uiTraverser((Component)((Component)pair.first)).filter(JBTextField.class).first()) != null) {
            JBTextField jBTextField = textField2;
            if (jBTextField == null) {
                FlatWelcomeFrame.$$$reportNull$$$0(1);
            }
            return jBTextField;
        }
        JComponent jComponent = (JComponent)pair.second;
        if (jComponent == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    public static boolean isUseProjectGroups() {
        return Registry.is((String)"welcome.screen.project.grouping.enabled");
    }

    private static Runnable createUsageTracker(AnAction action) {
        return () -> UsageTrigger.trigger("welcome.screen." + ActionManager.getInstance().getId(action));
    }

    private static JLabel createArrow(final ActionLink link) {
        JLabel arrow = new JLabel(AllIcons.General.Combo3);
        arrow.setCursor(Cursor.getPredefinedCursor(12));
        arrow.setVerticalAlignment(3);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                MouseEvent newEvent = MouseEventAdapter.convert((MouseEvent)e, (Component)link, (int)e.getX(), (int)e.getY());
                link.doClick((InputEvent)newEvent);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$3", "onClick"));
            }
        }.installOn((Component)arrow);
        return arrow;
    }

    public BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }

    public Rectangle suggestChildFrameBounds() {
        return this.getBounds();
    }

    @Nullable
    public Project getProject() {
        if (ApplicationManager.getApplication().isDisposeInProgress()) {
            return null;
        }
        return ProjectManager.getInstance().getDefaultProject();
    }

    public void setFrameTitle(String title) {
        this.setTitle(title);
    }

    public void setFileTitle(String fileTitle, File ioFile) {
        this.setTitle(fileTitle);
    }

    public IdeRootPaneNorthExtension getNorthExtension(String key) {
        return null;
    }

    public JComponent getComponent() {
        return this.getRootPane();
    }

    public static Pair<JPanel, JBList<AnAction>> createActionGroupPanel(ActionGroup action, final Runnable backAction, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(3);
        }
        JPanel actionsListPanel = new JPanel(new BorderLayout());
        actionsListPanel.setBackground(FlatWelcomeFrame.getProjectsBackground());
        List<AnAction> groups = FlatWelcomeFrame.flattenActionGroups(action);
        final DefaultListModel model = JBList.createDefaultListModel(groups);
        JBList list2 = new JBList((ListModel)model);
        for (AnAction group : groups) {
            if (!(group instanceof Disposable)) continue;
            Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)group));
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                model.clear();
            }
        });
        list2.setBackground(FlatWelcomeFrame.getProjectsBackground());
        list2.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer<AnAction>((ListItemDescriptor)new ListItemDescriptorAdapter<AnAction>(){

            @Nullable
            public String getTextFor(AnAction value) {
                return FlatWelcomeFrame.getActionText(value);
            }

            @Nullable
            public String getCaptionAboveOf(AnAction value) {
                return FlatWelcomeFrame.getParentGroupName(value);
            }

            public boolean hasSeparatorAboveOf(AnAction value) {
                int index = model.indexOf(value);
                String parentGroupName = FlatWelcomeFrame.getParentGroupName(value);
                if (index < 1) {
                    return parentGroupName != null;
                }
                AnAction upper = (AnAction)model.get(index - 1);
                if (FlatWelcomeFrame.getParentGroupName(upper) == null && parentGroupName != null) {
                    return true;
                }
                return !Comparing.equal((String)FlatWelcomeFrame.getParentGroupName(upper), (String)parentGroupName);
            }
        }){

            @Override
            protected JComponent createItemComponent() {
                this.myTextLabel = new ErrorLabel();
                this.myTextLabel.setOpaque(true);
                this.myTextLabel.setBorder((Border)JBUI.Borders.empty((int)3, (int)7));
                return this.myTextLabel;
            }

            protected Color getBackground() {
                return FlatWelcomeFrame.getProjectsBackground();
            }

            @Override
            protected void customizeComponent(JList<? extends AnAction> list2, AnAction value, boolean isSelected) {
                if (this.myTextLabel != null) {
                    this.myTextLabel.setText(FlatWelcomeFrame.getActionText(value));
                    this.myTextLabel.setIcon(value.getTemplatePresentation().getIcon());
                }
            }
        });
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)list2, (boolean)true);
        pane.setBackground(FlatWelcomeFrame.getProjectsBackground());
        actionsListPanel.add((Component)pane, "Center");
        int width = (int)Math.max(Math.min(Math.round(list2.getPreferredSize().getWidth()), (long)JBUI.scale((int)200)), (long)JBUI.scale((int)100));
        pane.setPreferredSize((Dimension)JBUI.size((int)(width + 14), (int)-1));
        boolean singleProjectGenerator = list2.getModel().getSize() == 1;
        Ref selected = Ref.create();
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)actionsListPanel, "West");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        bottomPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, (Color)new JBColor((Color)Gray._217, (Color)Gray._81)));
        main.add((Component)bottomPanel, "South");
        HashMap panelsMap = ContainerUtil.newHashMap();
        ListSelectionListener selectionListener = e -> {
            Object value;
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (!selected.isNull()) {
                main.remove((Component)selected.get());
            }
            if ((value = list2.getSelectedValue()) instanceof AbstractActionWithPanel) {
                JPanel panel2 = panelsMap.computeIfAbsent(value, o -> ((AbstractActionWithPanel)((Object)((Object)((Object)value)))).createPanel());
                ((AbstractActionWithPanel)((Object)((Object)value))).onPanelSelected();
                panel2.setBorder((Border)JBUI.Borders.empty((int)7, (int)10));
                selected.set((Object)panel2);
                main.add((Component)selected.get());
                FlatWelcomeFrame.updateBottomPanel(panel2, (AbstractActionWithPanel)((Object)((Object)value)), bottomPanel, backAction);
                main.revalidate();
                main.repaint();
            }
        };
        list2.addListSelectionListener(selectionListener);
        if (backAction != null) {
            new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    backAction.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$7", "actionPerformed"));
                }
            }.registerCustomShortcutSet(27, 0, (JComponent)main);
        }
        FlatWelcomeFrame.installQuickSearch((JBList<AnAction>)list2);
        if (singleProjectGenerator) {
            actionsListPanel.setPreferredSize(new Dimension(0, 0));
        }
        return Pair.create((Object)main, (Object)list2);
    }

    private static void updateBottomPanel(@NotNull JPanel currentPanel, @NotNull AbstractActionWithPanel actionWithPanel, @NotNull JPanel bottomPanel, @Nullable Runnable backAction) {
        if (currentPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(4);
        }
        if (actionWithPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(5);
        }
        if (bottomPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(6);
        }
        bottomPanel.removeAll();
        if (SystemInfoRt.isMac) {
            FlatWelcomeFrame.addCancelButton(bottomPanel, backAction);
            FlatWelcomeFrame.addActionButton(bottomPanel, actionWithPanel, currentPanel);
        } else {
            FlatWelcomeFrame.addActionButton(bottomPanel, actionWithPanel, currentPanel);
            FlatWelcomeFrame.addCancelButton(bottomPanel, backAction);
        }
    }

    private static void addCancelButton(@NotNull JPanel bottomPanel, @Nullable Runnable backAction) {
        JComponent cancelButton;
        if (bottomPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(7);
        }
        if ((cancelButton = FlatWelcomeFrame.createCancelButton(backAction)) != null) {
            bottomPanel.add(cancelButton);
        }
    }

    private static void addActionButton(@NotNull JPanel bottomPanel, @NotNull AbstractActionWithPanel actionWithPanel, @NotNull JPanel currentPanel) {
        if (bottomPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(8);
        }
        if (actionWithPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(9);
        }
        if (currentPanel == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(10);
        }
        JButton actionButton = actionWithPanel.getActionButton();
        bottomPanel.add(actionButton);
        currentPanel.getRootPane().setDefaultButton(actionButton);
    }

    @Nullable
    private static JComponent createCancelButton(@Nullable Runnable cancelAction) {
        if (cancelAction == null) {
            return null;
        }
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> cancelAction.run());
        return cancelButton;
    }

    public static void installQuickSearch(JBList<AnAction> list2) {
        new ListSpeedSearch<AnAction>((JList<AnAction>)list2, (Function<AnAction, String>)((Function)o -> {
            if (o instanceof AbstractActionWithPanel) {
                return o.getTemplatePresentation().getText();
            }
            return null;
        }));
    }

    private static List<AnAction> flattenActionGroups(@NotNull ActionGroup action) {
        if (action == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(11);
        }
        ArrayList groups = ContainerUtil.newArrayList();
        for (AnAction anAction : action.getChildren(null)) {
            if (anAction instanceof ActionGroup) {
                String groupName = FlatWelcomeFrame.getActionText(anAction);
                for (AnAction childAction : ((ActionGroup)anAction).getChildren(null)) {
                    if (groupName != null) {
                        FlatWelcomeFrame.setParentGroupName(groupName, childAction);
                    }
                    groups.add(childAction);
                }
                continue;
            }
            groups.add(anAction);
        }
        return groups;
    }

    private static String getActionText(@NotNull AnAction value) {
        if (value == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(12);
        }
        return value.getTemplatePresentation().getText();
    }

    private static String getParentGroupName(@NotNull AnAction value) {
        if (value == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(13);
        }
        return (String)value.getTemplatePresentation().getClientProperty(ACTION_GROUP_KEY);
    }

    private static void setParentGroupName(@NotNull String groupName, @NotNull AnAction childAction) {
        if (groupName == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(14);
        }
        if (childAction == null) {
            FlatWelcomeFrame.$$$reportNull$$$0(15);
        }
        childAction.getTemplatePresentation().putClientProperty(ACTION_GROUP_KEY, (Object)groupName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPanel";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionWithPanel";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bottomPanel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredFocusedComponent";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createActionGroupPanel";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateBottomPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCancelButton";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addActionButton";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "flattenActionGroups";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getActionText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParentGroupName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setParentGroupName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class WelcomeScreenActionsPanel {
        private JPanel root;
        private JPanel actions;

        public WelcomeScreenActionsPanel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            JPanel jPanel2;
            this.root = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.setOpaque(false);
            this.actions = jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 0));
            jPanel.setOpaque(false);
            jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel2.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer3 = new Spacer();
            jPanel2.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.root;
        }
    }

    private class FlatWelcomeScreen
    extends JPanel
    implements WelcomeScreen {
        private final JBSlidingPanel mySlidingPanel;
        public Consumer<List<NotificationType>> myEventListener;
        public Computable<Point> myEventLocation;

        public FlatWelcomeScreen() {
            super(new BorderLayout());
            this.mySlidingPanel = new JBSlidingPanel();
            this.mySlidingPanel.add("root", (Component)this);
            this.setBackground(FlatWelcomeFrame.getMainBackground());
            if (RecentProjectsManager.getInstance().getRecentProjectsActions(false, FlatWelcomeFrame.isUseProjectGroups()).length > 0) {
                final JComponent recentProjects = this.createRecentProjects();
                this.add((Component)recentProjects, "West");
                final JList projectsList = (JList)UIUtil.findComponentOfType((JComponent)recentProjects, JList.class);
                if (projectsList != null) {
                    projectsList.getModel().addListDataListener(new ListDataListener(){

                        @Override
                        public void intervalAdded(ListDataEvent e) {
                        }

                        @Override
                        public void intervalRemoved(ListDataEvent e) {
                            this.removeIfNeeded();
                        }

                        private void removeIfNeeded() {
                            if (RecentProjectsManager.getInstance().getRecentProjectsActions(false, FlatWelcomeFrame.isUseProjectGroups()).length == 0) {
                                FlatWelcomeScreen.this.remove(recentProjects);
                                FlatWelcomeScreen.this.revalidate();
                                FlatWelcomeScreen.this.repaint();
                            }
                        }

                        @Override
                        public void contentsChanged(ListDataEvent e) {
                            this.removeIfNeeded();
                        }
                    });
                    projectsList.addFocusListener(new FocusListener(){

                        @Override
                        public void focusGained(FocusEvent e) {
                            projectsList.repaint();
                        }

                        @Override
                        public void focusLost(FocusEvent e) {
                            projectsList.repaint();
                        }
                    });
                }
            }
            this.add((Component)this.createBody(), "Center");
        }

        public JComponent getWelcomePanel() {
            return this.mySlidingPanel;
        }

        private JComponent createBody() {
            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
            panel2.add((Component)this.createLogo(), (Object)"North");
            panel2.add((Component)this.createActionPanel(), (Object)"Center");
            panel2.add((Component)this.createSettingsAndDocs(), (Object)"South");
            return panel2;
        }

        private JComponent createSettingsAndDocs() {
            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
            NonOpaquePanel toolbar = new NonOpaquePanel();
            AnAction register = ActionManager.getInstance().getAction("Register");
            boolean registeredVisible = false;
            if (register != null) {
                AnActionEvent e = AnActionEvent.createFromAnAction((AnAction)register, null, (String)"WelcomeScreen", (DataContext)DataManager.getInstance().getDataContext((Component)this));
                register.update(e);
                Presentation presentation = e.getPresentation();
                if (presentation.isEnabled()) {
                    ActionLink registerLink = new ActionLink("Register", register);
                    registerLink.setFocusable(false);
                    registerLink.setNormalColor(FlatWelcomeFrame.getLinkNormalColor());
                    NonOpaquePanel button = new NonOpaquePanel((LayoutManager)new BorderLayout());
                    button.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
                    button.add((Component)registerLink);
                    this.installFocusable((JComponent)button, register, 38, 39, true);
                    NonOpaquePanel wrap = new NonOpaquePanel();
                    wrap.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
                    wrap.add((Component)button);
                    panel2.add((Component)wrap, "West");
                    registeredVisible = true;
                }
            }
            toolbar.setLayout((LayoutManager)new BoxLayout((Container)toolbar, 0));
            toolbar.add((Component)this.createErrorsLink());
            toolbar.add((Component)this.createEventsLink());
            toolbar.add((Component)this.createActionLink("Configure", "WelcomeScreen.Configure", AllIcons.General.GearPlain, !registeredVisible));
            toolbar.add((Component)this.createActionLink("Get Help", "WelcomeScreen.Documentation", null, false));
            panel2.add((Component)toolbar, "East");
            panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)8, (int)11));
            return panel2;
        }

        private JComponent createErrorsLink() {
            IdeMessagePanel panel2 = new IdeMessagePanel(null, MessagePool.getInstance());
            panel2.setBorder((Border)JBUI.Borders.emptyRight((int)13));
            Disposer.register((Disposable)this, (Disposable)panel2);
            return panel2;
        }

        private JComponent createEventsLink() {
            Ref actionLinkRef = new Ref();
            JComponent panel2 = this.createActionLink("Events", AllIcons.Ide.Notification.NoEvents, (Ref<ActionLink>)actionLinkRef, new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ((WelcomeBalloonLayoutImpl)FlatWelcomeFrame.this.myBalloonLayout).showPopup();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$3", "actionPerformed"));
                }
            });
            panel2.setVisible(false);
            this.myEventListener = types -> {
                NotificationType type = null;
                for (NotificationType t : types) {
                    if (NotificationType.ERROR == t) {
                        type = NotificationType.ERROR;
                        break;
                    }
                    if (NotificationType.WARNING == t) {
                        type = NotificationType.WARNING;
                        continue;
                    }
                    if (type != null || NotificationType.INFORMATION != t) continue;
                    type = NotificationType.INFORMATION;
                }
                if (types.isEmpty()) {
                    panel2.setVisible(false);
                } else {
                    ((ActionLink)actionLinkRef.get()).setIcon((Icon)IdeNotificationArea.createIconWithNotificationCount((JComponent)actionLinkRef.get(), type, types.size()));
                    panel2.setVisible(true);
                }
            };
            this.myEventLocation = () -> {
                Point location = SwingUtilities.convertPoint(panel2, 0, 0, this.getRootPane().getLayeredPane());
                return new Point(location.x, location.y + 5);
            };
            return panel2;
        }

        private JComponent createActionLink(String text, final String groupId, Icon icon, boolean focusListOnLeft) {
            final Ref ref = new Ref(null);
            AnAction action = new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    ActionGroup configureGroup = (ActionGroup)ActionManager.getInstance().getAction(groupId);
                    PopupFactoryImpl.ActionGroupPopup popup2 = (PopupFactoryImpl.ActionGroupPopup)JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new IconsFreeActionGroup(configureGroup), e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, "WelcomeScreen");
                    popup2.showUnderneathOfLabel((JLabel)ref.get());
                    UsageTrigger.trigger("welcome.screen." + groupId);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$4", "actionPerformed"));
                }
            };
            JComponent panel2 = this.createActionLink(text, icon, (Ref<ActionLink>)ref, action);
            this.installFocusable(panel2, action, 38, 40, focusListOnLeft);
            return panel2;
        }

        private JComponent createActionLink(String text, Icon icon, Ref<ActionLink> ref, AnAction action) {
            ActionLink link = new ActionLink(text, icon, action);
            ref.set((Object)link);
            link.setFocusable(false);
            link.setPaintUnderline(false);
            link.setNormalColor(FlatWelcomeFrame.getLinkNormalColor());
            JActionLinkPanel panel2 = new JActionLinkPanel(link);
            panel2.setBorder((Border)JBUI.Borders.empty((int)4, (int)6, (int)4, (int)6));
            panel2.add((Component)FlatWelcomeFrame.createArrow(link), "East");
            return panel2;
        }

        private JComponent createActionPanel() {
            NonOpaquePanel actions = new NonOpaquePanel();
            actions.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
            actions.setLayout(new BoxLayout((Container)actions, 1));
            ActionManager actionManager = ActionManager.getInstance();
            ActionGroup quickStart = (ActionGroup)actionManager.getAction("WelcomeScreen.QuickStart");
            DefaultActionGroup group = new DefaultActionGroup();
            this.collectAllActions(group, quickStart);
            for (AnAction action : group.getChildren(null)) {
                Icon icon;
                AnActionEvent e = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"WelcomeScreen", (DataContext)DataManager.getInstance().getDataContext((Component)this));
                action.update(e);
                Presentation presentation = e.getPresentation();
                if (!presentation.isVisible()) continue;
                String text = presentation.getText();
                if (text != null && text.endsWith("...")) {
                    text = text.substring(0, text.length() - 3);
                }
                if ((icon = presentation.getIcon()).getIconHeight() != JBUI.scale((int)16) || icon.getIconWidth() != JBUI.scale((int)16)) {
                    icon = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)16));
                }
                action = this.wrapGroups(action);
                ActionLink link = new ActionLink(text, icon, action, FlatWelcomeFrame.createUsageTracker(action));
                link.setFocusable(false);
                link.setPaintUnderline(false);
                link.setNormalColor(FlatWelcomeFrame.getLinkNormalColor());
                JActionLinkPanel button = new JActionLinkPanel(link);
                button.setBorder((Border)JBUI.Borders.empty((int)8, (int)20));
                if (action instanceof WelcomePopupAction) {
                    button.add((Component)FlatWelcomeFrame.createArrow(link), "East");
                }
                this.installFocusable(button, action, 38, 40, true);
                actions.add(button);
            }
            Component verticalSpacer = Box.createVerticalStrut(25);
            actions.add(verticalSpacer);
            WelcomeScreenActionsPanel panel2 = new WelcomeScreenActionsPanel();
            panel2.actions.add((Component)actions);
            panel2.root.setMinimumSize(panel2.actions.getMinimumSize());
            return panel2.root;
        }

        private AnAction wrapGroups(AnAction action) {
            if (action instanceof ActionGroup && ((ActionGroup)action).isPopup()) {
                Pair<JPanel, JBList<AnAction>> panel2 = FlatWelcomeFrame.createActionGroupPanel((ActionGroup)action, () -> this.goBack(), (Disposable)this);
                final Runnable onDone = () -> {
                    ListSelectionListener[] listeners;
                    FlatWelcomeFrame.this.setTitle("New Project");
                    JBList list2 = (JBList)panel2.second;
                    ScrollingUtil.ensureSelectionExists((JList)list2);
                    for (ListSelectionListener listener2 : listeners = (ListSelectionListener[])((DefaultListSelectionModel)list2.getSelectionModel()).getListeners(ListSelectionListener.class)) {
                        listener2.valueChanged(new ListSelectionEvent(list2, list2.getSelectedIndex(), list2.getSelectedIndex(), false));
                    }
                    JComponent toFocus = FlatWelcomeFrame.getPreferredFocusedComponent(panel2);
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)toFocus, true));
                };
                final String name = action.getClass().getName();
                this.mySlidingPanel.add(name, (Component)panel2.first);
                Presentation p = action.getTemplatePresentation();
                return new DumbAwareAction(p.getText(), p.getDescription(), p.getIcon()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        FlatWelcomeScreen.this.mySlidingPanel.getLayout().swipe((Container)FlatWelcomeScreen.this.mySlidingPanel, name, JBCardLayout.SwipeDirection.FORWARD, onDone);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$5", "actionPerformed"));
                    }
                };
            }
            return action;
        }

        protected void goBack() {
            this.mySlidingPanel.swipe("root", JBCardLayout.SwipeDirection.BACKWARD).doWhenDone(() -> {
                this.mySlidingPanel.getRootPane().setDefaultButton(null);
                FlatWelcomeFrame.this.setTitle(FlatWelcomeFrame.this.getWelcomeFrameTitle());
            });
        }

        private void collectAllActions(DefaultActionGroup group, ActionGroup actionGroup) {
            for (AnAction action : actionGroup.getChildren(null)) {
                if (action instanceof ActionGroup && !((ActionGroup)action).isPopup()) {
                    this.collectAllActions(group, (ActionGroup)action);
                    continue;
                }
                group.add(action);
            }
        }

        private JComponent createLogo() {
            NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
            ApplicationInfoEx app = ApplicationInfoEx.getInstanceEx();
            JLabel logo = new JLabel(IconLoader.getIcon((String)app.getWelcomeScreenLogoUrl()));
            logo.setBorder((Border)JBUI.Borders.empty((int)30, (int)0, (int)10, (int)0));
            logo.setHorizontalAlignment(0);
            panel2.add((Component)logo, (Object)"North");
            String applicationName = Boolean.getBoolean("ide.ui.name.with.edition") ? ApplicationNamesInfo.getInstance().getFullProductNameWithEdition() : ApplicationNamesInfo.getInstance().getFullProductName();
            JLabel appName = new JLabel(applicationName);
            Font font = this.getProductFont();
            appName.setForeground(JBColor.foreground());
            appName.setFont(font.deriveFont(JBUI.scale((float)36.0f)).deriveFont(0));
            appName.setHorizontalAlignment(0);
            String appVersion = "Version ";
            appVersion = appVersion + app.getFullVersion();
            if (app.isEAP() && !app.getBuild().isSnapshot()) {
                appVersion = appVersion + " (" + app.getBuild().asStringWithoutProductCode() + ")";
            }
            JLabel version = new JLabel(appVersion);
            version.setFont(this.getProductFont().deriveFont(JBUI.scale((float)16.0f)));
            version.setHorizontalAlignment(0);
            version.setForeground((Color)Gray._128);
            panel2.add((Component)appName);
            panel2.add((Component)version, (Object)"South");
            panel2.setBorder((Border)JBUI.Borders.emptyBottom((int)20));
            return panel2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Font getProductFont() {
            String name = "/fonts/Roboto-Light.ttf";
            URL url = AppUIUtil.class.getResource(name);
            if (url == null) {
                Logger.getInstance(AppUIUtil.class).warn("Resource missing: " + name);
            } else {
                Font font;
                InputStream is = url.openStream();
                try {
                    font = Font.createFont(0, is);
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (Throwable t) {
                        Logger.getInstance(AppUIUtil.class).warn("Cannot load font: " + url, t);
                    }
                }
                is.close();
                return font;
            }
            return UIUtil.getLabelFont();
        }

        private JComponent createRecentProjects() {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)new NewRecentProjectPanel((Disposable)this), "Center");
            panel2.setBackground(FlatWelcomeFrame.getProjectsBackground());
            panel2.setBorder((Border)new CustomLineBorder((Color)FlatWelcomeFrame.getSeparatorColor(), (Insets)JBUI.insetsRight((int)1)));
            return panel2;
        }

        private void installFocusable(final JComponent comp, final AnAction action, final int prevKeyCode, final int nextKeyCode, final boolean focusListOnLeft) {
            comp.setFocusable(true);
            comp.setFocusTraversalKeysEnabled(true);
            comp.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    JList list2 = (JList)UIUtil.findComponentOfType((JComponent)FlatWelcomeFrame.this.getComponent(), JList.class);
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        ActionLink link;
                        InputEvent event = e;
                        if (e.getComponent() instanceof JComponent && (link = (ActionLink)UIUtil.findComponentOfType((JComponent)((JComponent)e.getComponent()), ActionLink.class)) != null) {
                            event = new MouseEvent((Component)link, 500, e.getWhen(), e.getModifiers(), 0, 0, 1, false, 1);
                        }
                        action.actionPerformed(AnActionEvent.createFromAnAction((AnAction)action, (InputEvent)event, (String)"WelcomeScreen", (DataContext)DataManager.getInstance().getDataContext()));
                    } else if (e.getKeyCode() == prevKeyCode) {
                        FlatWelcomeScreen.this.focusPrev(comp);
                    } else if (e.getKeyCode() == nextKeyCode) {
                        FlatWelcomeScreen.this.focusNext(comp);
                    } else if (e.getKeyCode() == 37) {
                        if (focusListOnLeft) {
                            if (list2 != null) {
                                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)list2, true));
                            }
                        } else {
                            FlatWelcomeScreen.this.focusPrev(comp);
                        }
                    } else if (e.getKeyCode() == 39) {
                        FlatWelcomeScreen.this.focusNext(comp);
                    }
                }
            });
            comp.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    comp.setOpaque(true);
                    comp.setBackground(FlatWelcomeFrame.getActionLinkSelectionColor());
                }

                @Override
                public void focusLost(FocusEvent e) {
                    comp.setOpaque(false);
                    comp.setBackground(FlatWelcomeFrame.getMainBackground());
                }
            });
        }

        protected void focusPrev(JComponent comp) {
            Component prev2;
            FocusTraversalPolicy policy = FlatWelcomeFrame.this.getFocusTraversalPolicy();
            if (policy != null && (prev2 = policy.getComponentBefore(FlatWelcomeFrame.this, comp)) != null) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(prev2, true));
            }
        }

        protected void focusNext(JComponent comp) {
            Component next;
            FocusTraversalPolicy policy = FlatWelcomeFrame.this.getFocusTraversalPolicy();
            if (policy != null && (next = policy.getComponentAfter(FlatWelcomeFrame.this, comp)) != null) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(next, true));
            }
        }

        public void setupFrame(JFrame frame) {
        }

        public void dispose() {
        }

        private class IconsFreeActionGroup
        extends ActionGroup {
            private final ActionGroup myGroup;

            public IconsFreeActionGroup(ActionGroup group) {
                super(group.getTemplatePresentation().getText(), group.getTemplatePresentation().getDescription(), null);
                this.myGroup = group;
            }

            public boolean isPopup() {
                return this.myGroup.isPopup();
            }

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                AnAction[] children2 = this.myGroup.getChildren(e);
                AnAction[] patched = new AnAction[children2.length];
                for (int i = 0; i < children2.length; ++i) {
                    patched[i] = this.patch(children2[i]);
                }
                if (patched == null) {
                    IconsFreeActionGroup.$$$reportNull$$$0(0);
                }
                return patched;
            }

            private AnAction patch(final AnAction child) {
                if (child instanceof ActionGroup) {
                    return new IconsFreeActionGroup((ActionGroup)child);
                }
                Presentation presentation = child.getTemplatePresentation();
                return new AnAction(presentation.getText(), presentation.getDescription(), null){

                    public boolean startInTransaction() {
                        return child.startInTransaction();
                    }

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        child.actionPerformed(e);
                        UsageTrigger.trigger("welcome.screen." + e.getActionManager().getId(child));
                    }

                    public void update(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        child.update(e);
                        e.getPresentation().setIcon(null);
                    }

                    public boolean isDumbAware() {
                        return child.isDumbAware();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$IconsFreeActionGroup$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "actionPerformed";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "update";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$IconsFreeActionGroup", "getChildren"));
            }
        }

        protected class JActionLinkPanel
        extends JPanel {
            @NotNull
            private final ActionLink myActionLink;

            public JActionLinkPanel(ActionLink actionLink) {
                if (actionLink == null) {
                    JActionLinkPanel.$$$reportNull$$$0(0);
                }
                super(new BorderLayout());
                this.myActionLink = actionLink;
                this.add((Component)this.myActionLink);
                NonOpaquePanel.setTransparent((JComponent)this);
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleJActionLinkPanel(this.myActionLink.getAccessibleContext());
                }
                return this.accessibleContext;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionLink", "com/intellij/openapi/wm/impl/welcomeScreen/FlatWelcomeFrame$FlatWelcomeScreen$JActionLinkPanel", "<init>"));
            }

            protected class AccessibleJActionLinkPanel
            extends AccessibleContextDelegate {
                public AccessibleJActionLinkPanel(AccessibleContext context) {
                    super(context);
                }

                public Accessible getAccessibleParent() {
                    if (JActionLinkPanel.this.getParent() instanceof Accessible) {
                        return (Accessible)((Object)JActionLinkPanel.this.getParent());
                    }
                    return super.getAccessibleParent();
                }

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PUSH_BUTTON;
                }
            }
        }
    }
}

