/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.InjectedLanguageBlockWrapper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InjectedLanguageBlockBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.xml.XmlInjectedLanguageBlockBuilder");

    @NotNull
    public Block createInjectedBlock(@NotNull ASTNode node, @NotNull Block originalBlock, Indent indent, int offset, TextRange range2, @NotNull Language language) {
        if (node == null) {
            InjectedLanguageBlockBuilder.$$$reportNull$$$0(0);
        }
        if (originalBlock == null) {
            InjectedLanguageBlockBuilder.$$$reportNull$$$0(1);
        }
        if (language == null) {
            InjectedLanguageBlockBuilder.$$$reportNull$$$0(2);
        }
        InjectedLanguageBlockWrapper injectedLanguageBlockWrapper = new InjectedLanguageBlockWrapper(originalBlock, offset, range2, indent, language);
        if (injectedLanguageBlockWrapper == null) {
            InjectedLanguageBlockBuilder.$$$reportNull$$$0(3);
        }
        return injectedLanguageBlockWrapper;
    }

    public abstract CodeStyleSettings getSettings();

    public abstract boolean canProcessFragment(String var1, ASTNode var2);

    public abstract Block createBlockBeforeInjection(ASTNode var1, Wrap var2, Alignment var3, Indent var4, TextRange var5);

    public abstract Block createBlockAfterInjection(ASTNode var1, Wrap var2, Alignment var3, Indent var4, TextRange var5);

    public boolean addInjectedBlocks(List<Block> result2, ASTNode injectionHost, Wrap wrap, Alignment alignment, Indent indent) {
        Language childLanguage;
        FormattingModelBuilder builder;
        PsiFile[] injectedFile = new PsiFile[1];
        Ref injectedRangeInsideHost = new Ref();
        Ref prefixLength = new Ref();
        Ref suffixLength = new Ref();
        Ref injectionHostToUse = new Ref((Object)injectionHost);
        PsiLanguageInjectionHost.InjectedPsiVisitor injectedPsiVisitor = (injectedPsi, places) -> {
            String childText;
            if (places.size() != 1) {
                return;
            }
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)places.get(0);
            TextRange textRange = shred.getRangeInsideHost();
            PsiLanguageInjectionHost shredHost = shred.getHost();
            if (shredHost == null) {
                return;
            }
            ASTNode node = shredHost.getNode();
            if (node == null || !injectionHost.getTextRange().contains(textRange.shiftRight(node.getStartOffset()))) {
                return;
            }
            if (node != injectionHost) {
                int shift = 0;
                boolean canProcess = false;
                ASTNode prev2 = injectionHost;
                for (ASTNode n = injectionHost.getTreeParent(); n != null; n = n.getTreeParent()) {
                    shift += n.getStartOffset() - prev2.getStartOffset();
                    if (n == node) {
                        textRange = textRange.shiftRight(shift);
                        canProcess = true;
                        break;
                    }
                    prev2 = n;
                }
                if (!canProcess) {
                    return;
                }
            }
            if (injectionHost.getTextLength() == textRange.getEndOffset() && textRange.getStartOffset() == 0 || this.canProcessFragment((childText = injectionHost.getText()).substring(0, textRange.getStartOffset()), injectionHost) && this.canProcessFragment(childText.substring(textRange.getEndOffset()), injectionHost)) {
                injectedFile[0] = injectedPsi;
                injectedRangeInsideHost.set((Object)textRange);
                prefixLength.set((Object)shred.getPrefix().length());
                suffixLength.set((Object)shred.getSuffix().length());
            }
        };
        PsiElement injectionHostPsi = injectionHost.getPsi();
        PsiFile containingFile = injectionHostPsi.getContainingFile();
        InjectedLanguageManager.getInstance((Project)containingFile.getProject()).enumerateEx(injectionHostPsi, containingFile, true, injectedPsiVisitor);
        if (injectedFile[0] != null && (builder = LanguageFormatting.INSTANCE.forContext(childLanguage = injectedFile[0].getLanguage(), injectionHostPsi)) != null) {
            ASTNode leaf;
            int startOffset = ((TextRange)injectedRangeInsideHost.get()).getStartOffset();
            int endOffset = ((TextRange)injectedRangeInsideHost.get()).getEndOffset();
            TextRange range2 = ((ASTNode)injectionHostToUse.get()).getTextRange();
            int childOffset = range2.getStartOffset();
            if (startOffset != 0) {
                leaf = ((ASTNode)injectionHostToUse.get()).findLeafElementAt(startOffset - 1);
                result2.add(this.createBlockBeforeInjection(leaf, wrap, alignment, indent, new TextRange(childOffset, childOffset + startOffset)));
            }
            this.addInjectedLanguageBlockWrapper(result2, (ASTNode)injectedFile[0].getNode(), indent, childOffset + startOffset, new TextRange(((Integer)prefixLength.get()).intValue(), injectedFile[0].getTextLength() - (Integer)suffixLength.get()));
            if (endOffset != ((ASTNode)injectionHostToUse.get()).getTextLength()) {
                leaf = ((ASTNode)injectionHostToUse.get()).findLeafElementAt(endOffset);
                result2.add(this.createBlockAfterInjection(leaf, wrap, alignment, indent, new TextRange(childOffset + endOffset, range2.getEndOffset())));
            }
            return true;
        }
        return false;
    }

    public void addInjectedLanguageBlockWrapper(List<Block> result2, ASTNode injectedNode, Indent indent, int offset, @Nullable TextRange range2) {
        PsiElement childPsi;
        Language childLanguage;
        FormattingModelBuilder builder;
        if (range2 != null) {
            if (range2.getLength() == 0) {
                return;
            }
            if (StringUtil.isEmptyOrSpaces((String)range2.substring(injectedNode.getText()))) {
                return;
            }
        }
        LOG.assertTrue((builder = LanguageFormatting.INSTANCE.forContext(childLanguage = (childPsi = injectedNode.getPsi()).getLanguage(), childPsi)) != null);
        FormattingModel childModel = builder.createModel(childPsi, this.getSettings());
        Block original = childModel.getRootBlock();
        if (original.isLeaf() && !injectedNode.getText().trim().isEmpty() || !original.getSubBlocks().isEmpty()) {
            result2.add(this.createInjectedBlock(injectedNode, original, indent, offset, range2, childLanguage));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalBlock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/common/InjectedLanguageBlockBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/common/InjectedLanguageBlockBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createInjectedBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createInjectedBlock";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

