/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.file.FileLookupInfoProvider;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileInfoManager
implements Disposable {
    private final Map<FileType, FileLookupInfoProvider> myFileType2InfoProvider = new HashMap<FileType, FileLookupInfoProvider>();

    public FileInfoManager() {
        FileLookupInfoProvider[] providers;
        for (FileLookupInfoProvider provider : providers = (FileLookupInfoProvider[])FileLookupInfoProvider.EP_NAME.getExtensions()) {
            FileType[] types;
            for (FileType type : types = provider.getFileTypes()) {
                this.myFileType2InfoProvider.put(type, provider);
            }
        }
    }

    public static FileInfoManager getFileInfoManager() {
        return (FileInfoManager)ServiceManager.getService(FileInfoManager.class);
    }

    public static Object getFileLookupItem(PsiElement psiElement) {
        if (!(psiElement instanceof PsiFile) || !psiElement.isPhysical()) {
            return psiElement;
        }
        PsiFile file2 = (PsiFile)psiElement;
        return FileInfoManager.getFileInfoManager()._getLookupItem(file2, file2.getName(), file2.getIcon(0));
    }

    @Nullable
    public static String getFileAdditionalInfo(PsiElement psiElement) {
        return FileInfoManager.getFileInfoManager()._getInfo(psiElement);
    }

    @Nullable
    private String _getInfo(PsiElement psiElement) {
        VirtualFile virtualFile;
        if (!(psiElement instanceof PsiFile) || !psiElement.isPhysical()) {
            return null;
        }
        PsiFile psiFile = (PsiFile)psiElement;
        FileLookupInfoProvider provider = this.myFileType2InfoProvider.get(psiFile.getFileType());
        if (provider != null && (virtualFile = psiFile.getVirtualFile()) != null) {
            Pair info = provider.getLookupInfo(virtualFile, psiElement.getProject());
            return info == null ? null : (String)info.second;
        }
        return null;
    }

    public static LookupElementBuilder getFileLookupItem(PsiElement psiElement, String encoded, Icon icon) {
        if (!(psiElement instanceof PsiFile) || !psiElement.isPhysical()) {
            return LookupElementBuilder.create((Object)psiElement, (String)encoded).withIcon(icon);
        }
        return FileInfoManager.getFileInfoManager()._getLookupItem((PsiFile)psiElement, encoded, icon);
    }

    public LookupElementBuilder _getLookupItem(@NotNull PsiFile file2, String name, Icon icon) {
        if (file2 == null) {
            FileInfoManager.$$$reportNull$$$0(0);
        }
        LookupElementBuilder builder = LookupElementBuilder.create((Object)file2, (String)name).withIcon(icon);
        String info = this._getInfo((PsiElement)file2);
        if (info != null) {
            return builder.withTailText(String.format(" (%s)", info), true);
        }
        return builder;
    }

    public void dispose() {
        this.myFileType2InfoProvider.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileInfoManager", "_getLookupItem"));
    }
}

