/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SharedImplUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.SharedImplUtil");
    private static final boolean CHECK_FOR_READ_ACTION = DebugUtil.DO_EXPENSIVE_CHECKS || ApplicationManager.getApplication().isInternal();

    private SharedImplUtil() {
    }

    public static PsiElement getParent(ASTNode thisElement) {
        if (CHECK_FOR_READ_ACTION && thisElement instanceof TreeElement) {
            ((TreeElement)thisElement).assertReadAccessAllowed();
        }
        return SourceTreeToPsiMap.treeElementToPsi(thisElement.getTreeParent());
    }

    public static PsiElement getFirstChild(ASTNode element) {
        return SourceTreeToPsiMap.treeElementToPsi(element.getFirstChildNode());
    }

    @Nullable
    public static PsiElement getLastChild(ASTNode element) {
        return SourceTreeToPsiMap.treeElementToPsi(element.getLastChildNode());
    }

    public static PsiElement getNextSibling(ASTNode thisElement) {
        return SourceTreeToPsiMap.treeElementToPsi(thisElement.getTreeNext());
    }

    public static PsiElement getPrevSibling(ASTNode thisElement) {
        return SourceTreeToPsiMap.treeElementToPsi(thisElement.getTreePrev());
    }

    public static PsiFile getContainingFile(ASTNode thisElement) {
        PsiElement psi;
        FileASTNode node = SharedImplUtil.findFileElement(thisElement);
        PsiElement psiElement = psi = node == null ? null : node.getPsi();
        if (psi == null || psi instanceof PsiFile) {
            return (PsiFile)psi;
        }
        throw new AssertionError((Object)("Invalid PSI " + psi + " of " + psi.getClass() + " for AST " + node + " of " + node.getClass()));
    }

    public static boolean isValid(ASTNode thisElement) {
        LOG.assertTrue(thisElement instanceof PsiElement);
        PsiFile file2 = SharedImplUtil.getContainingFile(thisElement);
        return file2 != null && file2.isValid();
    }

    public static boolean isWritable(ASTNode thisElement) {
        PsiFile file2 = SharedImplUtil.getContainingFile(thisElement);
        return file2 == null || file2.isWritable();
    }

    public static FileASTNode findFileElement(@NotNull ASTNode element) {
        if (element == null) {
            SharedImplUtil.$$$reportNull$$$0(0);
        }
        for (ASTNode parent = element.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            element = parent;
        }
        if (CHECK_FOR_READ_ACTION && element instanceof TreeElement) {
            ((TreeElement)element).assertReadAccessAllowed();
        }
        if (element instanceof FileASTNode) {
            return (FileASTNode)element;
        }
        return null;
    }

    @NotNull
    public static CharTable findCharTableByTree(ASTNode tree) {
        for (ASTNode o = tree; o != null; o = o.getTreeParent()) {
            CharTable charTable = (CharTable)o.getUserData(CharTable.CHAR_TABLE_KEY);
            if (charTable != null) {
                CharTable charTable2 = charTable;
                if (charTable2 == null) {
                    SharedImplUtil.$$$reportNull$$$0(1);
                }
                return charTable2;
            }
            if (!(o instanceof FileASTNode)) continue;
            CharTable charTable3 = ((FileASTNode)o).getCharTable();
            if (charTable3 == null) {
                SharedImplUtil.$$$reportNull$$$0(2);
            }
            return charTable3;
        }
        throw new AssertionError((Object)("CharTable not found in: " + tree));
    }

    public static PsiElement addRange(PsiElement thisElement, PsiElement first, PsiElement last, ASTNode anchor2, Boolean before) throws IncorrectOperationException {
        ASTNode element;
        CheckUtil.checkWritable(thisElement);
        CharTable table = SharedImplUtil.findCharTableByTree(SourceTreeToPsiMap.psiElementToTree(thisElement));
        TreeElement copyFirst = null;
        TreeElement copyLast = null;
        ASTNode next = SourceTreeToPsiMap.psiElementToTree(last).getTreeNext();
        CompositeElement parent = null;
        for (element = SourceTreeToPsiMap.psiElementToTree(first); element != next; element = element.getTreeNext()) {
            TreeElement elementCopy = ChangeUtil.copyElement((TreeElement)element, table);
            if (element == first.getNode()) {
                copyFirst = elementCopy;
            }
            if (element == last.getNode()) {
                copyLast = elementCopy;
            }
            if (parent == null) {
                parent = elementCopy.getTreeParent();
                continue;
            }
            if (elementCopy.getElementType() == TokenType.WHITE_SPACE) {
                CodeEditUtil.setNodeGenerated(elementCopy, true);
            }
            parent.addChild(elementCopy, null);
        }
        if (copyFirst == null) {
            return null;
        }
        copyFirst = ((CompositeElement)SourceTreeToPsiMap.psiElementToTree(thisElement)).addInternal(copyFirst, copyLast, anchor2, before);
        for (element = copyFirst; element != null; element = element.getTreeNext()) {
            if ((element = ChangeUtil.decodeInformation((TreeElement)element)).getTreePrev() != null) continue;
            copyFirst = element;
        }
        return SourceTreeToPsiMap.treeElementToPsi(copyFirst);
    }

    public static PsiManager getManagerByTree(ASTNode node) {
        if (node instanceof FileElement) {
            return node.getPsi().getManager();
        }
        return node.getTreeParent().getPsi().getManager();
    }

    @NotNull
    public static ASTNode[] getChildrenOfType(@NotNull ASTNode node, @NotNull IElementType elementType) {
        int count;
        if (node == null) {
            SharedImplUtil.$$$reportNull$$$0(3);
        }
        if (elementType == null) {
            SharedImplUtil.$$$reportNull$$$0(4);
        }
        if ((count = SharedImplUtil.countChildrenOfType(node, elementType)) == 0) {
            if (ASTNode.EMPTY_ARRAY == null) {
                SharedImplUtil.$$$reportNull$$$0(5);
            }
            return ASTNode.EMPTY_ARRAY;
        }
        ASTNode[] result2 = new ASTNode[count];
        count = 0;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != elementType) continue;
            result2[count++] = child;
        }
        if (result2 == null) {
            SharedImplUtil.$$$reportNull$$$0(6);
        }
        return result2;
    }

    private static int countChildrenOfType(@NotNull ASTNode node, @NotNull IElementType elementType) {
        if (node == null) {
            SharedImplUtil.$$$reportNull$$$0(7);
        }
        if (elementType == null) {
            SharedImplUtil.$$$reportNull$$$0(8);
        }
        int count = 0;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != elementType) continue;
            ++count;
        }
        return count;
    }

    public static void acceptChildren(PsiElementVisitor visitor, ASTNode root) {
        for (ASTNode childNode = root.getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            PsiElement psi = childNode instanceof PsiElement ? (PsiElement)childNode : childNode.getPsi();
            psi.accept(visitor);
        }
    }

    public static PsiElement doReplace(PsiElement psiElement, TreeElement treeElement, PsiElement newElement) {
        CompositeElement treeParent = treeElement.getTreeParent();
        LOG.assertTrue(treeParent != null);
        CheckUtil.checkWritable(psiElement);
        TreeElement elementCopy = ChangeUtil.copyToElement(newElement);
        treeParent.replaceChildInternal(treeElement, elementCopy);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        PsiElement result2 = SourceTreeToPsiMap.treeElementToPsi(elementCopy);
        treeElement.invalidate();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/SharedImplUtil";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/SharedImplUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findCharTableByTree";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileElement";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "countChildrenOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

