/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.scope.packageSet.AbstractPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.Colored;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Colored(color="ffffe4", darkVariant="494539")
public class NonProjectFilesScope
extends NamedScope {
    public static final String NAME = "Non-Project Files";

    public NonProjectFilesScope() {
        super(NAME, (PackageSet)new AbstractPackageSet("NonProject"){

            public boolean contains(VirtualFile file2, NamedScopesHolder holder) {
                return this.contains(file2, holder.getProject(), holder);
            }

            public boolean contains(VirtualFile file2, @NotNull Project project, @Nullable NamedScopesHolder holder) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                return NonProjectFilesScope.containsImpl(file2, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/search/scope/NonProjectFilesScope$1", "contains"));
            }
        });
    }

    private static boolean containsImpl(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            NonProjectFilesScope.$$$reportNull$$$0(0);
        }
        if (project == null) {
            NonProjectFilesScope.$$$reportNull$$$0(1);
        }
        if (file2 == null || file2.getFileSystem() instanceof NonPhysicalFileSystem) {
            return false;
        }
        if (!file2.isInLocalFileSystem()) {
            return true;
        }
        if (ScratchUtil.isScratch(file2)) {
            return false;
        }
        return !ProjectScope.getProjectScope((Project)project).contains(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/search/scope/NonProjectFilesScope";
        objectArray[2] = "containsImpl";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

