/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"move.title");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project == null) {
            MoveHandler.$$$reportNull$$$0(0);
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            element = file2;
        }
        while (true) {
            PsiElement refElement;
            int relative;
            PsiReference reference;
            if (element == null) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.at.the.class.method.or.field.to.be.refactored"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, null);
                return;
            }
            if (MoveHandler.tryToMoveElement(element, project, dataContext, null, editor)) {
                return;
            }
            TextRange range2 = element.getTextRange();
            if (range2 != null && (reference = element.findReferenceAt(relative = offset - range2.getStartOffset())) != null && (refElement = reference.resolve()) != null && MoveHandler.tryToMoveElement(refElement, project, dataContext, reference, editor)) {
                return;
            }
            element = element.getParent();
        }
    }

    private static boolean tryToMoveElement(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        for (MoveHandlerDelegate delegate : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!delegate.tryToMove(element, project, dataContext, reference, editor)) continue;
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            MoveHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            MoveHandler.$$$reportNull$$$0(2);
        }
        PsiElement targetContainer = dataContext == null ? null : (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext);
        HashSet<PsiElement> filesOrDirs = new HashSet<PsiElement>();
        for (MoveHandlerDelegate moveHandlerDelegate : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!moveHandlerDelegate.canMove(dataContext) || !moveHandlerDelegate.isValidTarget(targetContainer, elements)) continue;
            moveHandlerDelegate.collectFilesOrDirsFromContext(dataContext, filesOrDirs);
        }
        if (!filesOrDirs.isEmpty()) {
            for (MoveHandlerDelegate moveHandlerDelegate : elements) {
                if (moveHandlerDelegate instanceof PsiDirectory) {
                    filesOrDirs.add((PsiElement)moveHandlerDelegate);
                    continue;
                }
                PsiFile containingFile = moveHandlerDelegate.getContainingFile();
                if (containingFile == null) continue;
                filesOrDirs.add((PsiElement)containingFile);
            }
            MoveFilesOrDirectoriesUtil.doMove(project, PsiUtilCore.toPsiElementArray(filesOrDirs), new PsiElement[]{targetContainer}, null);
            return;
        }
        MoveHandler.doMove(project, elements, targetContainer, dataContext, null);
    }

    public static void doMove(Project project, @NotNull PsiElement[] elements, PsiElement targetContainer, DataContext dataContext, MoveCallback callback) {
        if (elements == null) {
            MoveHandler.$$$reportNull$$$0(3);
        }
        if (elements.length == 0) {
            return;
        }
        for (MoveHandlerDelegate delegate : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!delegate.canMove(elements, targetContainer)) continue;
            delegate.doMove(project, elements, delegate.adjustTargetForMove(dataContext, targetContainer), callback);
            break;
        }
    }

    @Nullable
    public static PsiElement[] adjustForMove(Project project, PsiElement[] sourceElements, PsiElement targetElement) {
        for (MoveHandlerDelegate delegate : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!delegate.canMove(sourceElements, targetElement)) continue;
            return delegate.adjustForMove(project, sourceElements, targetElement);
        }
        return sourceElements;
    }

    public static boolean canMove(@NotNull PsiElement[] elements, PsiElement targetContainer) {
        if (elements == null) {
            MoveHandler.$$$reportNull$$$0(4);
        }
        for (MoveHandlerDelegate delegate : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!delegate.canMove(elements, targetContainer)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidTarget(PsiElement psiElement, PsiElement[] elements) {
        if (psiElement != null) {
            for (MoveHandlerDelegate delegate : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
                if (!delegate.isValidTarget(psiElement, elements)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canMove(DataContext dataContext) {
        for (MoveHandlerDelegate delegate : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!delegate.canMove(dataContext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMoveRedundant(PsiElement source, PsiElement target2) {
        for (MoveHandlerDelegate delegate : (MoveHandlerDelegate[])Extensions.getExtensions(MoveHandlerDelegate.EP_NAME)) {
            if (!delegate.isMoveRedundant(source, target2)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/move/MoveHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doMove";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canMove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

