/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectFileTreeModel
extends BaseTreeModel<Object>
implements InvokerSupplier {
    private final Invoker invoker;
    private final ProjectNode root;

    public ProjectFileTreeModel(@NotNull Project project) {
        if (project == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(0);
        }
        this.invoker = new Invoker.BackgroundThread((Disposable)this);
        this.root = new ProjectNode(project);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                ProjectFileTreeModel.this.onValidThread(() -> {
                    ((ProjectFileTreeModel)ProjectFileTreeModel.this).root.valid = false;
                    ProjectFileTreeModel.this.treeStructureChanged(null, null, null);
                });
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                ProjectFileTreeModel.this.onValidThread(() -> {
                    if (events == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    for (VFileEvent event : events) {
                        VirtualFile parent;
                        if (event instanceof VFileCreateEvent) {
                            VFileCreateEvent create2 = (VFileCreateEvent)event;
                            ProjectFileTreeModel.this.invalidate(create2.getParent());
                            continue;
                        }
                        if (event instanceof VFileCopyEvent) {
                            VFileCopyEvent copy = (VFileCopyEvent)event;
                            ProjectFileTreeModel.this.invalidate(copy.getNewParent());
                            continue;
                        }
                        if (event instanceof VFileMoveEvent) {
                            VFileMoveEvent move = (VFileMoveEvent)event;
                            ProjectFileTreeModel.this.invalidate(move.getNewParent());
                            ProjectFileTreeModel.this.invalidate(move.getOldParent());
                            ProjectFileTreeModel.this.invalidate(move.getFile());
                            continue;
                        }
                        VirtualFile file2 = event.getFile();
                        if (file2 == null) continue;
                        if (event instanceof VFileDeleteEvent && (parent = file2.getParent()) != null) {
                            ProjectFileTreeModel.this.invalidate(parent);
                        }
                        ProjectFileTreeModel.this.invalidate(file2);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "events";
                objectArray2[1] = "com/intellij/ui/tree/ProjectFileTreeModel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$after$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.invoker;
        if (invoker == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(1);
        }
        return invoker;
    }

    public boolean isValidThread() {
        return this.invoker.isValidThread();
    }

    public void onValidThread(@NotNull Runnable task) {
        if (task == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(2);
        }
        this.invoker.invokeLaterIfNeeded(task);
    }

    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.root != object && super.isLeaf(object);
    }

    @Override
    public int getIndexOfChild(Object parent, Object object) {
        Node node = object instanceof Node ? (Node)object : null;
        return node == null || node.parent != parent ? -1 : super.getIndexOfChild(parent, object);
    }

    @Override
    @NotNull
    public List<Object> getChildren(Object object) {
        Node node;
        Node node2 = node = object instanceof Node && this.isValidThread() ? (Node)object : null;
        if (node == null) {
            List<Object> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectFileTreeModel.$$$reportNull$$$0(3);
            }
            return list2;
        }
        List children2 = node.getChildren();
        List<Object> list3 = Collections.unmodifiableList(children2);
        if (list3 == null) {
            ProjectFileTreeModel.$$$reportNull$$$0(4);
        }
        return list3;
    }

    @Nullable
    public Object getContentRoot(@Nullable Object object) {
        FileNode node = object instanceof FileNode && this.isValidThread() ? (FileNode)object : null;
        return node == null ? null : node.findParent(RootNode.class);
    }

    @Nullable
    public Pair<VirtualFile, Module> getContent(@Nullable Object object) {
        FileNode node = object instanceof FileNode ? (FileNode)object : null;
        return node == null ? null : Pair.create((Object)node.file, (Object)node.module);
    }

    public void invalidate(VirtualFile file2) {
        this.onValidThread(() -> {
            if (this.root.project.isDisposed()) {
                return;
            }
            ProjectRootManager manager = ProjectRootManager.getInstance((Project)this.root.project);
            if (manager == null) {
                return;
            }
            Module module = manager.getFileIndex().getModuleForFile(file2);
            if (module == null || module.isDisposed()) {
                return;
            }
            for (RootNode node : this.root.children) {
                if (node.module != module || !node.invalidate(file2) || !node.valid || !this.root.valid) continue;
                node.invalidateLater(this.invoker, path -> this.treeStructureChanged((TreePath)path, null, null));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/ProjectFileTreeModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/ProjectFileTreeModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onValidThread";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RootNode
    extends FileNode {
        final AtomicLong counter;
        final List<VirtualFile> accumulator;

        RootNode(@NotNull VirtualFile file2, @NotNull Module module) {
            if (file2 == null) {
                RootNode.$$$reportNull$$$0(0);
            }
            if (module == null) {
                RootNode.$$$reportNull$$$0(1);
            }
            super(file2, module);
            this.counter = new AtomicLong();
            this.accumulator = new SmartList();
        }

        @Override
        public String toString() {
            return this.file.getPath();
        }

        boolean invalidate(VirtualFile file2) {
            if (!VfsUtilCore.isAncestor((VirtualFile)this.file, (VirtualFile)file2, (boolean)false)) {
                return false;
            }
            List<VirtualFile> list2 = this.accumulator;
            if (!list2.isEmpty()) {
                for (VirtualFile ancestor : list2) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)false)) continue;
                    return false;
                }
                Iterator<VirtualFile> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)iterator.next(), (boolean)false)) continue;
                    iterator.remove();
                }
            }
            list2.add(file2);
            return true;
        }

        void invalidateLater(@NotNull Invoker invoker, @NotNull Consumer<TreePath> consumer) {
            if (invoker == null) {
                RootNode.$$$reportNull$$$0(2);
            }
            if (consumer == null) {
                RootNode.$$$reportNull$$$0(3);
            }
            long count = this.counter.incrementAndGet();
            invoker.invokeLater(() -> {
                ProjectNode parent;
                if (invoker == null) {
                    RootNode.$$$reportNull$$$0(4);
                }
                if (consumer == null) {
                    RootNode.$$$reportNull$$$0(5);
                }
                if (count == this.counter.get() && (parent = this.findParent(ProjectNode.class)) != null && !parent.project.isDisposed()) {
                    SmartList list2 = new SmartList();
                    this.invalidateNow(arg_0 -> RootNode.lambda$null$0((List)list2, arg_0));
                    for (FileNode node : list2) {
                        void consumer2;
                        TreePath path = TreePathUtil.pathToCustomNode(node, child -> child.parent);
                        if (path == null) continue;
                        invoker.invokeLaterIfNeeded(() -> RootNode.lambda$null$2((Consumer)consumer2, path));
                    }
                }
            }, 10);
        }

        void invalidateNow(Consumer<FileNode> consumer) {
            List<VirtualFile> list2 = this.accumulator;
            if (!list2.isEmpty()) {
                HashMap map = new HashMap();
                list2.forEach(file2 -> map.put(file2, file2));
                list2.clear();
                this.invalidateChildren(node -> {
                    if (!map.containsKey(node.file)) {
                        return true;
                    }
                    if (consumer != null) {
                        consumer.accept((FileNode)node);
                    }
                    return false;
                });
            }
        }

        private static /* synthetic */ void lambda$null$2(@NotNull Consumer consumer, TreePath path) {
            if (consumer == null) {
                RootNode.$$$reportNull$$$0(6);
            }
            consumer.accept(path);
        }

        private static /* synthetic */ void lambda$null$0(List list2, FileNode node) {
            list2.add(node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invoker";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/tree/ProjectFileTreeModel$RootNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invalidateLater";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$invalidateLater$3";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$null$2";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FileNode
    extends Node<FileNode> {
        final VirtualFile file;
        final Module module;

        FileNode(@NotNull VirtualFile file2, @NotNull Module module) {
            if (file2 == null) {
                FileNode.$$$reportNull$$$0(0);
            }
            if (module == null) {
                FileNode.$$$reportNull$$$0(1);
            }
            this.file = file2;
            this.module = module;
        }

        public String toString() {
            return this.file.getName();
        }

        @Override
        @NotNull
        List<FileNode> getChildren(@NotNull List<FileNode> oldList) {
            if (oldList == null) {
                FileNode.$$$reportNull$$$0(2);
            }
            if (!this.file.isValid() || this.module.isDisposed()) {
                List<FileNode> list2 = Collections.emptyList();
                if (list2 == null) {
                    FileNode.$$$reportNull$$$0(3);
                }
                return list2;
            }
            ModuleRootManager manager = ModuleRootManager.getInstance((Module)this.module);
            if (manager == null) {
                List<FileNode> list3 = Collections.emptyList();
                if (list3 == null) {
                    FileNode.$$$reportNull$$$0(4);
                }
                return list3;
            }
            SmartList list4 = new SmartList();
            Mapper<FileNode> mapper = new Mapper<FileNode>(oldList, FileNode::new);
            manager.getFileIndex().iterateContentUnderDirectory(this.file, arg_0 -> this.lambda$getChildren$0((List)list4, mapper, arg_0), child -> this.file.equals(child) || this.file.equals(child.getParent()));
            SmartList smartList = list4;
            if (smartList == null) {
                FileNode.$$$reportNull$$$0(5);
            }
            return smartList;
        }

        final void invalidateChildren(Predicate<FileNode> validator) {
            if (this.valid) {
                if (validator == null || !validator.test(this)) {
                    validator = null;
                    this.valid = false;
                }
                for (FileNode node : this.children) {
                    node.invalidateChildren(validator);
                }
            }
        }

        private /* synthetic */ boolean lambda$getChildren$0(List list2, Mapper mapper, VirtualFile child) {
            return this.file.equals(child) || list2.add(mapper.apply(child, this.module));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldList";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/ProjectFileTreeModel$FileNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/ProjectFileTreeModel$FileNode";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ProjectNode
    extends Node<RootNode> {
        final Project project;

        ProjectNode(@NotNull Project project) {
            if (project == null) {
                ProjectNode.$$$reportNull$$$0(0);
            }
            this.project = project;
        }

        public String toString() {
            return this.project.getName();
        }

        @Override
        @NotNull
        List<RootNode> getChildren(@NotNull List<RootNode> oldList) {
            if (oldList == null) {
                ProjectNode.$$$reportNull$$$0(1);
            }
            if (this.project.isDisposed()) {
                List<RootNode> list2 = Collections.emptyList();
                if (list2 == null) {
                    ProjectNode.$$$reportNull$$$0(2);
                }
                return list2;
            }
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.project);
            if (moduleManager == null) {
                List<RootNode> list3 = Collections.emptyList();
                if (list3 == null) {
                    ProjectNode.$$$reportNull$$$0(3);
                }
                return list3;
            }
            SmartList list4 = new SmartList();
            Mapper<RootNode> mapper = new Mapper<RootNode>(oldList, RootNode::new);
            for (Module module : moduleManager.getModules()) {
                ModuleRootManager manager;
                if (module.isDisposed() || (manager = ModuleRootManager.getInstance((Module)module)) == null) continue;
                for (VirtualFile file2 : manager.getContentRoots()) {
                    list4.add(mapper.apply(file2, module));
                }
            }
            list4.forEach(node -> node.invalidateNow(null));
            SmartList smartList = list4;
            if (smartList == null) {
                ProjectNode.$$$reportNull$$$0(4);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldList";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/ProjectFileTreeModel$ProjectNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/ProjectFileTreeModel$ProjectNode";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildren";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class Node<FN extends FileNode> {
        volatile Node parent;
        volatile List<FN> children = Collections.emptyList();
        volatile boolean valid;

        private Node() {
        }

        @NotNull
        abstract List<FN> getChildren(@NotNull List<FN> var1);

        final List<FN> getChildren() {
            List<FN> oldList = this.children;
            if (this.valid) {
                return oldList;
            }
            List<FN> newList = this.getChildren(oldList);
            oldList.forEach(node -> {
                node.parent = null;
            });
            newList.forEach(node -> {
                node.parent = this;
            });
            this.children = newList;
            this.valid = true;
            return newList;
        }

        final <N> N findParent(Class<N> type) {
            Node node = this;
            while (node != null) {
                if (type.isInstance(node)) {
                    return type.cast(node);
                }
                node = node.parent;
            }
            return null;
        }
    }

    private static final class Mapper<N extends FileNode>
    implements BiFunction<VirtualFile, Module, N> {
        private final HashMap<VirtualFile, N> map;
        private final BiFunction<VirtualFile, Module, N> function;

        Mapper(@NotNull List<N> list2, @NotNull BiFunction<VirtualFile, Module, N> function) {
            if (list2 == null) {
                Mapper.$$$reportNull$$$0(0);
            }
            if (function == null) {
                Mapper.$$$reportNull$$$0(1);
            }
            this.map = new HashMap();
            list2.forEach(node -> this.map.put(node.file, node));
            this.function = function;
        }

        @Override
        @NotNull
        public final N apply(VirtualFile file2, Module module) {
            FileNode node = this.map.isEmpty() ? null : (FileNode)this.map.remove(file2);
            FileNode fileNode = node != null && node.module == module ? node : (FileNode)this.function.apply(file2, module);
            if (fileNode == null) {
                Mapper.$$$reportNull$$$0(2);
            }
            return (N)fileNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/ProjectFileTreeModel$Mapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/ProjectFileTreeModel$Mapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "apply";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

