/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;

public class IndexAccessValidator {
    private final ThreadLocal<ID<?, ?>> ourAlreadyProcessingIndices = new ThreadLocal();

    public void checkAccessingIndexDuringOtherIndexProcessing(@NotNull ID<?, ?> indexKey) {
        ID<?, ?> alreadyProcessingIndex;
        if (indexKey == null) {
            IndexAccessValidator.$$$reportNull$$$0(0);
        }
        if ((alreadyProcessingIndex = this.ourAlreadyProcessingIndices.get()) != null && alreadyProcessingIndex != indexKey) {
            String message = MessageFormat.format("Accessing ''{0}'' during processing ''{1}''. Nested different indices processing may cause deadlock", indexKey.getName(), alreadyProcessingIndex.getName());
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(message);
            }
            Logger.getInstance(FileBasedIndexImpl.class).error(message);
        }
    }

    public void startedProcessingActivityForIndex(ID<?, ?> indexId) {
        this.ourAlreadyProcessingIndices.set(indexId);
    }

    public void stoppedProcessingActivityForIndex(ID<?, ?> indexId) {
        this.ourAlreadyProcessingIndices.set(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexKey", "com/intellij/util/indexing/IndexAccessValidator", "checkAccessingIndexDuringOtherIndexProcessing"));
    }
}

