/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.JBTableRow;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.Nullable;

public abstract class JBTableRowEditor
extends JPanel {
    private final List<RowDocumentListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private MouseEvent myMouseEvent;

    public abstract void prepareEditor(JTable var1, int var2);

    public abstract JBTableRow getValue();

    public abstract JComponent getPreferredFocusedComponent();

    public abstract JComponent[] getFocusableComponents();

    public final void addDocumentListener(RowDocumentListener listener2) {
        this.myListeners.add(listener2);
    }

    public void fireDocumentChanged(DocumentEvent e, int column) {
        for (RowDocumentListener listener2 : this.myListeners) {
            listener2.documentChanged(e, column);
        }
    }

    @Nullable
    public final MouseEvent getMouseEvent() {
        if (this.myMouseEvent != null && this.myMouseEvent.getClickCount() == 0) {
            return null;
        }
        return this.myMouseEvent;
    }

    public final void setMouseEvent(@Nullable MouseEvent e) {
        this.myMouseEvent = e;
    }

    public static JPanel createLabeledPanel(String labelText, JComponent component) {
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 4, 2, true, false));
        JBLabel label = new JBLabel(labelText, UIUtil.ComponentStyle.SMALL);
        IJSwingUtilities.adjustComponentsOnMac((JLabel)label, component);
        panel2.add((Component)label);
        panel2.add(component);
        return panel2;
    }

    public class RowEditorChangeListener
    implements DocumentListener {
        private final int myColumn;

        public RowEditorChangeListener(int column) {
            this.myColumn = column;
        }

        public void documentChanged(DocumentEvent e) {
            JBTableRowEditor.this.fireDocumentChanged(e, this.myColumn);
        }
    }

    public static interface RowDocumentListener {
        public void documentChanged(DocumentEvent var1, int var2);
    }
}

