/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsAppendableHistoryPartnerAdapter;
import com.intellij.openapi.vcs.history.VcsAppendableHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.impl.facade.ReachableNodes;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.utils.BfsUtil;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import com.intellij.vcs.log.history.FileHistoryVisiblePack;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileHistoryFilterer
extends VcsLogFilterer {
    private static final Logger LOG = Logger.getInstance(FileHistoryFilterer.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final FilePath myFilePath;
    @Nullable
    private final Hash myHash;
    @NotNull
    private final IndexDataGetter myIndexDataGetter;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final VcsHistoryCache myVcsHistoryCache;

    public FileHistoryFilterer(@NotNull VcsLogData logData, @NotNull FilePath filePath, @Nullable Hash hash) {
        if (logData == null) {
            FileHistoryFilterer.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            FileHistoryFilterer.$$$reportNull$$$0(1);
        }
        super(logData.getLogProviders(), logData.getStorage(), logData.getTopCommitsCache(), logData.getCommitDetailsGetter(), logData.getIndex());
        this.myProject = logData.getProject();
        this.myFilePath = filePath;
        this.myHash = hash;
        this.myIndexDataGetter = (IndexDataGetter)ObjectUtils.assertNotNull((Object)this.myIndex.getDataGetter());
        this.myRoot = (VirtualFile)ObjectUtils.assertNotNull((Object)VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)this.myFilePath));
        this.myVcsHistoryCache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsHistoryCache();
    }

    @Override
    @NotNull
    protected Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
        VcsHistoryProvider provider;
        if (dataPack == null) {
            FileHistoryFilterer.$$$reportNull$$$0(2);
        }
        if (sortType == null) {
            FileHistoryFilterer.$$$reportNull$$$0(3);
        }
        if (filters == null) {
            FileHistoryFilterer.$$$reportNull$$$0(4);
        }
        if (commitCount == null) {
            FileHistoryFilterer.$$$reportNull$$$0(5);
        }
        long start = System.currentTimeMillis();
        this.checkDetailsFilter(filters);
        if (this.myIndex.isIndexed(this.myRoot) && (dataPack.isFull() || this.myFilePath.isDirectory())) {
            VisiblePack visiblePack = this.filterWithIndex(dataPack, sortType, filters);
            LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start) + " for computing history for " + this.myFilePath + " with index");
            this.checkNotEmpty(dataPack, visiblePack, true);
            Pair pair = Pair.create((Object)visiblePack, (Object)((Object)commitCount));
            if (pair == null) {
                FileHistoryFilterer.$$$reportNull$$$0(6);
            }
            return pair;
        }
        if (this.myFilePath.isDirectory()) {
            Pair<VisiblePack, CommitCountStage> pair = super.filter(dataPack, sortType, filters, commitCount);
            if (pair == null) {
                FileHistoryFilterer.$$$reportNull$$$0(7);
            }
            return pair;
        }
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(this.myRoot);
        if (vcs != null && (provider = vcs.getVcsHistoryProvider()) != null) {
            Pair pair;
            try {
                VisiblePack visiblePack = this.filterWithProvider(vcs, provider, dataPack, sortType, filters);
                LOG.debug(StopWatch.formatTime(System.currentTimeMillis() - start) + " for computing history for " + this.myFilePath + " with history provider");
                this.checkNotEmpty(dataPack, visiblePack, false);
                pair = Pair.create((Object)visiblePack, (Object)((Object)commitCount));
            }
            catch (VcsException e) {
                LOG.error((Throwable)e);
                Pair<VisiblePack, CommitCountStage> pair2 = super.filter(dataPack, sortType, filters, commitCount);
                if (pair2 == null) {
                    FileHistoryFilterer.$$$reportNull$$$0(9);
                }
                return pair2;
            }
            if (pair == null) {
                FileHistoryFilterer.$$$reportNull$$$0(8);
            }
            return pair;
        }
        LOG.warn("Could not find vcs or history provider for file " + this.myFilePath);
        Pair<VisiblePack, CommitCountStage> pair = super.filter(dataPack, sortType, filters, commitCount);
        if (pair == null) {
            FileHistoryFilterer.$$$reportNull$$$0(10);
        }
        return pair;
    }

    private void checkNotEmpty(@NotNull DataPack dataPack, @NotNull VisiblePack visiblePack, boolean withIndex) {
        if (dataPack == null) {
            FileHistoryFilterer.$$$reportNull$$$0(11);
        }
        if (visiblePack == null) {
            FileHistoryFilterer.$$$reportNull$$$0(12);
        }
        if (!dataPack.isFull()) {
            LOG.debug("Data pack is not full while computing file history for " + this.myFilePath + "\nFound " + visiblePack.getVisibleGraph().getVisibleCommitCount() + " commits");
        } else if (visiblePack.getVisibleGraph().getVisibleCommitCount() == 0) {
            LOG.warn("Empty file history from " + (withIndex ? "index" : "provider") + " for " + this.myFilePath);
        }
    }

    @NotNull
    private VisiblePack filterWithProvider(@NotNull AbstractVcs vcs, @NotNull VcsHistoryProvider provider, @NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters) throws VcsException {
        VisibleGraph<Integer> visibleGraph;
        if (vcs == null) {
            FileHistoryFilterer.$$$reportNull$$$0(13);
        }
        if (provider == null) {
            FileHistoryFilterer.$$$reportNull$$$0(14);
        }
        if (dataPack == null) {
            FileHistoryFilterer.$$$reportNull$$$0(15);
        }
        if (sortType == null) {
            FileHistoryFilterer.$$$reportNull$$$0(16);
        }
        if (filters == null) {
            FileHistoryFilterer.$$$reportNull$$$0(17);
        }
        VcsAbstractHistorySession session2 = null;
        if (provider instanceof VcsCacheableHistorySessionFactory && this.myHash == null) {
            session2 = this.myVcsHistoryCache.getFull(this.myFilePath, vcs.getKeyInstanceMethod(), (VcsCacheableHistorySessionFactory)provider);
        }
        if (session2 == null || session2.getRevisionList().isEmpty() || session2.shouldBeRefreshed()) {
            VcsAppendableHistoryPartnerAdapter partner = new VcsAppendableHistoryPartnerAdapter();
            if (provider instanceof VcsHistoryProviderEx && this.myHash != null) {
                ((VcsHistoryProviderEx)provider).reportAppendableHistory(this.myFilePath, (VcsRevisionNumber)VcsLogUtil.convertToRevisionNumber(this.myHash), (VcsAppendableHistorySessionPartner)partner);
            } else {
                provider.reportAppendableHistory(this.myFilePath, (VcsAppendableHistorySessionPartner)partner);
            }
            session2 = partner.getSession();
            if (provider instanceof VcsCacheableHistorySessionFactory && this.myHash == null) {
                this.myVcsHistoryCache.put(this.myFilePath, null, vcs.getKeyInstanceMethod(), session2, (VcsCacheableHistorySessionFactory)provider, true);
            }
        }
        List revisions = session2.getRevisionList();
        HashMap pathsMap = ContainerUtil.newHashMap();
        if (dataPack.isFull()) {
            for (VcsFileRevision revision : revisions) {
                pathsMap.put(this.getIndex(revision), ((VcsFileRevisionEx)revision).getPath());
            }
            visibleGraph = this.createVisibleGraph(dataPack, sortType, null, pathsMap.keySet());
        } else {
            ArrayList commits = ContainerUtil.newArrayListWithCapacity((int)revisions.size());
            for (VcsFileRevision revision : revisions) {
                int index = this.getIndex(revision);
                pathsMap.put(index, ((VcsFileRevisionEx)revision).getPath());
                commits.add(GraphCommitImpl.createCommit(index, Collections.emptyList(), revision.getRevisionDate().getTime()));
            }
            dataPack = DataPack.build(commits, dataPack.getRefsModel().getAllRefsByRoot(), dataPack.getLogProviders(), this.myStorage, false);
            visibleGraph = this.createVisibleGraph(dataPack, sortType, null, null);
        }
        FileHistoryVisiblePack fileHistoryVisiblePack = new FileHistoryVisiblePack(dataPack, visibleGraph, false, filters, pathsMap);
        if (fileHistoryVisiblePack == null) {
            FileHistoryFilterer.$$$reportNull$$$0(18);
        }
        return fileHistoryVisiblePack;
    }

    private int getIndex(@NotNull VcsFileRevision revision) {
        if (revision == null) {
            FileHistoryFilterer.$$$reportNull$$$0(19);
        }
        return this.myStorage.getCommitIndex(HashImpl.build(revision.getRevisionNumber().asString()), this.myRoot);
    }

    @NotNull
    private VisiblePack filterWithIndex(@NotNull DataPack dataPack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters) {
        FileHistoryRefiner refiner;
        int row;
        if (dataPack == null) {
            FileHistoryFilterer.$$$reportNull$$$0(20);
        }
        if (sortType == null) {
            FileHistoryFilterer.$$$reportNull$$$0(21);
        }
        if (filters == null) {
            FileHistoryFilterer.$$$reportNull$$$0(22);
        }
        Set<Integer> matchingHeads = this.getMatchingHeads(dataPack.getRefsModel(), Collections.singleton(this.myRoot), filters);
        IndexDataGetter.FileNamesData data = this.myIndexDataGetter.buildFileNamesData(this.myFilePath);
        VisibleGraph<Integer> visibleGraph = this.createVisibleGraph(dataPack, sortType, matchingHeads, data.getCommits());
        Map<Integer, FilePath> pathsMap = null;
        if (visibleGraph.getVisibleCommitCount() > 0 && visibleGraph instanceof VisibleGraphImpl && (row = this.getCurrentRow(dataPack, visibleGraph, data)) >= 0 && (refiner = new FileHistoryRefiner((VisibleGraphImpl)visibleGraph, data)).refine(row, this.myFilePath)) {
            visibleGraph = this.createVisibleGraph(dataPack, sortType, matchingHeads, refiner.getPathsForCommits().keySet());
            pathsMap = refiner.getPathsForCommits();
        }
        if (pathsMap == null) {
            pathsMap = data.buildPathsMap();
        }
        if (!this.myFilePath.isDirectory()) {
            this.reindexFirstCommitsIfNeeded(visibleGraph);
        }
        FileHistoryVisiblePack fileHistoryVisiblePack = new FileHistoryVisiblePack(dataPack, visibleGraph, false, filters, pathsMap);
        if (fileHistoryVisiblePack == null) {
            FileHistoryFilterer.$$$reportNull$$$0(23);
        }
        return fileHistoryVisiblePack;
    }

    private void reindexFirstCommitsIfNeeded(@NotNull VisibleGraph<Integer> graph) {
        if (graph == null) {
            FileHistoryFilterer.$$$reportNull$$$0(24);
        }
        if (graph instanceof VisibleGraphImpl) {
            LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(((VisibleGraphImpl)graph).getLinearGraph());
            for (int row = 0; row < liteLinearGraph.nodesCount(); ++row) {
                if (!liteLinearGraph.getNodes(row, LiteLinearGraph.NodeFilter.DOWN).isEmpty()) continue;
                this.myIndex.reindexWithRenames((Integer)graph.getRowInfo(row).getCommit(), this.myRoot);
            }
        }
    }

    private void checkDetailsFilter(@NotNull VcsLogFilterCollection filters) {
        List detailsFilters;
        if (filters == null) {
            FileHistoryFilterer.$$$reportNull$$$0(25);
        }
        LOG.assertTrue((detailsFilters = filters.getDetailsFilters()).size() == 1);
        VcsLogDetailsFilter filter2 = (VcsLogDetailsFilter)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)detailsFilters));
        LOG.assertTrue(filter2 instanceof VcsLogStructureFilter);
        LOG.assertTrue(((VcsLogStructureFilter)filter2).getFiles().equals(Collections.singleton(this.myFilePath)));
    }

    private int getCurrentRow(@NotNull DataPack pack, @NotNull VisibleGraph<Integer> visibleGraph, @NotNull IndexDataGetter.FileNamesData fileIndexData) {
        PermanentGraph<Integer> permanentGraph;
        if (pack == null) {
            FileHistoryFilterer.$$$reportNull$$$0(26);
        }
        if (visibleGraph == null) {
            FileHistoryFilterer.$$$reportNull$$$0(27);
        }
        if (fileIndexData == null) {
            FileHistoryFilterer.$$$reportNull$$$0(28);
        }
        if ((permanentGraph = pack.getPermanentGraph()) instanceof PermanentGraphImpl) {
            Hash hash;
            Hash hash2 = hash = this.myHash != null ? this.myHash : this.getHead(pack);
            if (hash != null) {
                return this.findAncestorRowAffectingFile((PermanentGraphImpl)permanentGraph, hash, visibleGraph, fileIndexData);
            }
        }
        return 0;
    }

    @Nullable
    private Hash getHead(@NotNull DataPack pack) {
        CompressedRefs refs;
        Optional<VcsRef> headOptional;
        if (pack == null) {
            FileHistoryFilterer.$$$reportNull$$$0(29);
        }
        if ((headOptional = (refs = pack.getRefsModel().getAllRefsByRoot().get(this.myRoot)).streamBranches().filter(br -> br.getName().equals("HEAD")).findFirst()).isPresent()) {
            VcsRef head = headOptional.get();
            assert (head.getRoot().equals(this.myRoot));
            return head.getCommitHash();
        }
        return null;
    }

    private int findAncestorRowAffectingFile(@NotNull PermanentGraphImpl<Integer> permanentGraph, @NotNull Hash hash, @NotNull VisibleGraph<Integer> visibleGraph, @NotNull IndexDataGetter.FileNamesData fileNamesData) {
        if (permanentGraph == null) {
            FileHistoryFilterer.$$$reportNull$$$0(30);
        }
        if (hash == null) {
            FileHistoryFilterer.$$$reportNull$$$0(31);
        }
        if (visibleGraph == null) {
            FileHistoryFilterer.$$$reportNull$$$0(32);
        }
        if (fileNamesData == null) {
            FileHistoryFilterer.$$$reportNull$$$0(33);
        }
        Ref result2 = new Ref();
        PermanentCommitsInfo commitsInfo = permanentGraph.getPermanentCommitsInfo();
        ReachableNodes reachableNodes = new ReachableNodes(LinearGraphUtils.asLiteLinearGraph(permanentGraph.getLinearGraph()));
        reachableNodes.walk(Collections.singleton(((PermanentCommitsInfoImpl)commitsInfo).getNodeId(this.myStorage.getCommitIndex(hash, this.myRoot))), true, arg_0 -> this.lambda$findAncestorRowAffectingFile$1((PermanentCommitsInfoImpl)commitsInfo, fileNamesData, result2, arg_0));
        if (!result2.isNull()) {
            Integer rowIndex = visibleGraph.getVisibleRowIndex(((PermanentCommitsInfoImpl)commitsInfo).getCommitId((Integer)result2.get()));
            return (Integer)ObjectUtils.assertNotNull((Object)rowIndex);
        }
        return -1;
    }

    private /* synthetic */ boolean lambda$findAncestorRowAffectingFile$1(PermanentCommitsInfoImpl commitsInfo, @NotNull IndexDataGetter.FileNamesData fileNamesData, Ref result2, int currentNode) {
        int id;
        if (fileNamesData == null) {
            FileHistoryFilterer.$$$reportNull$$$0(34);
        }
        if (fileNamesData.affects(id = ((Integer)commitsInfo.getCommitId(currentNode)).intValue(), this.myFilePath)) {
            result2.set((Object)currentNode);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: 
            case 11: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 3: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortType";
                break;
            }
            case 4: 
            case 17: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitCount";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryFilterer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleGraph";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndexData";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentGraph";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNamesData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryFilterer";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "filterWithProvider";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "filterWithIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 23: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkNotEmpty";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "filterWithProvider";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "filterWithIndex";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "reindexFirstCommitsIfNeeded";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkDetailsFilter";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRow";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getHead";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findAncestorRowAffectingFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findAncestorRowAffectingFile$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileHistoryRefiner
    implements DfsUtil.NodeVisitor {
        @NotNull
        private final VisibleGraphImpl<Integer> myVisibleGraph;
        @NotNull
        private final PermanentCommitsInfo<Integer> myPermanentCommitsInfo;
        @NotNull
        private final LiteLinearGraph myPermanentLinearGraph;
        @NotNull
        private final IndexDataGetter.FileNamesData myNamesData;
        @NotNull
        private final Stack<FilePath> myPaths;
        @NotNull
        private final BitSetFlags myVisibilityBuffer;
        @NotNull
        private final Map<Integer, FilePath> myPathsForCommits;
        @NotNull
        private final Set<Integer> myExcluded;

        public FileHistoryRefiner(@NotNull VisibleGraphImpl<Integer> visibleGraph, @NotNull IndexDataGetter.FileNamesData namesData) {
            if (visibleGraph == null) {
                FileHistoryRefiner.$$$reportNull$$$0(0);
            }
            if (namesData == null) {
                FileHistoryRefiner.$$$reportNull$$$0(1);
            }
            this.myPaths = new Stack();
            this.myPathsForCommits = ContainerUtil.newHashMap();
            this.myExcluded = ContainerUtil.newHashSet();
            this.myVisibleGraph = visibleGraph;
            this.myPermanentCommitsInfo = this.myVisibleGraph.getPermanentGraph().getPermanentCommitsInfo();
            this.myPermanentLinearGraph = LinearGraphUtils.asLiteLinearGraph(this.myVisibleGraph.getPermanentGraph().getLinearGraph());
            this.myNamesData = namesData;
            this.myVisibilityBuffer = new BitSetFlags(this.myPermanentLinearGraph.nodesCount());
        }

        public boolean refine(int row, @NotNull FilePath startPath) {
            if (startPath == null) {
                FileHistoryRefiner.$$$reportNull$$$0(2);
            }
            if (this.myNamesData.hasRenames()) {
                this.myPaths.push((Object)startPath);
                DfsUtil.walk(LinearGraphUtils.asLiteLinearGraph(this.myVisibleGraph.getLinearGraph()), row, this);
            } else {
                this.myPathsForCommits.putAll(this.myNamesData.buildPathsMap());
            }
            for (int commit : this.myPathsForCommits.keySet()) {
                FilePath path = this.myPathsForCommits.get(commit);
                if (path == null) continue;
                if (!this.myNamesData.affects(commit, path)) {
                    this.myExcluded.add(commit);
                }
                if (!this.myNamesData.isTrivialMerge(commit, path)) continue;
                this.myExcluded.add(commit);
            }
            this.myExcluded.forEach(this.myPathsForCommits::remove);
            return !this.myExcluded.isEmpty();
        }

        @NotNull
        public Map<Integer, FilePath> getPathsForCommits() {
            Map<Integer, FilePath> map = this.myPathsForCommits;
            if (map == null) {
                FileHistoryRefiner.$$$reportNull$$$0(3);
            }
            return map;
        }

        @Override
        public void enterNode(int currentNode, int previousNode, boolean down) {
            FilePath previousPath;
            int currentNodeId = this.myVisibleGraph.getNodeId(currentNode);
            int currentCommit = this.myPermanentCommitsInfo.getCommitId(currentNodeId);
            FilePath currentPath = previousPath = (FilePath)ObjectUtils.notNull((Object)ContainerUtil.findLast(this.myPaths, path -> path != null));
            if (previousNode != -1) {
                int previousNodeId = this.myVisibleGraph.getNodeId(previousNode);
                int previousCommit = this.myPermanentCommitsInfo.getCommitId(previousNodeId);
                if (down) {
                    Function pathGetter = parentIndex -> this.myNamesData.getPathInParentRevision(previousCommit, this.myPermanentCommitsInfo.getCommitId((int)parentIndex), previousPath);
                    currentPath = this.findPathWithoutConflict(previousNodeId, (Function<Integer, FilePath>)pathGetter);
                    if (currentPath == null) {
                        int parentIndex2 = BfsUtil.getCorrespondingParent(this.myPermanentLinearGraph, previousNodeId, currentNodeId, this.myVisibilityBuffer);
                        currentPath = (FilePath)pathGetter.fun((Object)parentIndex2);
                    }
                } else {
                    Function pathGetter = parentIndex -> this.myNamesData.getPathInChildRevision(currentCommit, this.myPermanentCommitsInfo.getCommitId((int)parentIndex), previousPath);
                    currentPath = this.findPathWithoutConflict(currentNodeId, (Function<Integer, FilePath>)pathGetter);
                    if (currentPath == null) {
                        int parentIndex3 = BfsUtil.getCorrespondingParent(this.myPermanentLinearGraph, currentNodeId, previousNodeId, this.myVisibilityBuffer);
                        currentPath = (FilePath)pathGetter.fun((Object)parentIndex3);
                    }
                }
            }
            this.myPathsForCommits.put(currentCommit, currentPath);
            this.myPaths.push((Object)currentPath);
        }

        @Nullable
        private FilePath findPathWithoutConflict(int nodeId, @NotNull Function<Integer, FilePath> pathGetter) {
            if (pathGetter == null) {
                FileHistoryRefiner.$$$reportNull$$$0(4);
            }
            List<Integer> parents = this.myPermanentLinearGraph.getNodes(nodeId, LiteLinearGraph.NodeFilter.DOWN);
            FilePath path = (FilePath)pathGetter.fun((Object)parents.get(0));
            if (parents.size() == 1) {
                return path;
            }
            for (Integer parent : ContainerUtil.subList(parents, (int)1)) {
                if (Objects.equals(pathGetter.fun((Object)parent), path)) continue;
                return null;
            }
            return path;
        }

        @Override
        public void exitNode(int node) {
            this.myPaths.pop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visibleGraph";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namesData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryFilterer$FileHistoryRefiner";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathGetter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryFilterer$FileHistoryRefiner";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathsForCommits";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "refine";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findPathWithoutConflict";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

