/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.frame.ReferencesPanel;
import com.intellij.vcs.log.ui.render.LabelIcon;
import com.intellij.vcs.log.ui.render.LabelPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TooltipReferencesPanel
extends ReferencesPanel {
    private static final int REFS_LIMIT = 10;
    @NotNull
    private final LabelPainter myReferencePainter;
    private boolean myHasGroupWithMultipleRefs;

    public TooltipReferencesPanel(@NotNull VcsLogData logData, @NotNull LabelPainter referencePainter, @NotNull Collection<VcsRef> refs) {
        if (logData == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(0);
        }
        if (referencePainter == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(1);
        }
        if (refs == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(2);
        }
        super((LayoutManager)new VerticalFlowLayout(JBUI.scale((int)4), JBUI.scale((int)0)), 10);
        this.myReferencePainter = referencePainter;
        VirtualFile root = ((VcsRef)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(refs))).getRoot();
        this.setReferences(ContainerUtil.sorted(refs, (Comparator)logData.getLogProvider(root).getReferenceManager().getLabelsOrderComparator()));
    }

    @Override
    public void update() {
        this.myHasGroupWithMultipleRefs = false;
        for (Map.Entry typeAndRefs : this.myGroupedVisibleReferences.entrySet()) {
            if (((Collection)typeAndRefs.getValue()).size() <= 1) continue;
            this.myHasGroupWithMultipleRefs = true;
        }
        super.update();
    }

    @Override
    @NotNull
    protected Font getLabelsFont() {
        Font font = this.myReferencePainter.getReferenceFont();
        if (font == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(3);
        }
        return font;
    }

    @Override
    @Nullable
    protected Icon createIcon(@NotNull VcsRefType type, @NotNull Collection<VcsRef> refs, int refIndex, int height) {
        if (type == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(4);
        }
        if (refs == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(5);
        }
        if (refIndex == 0) {
            Color color = type.getBackgroundColor();
            return new LabelIcon(this, height, this.getBackground(), refs.size() > 1 ? ContainerUtil.newArrayList((Object[])new Color[]{color, color}) : Collections.singletonList(color)){

                @Override
                public int getIconWidth() {
                    return this.getWidth(TooltipReferencesPanel.this.myHasGroupWithMultipleRefs ? 2 : 1);
                }
            };
        }
        return TooltipReferencesPanel.createEmptyIcon(height);
    }

    @NotNull
    private static Icon createEmptyIcon(int height) {
        EmptyIcon emptyIcon = EmptyIcon.create((int)LabelIcon.getWidth(height, 2), (int)height);
        if (emptyIcon == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(6);
        }
        return emptyIcon;
    }

    @Override
    @NotNull
    protected JBLabel createRestLabel(int restSize) {
        String gray = ColorUtil.toHex((Color)UIManager.getColor("Button.disabledText"));
        JBLabel jBLabel = this.createLabel("<html><font color=\"#" + gray + "\">... " + restSize + " more in details pane</font></html>", TooltipReferencesPanel.createEmptyIcon(this.getIconHeight()));
        if (jBLabel == null) {
            TooltipReferencesPanel.$$$reportNull$$$0(7);
        }
        return jBLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencePainter";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/render/TooltipReferencesPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/render/TooltipReferencesPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelsFont";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRestLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

