/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.template.formatter;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.intellij.xml.template.formatter.FragmentedTemplateException;
import com.intellij.xml.template.formatter.IndentInheritingBlock;
import com.intellij.xml.template.formatter.TemplateLanguageBlock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateFormatUtil {
    private static final List<PsiElement> EMPTY_PSI_ELEMENT_LIST = new ArrayList<PsiElement>();
    private static final String[] IGNORABLE_ERROR_MESSAGES = new String[]{XmlErrorMessages.message("xml.parsing.closing.tag.matches.nothing", new Object[0]), XmlErrorMessages.message("xml.parsing.closing.tag.name.missing", new Object[0])};

    private TemplateFormatUtil() {
    }

    @NotNull
    static List<PsiElement> findAllMarkupLanguageElementsInside(PsiElement outerLangElement) {
        PsiFile file2 = outerLangElement.getContainingFile();
        if (file2 != null && file2.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
            TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)file2.getViewProvider();
            List<PsiElement> list2 = TemplateFormatUtil.findAllElementsInside(outerLangElement.getTextRange(), viewProvider, false);
            if (list2 == null) {
                TemplateFormatUtil.$$$reportNull$$$0(0);
            }
            return list2;
        }
        List<PsiElement> list3 = EMPTY_PSI_ELEMENT_LIST;
        if (list3 == null) {
            TemplateFormatUtil.$$$reportNull$$$0(1);
        }
        return list3;
    }

    @NotNull
    static List<PsiElement> findAllTemplateLanguageElementsInside(@NotNull PsiElement outerLangElement, @NotNull TemplateLanguageFileViewProvider viewProvider) {
        if (outerLangElement == null) {
            TemplateFormatUtil.$$$reportNull$$$0(2);
        }
        if (viewProvider == null) {
            TemplateFormatUtil.$$$reportNull$$$0(3);
        }
        List<PsiElement> list2 = TemplateFormatUtil.findAllElementsInside(outerLangElement.getTextRange(), viewProvider, true);
        if (list2 == null) {
            TemplateFormatUtil.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    static List<PsiElement> findAllElementsInside(@NotNull TextRange range2, @NotNull TemplateLanguageFileViewProvider viewProvider, boolean fromTemplate) {
        if (range2 == null) {
            TemplateFormatUtil.$$$reportNull$$$0(5);
        }
        if (viewProvider == null) {
            TemplateFormatUtil.$$$reportNull$$$0(6);
        }
        List<PsiElement> list2 = TemplateFormatUtil.findAllElementsInside(range2, viewProvider, viewProvider.getBaseLanguage(), fromTemplate ? viewProvider.getBaseLanguage() : viewProvider.getTemplateDataLanguage());
        if (list2 == null) {
            TemplateFormatUtil.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    public static List<PsiElement> findAllElementsInside(TextRange range2, TemplateLanguageFileViewProvider viewProvider, Language templateLanguage, Language language) {
        ArrayList<PsiElement> matchingElements = new ArrayList<PsiElement>();
        PsiElement currElement = viewProvider.findElementAt(range2.getStartOffset(), language);
        while (currElement instanceof OuterLanguageElement) {
            currElement = currElement.getNextSibling();
        }
        if (currElement != null) {
            currElement = TemplateFormatUtil.findTopmostElementInRange(currElement, range2);
            Pair<Integer, PsiElement> result2 = TemplateFormatUtil.addElementSequence(currElement, templateLanguage, range2, matchingElements, templateLanguage == language);
            int lastOffset = (Integer)result2.first;
            assert (lastOffset >= 0) : "Failed to process elements in range: " + range2;
            if (lastOffset < range2.getEndOffset()) {
                List<PsiElement> moreElements = TemplateFormatUtil.findAllElementsInside(new TextRange(lastOffset, range2.getEndOffset()), viewProvider, templateLanguage, language);
                matchingElements.addAll(moreElements);
            }
        }
        ArrayList<PsiElement> arrayList = matchingElements;
        if (arrayList == null) {
            TemplateFormatUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static Pair<Integer, PsiElement> addElementSequence(PsiElement startElement, Language templateLanguage, TextRange range2, List<PsiElement> targetList, boolean fromTemplate) {
        PsiElement child;
        PsiElement currElement;
        int lastOffset = -1;
        for (currElement = startElement; currElement != null && (lastOffset = currElement.getTextRange().getEndOffset()) <= range2.getEndOffset(); currElement = currElement.getNextSibling()) {
            boolean isTemplateLanguage = currElement.getLanguage().is(templateLanguage);
            if (fromTemplate != isTemplateLanguage) continue;
            targetList.add(currElement);
        }
        if (currElement != null && currElement.getTextRange().intersects(range2) && (child = currElement.getFirstChild()) != null) {
            TemplateFormatUtil.addElementSequence(child, templateLanguage, range2, targetList, fromTemplate);
        }
        return new Pair((Object)lastOffset, (Object)currElement);
    }

    @NotNull
    public static PsiElement findTopmostElementInRange(@NotNull PsiElement original, TextRange fitToRange) {
        if (original == null) {
            TemplateFormatUtil.$$$reportNull$$$0(9);
        }
        PsiElement prevElement = original;
        for (PsiElement currElement = original; currElement != null; currElement = currElement.getParent()) {
            if (currElement instanceof PsiFile || !fitToRange.contains(currElement.getTextRange())) {
                if (!fitToRange.contains(prevElement.getTextRange())) {
                    PsiElement psiElement = original;
                    if (psiElement == null) {
                        TemplateFormatUtil.$$$reportNull$$$0(10);
                    }
                    return psiElement;
                }
                PsiElement psiElement = prevElement;
                if (psiElement == null) {
                    TemplateFormatUtil.$$$reportNull$$$0(11);
                }
                return psiElement;
            }
            prevElement = currElement;
        }
        PsiElement psiElement = original;
        if (psiElement == null) {
            TemplateFormatUtil.$$$reportNull$$$0(12);
        }
        return psiElement;
    }

    static List<Block> mergeBlocks(List<Block> originalBlocks, List<Block> blocksToMerge, TextRange range2) throws FragmentedTemplateException {
        if (blocksToMerge.isEmpty()) {
            return originalBlocks;
        }
        ArrayList<Block> result2 = new ArrayList<Block>();
        if (originalBlocks.isEmpty()) {
            for (Block mergeCandidate : blocksToMerge) {
                if (!range2.contains(mergeCandidate.getTextRange())) continue;
                result2.add(mergeCandidate);
            }
            return result2;
        }
        ArrayList<TextRange> originalRanges = new ArrayList<TextRange>();
        for (Block originalBlock : originalBlocks) {
            originalRanges.add(originalBlock.getTextRange());
        }
        int lastOffset = range2.getStartOffset();
        Iterator<Block> originalBlockIterator = originalBlocks.iterator();
        while (originalBlockIterator.hasNext()) {
            Block mergeableBlock;
            Block originalBlock = originalBlockIterator.next();
            int startOffset = originalBlock.getTextRange().getStartOffset();
            if (lastOffset < startOffset && (lastOffset = TemplateFormatUtil.fillGap(originalRanges, blocksToMerge, result2, lastOffset, startOffset)) < startOffset) {
                lastOffset = TemplateFormatUtil.fillGap(originalRanges, originalBlocks, result2, lastOffset, startOffset);
            }
            if ((mergeableBlock = TemplateFormatUtil.getBlockContaining(blocksToMerge, originalRanges, originalBlock.getTextRange())) != null) {
                if (mergeableBlock.getTextRange().getStartOffset() < lastOffset) continue;
                result2.add(mergeableBlock);
                lastOffset = mergeableBlock.getTextRange().getEndOffset();
                continue;
            }
            if (startOffset < lastOffset) continue;
            result2.add(originalBlock);
            originalBlockIterator.remove();
            lastOffset = originalBlock.getTextRange().getEndOffset();
        }
        if (lastOffset < range2.getEndOffset() && (lastOffset = TemplateFormatUtil.fillGap(originalRanges, blocksToMerge, result2, lastOffset, range2.getEndOffset())) < range2.getEndOffset()) {
            TemplateFormatUtil.fillGap(originalRanges, originalBlocks, result2, lastOffset, range2.getEndOffset());
        }
        return result2;
    }

    private static int fillGap(List<TextRange> originalRanges, List<Block> blocks, List<Block> result2, int startOffset, int endOffset) throws FragmentedTemplateException {
        return TemplateFormatUtil.fillGap(null, originalRanges, blocks, result2, startOffset, endOffset, 0);
    }

    private static int fillGap(@Nullable Block parent, List<TextRange> originalRanges, List<Block> blocks, List<Block> result2, int startOffset, int endOffset, int depth) throws FragmentedTemplateException {
        int lastOffset = startOffset;
        TextRange currRange = new TextRange(lastOffset, endOffset);
        for (Block block : blocks) {
            if (lastOffset == endOffset || block.getTextRange().getStartOffset() > endOffset) {
                return lastOffset;
            }
            if (currRange.contains(block.getTextRange())) {
                result2.add(block);
                if (parent != null && block instanceof IndentInheritingBlock) {
                    ((IndentInheritingBlock)block).setIndent(parent.getIndent());
                }
                lastOffset = block.getTextRange().getEndOffset();
                currRange = new TextRange(lastOffset, endOffset);
                continue;
            }
            if (!currRange.intersects(block.getTextRange()) || !TemplateFormatUtil.intersectsOneOf(block.getTextRange(), originalRanges)) continue;
            List subBlocks = block.getSubBlocks();
            if (block instanceof TemplateLanguageBlock && ((TemplateLanguageBlock)block).containsErrorElements()) {
                throw new FragmentedTemplateException();
            }
            lastOffset = TemplateFormatUtil.fillGap(block, originalRanges, subBlocks, result2, lastOffset, endOffset, depth + 1);
            currRange = new TextRange(lastOffset, endOffset);
        }
        return lastOffset;
    }

    public static boolean intersectsOneOf(TextRange blockRange, List<TextRange> originalRanges) {
        return TemplateFormatUtil.rangesContain(originalRanges, 0, originalRanges.size() - 1, blockRange.getStartOffset()) || TemplateFormatUtil.rangesContain(originalRanges, 0, originalRanges.size() - 1, blockRange.getEndOffset());
    }

    static boolean rangesContain(List<TextRange> ranges, int startIndex, int endIndex, int offset) {
        if (endIndex < startIndex || ranges.size() <= startIndex || ranges.size() <= endIndex) {
            return false;
        }
        int startOffset = ranges.get(startIndex).getStartOffset();
        int endOffset = ranges.get(endIndex).getEndOffset();
        if (offset < startOffset || offset > endOffset) {
            return false;
        }
        if (startIndex == endIndex) {
            return true;
        }
        int midIndex = (endIndex + startIndex) / 2;
        return TemplateFormatUtil.rangesContain(ranges, startIndex, midIndex, offset) || TemplateFormatUtil.rangesContain(ranges, midIndex + 1, endIndex, offset);
    }

    private static Block getBlockContaining(List<Block> blockList, List<TextRange> originalRanges, TextRange range2) {
        return TemplateFormatUtil.getBlockContaining(blockList, originalRanges, range2, 0);
    }

    @Nullable
    private static Block getBlockContaining(List<Block> blockList, List<TextRange> originalRanges, TextRange range2, int depth) {
        for (Block block : blockList) {
            Block containingBlock;
            if (!block.getTextRange().contains(range2)) continue;
            if (TemplateFormatUtil.intersectsOneOf(block.getTextRange(), originalRanges) && (containingBlock = TemplateFormatUtil.getBlockContaining(block.getSubBlocks(), originalRanges, range2, depth + 1)) != null) {
                return containingBlock;
            }
            return block;
        }
        return null;
    }

    @Nullable
    public static Block buildTemplateLanguageBlock(@NotNull OuterLanguageElement outerElement, @NotNull CodeStyleSettings settings, @Nullable Indent indent) {
        if (outerElement == null) {
            TemplateFormatUtil.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            TemplateFormatUtil.$$$reportNull$$$0(14);
        }
        try {
            FormattingModel model;
            Language language;
            FormattingModelBuilder builder;
            PsiFile file2 = outerElement.getContainingFile();
            FileViewProvider viewProvider = outerElement.getContainingFile().getViewProvider();
            if (viewProvider instanceof TemplateLanguageFileViewProvider && (builder = LanguageFormatting.INSTANCE.forContext(language = outerElement.getLanguage(), (PsiElement)outerElement)) instanceof AbstractXmlTemplateFormattingModelBuilder && (model = ((AbstractXmlTemplateFormattingModelBuilder)builder).createTemplateFormattingModel(file2, (TemplateLanguageFileViewProvider)viewProvider, outerElement, settings, indent)) != null) {
                return model.getRootBlock();
            }
        }
        catch (FragmentedTemplateException fragmentedTemplateException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isErrorElement(@NotNull PsiElement element) {
        if (element == null) {
            TemplateFormatUtil.$$$reportNull$$$0(15);
        }
        if (element instanceof PsiErrorElement) {
            String description = ((PsiErrorElement)element).getErrorDescription();
            for (String ignorableMessage : IGNORABLE_ERROR_MESSAGES) {
                if (!ignorableMessage.equals(description)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/template/formatter/TemplateFormatUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerLangElement";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllMarkupLanguageElementsInside";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/template/formatter/TemplateFormatUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllTemplateLanguageElementsInside";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllElementsInside";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopmostElementInRange";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAllTemplateLanguageElementsInside";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAllElementsInside";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findTopmostElementInRange";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplateLanguageBlock";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isErrorElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

