/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckEmptyTagInspection
extends XmlSuppressableInspectionTool {
    @NonNls
    private static final Set<String> ourTagsWithEmptyEndsNotAllowed = new THashSet(Arrays.asList("script", "div", "iframe"));

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CheckEmptyTagInspection.$$$reportNull$$$0(0);
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (XmlExtension.shouldIgnoreSelfClosingTag(tag) || !CheckEmptyTagInspection.isTagWithEmptyEndNotAllowed(tag)) {
                    return;
                }
                ASTNode child = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(tag.getNode());
                if (child == null) {
                    return;
                }
                MyLocalQuickFix fix = new MyLocalQuickFix();
                holder.registerProblem((PsiElement)tag, XmlBundle.message((String)"html.inspections.check.empty.script.message", (Object[])new Object[0]), tag.getContainingFile().getContext() != null ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
            }
        };
        if (xmlElementVisitor == null) {
            CheckEmptyTagInspection.$$$reportNull$$$0(1);
        }
        return xmlElementVisitor;
    }

    public static boolean isTagWithEmptyEndNotAllowed(XmlTag tag) {
        String tagName = tag.getName();
        if (tag instanceof HtmlTag) {
            tagName = tagName.toLowerCase();
        }
        Language language = tag.getLanguage();
        return ourTagsWithEmptyEndsNotAllowed.contains(tagName) && (language.isKindOf((Language)HTMLLanguage.INSTANCE) || language.isKindOf((Language)XHTMLLanguage.INSTANCE)) || language.isKindOf((Language)HTMLLanguage.INSTANCE) && !HtmlUtil.isSingleHtmlTag(tag, false) && tagName.indexOf(58) == -1 && !XmlExtension.isCollapsible(tag);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = XmlInspectionGroupNames.HTML_INSPECTIONS;
        if (string == null) {
            CheckEmptyTagInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.check.empty.tag", (Object[])new Object[0]);
        if (string == null) {
            CheckEmptyTagInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("CheckEmptyScriptTag" == null) {
            CheckEmptyTagInspection.$$$reportNull$$$0(4);
        }
        return "CheckEmptyScriptTag";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/CheckEmptyTagInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/CheckEmptyTagInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLocalQuickFix
    implements LocalQuickFix {
        private MyLocalQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = XmlBundle.message((String)"html.inspections.check.empty.script.tag.fix.message", (Object[])new Object[0]);
            if (string == null) {
                MyLocalQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            XmlTag tag;
            if (project == null) {
                MyLocalQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyLocalQuickFix.$$$reportNull$$$0(2);
            }
            if ((tag = (XmlTag)descriptor.getPsiElement()) == null) {
                return;
            }
            XmlUtil.expandTag(tag);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xml/util/CheckEmptyTagInspection$MyLocalQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xml/util/CheckEmptyTagInspection$MyLocalQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

