/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.DataManager;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaDocumentationProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaCompletionContributor
extends CompletionContributor {
    private static final String BUILTIN_USAGE_KEY = "json.schema.builtin.completion";
    private static final String SCHEMA_USAGE_KEY = "json.schema.schema.completion";
    private static final String USER_USAGE_KEY = "json.schema.user.completion";

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        PsiElement position;
        VirtualFile file2;
        if (parameters == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((file2 = PsiUtilCore.getVirtualFile((PsiElement)(position = parameters.getPosition()))) == null) {
            return;
        }
        JsonSchemaService service = JsonSchemaService.Impl.get(position.getProject());
        JsonSchemaObject rootSchema = service.getSchemaObject(file2);
        if (rootSchema == null) {
            return;
        }
        JsonSchemaCompletionContributor.updateStat(service.getSchemaProvider(rootSchema.getSchemaFile()));
        JsonSchemaCompletionContributor.doCompletion(parameters, result2, rootSchema);
    }

    public static void doCompletion(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, @NotNull JsonSchemaObject rootSchema) {
        if (parameters == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(3);
        }
        if (rootSchema == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(4);
        }
        PsiElement completionPosition = parameters.getOriginalPosition() != null ? parameters.getOriginalPosition() : parameters.getPosition();
        new Worker(rootSchema, parameters.getPosition(), completionPosition, (Consumer<LookupElement>)result2).work();
        result2.stopHere();
    }

    public static List<LookupElement> getCompletionVariants(@NotNull JsonSchemaObject schema, @NotNull PsiElement position, @NotNull PsiElement originalPosition) {
        if (schema == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(5);
        }
        if (position == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(6);
        }
        if (originalPosition == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(7);
        }
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        new Worker(schema, position, originalPosition, (Consumer<LookupElement>)((Consumer)element -> result2.add((LookupElement)element))).work();
        return result2;
    }

    private static void updateStat(@Nullable JsonSchemaFileProvider provider) {
        if (provider == null) {
            return;
        }
        SchemaType schemaType = provider.getSchemaType();
        if (SchemaType.schema.equals((Object)schemaType)) {
            UsageTrigger.trigger(SCHEMA_USAGE_KEY);
        } else if (SchemaType.embeddedSchema.equals((Object)schemaType)) {
            UsageTrigger.trigger(BUILTIN_USAGE_KEY);
        } else if (SchemaType.userSchema.equals((Object)schemaType)) {
            UsageTrigger.trigger(USER_USAGE_KEY);
        }
    }

    public static void insertPropertyWithEnum(InsertionContext context, Editor editor, String defaultValue, List<Object> values, JsonSchemaType type, String comma) {
        boolean isNumber = type != null && (JsonSchemaType._integer.equals((Object)type) || JsonSchemaType._number.equals((Object)type)) || type == null && (defaultValue != null && !StringUtil.isQuotedString((String)defaultValue) || values != null && ContainerUtil.and(values, v -> !(v instanceof String)));
        boolean hasValues = !ContainerUtil.isEmpty(values);
        boolean hasDefaultValue = !StringUtil.isEmpty((String)defaultValue);
        String stringToInsert = ":" + (hasDefaultValue ? defaultValue : (isNumber ? "" : "\"\"")) + comma;
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)1);
        if (!isNumber || hasDefaultValue) {
            SelectionModel model = editor.getSelectionModel();
            int caretStart = model.getSelectionStart();
            int newOffset = caretStart + (hasDefaultValue ? defaultValue.length() : 1);
            if (hasDefaultValue && !isNumber) {
                --newOffset;
            }
            model.setSelection(isNumber ? caretStart : caretStart + 1, newOffset);
            editor.getCaretModel().moveToOffset(newOffset);
        }
        JsonSchemaCompletionContributor.formatInsertedString(context, stringToInsert.length());
        if (hasValues) {
            AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
        }
    }

    public static void formatInsertedString(@NotNull InsertionContext context, int offset) {
        if (context == null) {
            JsonSchemaCompletionContributor.$$$reportNull$$$0(8);
        }
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitDocument(context.getDocument());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformatText(context.getFile(), context.getStartOffset(), context.getTailOffset() + offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSchema";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPosition";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doCompletion";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getCompletionVariants";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "formatInsertedString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Worker {
        @NotNull
        private final JsonSchemaObject myRootSchema;
        @NotNull
        private final PsiElement myPosition;
        @NotNull
        private final PsiElement myOriginalPosition;
        @NotNull
        private final Consumer<LookupElement> myResultConsumer;
        private final boolean myWrapInQuotes;
        private final boolean myInsideStringLiteral;
        private final Set<LookupElement> myVariants;
        private final JsonLikePsiWalker myWalker;

        public Worker(@NotNull JsonSchemaObject rootSchema, @NotNull PsiElement position, @NotNull PsiElement originalPosition, @NotNull Consumer<LookupElement> resultConsumer) {
            if (rootSchema == null) {
                Worker.$$$reportNull$$$0(0);
            }
            if (position == null) {
                Worker.$$$reportNull$$$0(1);
            }
            if (originalPosition == null) {
                Worker.$$$reportNull$$$0(2);
            }
            if (resultConsumer == null) {
                Worker.$$$reportNull$$$0(3);
            }
            this.myRootSchema = rootSchema;
            this.myPosition = position;
            this.myOriginalPosition = originalPosition;
            this.myResultConsumer = resultConsumer;
            this.myVariants = new HashSet<LookupElement>();
            this.myWalker = JsonLikePsiWalker.getWalker(this.myPosition, this.myRootSchema);
            this.myWrapInQuotes = this.myWalker != null && this.myWalker.isNameQuoted() && !(position.getParent() instanceof JsonStringLiteral);
            this.myInsideStringLiteral = position.getParent() instanceof JsonStringLiteral;
        }

        public void work() {
            if (this.myWalker == null) {
                return;
            }
            PsiElement checkable = this.myWalker.goUpToCheckable(this.myPosition);
            if (checkable == null) {
                return;
            }
            boolean isName = this.myWalker.isName(checkable);
            List<JsonSchemaVariantsTreeBuilder.Step> position = this.myWalker.findPosition(checkable, !isName);
            if (position == null || position.isEmpty() && !isName) {
                return;
            }
            Collection<JsonSchemaObject> schemas = new JsonSchemaResolver(this.myRootSchema, false, position).resolve();
            schemas.forEach(schema -> {
                if (isName) {
                    boolean insertComma = this.myWalker.hasPropertiesBehindAndNoComma(this.myPosition);
                    boolean hasValue = this.myWalker.isPropertyWithValue(this.myPosition.getParent().getParent());
                    Set<String> properties = this.myWalker.getPropertyNamesOfParentObject(this.myOriginalPosition);
                    JsonPropertyAdapter adapter = this.myWalker.getParentPropertyAdapter(this.myOriginalPosition);
                    Map<String, JsonSchemaObject> schemaProperties = schema.getProperties();
                    schemaProperties.keySet().stream().filter(name -> !properties.contains(name) || adapter != null && name.equals(adapter.getName())).forEach(name -> this.addPropertyVariant((String)name, (JsonSchemaObject)schemaProperties.get(name), hasValue, insertComma));
                } else {
                    this.suggestValues((JsonSchemaObject)schema);
                }
            });
            for (LookupElement variant : this.myVariants) {
                this.myResultConsumer.consume((Object)variant);
            }
        }

        private void suggestValues(JsonSchemaObject schema) {
            block3: {
                block4: {
                    block2: {
                        this.suggestValuesForSchemaVariants(schema.getAnyOf());
                        this.suggestValuesForSchemaVariants(schema.getOneOf());
                        this.suggestValuesForSchemaVariants(schema.getAllOf());
                        if (schema.getEnum() == null) break block2;
                        for (Object o : schema.getEnum()) {
                            this.addValueVariant(o.toString(), null);
                        }
                        break block3;
                    }
                    JsonSchemaType type = schema.getType();
                    if (type == null) break block4;
                    this.suggestByType(schema, type);
                    break block3;
                }
                if (schema.getTypeVariants() == null) break block3;
                for (JsonSchemaType schemaType : schema.getTypeVariants()) {
                    this.suggestByType(schema, schemaType);
                }
            }
        }

        private void suggestByType(JsonSchemaObject schema, JsonSchemaType type) {
            if (JsonSchemaType._boolean.equals((Object)type)) {
                this.addPossibleBooleanValue(type);
            } else if (JsonSchemaType._string.equals((Object)type)) {
                this.addPossibleStringValue(schema);
            } else if (JsonSchemaType._null.equals((Object)type)) {
                this.addValueVariant("null", null);
            }
        }

        private void addPossibleStringValue(JsonSchemaObject schema) {
            String defaultValueString;
            Object defaultValue = schema.getDefault();
            String string = defaultValueString = defaultValue == null ? null : defaultValue.toString();
            if (!StringUtil.isEmpty((String)defaultValueString)) {
                String quotedValue = defaultValueString;
                if (!StringUtil.isQuotedString((String)quotedValue)) {
                    quotedValue = StringUtil.wrapWithDoubleQuote((String)quotedValue);
                }
                this.addValueVariant(quotedValue, null);
            }
        }

        private void suggestValuesForSchemaVariants(List<JsonSchemaObject> list2) {
            if (list2 != null && list2.size() > 0) {
                for (JsonSchemaObject schemaObject : list2) {
                    this.suggestValues(schemaObject);
                }
            }
        }

        private void addPossibleBooleanValue(JsonSchemaType type) {
            if (JsonSchemaType._boolean.equals((Object)type)) {
                this.addValueVariant("true", null);
                this.addValueVariant("false", null);
            }
        }

        private void addValueVariant(@NotNull String key, @Nullable String description) {
            if (key == null) {
                Worker.$$$reportNull$$$0(4);
            }
            LookupElementBuilder builder = LookupElementBuilder.create((String)(!this.myWrapInQuotes ? StringUtil.unquoteString((String)key) : key));
            if (description != null) {
                builder = builder.withTypeText(description);
            }
            this.myVariants.add((LookupElement)builder);
        }

        private void addPropertyVariant(@NotNull String key, @NotNull JsonSchemaObject jsonSchemaObject, boolean hasValue, boolean insertComma) {
            if (key == null) {
                Worker.$$$reportNull$$$0(5);
            }
            if (jsonSchemaObject == null) {
                Worker.$$$reportNull$$$0(6);
            }
            jsonSchemaObject = (JsonSchemaObject)ObjectUtils.coalesce((Object)ContainerUtil.getFirstItem(new JsonSchemaResolver(jsonSchemaObject).resolve()), (Object)jsonSchemaObject);
            key = !this.myWrapInQuotes ? key : StringUtil.wrapWithDoubleQuote((String)key);
            LookupElementBuilder builder = LookupElementBuilder.create((String)key);
            String typeText = JsonSchemaDocumentationProvider.getBestDocumentation(true, jsonSchemaObject);
            if (!StringUtil.isEmptyOrSpaces((String)typeText)) {
                builder = builder.withTypeText(StringUtil.removeHtmlTags((String)typeText), true);
            }
            JsonSchemaType type = jsonSchemaObject.getType();
            List<Object> values = jsonSchemaObject.getEnum();
            if (type != null || !ContainerUtil.isEmpty(values) || jsonSchemaObject.getDefault() != null) {
                builder = builder.withInsertHandler(this.createPropertyInsertHandler(jsonSchemaObject, hasValue, insertComma));
            } else if (!hasValue) {
                builder = builder.withInsertHandler(this.createDefaultPropertyInsertHandler(false, insertComma));
            }
            this.myVariants.add((LookupElement)builder);
        }

        private InsertHandler<LookupElement> createDefaultPropertyInsertHandler(final boolean hasValue, final boolean insertComma) {
            return new InsertHandler<LookupElement>(){

                public void handleInsert(InsertionContext context, LookupElement item) {
                    ApplicationManager.getApplication().assertWriteAccessAllowed();
                    Editor editor = context.getEditor();
                    Project project = context.getProject();
                    if (this.handleInsideQuotesInsertion(context, editor, hasValue)) {
                        return;
                    }
                    String stringToInsert = ": 1" + (insertComma ? "," : "");
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)2);
                    JsonSchemaCompletionContributor.formatInsertedString(context, stringToInsert.length());
                    int offset = editor.getCaretModel().getOffset();
                    context.getDocument().deleteString(offset, offset + 1);
                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                    AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
                }
            };
        }

        @NotNull
        private InsertHandler<LookupElement> createPropertyInsertHandler(@NotNull JsonSchemaObject jsonSchemaObject, final boolean hasValue, final boolean insertComma) {
            Object defaultValue;
            if (jsonSchemaObject == null) {
                Worker.$$$reportNull$$$0(7);
            }
            JsonSchemaType type = jsonSchemaObject.getType();
            final List<Object> values = jsonSchemaObject.getEnum();
            if (type == null && values != null && !values.isEmpty()) {
                type = Worker.detectType(values);
            }
            final String defaultValueAsString = (defaultValue = jsonSchemaObject.getDefault()) == null || defaultValue instanceof JsonSchemaObject ? null : (defaultValue instanceof String ? "\"" + defaultValue + "\"" : String.valueOf(defaultValue));
            final JsonSchemaType finalType = type;
            InsertHandler<LookupElement> insertHandler = new InsertHandler<LookupElement>(){

                public void handleInsert(InsertionContext context, LookupElement item) {
                    String comma;
                    ApplicationManager.getApplication().assertWriteAccessAllowed();
                    Editor editor = context.getEditor();
                    Project project = context.getProject();
                    String string = comma = insertComma ? "," : "";
                    if (this.handleInsideQuotesInsertion(context, editor, hasValue)) {
                        return;
                    }
                    if (finalType != null) {
                        switch (finalType) {
                            case _object: {
                                String stringToInsert = ":{}" + comma;
                                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)2);
                                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                                JsonSchemaCompletionContributor.formatInsertedString(context, stringToInsert.length());
                                EditorActionHandler handler2 = EditorActionManager.getInstance().getActionHandler("EditorEnter");
                                handler2.execute(editor, editor.getCaretModel().getCurrentCaret(), DataManager.getInstance().getDataContext((Component)editor.getContentComponent()));
                                break;
                            }
                            case _boolean: {
                                String value = String.valueOf(Boolean.TRUE.toString().equals(defaultValueAsString));
                                String stringToInsert = ":" + value + comma;
                                SelectionModel model = editor.getSelectionModel();
                                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)(stringToInsert.length() - comma.length()));
                                JsonSchemaCompletionContributor.formatInsertedString(context, stringToInsert.length());
                                int start = editor.getSelectionModel().getSelectionStart();
                                model.setSelection(start - value.length(), start);
                                AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
                                break;
                            }
                            case _array: {
                                String stringToInsert = ":[]" + comma;
                                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)2);
                                JsonSchemaCompletionContributor.formatInsertedString(context, stringToInsert.length());
                                break;
                            }
                            case _string: 
                            case _integer: {
                                JsonSchemaCompletionContributor.insertPropertyWithEnum(context, editor, defaultValueAsString, values, finalType, comma);
                                break;
                            }
                        }
                    } else {
                        JsonSchemaCompletionContributor.insertPropertyWithEnum(context, editor, defaultValueAsString, values, null, comma);
                    }
                }
            };
            if (insertHandler == null) {
                Worker.$$$reportNull$$$0(8);
            }
            return insertHandler;
        }

        private boolean handleInsideQuotesInsertion(InsertionContext context, Editor editor, boolean hasValue) {
            if (this.myInsideStringLiteral) {
                int endOffset;
                int offset = editor.getCaretModel().getOffset();
                PsiElement element = context.getFile().findElementAt(offset);
                int tailOffset = context.getTailOffset();
                int guessEndOffset = tailOffset + 1;
                if (element != null && (endOffset = element.getTextRange().getEndOffset()) > tailOffset) {
                    context.getDocument().deleteString(tailOffset, endOffset - 1);
                }
                if (hasValue) {
                    return true;
                }
                editor.getCaretModel().moveToOffset(guessEndOffset);
            } else {
                editor.getCaretModel().moveToOffset(context.getTailOffset());
            }
            return false;
        }

        @Nullable
        private static JsonSchemaType detectType(List<Object> values) {
            JsonSchemaType type = null;
            for (Object value : values) {
                JsonSchemaType newType = null;
                if (value instanceof Integer) {
                    newType = JsonSchemaType._integer;
                }
                if (type != null && !type.equals((Object)newType)) {
                    return null;
                }
                type = newType;
            }
            return type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootSchema";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalPosition";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultConsumer";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jsonSchemaObject";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor$Worker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaCompletionContributor$Worker";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPropertyInsertHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addValueVariant";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addPropertyVariant";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createPropertyInsertHandler";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

