/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.intellij.json.psi.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaObject {
    @NonNls
    public static final String DEFINITIONS = "definitions";
    @NonNls
    public static final String PROPERTIES = "properties";
    @NonNls
    public static final String ITEMS = "items";
    @NonNls
    public static final String ADDITIONAL_ITEMS = "additionalItems";
    @NonNls
    public static final String X_INTELLIJ_HTML_DESCRIPTION = "x-intellij-html-description";
    @NotNull
    private final JsonObject myJsonObject;
    @Nullable
    private Map<String, JsonSchemaObject> myDefinitionsMap;
    @NotNull
    private Map<String, JsonSchemaObject> myProperties;
    @Nullable
    private PatternProperties myPatternProperties;
    @Nullable
    private PropertyNamePattern myPattern;
    @Nullable
    private String myId;
    @Nullable
    private String mySchema;
    @Nullable
    private String myTitle;
    @Nullable
    private String myDescription;
    @Nullable
    private String myHtmlDescription;
    @Nullable
    private JsonSchemaType myType;
    @Nullable
    private Object myDefault;
    @Nullable
    private String myRef;
    @Nullable
    private String myFormat;
    @Nullable
    private List<JsonSchemaType> myTypeVariants;
    @Nullable
    private Number myMultipleOf;
    @Nullable
    private Number myMaximum;
    private boolean myExclusiveMaximum;
    @Nullable
    private Number myMinimum;
    private boolean myExclusiveMinimum;
    @Nullable
    private Integer myMaxLength;
    @Nullable
    private Integer myMinLength;
    @Nullable
    private Boolean myAdditionalPropertiesAllowed;
    @Nullable
    private JsonSchemaObject myAdditionalPropertiesSchema;
    @Nullable
    private Boolean myAdditionalItemsAllowed;
    @Nullable
    private JsonSchemaObject myAdditionalItemsSchema;
    @Nullable
    private JsonSchemaObject myItemsSchema;
    @Nullable
    private List<JsonSchemaObject> myItemsSchemaList;
    @Nullable
    private Integer myMaxItems;
    @Nullable
    private Integer myMinItems;
    @Nullable
    private Boolean myUniqueItems;
    @Nullable
    private Integer myMaxProperties;
    @Nullable
    private Integer myMinProperties;
    @Nullable
    private List<String> myRequired;
    @Nullable
    private Map<String, List<String>> myPropertyDependencies;
    @Nullable
    private Map<String, JsonSchemaObject> mySchemaDependencies;
    @Nullable
    private List<Object> myEnum;
    @Nullable
    private List<JsonSchemaObject> myAllOf;
    @Nullable
    private List<JsonSchemaObject> myAnyOf;
    @Nullable
    private List<JsonSchemaObject> myOneOf;
    @Nullable
    private JsonSchemaObject myNot;
    private boolean myShouldValidateAgainstJSType;

    public JsonSchemaObject(@NotNull JsonObject object) {
        if (object == null) {
            JsonSchemaObject.$$$reportNull$$$0(0);
        }
        this.myJsonObject = object;
        this.myProperties = new HashMap<String, JsonSchemaObject>();
    }

    public void mergeValues(@NotNull JsonSchemaObject other) {
        if (other == null) {
            JsonSchemaObject.$$$reportNull$$$0(1);
        }
        this.myProperties.putAll(other.myProperties);
        this.myDefinitionsMap = JsonSchemaObject.copyMap(this.myDefinitionsMap, other.myDefinitionsMap);
        Map<String, JsonSchemaObject> map = JsonSchemaObject.copyMap(this.myPatternProperties == null ? null : this.myPatternProperties.mySchemasMap, other.myPatternProperties == null ? null : other.myPatternProperties.mySchemasMap);
        PatternProperties patternProperties = this.myPatternProperties = map == null ? null : new PatternProperties(map);
        if (!StringUtil.isEmptyOrSpaces((String)other.myTitle)) {
            this.myTitle = other.myTitle;
        }
        if (!StringUtil.isEmptyOrSpaces((String)other.myDescription)) {
            this.myDescription = other.myDescription;
        }
        if (!StringUtil.isEmptyOrSpaces((String)other.myHtmlDescription)) {
            this.myHtmlDescription = other.myHtmlDescription;
        }
        if (other.myType != null) {
            this.myType = other.myType;
        }
        if (other.myDefault != null) {
            this.myDefault = other.myDefault;
        }
        if (other.myRef != null) {
            this.myRef = other.myRef;
        }
        if (other.myFormat != null) {
            this.myFormat = other.myFormat;
        }
        this.myTypeVariants = JsonSchemaObject.copyList(this.myTypeVariants, other.myTypeVariants);
        if (other.myMultipleOf != null) {
            this.myMultipleOf = other.myMultipleOf;
        }
        if (other.myMaximum != null) {
            this.myMaximum = other.myMaximum;
        }
        this.myExclusiveMaximum |= other.myExclusiveMaximum;
        if (other.myMinimum != null) {
            this.myMinimum = other.myMinimum;
        }
        this.myExclusiveMinimum |= other.myExclusiveMinimum;
        if (other.myMaxLength != null) {
            this.myMaxLength = other.myMaxLength;
        }
        if (other.myMinLength != null) {
            this.myMinLength = other.myMinLength;
        }
        if (other.myPattern != null) {
            this.myPattern = other.myPattern;
        }
        if (other.myAdditionalPropertiesAllowed != null) {
            this.myAdditionalPropertiesAllowed = other.myAdditionalPropertiesAllowed;
        }
        if (other.myAdditionalPropertiesSchema != null) {
            this.myAdditionalPropertiesSchema = other.myAdditionalPropertiesSchema;
        }
        if (other.myAdditionalItemsAllowed != null) {
            this.myAdditionalItemsAllowed = other.myAdditionalItemsAllowed;
        }
        if (other.myAdditionalItemsSchema != null) {
            this.myAdditionalItemsSchema = other.myAdditionalItemsSchema;
        }
        if (other.myItemsSchema != null) {
            this.myItemsSchema = other.myItemsSchema;
        }
        this.myItemsSchemaList = JsonSchemaObject.copyList(this.myItemsSchemaList, other.myItemsSchemaList);
        if (other.myMaxItems != null) {
            this.myMaxItems = other.myMaxItems;
        }
        if (other.myMinItems != null) {
            this.myMinItems = other.myMinItems;
        }
        if (other.myUniqueItems != null) {
            this.myUniqueItems = other.myUniqueItems;
        }
        if (other.myMaxProperties != null) {
            this.myMaxProperties = other.myMaxProperties;
        }
        if (other.myMinProperties != null) {
            this.myMinProperties = other.myMinProperties;
        }
        this.myRequired = JsonSchemaObject.copyList(this.myRequired, other.myRequired);
        this.myPropertyDependencies = JsonSchemaObject.copyMap(this.myPropertyDependencies, other.myPropertyDependencies);
        this.mySchemaDependencies = JsonSchemaObject.copyMap(this.mySchemaDependencies, other.mySchemaDependencies);
        if (other.myEnum != null) {
            this.myEnum = other.myEnum;
        }
        this.myAllOf = JsonSchemaObject.copyList(this.myAllOf, other.myAllOf);
        this.myAnyOf = JsonSchemaObject.copyList(this.myAnyOf, other.myAnyOf);
        this.myOneOf = JsonSchemaObject.copyList(this.myOneOf, other.myOneOf);
        if (other.myNot != null) {
            this.myNot = other.myNot;
        }
        this.myShouldValidateAgainstJSType |= other.myShouldValidateAgainstJSType;
    }

    public void shouldValidateAgainstJSType() {
        this.myShouldValidateAgainstJSType = true;
    }

    public boolean isShouldValidateAgainstJSType() {
        return this.myShouldValidateAgainstJSType;
    }

    @Nullable
    private static <T> List<T> copyList(@Nullable List<T> target2, @Nullable List<T> source) {
        if (source == null || source.isEmpty()) {
            return target2;
        }
        if (target2 == null) {
            target2 = new ArrayList<T>();
        }
        target2.addAll(source);
        return target2;
    }

    @Nullable
    private static <K, V> Map<K, V> copyMap(@Nullable Map<K, V> target2, @Nullable Map<K, V> source) {
        if (source == null || source.isEmpty()) {
            return target2;
        }
        if (target2 == null) {
            target2 = new HashMap();
        }
        target2.putAll(source);
        return target2;
    }

    @NotNull
    public VirtualFile getSchemaFile() {
        VirtualFile virtualFile = this.myJsonObject.getContainingFile().getViewProvider().getVirtualFile();
        if (virtualFile == null) {
            JsonSchemaObject.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @NotNull
    public JsonObject getJsonObject() {
        JsonObject jsonObject = this.myJsonObject;
        if (jsonObject == null) {
            JsonSchemaObject.$$$reportNull$$$0(3);
        }
        return jsonObject;
    }

    @Nullable
    public Map<String, JsonSchemaObject> getDefinitionsMap() {
        return this.myDefinitionsMap;
    }

    public void setDefinitionsMap(@NotNull Map<String, JsonSchemaObject> definitionsMap) {
        if (definitionsMap == null) {
            JsonSchemaObject.$$$reportNull$$$0(4);
        }
        this.myDefinitionsMap = definitionsMap;
    }

    @NotNull
    public Map<String, JsonSchemaObject> getProperties() {
        Map<String, JsonSchemaObject> map = this.myProperties;
        if (map == null) {
            JsonSchemaObject.$$$reportNull$$$0(5);
        }
        return map;
    }

    public void setProperties(@NotNull Map<String, JsonSchemaObject> properties) {
        if (properties == null) {
            JsonSchemaObject.$$$reportNull$$$0(6);
        }
        this.myProperties = properties;
    }

    public void setPatternProperties(@NotNull Map<String, JsonSchemaObject> patternProperties) {
        if (patternProperties == null) {
            JsonSchemaObject.$$$reportNull$$$0(7);
        }
        this.myPatternProperties = new PatternProperties(patternProperties);
    }

    @Nullable
    public JsonSchemaType getType() {
        return this.myType;
    }

    public void setType(@Nullable JsonSchemaType type) {
        this.myType = type;
    }

    @Nullable
    public Number getMultipleOf() {
        return this.myMultipleOf;
    }

    public void setMultipleOf(@Nullable Number multipleOf) {
        this.myMultipleOf = multipleOf;
    }

    @Nullable
    public Number getMaximum() {
        return this.myMaximum;
    }

    public void setMaximum(@Nullable Number maximum) {
        this.myMaximum = maximum;
    }

    public boolean isExclusiveMaximum() {
        return this.myExclusiveMaximum;
    }

    public void setExclusiveMaximum(boolean exclusiveMaximum) {
        this.myExclusiveMaximum = exclusiveMaximum;
    }

    @Nullable
    public Number getMinimum() {
        return this.myMinimum;
    }

    public void setMinimum(@Nullable Number minimum) {
        this.myMinimum = minimum;
    }

    public boolean isExclusiveMinimum() {
        return this.myExclusiveMinimum;
    }

    public void setExclusiveMinimum(boolean exclusiveMinimum) {
        this.myExclusiveMinimum = exclusiveMinimum;
    }

    @Nullable
    public Integer getMaxLength() {
        return this.myMaxLength;
    }

    public void setMaxLength(@Nullable Integer maxLength) {
        this.myMaxLength = maxLength;
    }

    @Nullable
    public Integer getMinLength() {
        return this.myMinLength;
    }

    public void setMinLength(@Nullable Integer minLength) {
        this.myMinLength = minLength;
    }

    @Nullable
    public String getPattern() {
        return this.myPattern == null ? null : this.myPattern.getPattern();
    }

    public void setPattern(@Nullable String pattern) {
        this.myPattern = pattern == null ? null : new PropertyNamePattern(pattern);
    }

    @Nullable
    public Boolean getAdditionalPropertiesAllowed() {
        return this.myAdditionalPropertiesAllowed == null || this.myAdditionalPropertiesAllowed != false;
    }

    public void setAdditionalPropertiesAllowed(@Nullable Boolean additionalPropertiesAllowed) {
        this.myAdditionalPropertiesAllowed = additionalPropertiesAllowed;
    }

    @Nullable
    public JsonSchemaObject getAdditionalPropertiesSchema() {
        return this.myAdditionalPropertiesSchema;
    }

    public void setAdditionalPropertiesSchema(@Nullable JsonSchemaObject additionalPropertiesSchema) {
        this.myAdditionalPropertiesSchema = additionalPropertiesSchema;
    }

    @Nullable
    public Boolean getAdditionalItemsAllowed() {
        return this.myAdditionalItemsAllowed == null || this.myAdditionalItemsAllowed != false;
    }

    public void setAdditionalItemsAllowed(@Nullable Boolean additionalItemsAllowed) {
        this.myAdditionalItemsAllowed = additionalItemsAllowed;
    }

    @Nullable
    public JsonSchemaObject getAdditionalItemsSchema() {
        return this.myAdditionalItemsSchema;
    }

    public void setAdditionalItemsSchema(@Nullable JsonSchemaObject additionalItemsSchema) {
        this.myAdditionalItemsSchema = additionalItemsSchema;
    }

    @Nullable
    public JsonSchemaObject getItemsSchema() {
        return this.myItemsSchema;
    }

    public void setItemsSchema(@Nullable JsonSchemaObject itemsSchema) {
        this.myItemsSchema = itemsSchema;
    }

    @Nullable
    public List<JsonSchemaObject> getItemsSchemaList() {
        return this.myItemsSchemaList;
    }

    public void setItemsSchemaList(@Nullable List<JsonSchemaObject> itemsSchemaList) {
        this.myItemsSchemaList = itemsSchemaList;
    }

    @Nullable
    public Integer getMaxItems() {
        return this.myMaxItems;
    }

    public void setMaxItems(@Nullable Integer maxItems) {
        this.myMaxItems = maxItems;
    }

    @Nullable
    public Integer getMinItems() {
        return this.myMinItems;
    }

    public void setMinItems(@Nullable Integer minItems) {
        this.myMinItems = minItems;
    }

    public boolean isUniqueItems() {
        return Boolean.TRUE.equals(this.myUniqueItems);
    }

    public void setUniqueItems(boolean uniqueItems) {
        this.myUniqueItems = uniqueItems;
    }

    @Nullable
    public Integer getMaxProperties() {
        return this.myMaxProperties;
    }

    public void setMaxProperties(@Nullable Integer maxProperties) {
        this.myMaxProperties = maxProperties;
    }

    @Nullable
    public Integer getMinProperties() {
        return this.myMinProperties;
    }

    public void setMinProperties(@Nullable Integer minProperties) {
        this.myMinProperties = minProperties;
    }

    @Nullable
    public List<String> getRequired() {
        return this.myRequired;
    }

    public void setRequired(@Nullable List<String> required) {
        this.myRequired = required;
    }

    @Nullable
    public Map<String, List<String>> getPropertyDependencies() {
        return this.myPropertyDependencies;
    }

    public void setPropertyDependencies(@Nullable Map<String, List<String>> propertyDependencies) {
        this.myPropertyDependencies = propertyDependencies;
    }

    @Nullable
    public Map<String, JsonSchemaObject> getSchemaDependencies() {
        return this.mySchemaDependencies;
    }

    public void setSchemaDependencies(@Nullable Map<String, JsonSchemaObject> schemaDependencies) {
        this.mySchemaDependencies = schemaDependencies;
    }

    @Nullable
    public List<Object> getEnum() {
        return this.myEnum;
    }

    public void setEnum(@Nullable List<Object> anEnum) {
        this.myEnum = anEnum;
    }

    @Nullable
    public List<JsonSchemaObject> getAllOf() {
        return this.myAllOf;
    }

    public void setAllOf(@Nullable List<JsonSchemaObject> allOf) {
        this.myAllOf = allOf;
    }

    @Nullable
    public List<JsonSchemaObject> getAnyOf() {
        return this.myAnyOf;
    }

    public void setAnyOf(@Nullable List<JsonSchemaObject> anyOf) {
        this.myAnyOf = anyOf;
    }

    @Nullable
    public List<JsonSchemaObject> getOneOf() {
        return this.myOneOf;
    }

    public void setOneOf(@Nullable List<JsonSchemaObject> oneOf) {
        this.myOneOf = oneOf;
    }

    @Nullable
    public JsonSchemaObject getNot() {
        return this.myNot;
    }

    public void setNot(@Nullable JsonSchemaObject not) {
        this.myNot = not;
    }

    @Nullable
    public List<JsonSchemaType> getTypeVariants() {
        return this.myTypeVariants;
    }

    public void setTypeVariants(@Nullable List<JsonSchemaType> typeVariants) {
        this.myTypeVariants = typeVariants;
    }

    @Nullable
    public String getRef() {
        return this.myRef;
    }

    public void setRef(@Nullable String ref) {
        this.myRef = ref;
    }

    @Nullable
    public Object getDefault() {
        if (JsonSchemaType._integer.equals((Object)this.myType)) {
            return this.myDefault instanceof Number ? Integer.valueOf(((Number)this.myDefault).intValue()) : this.myDefault;
        }
        return this.myDefault;
    }

    public void setDefault(@Nullable Object aDefault) {
        this.myDefault = aDefault;
    }

    @Nullable
    public String getFormat() {
        return this.myFormat;
    }

    public void setFormat(@Nullable String format) {
        this.myFormat = format;
    }

    @Nullable
    public String getId() {
        return this.myId;
    }

    public void setId(@Nullable String id) {
        this.myId = id;
    }

    @Nullable
    public String getSchema() {
        return this.mySchema;
    }

    public void setSchema(@Nullable String schema) {
        this.mySchema = schema;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@NotNull String description) {
        if (description == null) {
            JsonSchemaObject.$$$reportNull$$$0(8);
        }
        this.myDescription = JsonSchemaObject.unescapeJsonString(description);
    }

    @Nullable
    public String getHtmlDescription() {
        return this.myHtmlDescription;
    }

    public void setHtmlDescription(@NotNull String htmlDescription) {
        if (htmlDescription == null) {
            JsonSchemaObject.$$$reportNull$$$0(9);
        }
        this.myHtmlDescription = JsonSchemaObject.unescapeJsonString(htmlDescription);
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(@NotNull String title) {
        if (title == null) {
            JsonSchemaObject.$$$reportNull$$$0(10);
        }
        this.myTitle = JsonSchemaObject.unescapeJsonString(title);
    }

    private static String unescapeJsonString(@NotNull String text) {
        if (text == null) {
            JsonSchemaObject.$$$reportNull$$$0(11);
        }
        try {
            String object = String.format("{\"prop\": \"%s\"}", text);
            return ((com.google.gson.JsonObject)new Gson().fromJson(object, com.google.gson.JsonObject.class)).get("prop").getAsString();
        }
        catch (JsonParseException e) {
            return text;
        }
    }

    @Nullable
    public JsonSchemaObject getMatchingPatternPropertySchema(@NotNull String name) {
        if (name == null) {
            JsonSchemaObject.$$$reportNull$$$0(12);
        }
        if (this.myPatternProperties == null) {
            return null;
        }
        return this.myPatternProperties.getPatternPropertySchema(name);
    }

    public boolean checkByPattern(@NotNull String value) {
        if (value == null) {
            JsonSchemaObject.$$$reportNull$$$0(13);
        }
        return this.myPattern != null && this.myPattern.checkByPattern(value);
    }

    @Nullable
    public String getPatternError() {
        return this.myPattern == null ? null : this.myPattern.getPatternError();
    }

    @Nullable
    public Map<JsonObject, String> getInvalidPatternProperties() {
        if (this.myPatternProperties != null) {
            Map<String, String> patterns = this.myPatternProperties.getInvalidPatterns();
            return patterns.entrySet().stream().map(entry -> {
                JsonSchemaObject object = this.myPatternProperties.getSchemaForPattern((String)entry.getKey());
                assert (object != null);
                return Pair.create((Object)object.getJsonObject(), entry.getValue());
            }).collect(Collectors.toMap(o -> (JsonObject)o.getFirst(), o -> (String)o.getSecond()));
        }
        return null;
    }

    @Nullable
    public JsonSchemaObject findRelativeDefinition(@NotNull String ref) {
        if (ref == null) {
            JsonSchemaObject.$$$reportNull$$$0(14);
        }
        if ("#".equals(ref) || StringUtil.isEmpty((String)ref)) {
            return this;
        }
        if (!ref.startsWith("#/")) {
            return null;
        }
        ref = ref.substring(2);
        List parts = StringUtil.split((String)ref, (String)"/");
        JsonSchemaObject current = this;
        for (int i = 0; i < parts.size(); ++i) {
            if (current == null) {
                return null;
            }
            String part = (String)parts.get(i);
            if (DEFINITIONS.equals(part)) {
                if (i == parts.size() - 1) {
                    return null;
                }
                String nextPart = (String)parts.get(++i);
                current = current.getDefinitionsMap() == null ? null : current.getDefinitionsMap().get(nextPart);
                continue;
            }
            if (PROPERTIES.equals(part)) {
                if (i == parts.size() - 1) {
                    return null;
                }
                current = current.getProperties().get(parts.get(++i));
                continue;
            }
            if (ITEMS.equals(part)) {
                if (i == parts.size() - 1) {
                    current = current.getItemsSchema();
                    continue;
                }
                Integer next = JsonSchemaObject.tryParseInt((String)parts.get(++i));
                List<JsonSchemaObject> itemsSchemaList = current.getItemsSchemaList();
                if (itemsSchemaList == null || next == null || next >= itemsSchemaList.size()) continue;
                current = itemsSchemaList.get(next);
                continue;
            }
            if (ADDITIONAL_ITEMS.equals(part)) {
                if (i != parts.size() - 1) continue;
                current = current.getAdditionalItemsSchema();
                continue;
            }
            current = current.getDefinitionsMap() == null ? null : current.getDefinitionsMap().get(part);
        }
        return current;
    }

    @Nullable
    private static Integer tryParseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception __) {
            return null;
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchemaObject object = (JsonSchemaObject)o;
        return this.myJsonObject.equals(object.myJsonObject);
    }

    public int hashCode() {
        return this.myJsonObject.hashCode();
    }

    @NotNull
    private static String adaptSchemaPattern(String pattern) {
        pattern = pattern.startsWith("^") || pattern.startsWith("*") || pattern.startsWith(".") ? pattern : ".*" + pattern;
        pattern = pattern.endsWith("+") || pattern.endsWith("*") || pattern.endsWith("$") ? pattern : pattern + ".*";
        String string = pattern = pattern.replace("\\\\", "\\");
        if (string == null) {
            JsonSchemaObject.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static Pair<Pattern, String> compilePattern(@NotNull String pattern) {
        if (pattern == null) {
            JsonSchemaObject.$$$reportNull$$$0(16);
        }
        try {
            return Pair.create((Object)Pattern.compile(JsonSchemaObject.adaptSchemaPattern(pattern)), null);
        }
        catch (PatternSyntaxException e) {
            return Pair.create(null, (Object)e.getMessage());
        }
    }

    public static boolean matchPattern(@NotNull Pattern pattern, @NotNull String s) {
        if (pattern == null) {
            JsonSchemaObject.$$$reportNull$$$0(17);
        }
        if (s == null) {
            JsonSchemaObject.$$$reportNull$$$0(18);
        }
        try {
            return pattern.matcher(StringUtil.newBombedCharSequence((CharSequence)s, (long)300L)).matches();
        }
        catch (ProcessCanceledException e) {
            return false;
        }
        catch (Exception e) {
            Logger.getInstance(JsonSchemaObject.class).info((Throwable)e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionsMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROPERTIES;
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternProperties";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlDescription";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJsonObject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptSchemaPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "mergeValues";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDefinitionsMap";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setProperties";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setPatternProperties";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setHtmlDescription";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTitle";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unescapeJsonString";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingPatternPropertySchema";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkByPattern";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findRelativeDefinition";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "compilePattern";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "matchPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PatternProperties {
        @NotNull
        private final Map<String, JsonSchemaObject> mySchemasMap;
        @NotNull
        private final Map<String, Pattern> myCachedPatterns;
        @NotNull
        private final Map<String, String> myCachedPatternProperties;
        @NotNull
        private final Map<String, String> myInvalidPatterns;

        public PatternProperties(@NotNull Map<String, JsonSchemaObject> schemasMap) {
            if (schemasMap == null) {
                PatternProperties.$$$reportNull$$$0(0);
            }
            this.mySchemasMap = new HashMap<String, JsonSchemaObject>();
            schemasMap.keySet().forEach(key -> {
                if (schemasMap == null) {
                    PatternProperties.$$$reportNull$$$0(5);
                }
                this.mySchemasMap.put(StringUtil.unescapeBackSlashes((String)key), (JsonSchemaObject)schemasMap.get(key));
            });
            this.myCachedPatterns = new HashMap<String, Pattern>();
            this.myCachedPatternProperties = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
            this.myInvalidPatterns = new HashMap<String, String>();
            this.mySchemasMap.keySet().forEach(key -> {
                Pair pair = JsonSchemaObject.compilePattern(key);
                if (pair.getSecond() != null) {
                    this.myInvalidPatterns.put((String)key, (String)pair.getSecond());
                } else {
                    assert (pair.getFirst() != null);
                    this.myCachedPatterns.put((String)key, (Pattern)pair.getFirst());
                }
            });
        }

        @Nullable
        public JsonSchemaObject getPatternPropertySchema(@NotNull String name) {
            String value;
            if (name == null) {
                PatternProperties.$$$reportNull$$$0(1);
            }
            if ((value = this.myCachedPatternProperties.get(name)) != null) {
                assert (this.mySchemasMap.containsKey(value));
                return this.mySchemasMap.get(value);
            }
            value = this.myCachedPatterns.keySet().stream().filter(key -> {
                if (name == null) {
                    PatternProperties.$$$reportNull$$$0(4);
                }
                return JsonSchemaObject.matchPattern(this.myCachedPatterns.get(key), name);
            }).findFirst().orElse(null);
            if (value != null) {
                this.myCachedPatternProperties.put(name, value);
                assert (this.mySchemasMap.containsKey(value));
                return this.mySchemasMap.get(value);
            }
            return null;
        }

        @NotNull
        public Map<String, String> getInvalidPatterns() {
            Map<String, String> map = this.myInvalidPatterns;
            if (map == null) {
                PatternProperties.$$$reportNull$$$0(2);
            }
            return map;
        }

        public JsonSchemaObject getSchemaForPattern(@NotNull String key) {
            if (key == null) {
                PatternProperties.$$$reportNull$$$0(3);
            }
            return this.mySchemasMap.get(key);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schemasMap";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternProperties";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternProperties";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInvalidPatterns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getPatternPropertySchema";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getSchemaForPattern";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getPatternPropertySchema$2";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$new$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PropertyNamePattern {
        @NotNull
        private final String myPattern;
        @Nullable
        private final Pattern myCompiledPattern;
        @Nullable
        private final String myPatternError;
        @NotNull
        private final Map<String, Boolean> myValuePatternCache;

        public PropertyNamePattern(@NotNull String pattern) {
            if (pattern == null) {
                PropertyNamePattern.$$$reportNull$$$0(0);
            }
            this.myPattern = StringUtil.unescapeBackSlashes((String)pattern);
            Pair pair = JsonSchemaObject.compilePattern(pattern);
            this.myPatternError = (String)pair.getSecond();
            this.myCompiledPattern = (Pattern)pair.getFirst();
            this.myValuePatternCache = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
        }

        @Nullable
        public String getPatternError() {
            return this.myPatternError;
        }

        boolean checkByPattern(@NotNull String name) {
            if (name == null) {
                PropertyNamePattern.$$$reportNull$$$0(1);
            }
            if (this.myPatternError != null) {
                return true;
            }
            if (Boolean.TRUE.equals(this.myValuePatternCache.get(name))) {
                return true;
            }
            assert (this.myCompiledPattern != null);
            boolean matches = JsonSchemaObject.matchPattern(this.myCompiledPattern, name);
            this.myValuePatternCache.put(name, matches);
            return matches;
        }

        @NotNull
        public String getPattern() {
            String string = this.myPattern;
            if (string == null) {
                PropertyNamePattern.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PropertyNamePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PropertyNamePattern";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "checkByPattern";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

