/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicClearableLazyValue;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.jsonSchema.JsonSchemaVfsListener;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaServiceImpl
implements JsonSchemaService {
    @NotNull
    private final Project myProject;
    private final MyState myState;
    private final AtomicLong myAnyChangeCount;
    private final ModificationTracker myAnySchemaChangeTracker;

    public JsonSchemaServiceImpl(@NotNull Project project) {
        if (project == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(0);
        }
        this.myAnyChangeCount = new AtomicLong(0L);
        this.myProject = project;
        this.myState = new MyState(() -> this.getProvidersFromFactories());
        this.myAnySchemaChangeTracker = () -> this.myAnyChangeCount.get();
        project.getMessageBus().connect().subscribe(JsonSchemaVfsListener.JSON_SCHEMA_CHANGED, this.myAnyChangeCount::incrementAndGet);
        JsonSchemaVfsListener.startListening(project, this);
    }

    @Override
    public ModificationTracker getAnySchemaChangeTracker() {
        return this.myAnySchemaChangeTracker;
    }

    private List<JsonSchemaFileProvider> getProvidersFromFactories() {
        ArrayList<JsonSchemaFileProvider> providers = new ArrayList<JsonSchemaFileProvider>();
        for (JsonSchemaProviderFactory factory : this.getProviderFactories()) {
            try {
                providers.addAll(factory.getProviders(this.myProject));
            }
            catch (Exception e) {
                Logger.getInstance(JsonSchemaService.class).error((Throwable)e);
            }
        }
        return providers;
    }

    @NotNull
    protected JsonSchemaProviderFactory[] getProviderFactories() {
        JsonSchemaProviderFactory[] jsonSchemaProviderFactoryArray = (JsonSchemaProviderFactory[])JsonSchemaProviderFactory.EP_NAME.getExtensions();
        if (jsonSchemaProviderFactoryArray == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(1);
        }
        return jsonSchemaProviderFactoryArray;
    }

    @Override
    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(2);
        }
        return this.myState.getProvider(schemaFile);
    }

    @Override
    public void reset() {
        this.myState.reset();
        this.myAnyChangeCount.incrementAndGet();
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    @Override
    @Nullable
    public VirtualFile findSchemaFileByReference(@NotNull String reference, @Nullable VirtualFile referent) {
        if (reference == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(3);
        }
        Optional<VirtualFile> optional = this.myState.getFiles().stream().filter(file2 -> {
            if (reference == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(16);
            }
            return reference.equals(JsonSchemaReader.readSchemaId(this.myProject, file2));
        }).findFirst();
        return optional.orElseGet(() -> {
            if (reference == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(15);
            }
            return JsonSchemaServiceImpl.getSchemaFileByRefAsLocalFile(reference, referent);
        });
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getSchemaFilesForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(4);
        }
        Collection collection = this.myState.getProviders().stream().filter(provider -> {
            if (file2 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(14);
            }
            return JsonSchemaServiceImpl.isProviderAvailable(file2, provider);
        }).map(processor2 -> processor2.getSchemaFile()).collect(Collectors.toList());
        if (collection == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull VirtualFile file2) {
        JsonSchemaFileProvider selected;
        List providers;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(6);
        }
        if ((providers = this.myState.getProviders().stream().filter(provider -> {
            if (file2 == null) {
                JsonSchemaServiceImpl.$$$reportNull$$$0(13);
            }
            return JsonSchemaServiceImpl.isProviderAvailable(file2, provider);
        }).collect(Collectors.toList())).isEmpty() || providers.size() > 2) {
            return null;
        }
        if (providers.size() > 1) {
            Optional<JsonSchemaFileProvider> userSchema = providers.stream().filter(provider -> SchemaType.userSchema.equals((Object)provider.getSchemaType())).findFirst();
            if (!userSchema.isPresent()) {
                return null;
            }
            selected = userSchema.get();
        } else {
            selected = (JsonSchemaFileProvider)providers.get(0);
        }
        if (selected.getSchemaFile() == null) {
            return null;
        }
        return this.readCachedObject(selected.getSchemaFile());
    }

    @Override
    @Nullable
    public JsonSchemaObject getSchemaObjectForSchemaFile(@NotNull VirtualFile schemaFile) {
        if (schemaFile == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(7);
        }
        return this.readCachedObject(schemaFile);
    }

    @Override
    public boolean isSchemaFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(8);
        }
        return this.myState.getFiles().contains(file2);
    }

    @Nullable
    private JsonSchemaObject readCachedObject(@NotNull VirtualFile schemaFile) {
        PsiFile psiFile;
        if (schemaFile == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(9);
        }
        if (!((psiFile = PsiManager.getInstance((Project)this.myProject).findFile(schemaFile)) instanceof JsonFile)) {
            return null;
        }
        CachedValueProvider provider = () -> {
            JsonObject topLevelValue = (JsonObject)ObjectUtils.tryCast((Object)((JsonFile)psiFile).getTopLevelValue(), JsonObject.class);
            JsonSchemaObject object = topLevelValue == null ? null : new JsonSchemaReader().read(topLevelValue);
            return CachedValueProvider.Result.create((Object)object, (Object[])new Object[]{psiFile});
        };
        return (JsonSchemaObject)ReadAction.compute(() -> (JsonSchemaObject)CachedValuesManager.getCachedValue((PsiElement)psiFile, (CachedValueProvider)provider));
    }

    private static boolean isProviderAvailable(@NotNull VirtualFile file2, @NotNull JsonSchemaFileProvider provider) {
        FileType type;
        if (file2 == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(10);
        }
        if (provider == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(11);
        }
        boolean isJson = (type = file2.getFileType()) instanceof LanguageFileType && ((LanguageFileType)type).getLanguage().isKindOf((Language)JsonLanguage.INSTANCE);
        return (isJson || !SchemaType.userSchema.equals((Object)provider.getSchemaType())) && provider.isAvailable(file2);
    }

    @Nullable
    private static VirtualFile getSchemaFileByRefAsLocalFile(@NotNull String id, @Nullable VirtualFile referent) {
        VirtualFile dir;
        String normalizedId;
        if (id == null) {
            JsonSchemaServiceImpl.$$$reportNull$$$0(12);
        }
        if (FileUtil.isAbsolute((String)(normalizedId = JsonSchemaService.normalizeId(id))) || referent == null) {
            return VfsUtil.findFileByIoFile((File)new File(normalizedId), (boolean)false);
        }
        VirtualFile virtualFile = dir = referent.isDirectory() ? referent : referent.getParent();
        if (dir != null && dir.isValid()) {
            List parts = StringUtil.split((String)normalizedId.replace("\\", "/"), (String)"/");
            return VfsUtil.findRelativeFile((VirtualFile)dir, (String[])ArrayUtil.toStringArray((Collection)parts));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl";
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 3: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderFactories";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaFilesForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaProvider";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findSchemaFileByReference";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaFilesForFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaObject";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaObjectForSchemaFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSchemaFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readCachedObject";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isProviderAvailable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaFileByRefAsLocalFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSchemaObject$6";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSchemaFilesForFile$4";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findSchemaFileByReference$3";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findSchemaFileByReference$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyState {
        @NotNull
        private final Factory<List<JsonSchemaFileProvider>> myFactory;
        @NotNull
        private final AtomicClearableLazyValue<Map<VirtualFile, JsonSchemaFileProvider>> myData;

        private MyState(@NotNull Factory<List<JsonSchemaFileProvider>> factory) {
            if (factory == null) {
                MyState.$$$reportNull$$$0(0);
            }
            this.myFactory = factory;
            this.myData = new AtomicClearableLazyValue<Map<VirtualFile, JsonSchemaFileProvider>>(){

                @NotNull
                public Map<VirtualFile, JsonSchemaFileProvider> compute() {
                    Map<VirtualFile, JsonSchemaFileProvider> map = Collections.unmodifiableMap(MyState.createFileProviderMap((List)myFactory.create()));
                    if (map == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return map;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState$1", "compute"));
                }
            };
        }

        public void reset() {
            this.myData.drop();
        }

        @NotNull
        public Collection<JsonSchemaFileProvider> getProviders() {
            Collection<JsonSchemaFileProvider> collection = ((Map)this.myData.getValue()).values();
            if (collection == null) {
                MyState.$$$reportNull$$$0(1);
            }
            return collection;
        }

        @NotNull
        public Set<VirtualFile> getFiles() {
            Set<VirtualFile> set2 = ((Map)this.myData.getValue()).keySet();
            if (set2 == null) {
                MyState.$$$reportNull$$$0(2);
            }
            return set2;
        }

        @Nullable
        public JsonSchemaFileProvider getProvider(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyState.$$$reportNull$$$0(3);
            }
            return (JsonSchemaFileProvider)((Map)this.myData.getValue()).get(file2);
        }

        private static Map<VirtualFile, JsonSchemaFileProvider> createFileProviderMap(@NotNull List<JsonSchemaFileProvider> list2) {
            if (list2 == null) {
                MyState.$$$reportNull$$$0(4);
            }
            HashMap<VirtualFile, JsonSchemaFileProvider> map = new HashMap<VirtualFile, JsonSchemaFileProvider>();
            list2.stream().filter(provider -> provider.getSchemaFile() != null).forEach(provider -> map.put(provider.getSchemaFile(), (JsonSchemaFileProvider)provider));
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaServiceImpl$MyState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProviders";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getProvider";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createFileProviderMap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

