/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.util;

import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageInfoReader {
    private static final Logger LOG = Logger.getInstance((String)"#org.intellij.images.util.ImageInfoReader");

    private ImageInfoReader() {
    }

    @Nullable
    public static Info getInfo(@NotNull String file2) {
        if (file2 == null) {
            ImageInfoReader.$$$reportNull$$$0(0);
        }
        return ImageInfoReader.read(new File(file2));
    }

    @Nullable
    public static Info getInfo(@NotNull byte[] data) {
        if (data == null) {
            ImageInfoReader.$$$reportNull$$$0(1);
        }
        return ImageInfoReader.read(new ByteArrayInputStream(data));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Info read(@NotNull Object input) {
        if (input == null) {
            ImageInfoReader.$$$reportNull$$$0(2);
        }
        try (ImageInputStream iis = ImageIO.createImageInputStream(input);){
            Iterator<ImageReader> it = ImageIO.getImageReaders(iis);
            ImageReader reader = it.hasNext() ? it.next() : null;
            if (reader == null) return null;
            reader.setInput(iis, true);
            int w = reader.getWidth(0);
            int h = reader.getHeight(0);
            Iterator<ImageTypeSpecifier> it2 = reader.getImageTypes(0);
            int bpp = it2 != null && it2.hasNext() ? it2.next().getColorModel().getPixelSize() : -1;
            Info info = new Info(w, h, bpp);
            return info;
        }
        catch (Throwable e) {
            LOG.warn(e);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        objectArray2[1] = "org/intellij/images/util/ImageInfoReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Info {
        public int width;
        public int height;
        public int bpp;

        public Info(int width, int height, int bpp) {
            this.width = width;
            this.height = height;
            this.bpp = bpp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Info)) {
                return false;
            }
            Info info = (Info)o;
            if (this.width != info.width) {
                return false;
            }
            if (this.height != info.height) {
                return false;
            }
            return this.bpp == info.bpp;
        }

        public int hashCode() {
            int result2 = this.width;
            result2 = 31 * result2 + this.height;
            result2 = 31 * result2 + this.bpp;
            return result2;
        }
    }
}

