/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.DefaultWebServerPathHandlerKt;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerFileHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandler;
import org.jetbrains.builtInWebServer.WebServerPathHandlerKt;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerPathToFileManagerKt;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0004H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/builtInWebServer/DefaultWebServerPathHandler;", "Lorg/jetbrains/builtInWebServer/WebServerPathHandler;", "()V", "process", "", "path", "", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "projectName", "decodedRawPath", "isCustomHost", "intellij.platform.builtInServer.impl"})
final class DefaultWebServerPathHandler
extends WebServerPathHandler {
    @Override
    public boolean process(@NotNull String path, @NotNull Project project, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context, @NotNull String projectName, @NotNull String decodedRawPath, boolean isCustomHost) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        Intrinsics.checkParameterIsNotNull((Object)decodedRawPath, (String)"decodedRawPath");
        Channel channel = context.channel();
        EmptyHttpHeaders extraHeaders = EmptyHttpHeaders.INSTANCE;
        WebServerPathToFileManager pathToFileManager = WebServerPathToFileManager.Companion.getInstance(project);
        PathInfo pathInfo = (PathInfo)pathToFileManager.getPathToInfoCache().getIfPresent((Object)path);
        if (pathInfo == null || !pathInfo.isValid()) {
            pathInfo = pathToFileManager.doFindByRelativePath$intellij_platform_builtInServer_impl(path, WebServerPathToFileManagerKt.getDefaultPathQuery());
            if (pathInfo == null) {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
                Channel channel2 = channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)channel2, (String)"channel");
                Responses.send$default(httpResponseStatus, channel2, (HttpRequest)request, null, (HttpHeaders)extraHeaders, 4, null);
                return true;
            }
            pathToFileManager.getPathToInfoCache().put((Object)path, (Object)pathInfo);
        }
        boolean indexUsed = false;
        if (pathInfo.isDirectory()) {
            VirtualFile indexVirtualFile = null;
            Path indexFile = null;
            if (pathInfo.getFile() == null) {
                Path path2 = pathInfo.getIoFile();
                if (path2 == null) {
                    Intrinsics.throwNpe();
                }
                indexFile = BuiltInWebServerKt.findIndexFile(path2);
            } else {
                VirtualFile virtualFile = pathInfo.getFile();
                if (virtualFile == null) {
                    Intrinsics.throwNpe();
                }
                indexVirtualFile = BuiltInWebServerKt.findIndexFile(virtualFile);
            }
            if (indexFile == null && indexVirtualFile == null) {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
                Channel channel3 = channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)channel3, (String)"channel");
                Responses.send$default(httpResponseStatus, channel3, (HttpRequest)request, null, (HttpHeaders)extraHeaders, 4, null);
                return true;
            }
            if (!FileUtilKt.endsWithSlash(decodedRawPath)) {
                HttpRequest httpRequest = (HttpRequest)request;
                Channel channel4 = channel;
                Intrinsics.checkExpressionValueIsNotNull((Object)channel4, (String)"channel");
                WebServerPathHandlerKt.redirectToDirectory(httpRequest, channel4, isCustomHost ? path : "" + projectName + '/' + path, (HttpHeaders)extraHeaders);
                return true;
            }
            indexUsed = true;
            pathInfo = new PathInfo(indexFile, indexVirtualFile, pathInfo.getRoot(), pathInfo.getModuleName(), pathInfo.isLibrary(), false, 32, null);
            pathToFileManager.getPathToInfoCache().put((Object)path, (Object)pathInfo);
        }
        if (!indexUsed && !FileUtilKt.endsWithName(path, pathInfo.getName())) {
            if (FileUtilKt.endsWithSlash(decodedRawPath)) {
                indexUsed = true;
            } else {
                String parentPath = FileUtilKt.getParentPath(pathInfo.getPath());
                if (parentPath != null) {
                    String string = PathUtilRt.getFileName((String)parentPath);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.getFileName(parentPath)");
                    if (FileUtilKt.endsWithName(path, string)) {
                        HttpRequest httpRequest = (HttpRequest)request;
                        Channel channel5 = channel;
                        Intrinsics.checkExpressionValueIsNotNull((Object)channel5, (String)"channel");
                        WebServerPathHandlerKt.redirectToDirectory(httpRequest, channel5, isCustomHost ? path : "" + projectName + '/' + path, (HttpHeaders)extraHeaders);
                        return true;
                    }
                }
            }
        }
        Channel channel6 = channel;
        Intrinsics.checkExpressionValueIsNotNull((Object)channel6, (String)"channel");
        if (!DefaultWebServerPathHandlerKt.access$checkAccess(pathInfo, channel6, (HttpRequest)request)) {
            return true;
        }
        String canonicalPath = indexUsed ? "" + path + '/' + pathInfo.getName() : path;
        ExtensionPointName<WebServerFileHandler> extensionPointName = WebServerFileHandler.Companion.getEP_NAME$intellij_platform_builtInServer_impl();
        Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"WebServerFileHandler.EP_NAME");
        for (WebServerFileHandler fileHandler : (WebServerFileHandler[])extensionPointName.getExtensions()) {
            Intrinsics.checkExpressionValueIsNotNull((Object)BuiltInWebServerKt.getLOG(), (String)"LOG");
            try {
                PathInfo pathInfo2 = pathInfo;
                if (pathInfo2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)pathInfo2, (String)"pathInfo!!");
                CharSequence charSequence = canonicalPath;
                String string = isCustomHost ? null : projectName;
                EmptyHttpHeaders emptyHttpHeaders = extraHeaders;
                Intrinsics.checkExpressionValueIsNotNull((Object)emptyHttpHeaders, (String)"extraHeaders");
                if (!fileHandler.process(pathInfo2, charSequence, project, request, channel, string, (HttpHeaders)emptyHttpHeaders)) continue;
                return true;
            }
            catch (ProcessCanceledException e$iv) {
            }
            catch (Throwable e$iv) {
                Logger $receiver$iv;
                $receiver$iv.error(e$iv);
            }
        }
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
        Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.NOT_FOUND");
        Responses.send$default(httpResponseStatus, channel, (HttpRequest)request, null, (HttpHeaders)extraHeaders, 4, null);
        return true;
    }
}

