/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;
import org.gradle.api.internal.tasks.testing.junit.AbstractJUnitTestClassProcessor;
import org.gradle.api.internal.tasks.testing.junit.JUnitSpec;
import org.gradle.api.internal.tasks.testing.junit.TestClassExecutionListener;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformSpec;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestExecutionListener;
import org.gradle.api.internal.tasks.testing.junitplatform.VintageTestNameAdapter;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public class JUnitPlatformTestClassProcessor
extends AbstractJUnitTestClassProcessor<JUnitPlatformSpec> {
    private TestResultProcessor resultProcessor;
    private TestClassExecutionListener executionListener;
    private CollectAllTestClassesExecutor testClassExecutor;

    public JUnitPlatformTestClassProcessor(JUnitPlatformSpec spec, IdGenerator<?> idGenerator, ActorFactory actorFactory, Clock clock) {
        super((JUnitSpec)spec, idGenerator, actorFactory, clock);
    }

    protected Action<String> createTestExecutor(TestResultProcessor threadSafeResultProcessor, TestClassExecutionListener threadSafeTestClassListener) {
        this.resultProcessor = threadSafeResultProcessor;
        this.executionListener = threadSafeTestClassListener;
        this.testClassExecutor = new CollectAllTestClassesExecutor();
        return this.testClassExecutor;
    }

    public void stop() {
        this.testClassExecutor.processAllTestClasses();
        super.stop();
    }

    public void stopNow() {
        throw new UnsupportedOperationException("stopNow() should not be invoked on remote worker TestClassProcessor");
    }

    private boolean isTopClass(Class<?> klass) {
        return klass.getEnclosingClass() == null;
    }

    private Class<?> loadClass(String className) {
        try {
            ClassLoader applicationClassloader = Thread.currentThread().getContextClassLoader();
            return Class.forName(className, false, applicationClassloader);
        }
        catch (ClassNotFoundException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private LauncherDiscoveryRequest createLauncherDiscoveryRequest(List<Class<?>> testClasses) {
        List classSelectors = testClasses.stream().map(DiscoverySelectors::selectClass).collect(Collectors.toList());
        LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request().selectors(classSelectors);
        this.addTestNameFilters(requestBuilder);
        this.addEnginesFilter(requestBuilder);
        this.addTagsFilter(requestBuilder);
        return requestBuilder.build();
    }

    private void addEnginesFilter(LauncherDiscoveryRequestBuilder requestBuilder) {
        if (!((JUnitPlatformSpec)this.spec).getIncludeEngines().isEmpty()) {
            requestBuilder.filters(new Filter[]{EngineFilter.includeEngines((List)((JUnitPlatformSpec)this.spec).getIncludeEngines())});
        }
        if (!((JUnitPlatformSpec)this.spec).getExcludeEngines().isEmpty()) {
            requestBuilder.filters(new Filter[]{EngineFilter.excludeEngines((List)((JUnitPlatformSpec)this.spec).getExcludeEngines())});
        }
    }

    private void addTagsFilter(LauncherDiscoveryRequestBuilder requestBuilder) {
        if (!((JUnitPlatformSpec)this.spec).getIncludeTags().isEmpty()) {
            requestBuilder.filters(new Filter[]{TagFilter.includeTags((List)((JUnitPlatformSpec)this.spec).getIncludeTags())});
        }
        if (!((JUnitPlatformSpec)this.spec).getExcludeTags().isEmpty()) {
            requestBuilder.filters(new Filter[]{TagFilter.excludeTags((List)((JUnitPlatformSpec)this.spec).getExcludeTags())});
        }
    }

    private void addTestNameFilters(LauncherDiscoveryRequestBuilder requestBuilder) {
        if (!((JUnitPlatformSpec)this.spec).getIncludedTests().isEmpty() || !((JUnitPlatformSpec)this.spec).getIncludedTestsCommandLine().isEmpty()) {
            TestSelectionMatcher matcher = new TestSelectionMatcher((Collection)((JUnitPlatformSpec)this.spec).getIncludedTests(), (Collection)((JUnitPlatformSpec)this.spec).getIncludedTestsCommandLine());
            requestBuilder.filters(new Filter[]{new ClassMethodNameFilter(matcher)});
        }
    }

    private static class ClassMethodNameFilter
    implements PostDiscoveryFilter {
        private final TestSelectionMatcher matcher;

        private ClassMethodNameFilter(TestSelectionMatcher matcher) {
            this.matcher = matcher;
        }

        public FilterResult apply(TestDescriptor descriptor) {
            if (this.classMatch(descriptor)) {
                return FilterResult.included((String)"Class match");
            }
            if (this.shouldRun(descriptor)) {
                return FilterResult.included((String)"Method or class match");
            }
            return FilterResult.excluded((String)"Method or class mismatch");
        }

        private boolean shouldRun(TestDescriptor descriptor) {
            Optional source = descriptor.getSource();
            if (!source.isPresent()) {
                return true;
            }
            if (source.get() instanceof MethodSource) {
                MethodSource methodSource = (MethodSource)source.get();
                return this.matcher.matchesTest(methodSource.getClassName(), methodSource.getMethodName());
            }
            if (source.get() instanceof ClassSource) {
                for (TestDescriptor child : descriptor.getChildren()) {
                    if (!this.shouldRun(child)) continue;
                    return true;
                }
                if (VintageTestNameAdapter.isVintageDynamicLeafTest(descriptor, (TestSource)source.get())) {
                    return this.shouldRunVintageDynamicTest(descriptor);
                }
            }
            return false;
        }

        private boolean classMatch(TestDescriptor descriptor) {
            while (descriptor.getParent().isPresent()) {
                if (this.isClass(descriptor) && this.matcher.matchesTest(this.className(descriptor), null)) {
                    return true;
                }
                descriptor = (TestDescriptor)descriptor.getParent().get();
            }
            return false;
        }

        private boolean isClass(TestDescriptor descriptor) {
            return descriptor.getSource().isPresent() && descriptor.getSource().get() instanceof ClassSource;
        }

        private String className(TestDescriptor descriptor) {
            return ((ClassSource)ClassSource.class.cast(descriptor.getSource().get())).getClassName();
        }

        private boolean shouldRunVintageDynamicTest(TestDescriptor descriptor) {
            return this.matcher.matchesTest(VintageTestNameAdapter.vintageDynamicClassName(descriptor.getUniqueId()), VintageTestNameAdapter.vintageDynamicMethodName(descriptor.getUniqueId()));
        }
    }

    private class CollectAllTestClassesExecutor
    implements Action<String> {
        private final List<Class<?>> testClasses = new ArrayList();

        private CollectAllTestClassesExecutor() {
        }

        public void execute(String testClassName) {
            Class klass = JUnitPlatformTestClassProcessor.this.loadClass(testClassName);
            if (JUnitPlatformTestClassProcessor.this.isTopClass(klass)) {
                this.testClasses.add(klass);
            }
        }

        private void processAllTestClasses() {
            Launcher launcher = LauncherFactory.create();
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{new JUnitPlatformTestExecutionListener(JUnitPlatformTestClassProcessor.this.resultProcessor, JUnitPlatformTestClassProcessor.this.clock, JUnitPlatformTestClassProcessor.this.idGenerator, JUnitPlatformTestClassProcessor.this.executionListener)});
            launcher.execute(JUnitPlatformTestClassProcessor.this.createLauncherDiscoveryRequest(this.testClasses), new TestExecutionListener[0]);
        }
    }
}

