/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import java.io.Closeable;

public abstract class SQLiteClosable
implements Closeable {
    private int mReferenceCount = 1;

    protected abstract void onAllReferencesReleased();

    @Deprecated
    protected void onAllReferencesReleasedFromContainer() {
        this.onAllReferencesReleased();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireReference() {
        SQLiteClosable sQLiteClosable = this;
        synchronized (sQLiteClosable) {
            if (this.mReferenceCount <= 0) {
                throw new IllegalStateException("attempt to re-open an already-closed object: " + this);
            }
            ++this.mReferenceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseReference() {
        boolean refCountIsZero = false;
        SQLiteClosable sQLiteClosable = this;
        synchronized (sQLiteClosable) {
            refCountIsZero = --this.mReferenceCount == 0;
        }
        if (refCountIsZero) {
            this.onAllReferencesReleased();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void releaseReferenceFromContainer() {
        boolean refCountIsZero = false;
        SQLiteClosable sQLiteClosable = this;
        synchronized (sQLiteClosable) {
            refCountIsZero = --this.mReferenceCount == 0;
        }
        if (refCountIsZero) {
            this.onAllReferencesReleasedFromContainer();
        }
    }

    @Override
    public void close() {
        this.releaseReference();
    }
}

