/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.LinearGradient_Delegate;
import android.graphics.Shader;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class LinearGradient
extends Shader {
    private static final int TYPE_COLORS_AND_POSITIONS = 1;
    private static final int TYPE_COLOR_START_AND_COLOR_END = 2;
    private int mType;
    private float mX0;
    private float mY0;
    private float mX1;
    private float mY1;
    private int[] mColors;
    private float[] mPositions;
    private int mColor0;
    private int mColor1;
    private Shader.TileMode mTileMode;

    public LinearGradient(float x0, float y0, float x1, float y1, int[] colors, float[] positions, Shader.TileMode tile) {
        if (colors.length < 2) {
            throw new IllegalArgumentException("needs >= 2 number of colors");
        }
        if (positions != null && colors.length != positions.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
        this.mType = 1;
        this.mX0 = x0;
        this.mY0 = y0;
        this.mX1 = x1;
        this.mY1 = y1;
        this.mColors = (int[])colors.clone();
        this.mPositions = positions != null ? (float[])positions.clone() : null;
        this.mTileMode = tile;
    }

    public LinearGradient(float x0, float y0, float x1, float y1, int color0, int color1, Shader.TileMode tile) {
        this.mType = 2;
        this.mX0 = x0;
        this.mY0 = y0;
        this.mX1 = x1;
        this.mY1 = y1;
        this.mColor0 = color0;
        this.mColor1 = color1;
        this.mColors = null;
        this.mPositions = null;
        this.mTileMode = tile;
    }

    @Override
    long createNativeInstance(long nativeMatrix) {
        if (this.mType == 1) {
            return this.nativeCreate1(nativeMatrix, this.mX0, this.mY0, this.mX1, this.mY1, this.mColors, this.mPositions, this.mTileMode.nativeInt);
        }
        return this.nativeCreate2(nativeMatrix, this.mX0, this.mY0, this.mX1, this.mY1, this.mColor0, this.mColor1, this.mTileMode.nativeInt);
    }

    @Override
    protected Shader copy() {
        LinearGradient copy = this.mType == 1 ? new LinearGradient(this.mX0, this.mY0, this.mX1, this.mY1, (int[])this.mColors.clone(), this.mPositions != null ? (float[])this.mPositions.clone() : null, this.mTileMode) : new LinearGradient(this.mX0, this.mY0, this.mX1, this.mY1, this.mColor0, this.mColor1, this.mTileMode);
        this.copyLocalMatrix(copy);
        return copy;
    }

    @LayoutlibDelegate
    private long nativeCreate1(long l, float f, float f2, float f3, float f4, int[] nArray, float[] fArray, int n) {
        return LinearGradient_Delegate.nativeCreate1(this, l, f, f2, f3, f4, nArray, fArray, n);
    }

    @LayoutlibDelegate
    private long nativeCreate2(long l, float f, float f2, float f3, float f4, int n, int n2, int n3) {
        return LinearGradient_Delegate.nativeCreate2(this, l, f, f2, f3, f4, n, n2, n3);
    }
}

