/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioManager;
import android.media.AudioPatch;
import android.media.AudioPort;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

class AudioPortEventHandler {
    private Handler mHandler;
    private HandlerThread mHandlerThread;
    private final ArrayList<AudioManager.OnAudioPortUpdateListener> mListeners = new ArrayList();
    private static final String TAG = "AudioPortEventHandler";
    private static final int AUDIOPORT_EVENT_PORT_LIST_UPDATED = 1;
    private static final int AUDIOPORT_EVENT_PATCH_LIST_UPDATED = 2;
    private static final int AUDIOPORT_EVENT_SERVICE_DIED = 3;
    private static final int AUDIOPORT_EVENT_NEW_LISTENER = 4;
    private static final long RESCHEDULE_MESSAGE_DELAY_MS = 100L;
    private long mJniCallback;

    AudioPortEventHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        AudioPortEventHandler audioPortEventHandler = this;
        synchronized (audioPortEventHandler) {
            if (this.mHandler != null) {
                return;
            }
            this.mHandlerThread = new HandlerThread(TAG);
            this.mHandlerThread.start();
            if (this.mHandlerThread.getLooper() != null) {
                this.mHandler = new Handler(this.mHandlerThread.getLooper()){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void handleMessage(Message msg) {
                        int status;
                        ArrayList listeners;
                        1 var3_2 = this;
                        synchronized (var3_2) {
                            if (msg.what == 4) {
                                listeners = new ArrayList();
                                if (AudioPortEventHandler.this.mListeners.contains(msg.obj)) {
                                    listeners.add((AudioManager.OnAudioPortUpdateListener)msg.obj);
                                }
                            } else {
                                listeners = AudioPortEventHandler.this.mListeners;
                            }
                        }
                        if (msg.what == 1 || msg.what == 2 || msg.what == 3) {
                            AudioManager.resetAudioPortGeneration();
                        }
                        if (listeners.isEmpty()) {
                            return;
                        }
                        ArrayList<AudioPort> ports = new ArrayList<AudioPort>();
                        ArrayList<AudioPatch> patches = new ArrayList<AudioPatch>();
                        if (msg.what != 3 && (status = AudioManager.updateAudioPortCache(ports, patches, null)) != 0) {
                            this.sendMessageDelayed(this.obtainMessage(msg.what, msg.obj), 100L);
                            return;
                        }
                        switch (msg.what) {
                            case 1: 
                            case 4: {
                                AudioPort[] portList = ports.toArray(new AudioPort[0]);
                                for (int i = 0; i < listeners.size(); ++i) {
                                    ((AudioManager.OnAudioPortUpdateListener)listeners.get(i)).onAudioPortListUpdate(portList);
                                }
                                if (msg.what == 1) break;
                            }
                            case 2: {
                                AudioPatch[] patchList = patches.toArray(new AudioPatch[0]);
                                for (int i = 0; i < listeners.size(); ++i) {
                                    ((AudioManager.OnAudioPortUpdateListener)listeners.get(i)).onAudioPatchListUpdate(patchList);
                                }
                                break;
                            }
                            case 3: {
                                for (int i = 0; i < listeners.size(); ++i) {
                                    ((AudioManager.OnAudioPortUpdateListener)listeners.get(i)).onServiceDied();
                                }
                                break;
                            }
                        }
                    }
                };
                this.native_setup(new WeakReference<AudioPortEventHandler>(this));
            } else {
                this.mHandler = null;
            }
        }
    }

    private void native_setup(Object object) {
        OverrideMethod.invokeV("android.media.AudioPortEventHandler#native_setup(Ljava/lang/Object;)V", true, this);
    }

    protected void finalize() {
        this.native_finalize();
        if (this.mHandlerThread.isAlive()) {
            this.mHandlerThread.quit();
        }
    }

    private void native_finalize() {
        OverrideMethod.invokeV("android.media.AudioPortEventHandler#native_finalize()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerListener(AudioManager.OnAudioPortUpdateListener l) {
        AudioPortEventHandler audioPortEventHandler = this;
        synchronized (audioPortEventHandler) {
            this.mListeners.add(l);
        }
        if (this.mHandler != null) {
            Message m = this.mHandler.obtainMessage(4, 0, 0, l);
            this.mHandler.sendMessage(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterListener(AudioManager.OnAudioPortUpdateListener l) {
        AudioPortEventHandler audioPortEventHandler = this;
        synchronized (audioPortEventHandler) {
            this.mListeners.remove(l);
        }
    }

    Handler handler() {
        return this.mHandler;
    }

    private static void postEventFromNative(Object module_ref, int what, int arg1, int arg2, Object obj) {
        Handler handler;
        AudioPortEventHandler eventHandler = (AudioPortEventHandler)((WeakReference)module_ref).get();
        if (eventHandler == null) {
            return;
        }
        if (eventHandler != null && (handler = eventHandler.handler()) != null) {
            Message m = handler.obtainMessage(what, arg1, arg2, obj);
            if (what != 4) {
                handler.removeMessages(what);
            }
            handler.sendMessage(m);
        }
    }
}

