/*
 * Decompiled with CFR 0.152.
 */
package android.metrics;

import android.annotation.SystemApi;
import android.content.ComponentName;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;

@SystemApi
public class LogMaker {
    private static final String TAG = "LogBuilder";
    @VisibleForTesting
    public static final int MAX_SERIALIZED_SIZE = 4000;
    private SparseArray<Object> entries = new SparseArray();

    public LogMaker(int category) {
        this.setCategory(category);
    }

    public LogMaker(Object[] items) {
        if (items != null) {
            this.deserialize(items);
        } else {
            this.setCategory(0);
        }
    }

    public LogMaker setCategory(int category) {
        this.entries.put(757, category);
        return this;
    }

    public LogMaker clearCategory() {
        this.entries.remove(757);
        return this;
    }

    public LogMaker setType(int type) {
        this.entries.put(758, type);
        return this;
    }

    public LogMaker clearType() {
        this.entries.remove(758);
        return this;
    }

    public LogMaker setSubtype(int subtype) {
        this.entries.put(759, subtype);
        return this;
    }

    public LogMaker clearSubtype() {
        this.entries.remove(759);
        return this;
    }

    public LogMaker setLatency(long milliseconds) {
        this.entries.put(1359, milliseconds);
        return this;
    }

    public LogMaker setTimestamp(long timestamp) {
        this.entries.put(805, timestamp);
        return this;
    }

    public LogMaker clearTimestamp() {
        this.entries.remove(805);
        return this;
    }

    public LogMaker setPackageName(String packageName) {
        this.entries.put(806, packageName);
        return this;
    }

    public LogMaker setComponentName(ComponentName component) {
        this.entries.put(806, component.getPackageName());
        this.entries.put(871, component.getClassName());
        return this;
    }

    public LogMaker clearPackageName() {
        this.entries.remove(806);
        return this;
    }

    public LogMaker setProcessId(int pid) {
        this.entries.put(865, pid);
        return this;
    }

    public LogMaker clearProcessId() {
        this.entries.remove(865);
        return this;
    }

    public LogMaker setUid(int uid) {
        this.entries.put(943, uid);
        return this;
    }

    public LogMaker clearUid() {
        this.entries.remove(943);
        return this;
    }

    public LogMaker setCounterName(String name) {
        this.entries.put(799, name);
        return this;
    }

    public LogMaker setCounterBucket(int bucket) {
        this.entries.put(801, bucket);
        return this;
    }

    public LogMaker setCounterBucket(long bucket) {
        this.entries.put(801, bucket);
        return this;
    }

    public LogMaker setCounterValue(int value) {
        this.entries.put(802, value);
        return this;
    }

    public LogMaker addTaggedData(int tag, Object value) {
        if (value == null) {
            return this.clearTaggedData(tag);
        }
        if (!this.isValidValue(value)) {
            throw new IllegalArgumentException("Value must be loggable type - int, long, float, String");
        }
        if (value.toString().getBytes().length > 4000) {
            Log.i(TAG, "Log value too long, omitted: " + value.toString());
        } else {
            this.entries.put(tag, value);
        }
        return this;
    }

    public LogMaker clearTaggedData(int tag) {
        this.entries.delete(tag);
        return this;
    }

    public boolean isValidValue(Object value) {
        return value instanceof Integer || value instanceof String || value instanceof Long || value instanceof Float;
    }

    public Object getTaggedData(int tag) {
        return this.entries.get(tag);
    }

    public int getCategory() {
        Object obj = this.entries.get(757);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return 0;
    }

    public int getType() {
        Object obj = this.entries.get(758);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return 0;
    }

    public int getSubtype() {
        Object obj = this.entries.get(759);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return 0;
    }

    public long getTimestamp() {
        Object obj = this.entries.get(805);
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return 0L;
    }

    public String getPackageName() {
        Object obj = this.entries.get(806);
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public int getProcessId() {
        Object obj = this.entries.get(865);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return -1;
    }

    public int getUid() {
        Object obj = this.entries.get(943);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return -1;
    }

    public String getCounterName() {
        Object obj = this.entries.get(799);
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public long getCounterBucket() {
        Object obj = this.entries.get(801);
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        return 0L;
    }

    public boolean isLongCounterBucket() {
        Object obj = this.entries.get(801);
        return obj instanceof Long;
    }

    public int getCounterValue() {
        Object obj = this.entries.get(802);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return 0;
    }

    public Object[] serialize() {
        Object[] out = new Object[this.entries.size() * 2];
        for (int i = 0; i < this.entries.size(); ++i) {
            out[i * 2] = this.entries.keyAt(i);
            out[i * 2 + 1] = this.entries.valueAt(i);
        }
        int size = out.toString().getBytes().length;
        if (size > 4000) {
            Log.i(TAG, "Log line too long, did not emit: " + size + " bytes.");
            throw new RuntimeException();
        }
        return out;
    }

    public void deserialize(Object[] items) {
        int i = 0;
        while (items != null && i < items.length) {
            Object value;
            Object key = items[i++];
            Object object = value = i < items.length ? items[i++] : null;
            if (key instanceof Integer) {
                this.entries.put((Integer)key, value);
                continue;
            }
            Log.i(TAG, "Invalid key " + (key == null ? "null" : key.toString()));
        }
    }

    public boolean isSubsetOf(LogMaker that) {
        if (that == null) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            int key = this.entries.keyAt(i);
            Object thisValue = this.entries.valueAt(i);
            Object thatValue = that.entries.get(key);
            if ((thisValue != null || thatValue == null) && thisValue.equals(thatValue)) continue;
            return false;
        }
        return true;
    }
}

