/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;

public class StatsLogEventWrapper
implements Parcelable {
    private ByteArrayOutputStream mStorage = new ByteArrayOutputStream();
    private static final int EVENT_TYPE_INT = 0;
    private static final int EVENT_TYPE_LONG = 1;
    private static final int EVENT_TYPE_STRING = 2;
    private static final int EVENT_TYPE_LIST = 3;
    private static final int EVENT_TYPE_FLOAT = 4;
    private static final int STATS_BUFFER_TAG_ID = 1937006964;
    public static final Parcelable.Creator<StatsLogEventWrapper> CREATOR = new Parcelable.Creator<StatsLogEventWrapper>(){

        @Override
        public StatsLogEventWrapper createFromParcel(Parcel in) {
            return new StatsLogEventWrapper(in);
        }

        public StatsLogEventWrapper[] newArray(int size) {
            return new StatsLogEventWrapper[size];
        }
    };

    public StatsLogEventWrapper(long elapsedNanos, int tag, int fields) {
        this.write4Bytes(1937006964);
        this.mStorage.write(3);
        this.mStorage.write(fields + 2);
        this.writeLong(elapsedNanos);
        this.writeInt(tag);
    }

    private void write4Bytes(int val) {
        this.mStorage.write(val);
        this.mStorage.write(val >>> 8);
        this.mStorage.write(val >>> 16);
        this.mStorage.write(val >>> 24);
    }

    private void write8Bytes(long val) {
        this.write4Bytes((int)(val & 0xFFFFFFFFFFFFFFFFL));
        this.write4Bytes((int)(val >>> 32));
    }

    public void writeInt(int val) {
        this.mStorage.write(0);
        this.write4Bytes(val);
    }

    public void writeLong(long val) {
        this.mStorage.write(1);
        this.write8Bytes(val);
    }

    public void writeFloat(float val) {
        int v = Float.floatToIntBits(val);
        this.mStorage.write(4);
        this.write4Bytes(v);
    }

    public void writeString(String val) {
        this.mStorage.write(2);
        this.write4Bytes(val.length());
        byte[] bytes = val.getBytes(StandardCharsets.UTF_8);
        this.mStorage.write(bytes, 0, bytes.length);
    }

    private StatsLogEventWrapper(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.mStorage.write(10);
        out.writeByteArray(this.mStorage.toByteArray());
    }

    public void readFromParcel(Parcel in) {
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

