/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.UserHandle;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationRankingUpdate;
import android.service.notification.NotificationStats;

public interface INotificationListener
extends IInterface {
    public void onListenerConnected(NotificationRankingUpdate var1) throws RemoteException;

    public void onNotificationPosted(IStatusBarNotificationHolder var1, NotificationRankingUpdate var2) throws RemoteException;

    public void onNotificationRemoved(IStatusBarNotificationHolder var1, NotificationRankingUpdate var2, NotificationStats var3, int var4) throws RemoteException;

    public void onNotificationRankingUpdate(NotificationRankingUpdate var1) throws RemoteException;

    public void onListenerHintsChanged(int var1) throws RemoteException;

    public void onInterruptionFilterChanged(int var1) throws RemoteException;

    public void onNotificationChannelModification(String var1, UserHandle var2, NotificationChannel var3, int var4) throws RemoteException;

    public void onNotificationChannelGroupModification(String var1, UserHandle var2, NotificationChannelGroup var3, int var4) throws RemoteException;

    public void onNotificationEnqueued(IStatusBarNotificationHolder var1) throws RemoteException;

    public void onNotificationSnoozedUntilContext(IStatusBarNotificationHolder var1, String var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INotificationListener {
        private static final String DESCRIPTOR = "android.service.notification.INotificationListener";
        static final int TRANSACTION_onListenerConnected = 1;
        static final int TRANSACTION_onNotificationPosted = 2;
        static final int TRANSACTION_onNotificationRemoved = 3;
        static final int TRANSACTION_onNotificationRankingUpdate = 4;
        static final int TRANSACTION_onListenerHintsChanged = 5;
        static final int TRANSACTION_onInterruptionFilterChanged = 6;
        static final int TRANSACTION_onNotificationChannelModification = 7;
        static final int TRANSACTION_onNotificationChannelGroupModification = 8;
        static final int TRANSACTION_onNotificationEnqueued = 9;
        static final int TRANSACTION_onNotificationSnoozedUntilContext = 10;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INotificationListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INotificationListener) {
                return (INotificationListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    NotificationRankingUpdate _arg0 = 0 != data.readInt() ? NotificationRankingUpdate.CREATOR.createFromParcel(data) : null;
                    this.onListenerConnected(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IStatusBarNotificationHolder _arg0 = IStatusBarNotificationHolder.Stub.asInterface(data.readStrongBinder());
                    NotificationRankingUpdate _arg1 = 0 != data.readInt() ? NotificationRankingUpdate.CREATOR.createFromParcel(data) : null;
                    this.onNotificationPosted(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    IStatusBarNotificationHolder _arg0 = IStatusBarNotificationHolder.Stub.asInterface(data.readStrongBinder());
                    NotificationRankingUpdate _arg1 = 0 != data.readInt() ? NotificationRankingUpdate.CREATOR.createFromParcel(data) : null;
                    NotificationStats _arg2 = 0 != data.readInt() ? NotificationStats.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    this.onNotificationRemoved(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    NotificationRankingUpdate _arg0 = 0 != data.readInt() ? NotificationRankingUpdate.CREATOR.createFromParcel(data) : null;
                    this.onNotificationRankingUpdate(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onListenerHintsChanged(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onInterruptionFilterChanged(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    UserHandle _arg1 = 0 != data.readInt() ? UserHandle.CREATOR.createFromParcel(data) : null;
                    NotificationChannel _arg2 = 0 != data.readInt() ? NotificationChannel.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    this.onNotificationChannelModification(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    UserHandle _arg1 = 0 != data.readInt() ? UserHandle.CREATOR.createFromParcel(data) : null;
                    NotificationChannelGroup _arg2 = 0 != data.readInt() ? NotificationChannelGroup.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    this.onNotificationChannelGroupModification(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    IStatusBarNotificationHolder _arg0 = IStatusBarNotificationHolder.Stub.asInterface(data.readStrongBinder());
                    this.onNotificationEnqueued(_arg0);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    IStatusBarNotificationHolder _arg0 = IStatusBarNotificationHolder.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.onNotificationSnoozedUntilContext(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements INotificationListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void onListenerConnected(NotificationRankingUpdate update) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (update != null) {
                        _data.writeInt(1);
                        update.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationPosted(IStatusBarNotificationHolder notificationHolder, NotificationRankingUpdate update) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(notificationHolder != null ? notificationHolder.asBinder() : null);
                    if (update != null) {
                        _data.writeInt(1);
                        update.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationRemoved(IStatusBarNotificationHolder notificationHolder, NotificationRankingUpdate update, NotificationStats stats, int reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(notificationHolder != null ? notificationHolder.asBinder() : null);
                    if (update != null) {
                        _data.writeInt(1);
                        update.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (stats != null) {
                        _data.writeInt(1);
                        stats.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(reason);
                    this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onNotificationRankingUpdate(NotificationRankingUpdate update) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (update != null) {
                        _data.writeInt(1);
                        update.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onListenerHintsChanged(int hints) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(hints);
                    this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onInterruptionFilterChanged(int interruptionFilter) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(interruptionFilter);
                    this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationChannelModification(String pkgName, UserHandle user, NotificationChannel channel, int modificationType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkgName);
                    if (user != null) {
                        _data.writeInt(1);
                        user.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (channel != null) {
                        _data.writeInt(1);
                        channel.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(modificationType);
                    this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationChannelGroupModification(String pkgName, UserHandle user, NotificationChannelGroup group, int modificationType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(pkgName);
                    if (user != null) {
                        _data.writeInt(1);
                        user.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (group != null) {
                        _data.writeInt(1);
                        group.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(modificationType);
                    this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onNotificationEnqueued(IStatusBarNotificationHolder notificationHolder) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(notificationHolder != null ? notificationHolder.asBinder() : null);
                    this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNotificationSnoozedUntilContext(IStatusBarNotificationHolder notificationHolder, String snoozeCriterionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(notificationHolder != null ? notificationHolder.asBinder() : null);
                    _data.writeString(snoozeCriterionId);
                    this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }
}

