/*
 * Decompiled with CFR 0.152.
 */
package android.service.textclassifier;

import android.annotation.SystemApi;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.CancellationSignal;
import android.os.IBinder;
import android.os.RemoteException;
import android.service.textclassifier.ITextClassificationCallback;
import android.service.textclassifier.ITextClassifierService;
import android.service.textclassifier.ITextLinksCallback;
import android.service.textclassifier.ITextSelectionCallback;
import android.text.TextUtils;
import android.util.Slog;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassificationManager;
import android.view.textclassifier.TextClassificationSessionId;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import com.android.internal.util.Preconditions;

@SystemApi
public abstract class TextClassifierService
extends Service {
    private static final String LOG_TAG = "TextClassifierService";
    @SystemApi
    public static final String SERVICE_INTERFACE = "android.service.textclassifier.TextClassifierService";
    private final ITextClassifierService.Stub mBinder = new ITextClassifierService.Stub(){
        private final CancellationSignal mCancellationSignal = new CancellationSignal();

        @Override
        public void onSuggestSelection(TextClassificationSessionId sessionId, TextSelection.Request request, final ITextSelectionCallback callback) throws RemoteException {
            Preconditions.checkNotNull(request);
            Preconditions.checkNotNull(callback);
            TextClassifierService.this.onSuggestSelection(request.getText(), request.getStartIndex(), request.getEndIndex(), TextSelection.Options.from(sessionId, request), this.mCancellationSignal, new Callback<TextSelection>(){

                @Override
                public void onSuccess(TextSelection result) {
                    try {
                        callback.onSuccess(result);
                    }
                    catch (RemoteException e) {
                        Slog.d(TextClassifierService.LOG_TAG, "Error calling callback");
                    }
                }

                @Override
                public void onFailure(CharSequence error) {
                    try {
                        if (callback.asBinder().isBinderAlive()) {
                            callback.onFailure();
                        }
                    }
                    catch (RemoteException e) {
                        Slog.d(TextClassifierService.LOG_TAG, "Error calling callback");
                    }
                }
            });
        }

        @Override
        public void onClassifyText(TextClassificationSessionId sessionId, TextClassification.Request request, final ITextClassificationCallback callback) throws RemoteException {
            Preconditions.checkNotNull(request);
            Preconditions.checkNotNull(callback);
            TextClassifierService.this.onClassifyText(request.getText(), request.getStartIndex(), request.getEndIndex(), TextClassification.Options.from(sessionId, request), this.mCancellationSignal, new Callback<TextClassification>(){

                @Override
                public void onSuccess(TextClassification result) {
                    try {
                        callback.onSuccess(result);
                    }
                    catch (RemoteException e) {
                        Slog.d(TextClassifierService.LOG_TAG, "Error calling callback");
                    }
                }

                @Override
                public void onFailure(CharSequence error) {
                    try {
                        callback.onFailure();
                    }
                    catch (RemoteException e) {
                        Slog.d(TextClassifierService.LOG_TAG, "Error calling callback");
                    }
                }
            });
        }

        @Override
        public void onGenerateLinks(TextClassificationSessionId sessionId, TextLinks.Request request, final ITextLinksCallback callback) throws RemoteException {
            Preconditions.checkNotNull(request);
            Preconditions.checkNotNull(callback);
            TextClassifierService.this.onGenerateLinks(request.getText(), TextLinks.Options.from(sessionId, request), this.mCancellationSignal, new Callback<TextLinks>(){

                @Override
                public void onSuccess(TextLinks result) {
                    try {
                        callback.onSuccess(result);
                    }
                    catch (RemoteException e) {
                        Slog.d(TextClassifierService.LOG_TAG, "Error calling callback");
                    }
                }

                @Override
                public void onFailure(CharSequence error) {
                    try {
                        callback.onFailure();
                    }
                    catch (RemoteException e) {
                        Slog.d(TextClassifierService.LOG_TAG, "Error calling callback");
                    }
                }
            });
        }

        @Override
        public void onSelectionEvent(TextClassificationSessionId sessionId, SelectionEvent event) throws RemoteException {
            Preconditions.checkNotNull(event);
            TextClassifierService.this.onSelectionEvent(sessionId, event);
        }

        @Override
        public void onCreateTextClassificationSession(TextClassificationContext context, TextClassificationSessionId sessionId) throws RemoteException {
            Preconditions.checkNotNull(context);
            Preconditions.checkNotNull(sessionId);
            TextClassifierService.this.onCreateTextClassificationSession(context, sessionId);
        }

        @Override
        public void onDestroyTextClassificationSession(TextClassificationSessionId sessionId) throws RemoteException {
            TextClassifierService.this.onDestroyTextClassificationSession(sessionId);
        }
    };

    @Override
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            return this.mBinder;
        }
        return null;
    }

    public abstract void onSuggestSelection(TextClassificationSessionId var1, TextSelection.Request var2, CancellationSignal var3, Callback<TextSelection> var4);

    public void onSuggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex, TextSelection.Options options, CancellationSignal cancellationSignal, Callback<TextSelection> callback) {
        TextClassificationSessionId sessionId = options.getSessionId();
        TextSelection.Request request = options.getRequest() != null ? options.getRequest() : new TextSelection.Request.Builder(text, selectionStartIndex, selectionEndIndex).setDefaultLocales(options.getDefaultLocales()).build();
        this.onSuggestSelection(sessionId, request, cancellationSignal, callback);
    }

    public abstract void onClassifyText(TextClassificationSessionId var1, TextClassification.Request var2, CancellationSignal var3, Callback<TextClassification> var4);

    public void onClassifyText(CharSequence text, int startIndex, int endIndex, TextClassification.Options options, CancellationSignal cancellationSignal, Callback<TextClassification> callback) {
        TextClassificationSessionId sessionId = options.getSessionId();
        TextClassification.Request request = options.getRequest() != null ? options.getRequest() : new TextClassification.Request.Builder(text, startIndex, endIndex).setDefaultLocales(options.getDefaultLocales()).setReferenceTime(options.getReferenceTime()).build();
        this.onClassifyText(sessionId, request, cancellationSignal, callback);
    }

    public abstract void onGenerateLinks(TextClassificationSessionId var1, TextLinks.Request var2, CancellationSignal var3, Callback<TextLinks> var4);

    public void onGenerateLinks(CharSequence text, TextLinks.Options options, CancellationSignal cancellationSignal, Callback<TextLinks> callback) {
        TextClassificationSessionId sessionId = options.getSessionId();
        TextLinks.Request request = options.getRequest() != null ? options.getRequest() : new TextLinks.Request.Builder(text).setDefaultLocales(options.getDefaultLocales()).setEntityConfig(options.getEntityConfig()).build();
        this.onGenerateLinks(sessionId, request, cancellationSignal, callback);
    }

    public void onSelectionEvent(TextClassificationSessionId sessionId, SelectionEvent event) {
    }

    public void onCreateTextClassificationSession(TextClassificationContext context, TextClassificationSessionId sessionId) {
    }

    public void onDestroyTextClassificationSession(TextClassificationSessionId sessionId) {
    }

    public TextClassifier getLocalTextClassifier() {
        TextClassificationManager tcm = this.getSystemService(TextClassificationManager.class);
        if (tcm != null) {
            return tcm.getTextClassifier(0);
        }
        return TextClassifier.NO_OP;
    }

    public static ComponentName getServiceComponentName(Context context) {
        String packageName = context.getPackageManager().getSystemTextClassifierPackageName();
        if (TextUtils.isEmpty(packageName)) {
            Slog.d(LOG_TAG, "No configured system TextClassifierService");
            return null;
        }
        Intent intent = new Intent(SERVICE_INTERFACE).setPackage(packageName);
        ResolveInfo ri = context.getPackageManager().resolveService(intent, 0x100000);
        if (ri == null || ri.serviceInfo == null) {
            Slog.w(LOG_TAG, String.format("Package or service not found in package %s", packageName));
            return null;
        }
        ServiceInfo si = ri.serviceInfo;
        String permission2 = si.permission;
        if ("android.permission.BIND_TEXTCLASSIFIER_SERVICE".equals(permission2)) {
            return si.getComponentName();
        }
        Slog.w(LOG_TAG, String.format("Service %s should require %s permission. Found %s permission", si.getComponentName(), "android.permission.BIND_TEXTCLASSIFIER_SERVICE", si.permission));
        return null;
    }

    @SystemApi
    public static interface Callback<T> {
        public void onSuccess(T var1);

        public void onFailure(CharSequence var1);
    }
}

