/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.view.ContextThemeWrapper;
import android.view.Display;
import android.view.DisplayListCanvas;
import android.view.PixelCopy;
import android.view.RenderNode;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceHolder;
import android.view.SurfaceSession;
import android.view.SurfaceView;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewRootImpl;
import com.android.internal.util.Preconditions;

public class Magnifier {
    private static final int NONEXISTENT_PREVIOUS_CONFIG_VALUE = -1;
    private static final HandlerThread sPixelCopyHandlerThread = new HandlerThread("magnifier pixel copy result handler");
    private final View mView;
    private final int[] mViewCoordinatesInSurface;
    private InternalPopupWindow mWindow;
    private final int mWindowWidth;
    private final int mWindowHeight;
    private final float mZoom;
    private final int mBitmapWidth;
    private final int mBitmapHeight;
    private final float mWindowElevation;
    private final float mWindowCornerRadius;
    private SurfaceInfo mParentSurface;
    private SurfaceInfo mContentCopySurface;
    private final Point mWindowCoords = new Point();
    private final Point mCenterZoomCoords = new Point();
    private final Point mClampedCenterZoomCoords = new Point();
    private final Point mPrevStartCoordsInSurface = new Point(-1, -1);
    private final PointF mPrevPosInView = new PointF(-1.0f, -1.0f);
    private final Rect mPixelCopyRequestRect = new Rect();
    private final Object mLock = new Object();
    private Callback mCallback;

    public Magnifier(View view) {
        this.mView = Preconditions.checkNotNull(view);
        Context context = this.mView.getContext();
        this.mWindowWidth = context.getResources().getDimensionPixelSize(17105166);
        this.mWindowHeight = context.getResources().getDimensionPixelSize(17105164);
        this.mWindowElevation = context.getResources().getDimension(17105163);
        this.mWindowCornerRadius = this.getDeviceDefaultDialogCornerRadius();
        this.mZoom = context.getResources().getFloat(17105167);
        this.mBitmapWidth = Math.round((float)this.mWindowWidth / this.mZoom);
        this.mBitmapHeight = Math.round((float)this.mWindowHeight / this.mZoom);
        this.mViewCoordinatesInSurface = new int[2];
    }

    private float getDeviceDefaultDialogCornerRadius() {
        ContextThemeWrapper deviceDefaultContext = new ContextThemeWrapper(this.mView.getContext(), 16974120);
        TypedArray ta = deviceDefaultContext.obtainStyledAttributes(new int[]{16844145});
        float dialogCornerRadius = ta.getDimension(0, 0.0f);
        ta.recycle();
        return dialogCornerRadius;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(float xPosInView, float yPosInView) {
        xPosInView = Math.max(0.0f, Math.min(xPosInView, (float)this.mView.getWidth()));
        yPosInView = Math.max(0.0f, Math.min(yPosInView, (float)this.mView.getHeight()));
        this.obtainSurfaces();
        this.obtainContentCoordinates(xPosInView, yPosInView);
        this.obtainWindowCoordinates();
        int startX = this.mClampedCenterZoomCoords.x - this.mBitmapWidth / 2;
        int startY = this.mClampedCenterZoomCoords.y - this.mBitmapHeight / 2;
        if (xPosInView != this.mPrevPosInView.x || yPosInView != this.mPrevPosInView.y) {
            if (this.mWindow == null) {
                Object object = this.mLock;
                synchronized (object) {
                    this.mWindow = new InternalPopupWindow(this.mView.getContext(), this.mView.getDisplay(), this.mParentSurface.mSurface, this.mWindowWidth, this.mWindowHeight, this.mWindowElevation, this.mWindowCornerRadius, Handler.getMain(), this.mLock, this.mCallback);
                }
            }
            this.performPixelCopy(startX, startY, true);
            this.mPrevPosInView.x = xPosInView;
            this.mPrevPosInView.y = yPosInView;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismiss() {
        if (this.mWindow != null) {
            Object object = this.mLock;
            synchronized (object) {
                this.mWindow.destroy();
                this.mWindow = null;
            }
            this.mPrevPosInView.x = -1.0f;
            this.mPrevPosInView.y = -1.0f;
            this.mPrevStartCoordsInSurface.x = -1;
            this.mPrevStartCoordsInSurface.y = -1;
        }
    }

    public void update() {
        if (this.mWindow != null) {
            this.obtainSurfaces();
            this.performPixelCopy(this.mPrevStartCoordsInSurface.x, this.mPrevStartCoordsInSurface.y, false);
        }
    }

    public int getWidth() {
        return this.mWindowWidth;
    }

    public int getHeight() {
        return this.mWindowHeight;
    }

    public float getZoom() {
        return this.mZoom;
    }

    public Point getWindowCoords() {
        if (this.mWindow == null) {
            return null;
        }
        Rect surfaceInsets = this.mView.getViewRootImpl().mWindowAttributes.surfaceInsets;
        return new Point(this.mWindow.mLastDrawContentPositionX - surfaceInsets.left, this.mWindow.mLastDrawContentPositionY - surfaceInsets.top);
    }

    private void obtainSurfaces() {
        SurfaceHolder surfaceHolder;
        Surface surfaceViewSurface;
        SurfaceInfo validMainWindowSurface = SurfaceInfo.NULL;
        if (this.mView.getViewRootImpl() != null) {
            ViewRootImpl viewRootImpl = this.mView.getViewRootImpl();
            Surface mainWindowSurface = viewRootImpl.mSurface;
            if (mainWindowSurface != null && mainWindowSurface.isValid()) {
                Rect surfaceInsets = viewRootImpl.mWindowAttributes.surfaceInsets;
                int surfaceWidth = viewRootImpl.getWidth() + surfaceInsets.left + surfaceInsets.right;
                int surfaceHeight = viewRootImpl.getHeight() + surfaceInsets.top + surfaceInsets.bottom;
                validMainWindowSurface = new SurfaceInfo(mainWindowSurface, surfaceWidth, surfaceHeight, true);
            }
        }
        SurfaceInfo validSurfaceViewSurface = SurfaceInfo.NULL;
        if (this.mView instanceof SurfaceView && (surfaceViewSurface = (surfaceHolder = ((SurfaceView)this.mView).getHolder()).getSurface()) != null && surfaceViewSurface.isValid()) {
            Rect surfaceFrame = surfaceHolder.getSurfaceFrame();
            validSurfaceViewSurface = new SurfaceInfo(surfaceViewSurface, surfaceFrame.right, surfaceFrame.bottom, false);
        }
        this.mParentSurface = validMainWindowSurface != SurfaceInfo.NULL ? validMainWindowSurface : validSurfaceViewSurface;
        this.mContentCopySurface = this.mView instanceof SurfaceView ? validSurfaceViewSurface : validMainWindowSurface;
    }

    private void obtainContentCoordinates(float xPosInView, float yPosInView) {
        float posY;
        float posX;
        this.mView.getLocationInSurface(this.mViewCoordinatesInSurface);
        if (this.mView instanceof SurfaceView) {
            posX = xPosInView;
            posY = yPosInView;
        } else {
            posX = xPosInView + (float)this.mViewCoordinatesInSurface[0];
            posY = yPosInView + (float)this.mViewCoordinatesInSurface[1];
        }
        this.mCenterZoomCoords.x = Math.round(posX);
        this.mCenterZoomCoords.y = Math.round(posY);
        Rect viewVisibleRegion = new Rect();
        this.mView.getGlobalVisibleRect(viewVisibleRegion);
        if (this.mView.getViewRootImpl() != null) {
            Rect surfaceInsets = this.mView.getViewRootImpl().mWindowAttributes.surfaceInsets;
            viewVisibleRegion.offset(surfaceInsets.left, surfaceInsets.top);
        }
        if (this.mView instanceof SurfaceView) {
            viewVisibleRegion.offset(-this.mViewCoordinatesInSurface[0], -this.mViewCoordinatesInSurface[1]);
        }
        this.mClampedCenterZoomCoords.x = Math.max(viewVisibleRegion.left + this.mBitmapWidth / 2, Math.min(this.mCenterZoomCoords.x, viewVisibleRegion.right - this.mBitmapWidth / 2));
        this.mClampedCenterZoomCoords.y = this.mCenterZoomCoords.y;
    }

    private void obtainWindowCoordinates() {
        int verticalOffset = this.mView.getContext().getResources().getDimensionPixelSize(17105165);
        this.mWindowCoords.x = this.mCenterZoomCoords.x - this.mWindowWidth / 2;
        this.mWindowCoords.y = this.mCenterZoomCoords.y - this.mWindowHeight / 2 - verticalOffset;
        if (this.mParentSurface != this.mContentCopySurface) {
            this.mWindowCoords.x += this.mViewCoordinatesInSurface[0];
            this.mWindowCoords.y += this.mViewCoordinatesInSurface[1];
        }
    }

    private void performPixelCopy(int startXInSurface, int startYInSurface, boolean updateWindowPosition) {
        Rect windowBounds;
        if (this.mContentCopySurface.mSurface == null || !this.mContentCopySurface.mSurface.isValid()) {
            return;
        }
        int clampedStartXInSurface = Math.max(0, Math.min(startXInSurface, this.mContentCopySurface.mWidth - this.mBitmapWidth));
        int clampedStartYInSurface = Math.max(0, Math.min(startYInSurface, this.mContentCopySurface.mHeight - this.mBitmapHeight));
        if (this.mParentSurface.mIsMainWindowSurface) {
            Rect systemInsets = this.mView.getRootWindowInsets().getSystemWindowInsets();
            windowBounds = new Rect(systemInsets.left, systemInsets.top, this.mParentSurface.mWidth - systemInsets.right, this.mParentSurface.mHeight - systemInsets.bottom);
        } else {
            windowBounds = new Rect(0, 0, this.mParentSurface.mWidth, this.mParentSurface.mHeight);
        }
        int windowCoordsX = Math.max(windowBounds.left, Math.min(windowBounds.right - this.mWindowWidth, this.mWindowCoords.x));
        int windowCoordsY = Math.max(windowBounds.top, Math.min(windowBounds.bottom - this.mWindowHeight, this.mWindowCoords.y));
        this.mPixelCopyRequestRect.set(clampedStartXInSurface, clampedStartYInSurface, clampedStartXInSurface + this.mBitmapWidth, clampedStartYInSurface + this.mBitmapHeight);
        InternalPopupWindow currentWindowInstance = this.mWindow;
        Bitmap bitmap = Bitmap.createBitmap(this.mBitmapWidth, this.mBitmapHeight, Bitmap.Config.ARGB_8888);
        PixelCopy.request(this.mContentCopySurface.mSurface, this.mPixelCopyRequestRect, bitmap, result -> {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mWindow != currentWindowInstance) {
                    return;
                }
                if (updateWindowPosition) {
                    this.mWindow.setContentPositionForNextDraw(windowCoordsX, windowCoordsY);
                }
                this.mWindow.updateContent(bitmap);
            }
        }, sPixelCopyHandlerThread.getThreadHandler());
        this.mPrevStartCoordsInSurface.x = startXInSurface;
        this.mPrevStartCoordsInSurface.y = startYInSurface;
    }

    public void setOnOperationCompleteCallback(Callback callback) {
        this.mCallback = callback;
        if (this.mWindow != null) {
            this.mWindow.mCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getContent() {
        if (this.mWindow == null) {
            return null;
        }
        Object object = this.mWindow.mLock;
        synchronized (object) {
            return Bitmap.createScaledBitmap(this.mWindow.mBitmap, this.mWindowWidth, this.mWindowHeight, true);
        }
    }

    public Rect getWindowPositionOnScreen() {
        int[] viewLocationOnScreen = new int[2];
        this.mView.getLocationOnScreen(viewLocationOnScreen);
        int[] viewLocationInSurface = new int[2];
        this.mView.getLocationInSurface(viewLocationInSurface);
        int left = this.mWindowCoords.x + viewLocationOnScreen[0] - viewLocationInSurface[0];
        int top = this.mWindowCoords.y + viewLocationOnScreen[1] - viewLocationInSurface[1];
        return new Rect(left, top, left + this.mWindowWidth, top + this.mWindowHeight);
    }

    public static PointF getMagnifierDefaultSize() {
        Resources resources = Resources.getSystem();
        float density = resources.getDisplayMetrics().density;
        PointF size = new PointF();
        size.x = resources.getDimension(17105166) / density;
        size.y = resources.getDimension(17105164) / density;
        return size;
    }

    static {
        sPixelCopyHandlerThread.start();
    }

    public static interface Callback {
        public void onOperationComplete();
    }

    private static class InternalPopupWindow {
        private static final int CONTENT_BITMAP_ALPHA = 242;
        private static final int SURFACE_Z = 5;
        private final Display mDisplay;
        private final int mContentWidth;
        private final int mContentHeight;
        private final int mSurfaceWidth;
        private final int mSurfaceHeight;
        private final int mOffsetX;
        private final int mOffsetY;
        private final SurfaceSession mSurfaceSession;
        private final SurfaceControl mSurfaceControl;
        private final Surface mSurface;
        private final ThreadedRenderer.SimpleRenderer mRenderer;
        private final RenderNode mBitmapRenderNode;
        private final Runnable mMagnifierUpdater;
        private final Handler mHandler;
        private Callback mCallback;
        private int mLastDrawContentPositionX;
        private int mLastDrawContentPositionY;
        private final Object mLock;
        private boolean mFrameDrawScheduled;
        private Bitmap mBitmap;
        private boolean mFirstDraw = true;
        private int mWindowPositionX;
        private int mWindowPositionY;
        private boolean mPendingWindowPositionUpdate;
        private final Object mDestroyLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InternalPopupWindow(Context context, Display display, Surface parentSurface, int width, int height, float elevation, float cornerRadius, Handler handler, Object lock, Callback callback) {
            this.mDisplay = display;
            this.mLock = lock;
            this.mCallback = callback;
            this.mContentWidth = width;
            this.mContentHeight = height;
            this.mOffsetX = (int)(0.1f * (float)width);
            this.mOffsetY = (int)(0.1f * (float)height);
            this.mSurfaceWidth = this.mContentWidth + 2 * this.mOffsetX;
            this.mSurfaceHeight = this.mContentHeight + 2 * this.mOffsetY;
            this.mSurfaceSession = new SurfaceSession(parentSurface);
            this.mSurfaceControl = new SurfaceControl.Builder(this.mSurfaceSession).setFormat(-3).setSize(this.mSurfaceWidth, this.mSurfaceHeight).setName("magnifier surface").setFlags(4).build();
            this.mSurface = new Surface();
            this.mSurface.copyFrom(this.mSurfaceControl);
            this.mRenderer = new ThreadedRenderer.SimpleRenderer(context, "magnifier renderer", this.mSurface);
            this.mBitmapRenderNode = this.createRenderNodeForBitmap("magnifier content", elevation, cornerRadius);
            DisplayListCanvas canvas = this.mRenderer.getRootNode().start(width, height);
            try {
                canvas.insertReorderBarrier();
                canvas.drawRenderNode(this.mBitmapRenderNode);
                canvas.insertInorderBarrier();
            }
            finally {
                this.mRenderer.getRootNode().end(canvas);
            }
            this.mHandler = handler;
            this.mMagnifierUpdater = this::doDraw;
            this.mFrameDrawScheduled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RenderNode createRenderNodeForBitmap(String name, float elevation, float cornerRadius) {
            RenderNode bitmapRenderNode = RenderNode.create(name, null);
            bitmapRenderNode.setLeftTopRightBottom(this.mOffsetX, this.mOffsetY, this.mOffsetX + this.mContentWidth, this.mOffsetY + this.mContentHeight);
            bitmapRenderNode.setElevation(elevation);
            Outline outline = new Outline();
            outline.setRoundRect(0, 0, this.mContentWidth, this.mContentHeight, cornerRadius);
            outline.setAlpha(1.0f);
            bitmapRenderNode.setOutline(outline);
            bitmapRenderNode.setClipToOutline(true);
            DisplayListCanvas canvas = bitmapRenderNode.start(this.mContentWidth, this.mContentHeight);
            try {
                canvas.drawColor(-16711936);
            }
            finally {
                bitmapRenderNode.end(canvas);
            }
            return bitmapRenderNode;
        }

        public void setContentPositionForNextDraw(int contentX, int contentY) {
            this.mWindowPositionX = contentX - this.mOffsetX;
            this.mWindowPositionY = contentY - this.mOffsetY;
            this.mPendingWindowPositionUpdate = true;
            this.requestUpdate();
        }

        public void updateContent(Bitmap bitmap) {
            if (this.mBitmap != null) {
                this.mBitmap.recycle();
            }
            this.mBitmap = bitmap;
            this.requestUpdate();
        }

        private void requestUpdate() {
            if (this.mFrameDrawScheduled) {
                return;
            }
            Message request = Message.obtain(this.mHandler, this.mMagnifierUpdater);
            request.setAsynchronous(true);
            request.sendToTarget();
            this.mFrameDrawScheduled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            Object object = this.mDestroyLock;
            synchronized (object) {
                this.mSurface.destroy();
            }
            object = this.mLock;
            synchronized (object) {
                this.mRenderer.destroy();
                this.mSurfaceControl.destroy();
                this.mSurfaceSession.kill();
                this.mBitmapRenderNode.destroy();
                this.mHandler.removeCallbacks(this.mMagnifierUpdater);
                if (this.mBitmap != null) {
                    this.mBitmap.recycle();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doDraw() {
            ThreadedRenderer.FrameDrawingCallback callback;
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mSurface.isValid()) {
                    return;
                }
                DisplayListCanvas canvas = this.mBitmapRenderNode.start(this.mContentWidth, this.mContentHeight);
                try {
                    canvas.drawColor(-1);
                    Rect srcRect = new Rect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
                    Rect dstRect = new Rect(0, 0, this.mContentWidth, this.mContentHeight);
                    Paint paint = new Paint();
                    paint.setFilterBitmap(true);
                    paint.setAlpha(242);
                    canvas.drawBitmap(this.mBitmap, srcRect, dstRect, paint);
                }
                finally {
                    this.mBitmapRenderNode.end(canvas);
                }
                if (this.mPendingWindowPositionUpdate || this.mFirstDraw) {
                    boolean firstDraw = this.mFirstDraw;
                    this.mFirstDraw = false;
                    boolean updateWindowPosition = this.mPendingWindowPositionUpdate;
                    this.mPendingWindowPositionUpdate = false;
                    int pendingX = this.mWindowPositionX;
                    int pendingY = this.mWindowPositionY;
                    callback = frame -> {
                        Object object = this.mDestroyLock;
                        synchronized (object) {
                            if (!this.mSurface.isValid()) {
                                return;
                            }
                            Object object2 = this.mLock;
                            synchronized (object2) {
                                this.mRenderer.setLightCenter(this.mDisplay, pendingX, pendingY);
                                SurfaceControl.openTransaction();
                                this.mSurfaceControl.deferTransactionUntil(this.mSurface, frame);
                                if (updateWindowPosition) {
                                    this.mSurfaceControl.setPosition(pendingX, pendingY);
                                }
                                if (firstDraw) {
                                    this.mSurfaceControl.setLayer(5);
                                    this.mSurfaceControl.show();
                                }
                                SurfaceControl.closeTransaction();
                            }
                        }
                    };
                } else {
                    callback = null;
                }
                this.mLastDrawContentPositionX = this.mWindowPositionX + this.mOffsetX;
                this.mLastDrawContentPositionY = this.mWindowPositionY + this.mOffsetY;
                this.mFrameDrawScheduled = false;
            }
            this.mRenderer.draw(callback);
            if (this.mCallback != null) {
                this.mCallback.onOperationComplete();
            }
        }
    }

    private static class SurfaceInfo {
        public static final SurfaceInfo NULL = new SurfaceInfo(null, 0, 0, false);
        private Surface mSurface;
        private int mWidth;
        private int mHeight;
        private boolean mIsMainWindowSurface;

        SurfaceInfo(Surface surface, int width, int height, boolean isMainWindowSurface) {
            this.mSurface = surface;
            this.mWidth = width;
            this.mHeight = height;
            this.mIsMainWindowSurface = isMainWindowSurface;
        }
    }
}

