/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.StrictMode;
import android.os.SystemClock;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class KernelCpuProcReader {
    private static final String TAG = "KernelCpuProcReader";
    private static final int ERROR_THRESHOLD = 5;
    private static final long DEFAULT_THROTTLE_INTERVAL = 3000L;
    private static final int INITIAL_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private static final String PROC_UID_FREQ_TIME = "/proc/uid_cpupower/time_in_state";
    private static final String PROC_UID_ACTIVE_TIME = "/proc/uid_cpupower/concurrent_active_time";
    private static final String PROC_UID_CLUSTER_TIME = "/proc/uid_cpupower/concurrent_policy_time";
    private static final KernelCpuProcReader mFreqTimeReader = new KernelCpuProcReader("/proc/uid_cpupower/time_in_state");
    private static final KernelCpuProcReader mActiveTimeReader = new KernelCpuProcReader("/proc/uid_cpupower/concurrent_active_time");
    private static final KernelCpuProcReader mClusterTimeReader = new KernelCpuProcReader("/proc/uid_cpupower/concurrent_policy_time");
    private int mErrors;
    private long mThrottleInterval = 3000L;
    private long mLastReadTime = Long.MIN_VALUE;
    private final Path mProc;
    private ByteBuffer mBuffer;

    public static KernelCpuProcReader getFreqTimeReaderInstance() {
        return mFreqTimeReader;
    }

    public static KernelCpuProcReader getActiveTimeReaderInstance() {
        return mActiveTimeReader;
    }

    public static KernelCpuProcReader getClusterTimeReaderInstance() {
        return mClusterTimeReader;
    }

    @VisibleForTesting
    public KernelCpuProcReader(String procFile) {
        this.mProc = Paths.get(procFile, new String[0]);
        this.mBuffer = ByteBuffer.allocateDirect(8192);
        this.mBuffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer readBytes() {
        Throwable throwable;
        if (this.mErrors >= 5) {
            return null;
        }
        if (SystemClock.elapsedRealtime() < this.mLastReadTime + this.mThrottleInterval) {
            if (this.mBuffer.limit() > 0 && this.mBuffer.limit() < this.mBuffer.capacity()) {
                return this.mBuffer.asReadOnlyBuffer().order(ByteOrder.nativeOrder());
            }
            return null;
        }
        this.mLastReadTime = SystemClock.elapsedRealtime();
        this.mBuffer.clear();
        int oldMask = StrictMode.allowThreadDiskReadsMask();
        try {
            throwable = null;
            try (FileChannel fc = FileChannel.open(this.mProc, StandardOpenOption.READ);){
                while (true) {
                    if (fc.read(this.mBuffer) == this.mBuffer.capacity()) {
                        if (!this.resize()) {
                            ++this.mErrors;
                            Slog.e(TAG, "Proc file is too large: " + this.mProc);
                            ByteBuffer byteBuffer = null;
                            return byteBuffer;
                        }
                        fc.position(0L);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            ++this.mErrors;
            Slog.w(TAG, "File not exist: " + this.mProc);
            throwable = null;
            return throwable;
        }
        catch (IOException e) {
            ++this.mErrors;
            Slog.e(TAG, "Error reading: " + this.mProc, e);
            throwable = null;
            return throwable;
        }
        finally {
            StrictMode.setThreadPolicyMask(oldMask);
        }
        this.mBuffer.flip();
        return this.mBuffer.asReadOnlyBuffer().order(ByteOrder.nativeOrder());
    }

    public void setThrottleInterval(long throttleInterval) {
        if (throttleInterval >= 0L) {
            this.mThrottleInterval = throttleInterval;
        }
    }

    private boolean resize() {
        if (this.mBuffer.capacity() >= 0x100000) {
            return false;
        }
        int newSize = Math.min(this.mBuffer.capacity() << 1, 0x100000);
        this.mBuffer = ByteBuffer.allocateDirect(newSize);
        return true;
    }
}

