/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.StrictMode;
import android.util.IntArray;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.KernelCpuProcReader;
import com.android.internal.os.KernelUidCpuTimeReaderBase;
import com.android.internal.os.PowerProfile;
import com.android.internal.util.Preconditions;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;

public class KernelUidCpuFreqTimeReader
extends KernelUidCpuTimeReaderBase<Callback> {
    private static final String TAG = KernelUidCpuFreqTimeReader.class.getSimpleName();
    static final String UID_TIMES_PROC_FILE = "/proc/uid_time_in_state";
    private long[] mCpuFreqs;
    private long[] mCurTimes;
    private long[] mDeltaTimes;
    private int mCpuFreqsCount;
    private final KernelCpuProcReader mProcReader;
    private SparseArray<long[]> mLastUidCpuFreqTimeMs = new SparseArray();
    private static final int TOTAL_READ_ERROR_COUNT = 5;
    private int mReadErrorCounter;
    private boolean mPerClusterTimesAvailable;
    private boolean mAllUidTimesAvailable = true;

    public KernelUidCpuFreqTimeReader() {
        this.mProcReader = KernelCpuProcReader.getFreqTimeReaderInstance();
    }

    @VisibleForTesting
    public KernelUidCpuFreqTimeReader(KernelCpuProcReader procReader) {
        this.mProcReader = procReader;
    }

    public boolean perClusterTimesAvailable() {
        return this.mPerClusterTimesAvailable;
    }

    public boolean allUidTimesAvailable() {
        return this.mAllUidTimesAvailable;
    }

    public SparseArray<long[]> getAllUidCpuFreqTimeMs() {
        return this.mLastUidCpuFreqTimeMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long[] readFreqs(PowerProfile powerProfile) {
        Preconditions.checkNotNull(powerProfile);
        if (this.mCpuFreqs != null) {
            return this.mCpuFreqs;
        }
        if (!this.mAllUidTimesAvailable) {
            return null;
        }
        int oldMask = StrictMode.allowThreadDiskReadsMask();
        try {
            long[] lArray;
            Throwable throwable;
            BufferedReader reader;
            block20: {
                block19: {
                    reader = new BufferedReader(new FileReader(UID_TIMES_PROC_FILE));
                    throwable = null;
                    lArray = this.readFreqs(reader, powerProfile);
                    if (throwable == null) break block19;
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                reader.close();
            }
            return lArray;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            reader.close();
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    if (++this.mReadErrorCounter >= 5) {
                        this.mAllUidTimesAvailable = false;
                    }
                    Slog.e(TAG, "Failed to read /proc/uid_time_in_state: " + e);
                    throwable = null;
                    return throwable;
                }
            }
        }
        finally {
            StrictMode.setThreadPolicyMask(oldMask);
        }
    }

    @VisibleForTesting
    public long[] readFreqs(BufferedReader reader, PowerProfile powerProfile) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            return null;
        }
        String[] freqStr = line.split(" ");
        this.mCpuFreqsCount = freqStr.length - 1;
        this.mCpuFreqs = new long[this.mCpuFreqsCount];
        this.mCurTimes = new long[this.mCpuFreqsCount];
        this.mDeltaTimes = new long[this.mCpuFreqsCount];
        for (int i = 0; i < this.mCpuFreqsCount; ++i) {
            this.mCpuFreqs[i] = Long.parseLong(freqStr[i + 1], 10);
        }
        IntArray numClusterFreqs = this.extractClusterInfoFromProcFileFreqs();
        int numClusters = powerProfile.getNumCpuClusters();
        if (numClusterFreqs.size() == numClusters) {
            this.mPerClusterTimesAvailable = true;
            for (int i = 0; i < numClusters; ++i) {
                if (numClusterFreqs.get(i) == powerProfile.getNumSpeedStepsInCpuCluster(i)) continue;
                this.mPerClusterTimesAvailable = false;
                break;
            }
        } else {
            this.mPerClusterTimesAvailable = false;
        }
        Slog.i(TAG, "mPerClusterTimesAvailable=" + this.mPerClusterTimesAvailable);
        return this.mCpuFreqs;
    }

    @Override
    @VisibleForTesting
    public void readDeltaImpl(Callback callback) {
        if (this.mCpuFreqs == null) {
            return;
        }
        this.readImpl(buf -> {
            int uid = buf.get();
            long[] lastTimes = this.mLastUidCpuFreqTimeMs.get(uid);
            if (lastTimes == null) {
                lastTimes = new long[this.mCpuFreqsCount];
                this.mLastUidCpuFreqTimeMs.put(uid, lastTimes);
            }
            if (!this.getFreqTimeForUid((IntBuffer)buf, this.mCurTimes)) {
                return;
            }
            boolean notify = false;
            boolean valid = true;
            for (int i = 0; i < this.mCpuFreqsCount; ++i) {
                this.mDeltaTimes[i] = this.mCurTimes[i] - lastTimes[i];
                if (this.mDeltaTimes[i] < 0L) {
                    Slog.e(TAG, "Negative delta from freq time proc: " + this.mDeltaTimes[i]);
                    valid = false;
                }
                notify |= this.mDeltaTimes[i] > 0L;
            }
            if (notify && valid) {
                System.arraycopy(this.mCurTimes, 0, lastTimes, 0, this.mCpuFreqsCount);
                if (callback != null) {
                    callback.onUidCpuFreqTime(uid, this.mDeltaTimes);
                }
            }
        });
    }

    public void readAbsolute(Callback callback) {
        this.readImpl(buf -> {
            int uid = buf.get();
            if (this.getFreqTimeForUid((IntBuffer)buf, this.mCurTimes)) {
                callback.onUidCpuFreqTime(uid, this.mCurTimes);
            }
        });
    }

    private boolean getFreqTimeForUid(IntBuffer buffer, long[] freqTime) {
        boolean valid = true;
        for (int i = 0; i < this.mCpuFreqsCount; ++i) {
            freqTime[i] = (long)buffer.get() * 10L;
            if (freqTime[i] >= 0L) continue;
            Slog.e(TAG, "Negative time from freq time proc: " + freqTime[i]);
            valid = false;
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readImpl(Consumer<IntBuffer> processUid) {
        KernelCpuProcReader kernelCpuProcReader = this.mProcReader;
        synchronized (kernelCpuProcReader) {
            ByteBuffer bytes = this.mProcReader.readBytes();
            if (bytes == null || bytes.remaining() <= 4) {
                return;
            }
            if ((bytes.remaining() & 3) != 0) {
                Slog.wtf(TAG, "Cannot parse freq time proc bytes to int: " + bytes.remaining());
                return;
            }
            IntBuffer buf = bytes.asIntBuffer();
            int freqs = buf.get();
            if (freqs != this.mCpuFreqsCount) {
                Slog.wtf(TAG, "Cpu freqs expect " + this.mCpuFreqsCount + " , got " + freqs);
                return;
            }
            if (buf.remaining() % (freqs + 1) != 0) {
                Slog.wtf(TAG, "Freq time format error: " + buf.remaining() + " / " + (freqs + 1));
                return;
            }
            int numUids = buf.remaining() / (freqs + 1);
            for (int i = 0; i < numUids; ++i) {
                processUid.accept(buf);
            }
        }
    }

    public void removeUid(int uid) {
        this.mLastUidCpuFreqTimeMs.delete(uid);
    }

    public void removeUidsInRange(int startUid, int endUid) {
        this.mLastUidCpuFreqTimeMs.put(startUid, null);
        this.mLastUidCpuFreqTimeMs.put(endUid, null);
        int firstIndex = this.mLastUidCpuFreqTimeMs.indexOfKey(startUid);
        int lastIndex = this.mLastUidCpuFreqTimeMs.indexOfKey(endUid);
        this.mLastUidCpuFreqTimeMs.removeAtRange(firstIndex, lastIndex - firstIndex + 1);
    }

    private IntArray extractClusterInfoFromProcFileFreqs() {
        IntArray numClusterFreqs = new IntArray();
        int freqsFound = 0;
        for (int i = 0; i < this.mCpuFreqsCount; ++i) {
            ++freqsFound;
            if (i + 1 != this.mCpuFreqsCount && this.mCpuFreqs[i + 1] > this.mCpuFreqs[i]) continue;
            numClusterFreqs.add(freqsFound);
            freqsFound = 0;
        }
        return numClusterFreqs;
    }

    public static interface Callback
    extends KernelUidCpuTimeReaderBase.Callback {
        public void onUidCpuFreqTime(int var1, long[] var2);
    }
}

