/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;

public class ScreenshotHelper {
    private static final String TAG = "ScreenshotHelper";
    private static final String SYSUI_PACKAGE = "com.android.systemui";
    private static final String SYSUI_SCREENSHOT_SERVICE = "com.android.systemui.screenshot.TakeScreenshotService";
    private static final String SYSUI_SCREENSHOT_ERROR_RECEIVER = "com.android.systemui.screenshot.ScreenshotServiceErrorReceiver";
    private final int SCREENSHOT_TIMEOUT_MS = 10000;
    private final Object mScreenshotLock = new Object();
    private ServiceConnection mScreenshotConnection = null;
    private final Context mContext;

    public ScreenshotHelper(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeScreenshot(final int screenshotType, final boolean hasStatus, final boolean hasNav, final Handler handler) {
        Object object = this.mScreenshotLock;
        synchronized (object) {
            if (this.mScreenshotConnection != null) {
                return;
            }
            ComponentName serviceComponent = new ComponentName(SYSUI_PACKAGE, SYSUI_SCREENSHOT_SERVICE);
            Intent serviceIntent = new Intent();
            final Runnable mScreenshotTimeout = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ScreenshotHelper.this.mScreenshotLock;
                    synchronized (object) {
                        if (ScreenshotHelper.this.mScreenshotConnection != null) {
                            ScreenshotHelper.this.mContext.unbindService(ScreenshotHelper.this.mScreenshotConnection);
                            ScreenshotHelper.this.mScreenshotConnection = null;
                            ScreenshotHelper.this.notifyScreenshotError();
                        }
                    }
                }
            };
            serviceIntent.setComponent(serviceComponent);
            ServiceConnection conn = new ServiceConnection(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onServiceConnected(ComponentName name, IBinder service) {
                    Object object = ScreenshotHelper.this.mScreenshotLock;
                    synchronized (object) {
                        if (ScreenshotHelper.this.mScreenshotConnection != this) {
                            return;
                        }
                        Messenger messenger = new Messenger(service);
                        Message msg = Message.obtain(null, screenshotType);
                        final 2 myConn = this;
                        Handler h = new Handler(handler.getLooper()){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void handleMessage(Message msg) {
                                Object object = ScreenshotHelper.this.mScreenshotLock;
                                synchronized (object) {
                                    if (ScreenshotHelper.this.mScreenshotConnection == myConn) {
                                        ScreenshotHelper.this.mContext.unbindService(ScreenshotHelper.this.mScreenshotConnection);
                                        ScreenshotHelper.this.mScreenshotConnection = null;
                                        handler.removeCallbacks(mScreenshotTimeout);
                                    }
                                }
                            }
                        };
                        msg.replyTo = new Messenger(h);
                        msg.arg1 = hasStatus ? 1 : 0;
                        msg.arg2 = hasNav ? 1 : 0;
                        try {
                            messenger.send(msg);
                        }
                        catch (RemoteException e) {
                            Log.e(ScreenshotHelper.TAG, "Couldn't take screenshot: " + e);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onServiceDisconnected(ComponentName name) {
                    Object object = ScreenshotHelper.this.mScreenshotLock;
                    synchronized (object) {
                        if (ScreenshotHelper.this.mScreenshotConnection != null) {
                            ScreenshotHelper.this.mContext.unbindService(ScreenshotHelper.this.mScreenshotConnection);
                            ScreenshotHelper.this.mScreenshotConnection = null;
                            handler.removeCallbacks(mScreenshotTimeout);
                            ScreenshotHelper.this.notifyScreenshotError();
                        }
                    }
                }
            };
            if (this.mContext.bindServiceAsUser(serviceIntent, conn, 0x2000001, UserHandle.CURRENT)) {
                this.mScreenshotConnection = conn;
                handler.postDelayed(mScreenshotTimeout, 10000L);
            }
        }
    }

    private void notifyScreenshotError() {
        ComponentName errorComponent = new ComponentName(SYSUI_PACKAGE, SYSUI_SCREENSHOT_ERROR_RECEIVER);
        Intent errorIntent = new Intent("android.intent.action.USER_PRESENT");
        errorIntent.setComponent(errorComponent);
        errorIntent.addFlags(0x14000000);
        this.mContext.sendBroadcastAsUser(errorIntent, UserHandle.CURRENT);
    }
}

