/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.lang.reflect.Array;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.containers.SingletonIteratorBase;
import org.jetbrains.kotlin.gnu.trove.THashSet;
import org.jetbrains.kotlin.gnu.trove.TObjectProcedure;

public class SmartHashSet<T>
extends THashSet<T> {
    private T theElement;

    @Override
    public boolean contains(@NotNull Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "org/jetbrains/kotlin/com/intellij/util/containers/SmartHashSet", "contains"));
        }
        T theElement = this.theElement;
        if (theElement != null) {
            return this.eq(theElement, obj);
        }
        return !super.isEmpty() && super.contains(obj);
    }

    @Override
    public boolean add(@NotNull T obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "org/jetbrains/kotlin/com/intellij/util/containers/SmartHashSet", "add"));
        }
        T theElement = this.theElement;
        if (theElement != null) {
            if (this.eq(theElement, obj)) {
                return false;
            }
            super.add(theElement);
            this.theElement = null;
        } else if (super.isEmpty()) {
            this.theElement = obj;
            return true;
        }
        return super.add(obj);
    }

    private boolean eq(T obj, T theElement) {
        return theElement == obj || this._hashingStrategy.equals(theElement, obj);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        T theElement = this.theElement;
        if (theElement != null) {
            return other instanceof Set && ((Set)other).size() == 1 && this.eq(theElement, ((Set)other).iterator().next());
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        T theElement = this.theElement;
        if (theElement != null) {
            return this._hashingStrategy.computeHashCode(theElement);
        }
        return super.hashCode();
    }

    @Override
    public void clear() {
        this.theElement = null;
        super.clear();
    }

    @Override
    public int size() {
        T theElement = this.theElement;
        if (theElement != null) {
            return 1;
        }
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        T theElement = this.theElement;
        return theElement == null && super.isEmpty();
    }

    @Override
    public boolean remove(@NotNull Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "org/jetbrains/kotlin/com/intellij/util/containers/SmartHashSet", "remove"));
        }
        T theElement = this.theElement;
        if (theElement != null) {
            if (this.eq(theElement, obj)) {
                this.theElement = null;
                return true;
            }
            return false;
        }
        return super.remove(obj);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        if (this.theElement != null) {
            SingletonIteratorBase singletonIteratorBase = new SingletonIteratorBase<T>(){

                @Override
                protected void checkCoModification() {
                    if (SmartHashSet.this.theElement == null) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                protected T getElement() {
                    return SmartHashSet.this.theElement;
                }

                @Override
                public void remove() {
                    this.checkCoModification();
                    SmartHashSet.this.clear();
                }
            };
            if (singletonIteratorBase == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/SmartHashSet", "iterator"));
            }
            return singletonIteratorBase;
        }
        Iterator iterator2 = super.iterator();
        if (iterator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/SmartHashSet", "iterator"));
        }
        return iterator2;
    }

    @Override
    public boolean forEach(@NotNull TObjectProcedure<T> procedure) {
        if (procedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "org/jetbrains/kotlin/com/intellij/util/containers/SmartHashSet", "forEach"));
        }
        T theElement = this.theElement;
        if (theElement != null) {
            return procedure.execute(theElement);
        }
        return super.forEach(procedure);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        T theElement = this.theElement;
        if (theElement != null) {
            Object[] objectArray = new Object[]{theElement};
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/SmartHashSet", "toArray"));
            }
            return objectArray;
        }
        Object[] objectArray = super.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/SmartHashSet", "toArray"));
        }
        return objectArray;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/kotlin/com/intellij/util/containers/SmartHashSet", "toArray"));
        }
        T theElement = this.theElement;
        if (theElement != null) {
            if (a.length == 0) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
            }
            a[0] = theElement;
            if (a.length > 1) {
                a[1] = null;
            }
            if (a == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/SmartHashSet", "toArray"));
            }
            return a;
        }
        T[] TArray = super.toArray(a);
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/SmartHashSet", "toArray"));
        }
        return TArray;
    }
}

